'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH DS2506 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2506, DS2506-UNW
\- Add-Only Memory (64 kBit), UniqueWare Add-Only Memory (64 kBit)
.TP
.B DS1986, DS1986U
\- Add-Only iButton (64 kBit), UniqueWare iButton (64 kBit)
.SH SYNOPSIS
EPROM add-only memory.
.PP
.B 0F
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/page.[0-255|ALL]
|
.so man3/standard_mini.3so
]]
.HP
.B 8F
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/page.[0-255|ALL]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.TP
.I 0F
DS2506 DS1986
.TP
.I 8F
DS2506-UNW DS1986U
.SH SPECIAL PROPERTIES
.SS memory
.I read-write, binary
.br
8192 bytes of memory. Initially all bits are set to 1. Writing zero permanently alters the memory.
.SS pages/page.0 ... pages/page.255 pages/page.ALL
.I read-write, yes-no
.br
Memory is split into 256 pages of 32 bytes each.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2506 DS1986
The
.B DS2506 (3)
is used for write-once incremental storage. It's main advantage is for audit trails (i.e. a digital purse).
.PP
The
.B DS2506-UNW
is one of the
.I UniqueWare
class of devices. Some of the memory was preprogramed at the factory. See the datasheet for specifics. The
.B DS2502
,
.B DS2505
, and
.B DS2506
differ in their function by the amount of on-board memory they possess. (The internal protocols are slightly different, but the
.I OWFS
system handles this automatically.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2506.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS2502-UNW-DS2506S-UNW.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS1986-F3-DS1986-F5.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS1982U-DS1986U.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
