/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToFellerFormatEcp
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        this.enableSplitSP();
        return this.readECP(data, elementList);
    }

    @Override
    protected void readCmlMatrixECP(StringBuffer output, Matrix matrix, String element, String shell, String potentialType) throws FormatException {
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        String lValue = "?";
        if (shell.compareToIgnoreCase("S") == 0) {
            lValue = "0";
        } else if (shell.compareToIgnoreCase("P") == 0) {
            lValue = "1";
        } else if (shell.compareToIgnoreCase("D") == 0) {
            lValue = "2";
        } else if (shell.compareToIgnoreCase("F") == 0) {
            lValue = "3";
        } else if (shell.compareToIgnoreCase("G") == 0) {
            lValue = "4";
        } else if (shell.compareToIgnoreCase("H") == 0) {
            lValue = "5";
        } else if (shell.compareToIgnoreCase("I") == 0) {
            lValue = "6";
        } else {
            System.err.println("Error: unknown shell \"" + shell + "\", cannot assign L value.");
        }
        if (potentialType == null) {
            potentialType = "undefined";
        } else if (potentialType.compareTo("null") == 0) {
            potentialType = "undefined";
        }
        output.append("L=" + lValue + "\t\tTYPE=\"" + potentialType + "\"\n");
        output.append("NUMEXP= " + rows + "\n");
        try {
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    String value = this.formattedValue(matrix.getValue(i, j), j != 0);
                    output.append(value);
                }
                output.append("\n");
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }

    @Override
    protected void addHeaderECP(StringBuffer output, Element root) {
        output.append("! ------------------------- \n");
        output.append("! Effective core Potentials \n");
        output.append("! ------------------------- \n");
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        output.append("NAME=\"" + this.mTitle + "\"\n");
    }

    @Override
    protected void addFooterECP(StringBuffer output) {
        output.append("!\nEND\n");
        output.append("!                   File Revision History    \n");
    }

    @Override
    protected void addElementDescriptionECP(StringBuffer output, Element potentials, String element) {
        output.append("!\n");
        int elementAtomicNumber = this.mPertable.atomicNumber(element);
        String elementName = this.mPertable.name(elementAtomicNumber);
        output.append("Z=" + elementAtomicNumber + "\t\t\t!\t" + elementName.toUpperCase() + "\n");
        String ncore = potentials.getAttributeValue("numElectronsReplaced");
        output.append("NCORE=" + ncore + "\n");
        int levelMax = 0;
        List lPotentials = potentials.getChildren();
        for (Element potential : lPotentials) {
            String shell = potential.getAttributeValue("shell");
            if (shell.equals("I")) {
                if (levelMax >= 6) continue;
                levelMax = 6;
                continue;
            }
            if (shell.equals("H")) {
                if (levelMax >= 5) continue;
                levelMax = 5;
                continue;
            }
            if (shell.equals("G")) {
                if (levelMax >= 4) continue;
                levelMax = 4;
                continue;
            }
            if (shell.equals("F")) {
                if (levelMax >= 3) continue;
                levelMax = 3;
                continue;
            }
            if (shell.equals("D")) {
                if (levelMax >= 2) continue;
                levelMax = 2;
                continue;
            }
            if (!shell.equals("P") || levelMax >= 1) continue;
            levelMax = 1;
        }
        output.append("LMAX=" + levelMax + "\n");
    }

    protected String formattedValue(String value, boolean bSpaceForSign) {
        int i;
        String[] split;
        String beforeDecimal;
        String tmp;
        int TOTAL_WIDTH = 17;
        int DECIMAL_WIDTH = 16;
        value = value.trim();
        boolean isExponential = false;
        String expChars = "DE";
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c = value.charAt(i2);
            if (c != 'D' && c != 'd' && c != 'E' && c != 'e') continue;
            isExponential = true;
        }
        if (!isExponential && value.indexOf(46) == -1) {
            value = value + ".0";
        }
        if ((tmp = (beforeDecimal = (split = value.split("\\."))[0].trim()).replaceAll("\\+", "").replaceAll("\\-", "")).trim().length() == 0) {
            value = beforeDecimal + "0" + value.substring(value.indexOf(46));
        }
        if (bSpaceForSign && beforeDecimal.indexOf(43) == -1 && beforeDecimal.indexOf(45) == -1) {
            value = " " + value;
        }
        beforeDecimal = value.split("\\.")[0];
        int nonDeciLen = beforeDecimal.length();
        int deciLen = value.length() - nonDeciLen;
        String whitespaces = "";
        for (i = 0; i < TOTAL_WIDTH - DECIMAL_WIDTH - nonDeciLen; ++i) {
            whitespaces = whitespaces + " ";
        }
        value = whitespaces + value;
        if (!isExponential && value.length() < 8 && value.length() < 8) {
            for (i = 0; i < 8 - value.length(); ++i) {
                value = value + "0";
            }
        }
        if (value.length() < TOTAL_WIDTH) {
            int fill = TOTAL_WIDTH - value.length();
            for (int i3 = 0; i3 < fill; ++i3) {
                value = value + " ";
            }
        } else {
            value = value + "      ";
        }
        return value;
    }
}

