
/*
         
    main.h - Main file - Declares simple wxWidgets application with GUI created using wxFormBuilder.
    Copyright (C) 2011 Enas Giovanni <gio.enas@alice.it>
 
    This file is part of Nautic.

    Nautic is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Nautic is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Nautic.  If not, see <http://www.gnu.org/licenses/>.

 */

#ifndef __main__
#define __main__

// main wxWidgets header file
#include <wx-2.8/wx/wx.h>
#include <wx/defs.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/filename.h>
#include <wx/filefn.h>
#include "stars.h"
#include "sun.h"
#include "spa.h"
#include "starpos.h"
#include "h_correction.h"
#include "un_known_star.h"

// gui classes generated by wxFormBuilder
#include "gui.h"
#include  "Info_Dlg.h"
#include "Pos_dialog.h"
#include "about.h"
#include "plot_dialog.h"


////////////////////////////////////////////////////////////////////////////////
// application class declaration
////////////////////////////////////////////////////////////////////////////////

class MainApp : public wxApp
{
	public:
		virtual bool OnInit();

};

// declare global static function wxGetApp()
DECLARE_APP(MainApp)


////////////////////////////////////////////////////////////////////////////////
// main application frame declaration
////////////////////////////////////////////////////////////////////////////////

class MainDialog : public MainDialogBase
{
DECLARE_EVENT_TABLE()
	public:
		MainDialog( wxWindow *parent );


		virtual ~MainDialog();
		void SendMessage();
		wxColour* col;
		wxRect rect1;
		wxTimer timer;

		int iCount;
		bool bInsertNum;
		wxTimer * m_timer;
		int ihourval;
		int iminval;
		int isecval;
		wxDateTime time;
		///////////////sun///////////////////////////stars/////////////planets/////////////moon/////////////////
		double declination;
		double CoArect;
		double Tm;
		//////////////tempo siderale/////////////////////////
		double Ts;
		double altitude;
		double azimuth;
		double RA;
		double LHA;
		double equinox;
		double loctime;
		double t;
		double lamda;
		double beta;
		double parlax;
		double smdiam;
		Starpos planet;
		wxString bodyname;
		wxString date;
		wxString jul;
		wxString constell;
		double indxerr;
		bool bUpperLimb;
		///////////////////////data/////////////////////////////
		int year;
		int month;
		int day;
		double iYear ;
		double iMonth;
		double iDay;
		double iHour;
		double iMinute;
		double iSeconds;
		/////////////////////flag for choice///////////////////
		bool bSun;
		bool bMoon;
		bool bStar;
		bool bPlanet;

		////////////////////distance/////////////////
		double P_distance;
		double dTrueAlt;
		//////////////////////lat, lon//////////////////////////////
		double latitude;
		double longitude;
		double truelat;
		double truelong;
		wxString filepath;

	protected:
		// protected event handlers
		virtual void OnCloseDialog( wxCloseEvent& event );
		virtual void OnPaint(wxPaintEvent& event);
		virtual void OnCharHook( wxKeyEvent& event ) ;

		virtual void OnTimer(wxTimerEvent& event);
		virtual void OnText_Deg_Lat( wxCommandEvent& event );
		virtual void OnText_min_Lat( wxCommandEvent& event );
		virtual void OnText_Sec_Lat( wxCommandEvent& event );
		virtual void OnChar( wxKeyEvent& event );
		virtual void OnTextDegLon( wxCommandEvent& event );
		virtual void OnTextMinLon( wxCommandEvent& event );
		virtual void OnTextSecLon( wxCommandEvent& event ) ;
		virtual void OnTextMax( wxCommandEvent& event );
		virtual void OnCharDeg( wxKeyEvent& event );
		virtual void OnCharSec( wxKeyEvent& event );
		virtual void OnCharLon( wxKeyEvent& event );
		virtual void OnCharDegLon( wxKeyEvent& event );
		virtual void OnCharSecLon( wxKeyEvent& event );
		virtual void OnStartTimer( wxCommandEvent& event );
		virtual void OnStopTimer( wxCommandEvent& event );
		virtual void OnHrsUTC( wxKeyEvent& event );
		virtual void OnMinUTC( wxKeyEvent& event );
		virtual void OnSecUTC( wxKeyEvent& event );
		virtual void OnCharLocalHr( wxKeyEvent& event );
		virtual void OnCharLocalMin( wxKeyEvent& event );
		virtual void OnCharLocalSec( wxKeyEvent& event );

		virtual void OnTextUTChrs( wxCommandEvent& event );
		virtual void OnTextUTCmin( wxCommandEvent& event );
		virtual void OnTextUTCsecs( wxCommandEvent& event );
		virtual void OnTextLTHrs( wxCommandEvent& event );
		virtual void OnTextLTmins( wxCommandEvent& event );
		virtual void OnTextLTsecs( wxCommandEvent& event );
		virtual void OnLocal( wxCommandEvent& event );
		virtual void OnUTC( wxCommandEvent& event );
		virtual void OnStarChoice();
		virtual void OnCalcHeitht( wxCommandEvent& event );
		virtual void OnPlanetChoice();//( wxCommandEvent& event );
		virtual void OnCharAltMin( wxKeyEvent& event );
		virtual void OnTextEnter( wxFocusEvent& event );
		virtual void OnCharDiff(wxKeyEvent& event);
		virtual void OnCharAlt( wxKeyEvent& event );
		virtual void OnTextAlt( wxCommandEvent& event );
		virtual void OnInfo( wxCommandEvent& event );
		virtual void OnCharAltSec( wxKeyEvent& event );
		virtual void OnFocusOut( wxFocusEvent& event );
		virtual void OnAltMin( wxFocusEvent& event );
		virtual void OnAltSec( wxFocusEvent& event );
		virtual void OnCharEHt( wxKeyEvent& event );
		virtual void OnEyeHt( wxFocusEvent& event );
		virtual void OnCheckbox( wxCommandEvent& event );
		virtual void OnAzOut( wxFocusEvent& event );
		virtual void OnSave( wxCommandEvent& event );
		virtual void OnCalcPos( wxCommandEvent& event );
		virtual void OnCancLines( wxCommandEvent& event );
		virtual void OnMeridian( wxCommandEvent& event );
		virtual void OnPlot( wxCommandEvent& event );
		virtual void GetData( );
		virtual void OnComboStar(wxCommandEvent& event);
		virtual void OnComboPlan(wxCommandEvent& event);
		/////////menu////////////////
		virtual void OnMenuSave( wxCommandEvent& event );
		virtual void OnMenuCancel( wxCommandEvent& event );
		virtual void OnMenuAlt( wxCommandEvent& event );
		virtual void OnMenuMeridian( wxCommandEvent& event );
		virtual void OnMenuPlot( wxCommandEvent& event ) ;
		virtual void OnMenuInfo( wxCommandEvent& event );
		virtual void OnMenuAbout( wxCommandEvent& event );
		
private:
		void InitDialog();
		int GetMonthfromString(int iMon);
		wxString FormatDegrees(float Degrees);
		bool isNumber(int num);
		bool isOnlyNumber(int num);
		void formatNum(wxKeyEvent& evt);
		void formatOnlyNum(wxKeyEvent& evt);
		void SetTextOnLTime();
		void GetUTCfromLocal();
		double plan_prlx(double distance,double alt);
		////////////flags//////////////////////////////
		bool isStar;
		bool isPlanet;
		/////////////////last function/////////////////////for menu///////
		void CalcAltitude();
		void CalcMeridian();
		void CancLines();
		void save();
		void info();
		void calc_pos();



};

class InfoDlg : public Info_Dlg
{
	public:
		double decl;
		double CoRect;
		double GHAa;
		double GHA;
		double LHA;
		double RA;
		double JD;
		double Date;
		double t;
		double loctime;
		double lat;
		double lon;
		double parlx;
		double sdiam;
		double alt;
		double azth;
		double parlax;
		wxString sConst;
		wxString body;
		wxString date;
		wxString jul;

		InfoDlg(  wxWindow* parent, wxWindowID id = wxID_ANY, const wxString& title = wxT("Body 's paramether"), const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxSize( 300,500 ), long style = wxDEFAULT_FRAME_STYLE|wxTAB_TRAVERSAL|wxFRAME_FLOAT_ON_PARENT );
	protected:
	wxString hrms(double x);
	wxString dms(double x);
	wxString FormatDegrees(float Degrees);
	wxString FormatDegs(float Degrees);
	virtual void OnPaintDlgInfo( wxPaintEvent& event );

};

#endif //__main__
