/* @cond INNERDOC */
/*! 
 @file
 @brief Matrix type dispatching code, for each matrix operation.
 */

/*

Copyright (C) 2008-2020 Michele Martone

This file is part of librsb.

librsb is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

librsb is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public
License along with librsb; see the file COPYING.
If not, see <http://www.gnu.org/licenses/>.

*/
/*
 The code in this file was generated automatically by an M4 script. 
 It is not meant to be used as an API (Application Programming Interface).
 p.s.: right now, only row major matrix access is considered.

 */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*!
 @file
 @brief
 Performance kernels dispatching code, for each type, submatrix size, operation.
 But for block compressed sparse stripes format.
 Kernels unrolled, with no loops, for only user-specified blockings.
 */

/*

Copyright (C) 2008-2020 Michele Martone

This file is part of librsb.

librsb is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

librsb is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public
License along with librsb; see the file COPYING.
If not, see <http://www.gnu.org/licenses/>.

*/
/*
 The code in this file was generated automatically by an M4 script. 
 It is not meant to be used as an API (Application Programming Interface).
 p.s.: right now, only row major matrix access is considered.

 */
#include "rsb_common.h"
#include "rsb_krnl_bcss_spmv_u.h"	/* uhm */
#include "rsb_krnl_bcss_spsv_u.h"	/* uhm */
#include "rsb_krnl_bcss_misc_u.h"	/* uhm */




rsb_err_t rsb__do_spmv_uaua(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const rsb_trans_t transA)
/* generated by the RSB_M4_DIRECT_KERNEL_DISPATCH_FUNCTION macro */
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * A run-time kernel dispatching function.
	 * 
	 * Will use the right "spmv_uaua" kernel for each matrix block.
	 * 
	 * However, there could be some overhead in the process of dispatching
	 * the right function kernel for each block, especially for matrices
	 * partitioned in same-size blocks.
	 * 
	 * In that case, it is better to use some specialized function.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_NO_ERROR;
	rsb_flags_t symmetry,diagonal;
#ifdef RSB_COORDINATE_TYPE_H
	rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */

	if(!mtxAp /*|| !mtxAp->options */)
		return RSB_ERR_BADARGS;

	symmetry = rsb__get_symmetry_type_flag(mtxAp);
	diagonal = rsb__get_diagonal_type_flag(mtxAp);

	if(RSB_MATRIX_UNSUPPORTED_TYPE(mtxAp->typecode))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
		case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uaua_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uaua_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uaua_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uaua_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uaua_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uaua_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	return errval;
}

rsb_err_t rsb__do_spmv_uauz(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const rsb_trans_t transA)
/* generated by the RSB_M4_DIRECT_KERNEL_DISPATCH_FUNCTION macro */
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * A run-time kernel dispatching function.
	 * 
	 * Will use the right "spmv_uauz" kernel for each matrix block.
	 * 
	 * However, there could be some overhead in the process of dispatching
	 * the right function kernel for each block, especially for matrices
	 * partitioned in same-size blocks.
	 * 
	 * In that case, it is better to use some specialized function.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_NO_ERROR;
	rsb_flags_t symmetry,diagonal;
#ifdef RSB_COORDINATE_TYPE_H
	rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */

	if(!mtxAp /*|| !mtxAp->options */)
		return RSB_ERR_BADARGS;

	symmetry = rsb__get_symmetry_type_flag(mtxAp);
	diagonal = rsb__get_diagonal_type_flag(mtxAp);

	if(RSB_MATRIX_UNSUPPORTED_TYPE(mtxAp->typecode))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
		case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uauz_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uauz_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uauz_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uauz_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uauz_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uauz_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	return errval;
}

rsb_err_t rsb__do_spmv_uxua(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const void * alphap,const rsb_trans_t transA)
/* generated by the RSB_M4_DIRECT_KERNEL_DISPATCH_FUNCTION macro */
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * A run-time kernel dispatching function.
	 * 
	 * Will use the right "spmv_uxua" kernel for each matrix block.
	 * 
	 * However, there could be some overhead in the process of dispatching
	 * the right function kernel for each block, especially for matrices
	 * partitioned in same-size blocks.
	 * 
	 * In that case, it is better to use some specialized function.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_NO_ERROR;
	rsb_flags_t symmetry,diagonal;
#ifdef RSB_COORDINATE_TYPE_H
	rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */

	if(!mtxAp /*|| !mtxAp->options */)
		return RSB_ERR_BADARGS;

	symmetry = rsb__get_symmetry_type_flag(mtxAp);
	diagonal = rsb__get_diagonal_type_flag(mtxAp);

	if(RSB_MATRIX_UNSUPPORTED_TYPE(mtxAp->typecode))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
		case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_uxua_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_uxua_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_uxua_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_uxua_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_uxua_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_uxua_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	return errval;
}

rsb_err_t rsb__do_spmv_unua(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const rsb_trans_t transA)
/* generated by the RSB_M4_DIRECT_KERNEL_DISPATCH_FUNCTION macro */
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * A run-time kernel dispatching function.
	 * 
	 * Will use the right "spmv_unua" kernel for each matrix block.
	 * 
	 * However, there could be some overhead in the process of dispatching
	 * the right function kernel for each block, especially for matrices
	 * partitioned in same-size blocks.
	 * 
	 * In that case, it is better to use some specialized function.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_NO_ERROR;
	rsb_flags_t symmetry,diagonal;
#ifdef RSB_COORDINATE_TYPE_H
	rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */

	if(!mtxAp /*|| !mtxAp->options */)
		return RSB_ERR_BADARGS;

	symmetry = rsb__get_symmetry_type_flag(mtxAp);
	diagonal = rsb__get_diagonal_type_flag(mtxAp);

	if(RSB_MATRIX_UNSUPPORTED_TYPE(mtxAp->typecode))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
		case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_unua_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_unua_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_unua_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_unua_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_unua_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_unua_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	return errval;
}

rsb_err_t rsb__do_spmv_sasa(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,rsb_coo_idx_t incx, rsb_coo_idx_t incy,const rsb_trans_t transA)
/* generated by the RSB_M4_DIRECT_KERNEL_DISPATCH_FUNCTION macro */
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * A run-time kernel dispatching function.
	 * 
	 * Will use the right "spmv_sasa" kernel for each matrix block.
	 * 
	 * However, there could be some overhead in the process of dispatching
	 * the right function kernel for each block, especially for matrices
	 * partitioned in same-size blocks.
	 * 
	 * In that case, it is better to use some specialized function.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_NO_ERROR;
	rsb_flags_t symmetry,diagonal;
#ifdef RSB_COORDINATE_TYPE_H
	rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */

	if(!mtxAp /*|| !mtxAp->options */)
		return RSB_ERR_BADARGS;

	symmetry = rsb__get_symmetry_type_flag(mtxAp);
	diagonal = rsb__get_diagonal_type_flag(mtxAp);

	if(RSB_MATRIX_UNSUPPORTED_TYPE(mtxAp->typecode))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
		case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sasa_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sasa_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sasa_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sasa_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sasa_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sasa_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	return errval;
}

rsb_err_t rsb__do_spsv_uxua(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const rsb_trans_t transA)
/* generated by the RSB_M4_DIRECT_KERNEL_DISPATCH_FUNCTION macro */
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * A run-time kernel dispatching function.
	 * 
	 * Will use the right "spsv_uxua" kernel for each matrix block.
	 * 
	 * However, there could be some overhead in the process of dispatching
	 * the right function kernel for each block, especially for matrices
	 * partitioned in same-size blocks.
	 * 
	 * In that case, it is better to use some specialized function.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_NO_ERROR;
	rsb_flags_t symmetry,diagonal;
#ifdef RSB_COORDINATE_TYPE_H
	rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */

	if(!mtxAp /*|| !mtxAp->options */)
		return RSB_ERR_BADARGS;

	symmetry = rsb__get_symmetry_type_flag(mtxAp);
	diagonal = rsb__get_diagonal_type_flag(mtxAp);

	if(RSB_MATRIX_UNSUPPORTED_TYPE(mtxAp->typecode))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
		case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_C_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_C_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_C_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_C_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tN_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tT_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sU_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sU_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sS_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sS_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_H_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_H_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_H_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_H_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sH_dI_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H_u_tC_sH_dI_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	return errval;
}

rsb_err_t rsb__do_spmv_sxsa(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const void * alphap,rsb_coo_idx_t incx, rsb_coo_idx_t incy,const rsb_trans_t transA)
/* generated by the RSB_M4_DIRECT_KERNEL_DISPATCH_FUNCTION macro */
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * A run-time kernel dispatching function.
	 * 
	 * Will use the right "spmv_sxsa" kernel for each matrix block.
	 * 
	 * However, there could be some overhead in the process of dispatching
	 * the right function kernel for each block, especially for matrices
	 * partitioned in same-size blocks.
	 * 
	 * In that case, it is better to use some specialized function.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_NO_ERROR;
	rsb_flags_t symmetry,diagonal;
#ifdef RSB_COORDINATE_TYPE_H
	rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */

	if(!mtxAp /*|| !mtxAp->options */)
		return RSB_ERR_BADARGS;

	symmetry = rsb__get_symmetry_type_flag(mtxAp);
	diagonal = rsb__get_diagonal_type_flag(mtxAp);

	if(RSB_MATRIX_UNSUPPORTED_TYPE(mtxAp->typecode))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
		case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCOR_spmv_sxsa_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCOR_spmv_sxsa_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCOR_spmv_sxsa_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
		errval = rsb__BCSR_spmv_sxsa_double_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
		errval = rsb__BCSR_spmv_sxsa_float_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
		errval = rsb__BCSR_spmv_sxsa_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
			errval = RSB_ERR_UNSUPPORTED_FEATURE;
		}
	}
	return errval;
}

rsb_err_t rsb__do_spsv_sxsx(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const void * alphap,rsb_coo_idx_t incx, rsb_coo_idx_t incy,const rsb_trans_t transA)
/* generated by the RSB_M4_DIRECT_KERNEL_DISPATCH_FUNCTION macro */
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * A run-time kernel dispatching function.
	 * 
	 * Will use the right "spsv_sxsx" kernel for each matrix block.
	 * 
	 * However, there could be some overhead in the process of dispatching
	 * the right function kernel for each block, especially for matrices
	 * partitioned in same-size blocks.
	 * 
	 * In that case, it is better to use some specialized function.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_NO_ERROR;
	rsb_flags_t symmetry,diagonal;
#ifdef RSB_COORDINATE_TYPE_H
	rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */

	if(!mtxAp /*|| !mtxAp->options */)
		return RSB_ERR_BADARGS;

	symmetry = rsb__get_symmetry_type_flag(mtxAp);
	diagonal = rsb__get_diagonal_type_flag(mtxAp);

	if(RSB_MATRIX_UNSUPPORTED_TYPE(mtxAp->typecode))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tT_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tT_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tT_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tT_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tC_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tC_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tC_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tC_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tC_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C_u_tC_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H_u_tN_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H_u_tN_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H_u_tN_sS_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H_u_tN_sS_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
		case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H_u_tN_sH_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H_u_tN_sH_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
			default:
		{
		RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
		errval = RSB_ERR_UNSUPPORTED_FORMAT;
		}
	}
	break;
			default:
		{
			RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
			errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	}
	break;
		case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy);
	break;
			default:
		RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
		errval = RSB_ERR_UNSUPPORTED_TYPE	;
		}
	break;
		case(RSB_MATRIX_STORAGE_BCSR):
	switch(mtxAp->typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_double_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	break;
		case(RSB_NUMERICAL_TYPE_FLOAT ):
	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H_u_tT_sU_dE_uL(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy);
	else
		errval = rsb__BCSR_spsv_sxsx_float_H_u_tT_sU_dE_uU(	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->r