/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-3-Clause) */
/*
 * This file is provided under a dual BSD/GPLv2 license. When using or
 * redistributing this file, you may do so under either license.
 *
 * Copyright(c) 2021, 2023, 2024 Advanced Micro Devices, Inc. All rights reserved.
 *
 * Author: Ajit Kumar Pandey <AjitKumar.Pandey@amd.com>
 */

#ifndef _ACP_DSP_IP_OFFSET_H
#define _ACP_DSP_IP_OFFSET_H

/* Registers from ACP_DMA_0 block */
#define ACP_DMA_CNTL_0				0x00
#define ACP_DMA_DSCR_STRT_IDX_0			0x20
#define ACP_DMA_DSCR_CNT_0			0x40
#define ACP_DMA_PRIO_0				0x60
#define ACP_DMA_CUR_DSCR_0			0x80
#define ACP_DMA_ERR_STS_0			0xC0
#define ACP_DMA_DESC_BASE_ADDR			0xE0
#define ACP_DMA_DESC_MAX_NUM_DSCR		0xE4
#define ACP_DMA_CH_STS				0xE8
#define ACP_DMA_CH_GROUP			0xEC
#define ACP_DMA_CH_RST_STS			0xF0
#define ACP70_DMA_CNTL_0			0x00
#define ACP70_DMA_DSCR_STRT_IDX_0		0x28
#define ACP70_DMA_DSCR_CNT_0			0x50
#define ACP70_DMA_PRIO_0			0x78
#define ACP70_DMA_CUR_DSCR_0			0xA0
#define ACP70_DMA_ERR_STS_0			0xF0
#define ACP70_DMA_DESC_BASE_ADDR		0x118
#define ACP70_DMA_DESC_MAX_NUM_DSCR		0x11C
#define ACP70_DMA_CH_STS			0x120
#define ACP70_DMA_CH_GROUP			0x124
#define ACP70_DMA_CH_RST_STS			0x128

/* Registers from ACP_DSP_0 block */
#define ACP_DSP0_RUNSTALL			0x414

/* Registers from ACP_AXI2AXIATU block */
#define ACPAXI2AXI_ATU_PAGE_SIZE_GRP_1		0xC00
#define ACPAXI2AXI_ATU_BASE_ADDR_GRP_1		0xC04
#define ACPAXI2AXI_ATU_PAGE_SIZE_GRP_2		0xC08
#define ACPAXI2AXI_ATU_BASE_ADDR_GRP_2		0xC0C
#define ACPAXI2AXI_ATU_PAGE_SIZE_GRP_3		0xC10
#define ACPAXI2AXI_ATU_BASE_ADDR_GRP_3		0xC14
#define ACPAXI2AXI_ATU_PAGE_SIZE_GRP_4		0xC18
#define ACPAXI2AXI_ATU_BASE_ADDR_GRP_4		0xC1C
#define ACPAXI2AXI_ATU_PAGE_SIZE_GRP_5		0xC20
#define ACPAXI2AXI_ATU_BASE_ADDR_GRP_5		0xC24
#define ACPAXI2AXI_ATU_PAGE_SIZE_GRP_6		0xC28
#define ACPAXI2AXI_ATU_BASE_ADDR_GRP_6		0xC2C
#define ACPAXI2AXI_ATU_PAGE_SIZE_GRP_7		0xC30
#define ACPAXI2AXI_ATU_BASE_ADDR_GRP_7		0xC34
#define ACPAXI2AXI_ATU_PAGE_SIZE_GRP_8		0xC38
#define ACPAXI2AXI_ATU_BASE_ADDR_GRP_8		0xC3C
#define ACPAXI2AXI_ATU_CTRL			0xC40
#define ACP_SOFT_RESET				0x1000
#define ACP_CONTROL				0x1004

#define ACP3X_I2S_PIN_CONFIG			0x1400
#define ACP5X_I2S_PIN_CONFIG			0x1400
#define ACP6X_I2S_PIN_CONFIG			0x1440

/* Registers offsets from ACP_PGFSM block */
#define ACP3X_PGFSM_BASE			0x141C
#define ACP5X_PGFSM_BASE			0x1424
#define ACP6X_PGFSM_BASE                        0x1024
#define ACP70_PGFSM_BASE                        ACP6X_PGFSM_BASE
#define PGFSM_CONTROL_OFFSET			0x0
#define PGFSM_STATUS_OFFSET			0x4
#define ACP3X_CLKMUX_SEL			0x1424
#define ACP5X_CLKMUX_SEL			0x142C
#define ACP6X_CLKMUX_SEL			0x102C
#define ACP70_CLKMUX_SEL			ACP6X_CLKMUX_SEL

/* Registers from ACP_INTR block */
#define ACP3X_EXT_INTR_STAT			0x1808
#define ACP5X_EXT_INTR_STAT			0x1808
#define ACP6X_EXTERNAL_INTR_ENB			0x1A00
#define ACP6X_EXTERNAL_INTR_CNTL		0x1A04
#define ACP6X_EXT_INTR_STAT                     0x1A0C
#define ACP6X_EXT_INTR_STAT1			0x1A10
#define ACP70_EXTERNAL_INTR_ENB			ACP6X_EXTERNAL_INTR_ENB
#define ACP70_EXTERNAL_INTR_CNTL		ACP6X_EXTERNAL_INTR_CNTL
#define ACP70_EXT_INTR_STAT			ACP6X_EXT_INTR_STAT
#define ACP70_EXT_INTR_STAT1			ACP6X_EXT_INTR_STAT1

#define ACP3X_DSP_SW_INTR_BASE			0x1814
#define ACP5X_DSP_SW_INTR_BASE			0x1814
#define ACP6X_DSP_SW_INTR_BASE                  0x1808
#define ACP70_DSP_SW_INTR_BASE			ACP6X_DSP_SW_INTR_BASE
#define DSP_SW_INTR_CNTL_OFFSET			0x0
#define DSP_SW_INTR_STAT_OFFSET			0x4
#define DSP_SW_INTR_TRIG_OFFSET			0x8
#define ACP3X_ERROR_STATUS			0x18C4
#define ACP6X_ERROR_STATUS			0x1A4C
#define ACP70_ERROR_STATUS			ACP6X_ERROR_STATUS
#define ACP3X_AXI2DAGB_SEM_0			0x1880
#define ACP5X_AXI2DAGB_SEM_0			0x1884
#define ACP6X_AXI2DAGB_SEM_0			0x1874
#define ACP70_AXI2DAGB_SEM_0			ACP6X_AXI2DAGB_SEM_0

/* ACP common registers to report errors related to I2S & SoundWire interfaces */
#define ACP3X_SW_I2S_ERROR_REASON		0x18C8
#define ACP6X_SW0_I2S_ERROR_REASON		0x18B4
#define ACP7X_SW0_I2S_ERROR_REASON		ACP6X_SW0_I2S_ERROR_REASON
#define ACP_SW1_I2S_ERROR_REASON		0x1A50

/* Registers from ACP_SHA block */
#define ACP_SHA_DSP_FW_QUALIFIER		0x1C70
#define ACP_SHA_DMA_CMD				0x1CB0
#define ACP_SHA_MSG_LENGTH			0x1CB4
#define ACP_SHA_DMA_STRT_ADDR			0x1CB8
#define ACP_SHA_DMA_DESTINATION_ADDR		0x1CBC
#define ACP_SHA_DMA_CMD_STS			0x1CC0
#define ACP_SHA_DMA_ERR_STATUS			0x1CC4
#define ACP_SHA_TRANSFER_BYTE_CNT		0x1CC8
#define ACP_SHA_DMA_INCLUDE_HDR         0x1CCC
#define ACP_SHA_PSP_ACK                         0x1C74

#define ACP_SCRATCH_REG_0			0x10000
#define ACP6X_DSP_FUSION_RUNSTALL		0x0644
#define ACP70_DSP_FUSION_RUNSTALL		ACP6X_DSP_FUSION_RUNSTALL

/* Cache window registers */
#define ACP_DSP0_CACHE_OFFSET0			0x0420
#define ACP_DSP0_CACHE_SIZE0			0x0424

#define ACP_SW0_EN				0x3000
#define ACP_SW1_EN				0x3C00
#endif
