
;; GCC machine description for IA-32 and x86-64.
;; Copyright (C) 1988, 1994, 1995, 1996, 1997, 1998, 1999, 2000,
;; 2001, 2002, 2003, 2004
;; Free Software Foundation, Inc.
;; Mostly by William Schelter.
;; x86_64 support added by Jan Hubicka
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.  */
;;
;; The original PO technology requires these to be ordered by speed,
;; so that assigner will pick the fastest.
;;
;; See file "rtl.def" for documentation on define_insn, match_*, et. al.
;;
;; Macro REG_CLASS_FROM_LETTER in file i386.h defines the register
;; constraint letters.
;;
;; The special asm out single letter directives following a '%' are:
;; 'z' mov%z1 would be movl, movw, or movb depending on the mode of
;;     operands[1].
;; 'L' Print the opcode suffix for a 32-bit integer opcode.
;; 'W' Print the opcode suffix for a 16-bit integer opcode.
;; 'B' Print the opcode suffix for an 8-bit integer opcode.
;; 'Q' Print the opcode suffix for a 64-bit float opcode.
;; 'S' Print the opcode suffix for a 32-bit float opcode.
;; 'T' Print the opcode suffix for an 80-bit extended real XFmode float opcode.
;; 'J' Print the appropriate jump operand.
;;
;; 'b' Print the QImode name of the register for the indicated operand.
;;     %b0 would print %al if operands[0] is reg 0.
;; 'w' Likewise, print the HImode name of the register.
;; 'k' Likewise, print the SImode name of the register.
;; 'h' Print the QImode name for a "high" register, either ah, bh, ch or dh.
;; 'y' Print "st(0)" instead of "st" as a register.

;; UNSPEC usage:

(define_constants
  [; Relocation specifiers
   (UNSPEC_GOT			0)
   (UNSPEC_GOTOFF		1)
   (UNSPEC_GOTPCREL		2)
   (UNSPEC_GOTTPOFF		3)
   (UNSPEC_TPOFF		4)
   (UNSPEC_NTPOFF		5)
   (UNSPEC_DTPOFF		6)
   (UNSPEC_GOTNTPOFF		7)
   (UNSPEC_INDNTPOFF		8)

   ; Prologue support
   (UNSPEC_STACK_ALLOC		11)
   (UNSPEC_SET_GOT		12)
   (UNSPEC_SSE_PROLOGUE_SAVE	13)

   ; TLS support
   (UNSPEC_TP			15)
   (UNSPEC_TLS_GD		16)
   (UNSPEC_TLS_LD_BASE		17)

   ; Other random patterns
   (UNSPEC_SCAS			20)
   (UNSPEC_SIN			21)
   (UNSPEC_COS			22)
   (UNSPEC_FNSTSW		24)
   (UNSPEC_SAHF			25)
   (UNSPEC_FSTCW		26)
   (UNSPEC_ADD_CARRY		27)
   (UNSPEC_FLDCW		28)

   ; For SSE/MMX support:
   (UNSPEC_FIX			30)
   (UNSPEC_MASKMOV		32)
   (UNSPEC_MOVMSK		33)
   (UNSPEC_MOVNT		34)
   (UNSPEC_MOVA			38)
   (UNSPEC_MOVU			39)
   (UNSPEC_SHUFFLE		41)
   (UNSPEC_RCP			42)
   (UNSPEC_RSQRT		43)
   (UNSPEC_SFENCE		44)
   (UNSPEC_NOP			45)	; prevents combiner cleverness
   (UNSPEC_PAVGUSB		49)
   (UNSPEC_PFRCP		50)
   (UNSPEC_PFRCPIT1		51)
   (UNSPEC_PFRCPIT2		52)
   (UNSPEC_PFRSQRT		53)
   (UNSPEC_PFRSQIT1		54)
   (UNSPEC_PSHUFLW		55)
   (UNSPEC_PSHUFHW		56)
   (UNSPEC_MFENCE		59)
   (UNSPEC_LFENCE		60)
   (UNSPEC_PSADBW		61)
   (UNSPEC_ADDSUB		71)
   (UNSPEC_HADD			72)
   (UNSPEC_HSUB			73)
   (UNSPEC_MOVSHDUP		74)
   (UNSPEC_MOVSLDUP		75)
   (UNSPEC_LDQQU		76)
   (UNSPEC_MOVDDUP		77)

   ; x87 Floating point
   (UNSPEC_FPATAN		65)
   (UNSPEC_FYL2X		66)
   (UNSPEC_FSCALE		67)
   (UNSPEC_FRNDINT		68)
   (UNSPEC_F2XM1		69)

   ; REP instruction
   (UNSPEC_REP			75)
  ])

(define_constants
  [(UNSPECV_BLOCKAGE		0)
   (UNSPECV_STACK_PROBE		10)
   (UNSPECV_EH_RETURN		13)
   (UNSPECV_EMMS		31)
   (UNSPECV_LDMXCSR		37)
   (UNSPECV_STMXCSR		40)
   (UNSPECV_FEMMS		46)
   (UNSPECV_CLFLUSH		57)
   (UNSPECV_ALIGN		68)
   (UNSPECV_MONITOR		69)
   (UNSPECV_MWAIT		70)
  ])

;; Insns whose names begin with "x86_" are emitted by gen_FOO calls
;; from i386.c.

;; In C guard expressions, put expressions which may be compile-time
;; constants first.  This allows for better optimization.  For
;; example, write "TARGET_64BIT && reload_completed", not
;; "reload_completed && TARGET_64BIT".


;; Processor type.  This attribute must exactly match the processor_type
;; enumeration in i386.h.
(define_attr "cpu" "i386,i486,pentium,pentiumpro,k6,athlon,pentium4,k8"
  (const (symbol_ref "ix86_tune")))

;; A basic instruction type.  Refinements due to arguments to be
;; provided in other attributes.
(define_attr "type"
  "other,multi,
   alu,alu1,negnot,imov,imovx,lea,
   incdec,ishift,ishift1,rotate,rotate1,imul,idiv,
   icmp,test,ibr,setcc,icmov,
   push,pop,call,callv,leave,
   str,cld,
   fmov,fop,fsgn,fmul,fdiv,fpspc,fcmov,fcmp,fxch,fistp,
   sselog,sseiadd,sseishft,sseimul,
   sse,ssemov,sseadd,ssemul,ssecmp,ssecomi,ssecvt,sseicvt,ssediv,
   mmx,mmxmov,mmxadd,mmxmul,mmxcmp,mmxcvt,mmxshft"
  (const_string "other"))

;; Main data type used by the insn
(define_attr "mode"
  "unknown,none,QI,HI,SI,DI,SF,DF,XF,TI,V4SF,V2DF,V2SF"
  (const_string "unknown"))

;; The CPU unit operations uses.
(define_attr "unit" "integer,i387,sse,mmx,unknown"
  (cond [(eq_attr "type" "fmov,fop,fsgn,fmul,fdiv,fpspc,fcmov,fcmp,fxch,fistp")
	   (const_string "i387")
	 (eq_attr "type" "sselog,sseiadd,sseishft,sseimul,
			  sse,ssemov,sseadd,ssemul,ssecmp,ssecomi,ssecvt,sseicvt,ssediv")
	   (const_string "sse")
	 (eq_attr "type" "mmx,mmxmov,mmxadd,mmxmul,mmxcmp,mmxcvt,mmxshft")
	   (const_string "mmx")
	 (eq_attr "type" "other")
	   (const_string "unknown")]
	 (const_string "integer")))

;; The (bounding maximum) length of an instruction immediate.
(define_attr "length_immediate" ""
  (cond [(eq_attr "type" "incdec,setcc,icmov,str,cld,lea,other,multi,idiv,leave")
	   (const_int 0)
	 (eq_attr "unit" "i387,sse,mmx")
	   (const_int 0)
	 (eq_attr "type" "alu,alu1,negnot,imovx,ishift,rotate,ishift1,rotate1,
			  imul,icmp,push,pop")
	   (symbol_ref "ix86_attr_length_immediate_default(insn,1)")
	 (eq_attr "type" "imov,test")
	   (symbol_ref "ix86_attr_length_immediate_default(insn,0)")
	 (eq_attr "type" "call")
	   (if_then_else (match_operand 0 "constant_call_address_operand" "")
	     (const_int 4)
	     (const_int 0))
	 (eq_attr "type" "callv")
	   (if_then_else (match_operand 1 "constant_call_address_operand" "")
	     (const_int 4)
	     (const_int 0))
	 ;; We don't know the size before shorten_branches.  Expect
	 ;; the instruction to fit for better scheduling.
	 (eq_attr "type" "ibr")
	   (const_int 1)
	 ]
	 (symbol_ref "/* Update immediate_length and other attributes! */
		      abort(),1")))

;; The (bounding maximum) length of an instruction address.
(define_attr "length_address" ""
  (cond [(eq_attr "type" "str,cld,other,multi,fxch")
	   (const_int 0)
	 (and (eq_attr "type" "call")
	      (match_operand 0 "constant_call_address_operand" ""))
	     (const_int 0)
	 (and (eq_attr "type" "callv")
	      (match_operand 1 "constant_call_address_operand" ""))
	     (const_int 0)
	 ]
	 (symbol_ref "ix86_attr_length_address_default (insn)")))

;; Set when length prefix is used.
(define_attr "prefix_data16" ""
  (if_then_else (ior (eq_attr "mode" "HI")
		     (and (eq_attr "unit" "sse") (eq_attr "mode" "V2DF")))
    (const_int 1)
    (const_int 0)))

;; Set when string REP prefix is used.
(define_attr "prefix_rep" "" 
  (if_then_else (and (eq_attr "unit" "sse") (eq_attr "mode" "SF,DF"))
    (const_int 1)
    (const_int 0)))

;; Set when 0f opcode prefix is used.
(define_attr "prefix_0f" ""
  (if_then_else 
    (ior (eq_attr "type" "imovx,setcc,icmov")
	 (eq_attr "unit" "sse,mmx"))
    (const_int 1)
    (const_int 0)))

;; Set when 0f opcode prefix is used.
(define_attr "prefix_rex" ""
  (cond [(and (eq_attr "mode" "DI")
  	      (eq_attr "type" "!push,pop,call,callv,leave,ibr"))
	   (const_int 1)
	 (and (eq_attr "mode" "QI")
	      (ne (symbol_ref "x86_extended_QIreg_mentioned_p (insn)")
		  (const_int 0)))
	   (const_int 1)
	 (ne (symbol_ref "x86_extended_reg_mentioned_p (insn)")
	     (const_int 0))
	   (const_int 1)
	]
	(const_int 0)))

;; Set when modrm byte is used.
(define_attr "modrm" ""
  (cond [(eq_attr "type" "str,cld,leave")
	   (const_int 0)
	 (eq_attr "unit" "i387")
	   (const_int 0)
         (and (eq_attr "type" "incdec")
	      (ior (match_operand:SI 1 "register_operand" "")
		   (match_operand:HI 1 "register_operand" "")))
	   (const_int 0)
	 (and (eq_attr "type" "push")
	      (not (match_operand 1 "memory_operand" "")))
	   (const_int 0)
	 (and (eq_attr "type" "pop")
	      (not (match_operand 0 "memory_operand" "")))
	   (const_int 0)
	 (and (eq_attr "type" "imov")
	      (and (match_operand 0 "register_operand" "")
	           (match_operand 1 "immediate_operand" "")))
	   (const_int 0)
	 (and (eq_attr "type" "call")
	      (match_operand 0 "constant_call_address_operand" ""))
	     (const_int 0)
	 (and (eq_attr "type" "callv")
	      (match_operand 1 "constant_call_address_operand" ""))
	     (const_int 0)
	 ]
	 (const_int 1)))

;; The (bounding maximum) length of an instruction in bytes.
;; ??? fistp is in fact fldcw/fistp/fldcw sequence.  Later we may want
;; to split it and compute proper length as for other insns.
(define_attr "length" ""
  (cond [(eq_attr "type" "other,multi,fistp")
	   (const_int 16)
	 (eq_attr "type" "fcmp")
	   (const_int 4)
	 (eq_attr "unit" "i387")
	   (plus (const_int 2)
		 (plus (attr "prefix_data16")
		       (attr "length_address")))]
	 (plus (plus (attr "modrm")
		     (plus (attr "prefix_0f")
			   (plus (attr "prefix_rex")
				 (const_int 1))))
	       (plus (attr "prefix_rep")
		     (plus (attr "prefix_data16")
			   (plus (attr "length_immediate")
				 (attr "length_address")))))))

;; The `memory' attribute is `none' if no memory is referenced, `load' or
;; `store' if there is a simple memory reference therein, or `unknown'
;; if the instruction is complex.

(define_attr "memory" "none,load,store,both,unknown"
  (cond [(eq_attr "type" "other,multi,str")
	   (const_string "unknown")
	 (eq_attr "type" "lea,fcmov,fpspc,cld")
	   (const_string "none")
	 (eq_attr "type" "fistp,leave")
	   (const_string "both")
	 (eq_attr "type" "push")
	   (if_then_else (match_operand 1 "memory_operand" "")
	     (const_string "both")
	     (const_string "store"))
	 (eq_attr "type" "pop")
	   (if_then_else (match_operand 0 "memory_operand" "")
	     (const_string "both")
	     (const_string "load"))
	 (eq_attr "type" "setcc")
	   (if_then_else (match_operand 0 "memory_operand" "")
	     (const_string "store")
	     (const_string "none"))
	 (eq_attr "type" "icmp,test,ssecmp,ssecomi,mmxcmp,fcmp")
	   (if_then_else (ior (match_operand 0 "memory_operand" "")
			      (match_operand 1 "memory_operand" ""))
	     (const_string "load")
	     (const_string "none"))
	 (eq_attr "type" "ibr")
	   (if_then_else (match_operand 0 "memory_operand" "")
	     (const_string "load")
	     (const_string "none"))
	 (eq_attr "type" "call")
	   (if_then_else (match_operand 0 "constant_call_address_operand" "")
	     (const_string "none")
	     (const_string "load"))
	 (eq_attr "type" "callv")
	   (if_then_else (match_operand 1 "constant_call_address_operand" "")
	     (const_string "none")
	     (const_string "load"))
	 (and (eq_attr "type" "alu1,negnot,ishift1")
	      (match_operand 1 "memory_operand" ""))
	   (const_string "both")
	 (and (match_operand 0 "memory_operand" "")
	      (match_operand 1 "memory_operand" ""))
	   (const_string "both")
	 (match_operand 0 "memory_operand" "")
	   (const_string "store")
	 (match_operand 1 "memory_operand" "")
	   (const_string "load")
	 (and (eq_attr "type"
		 "!alu1,negnot,ishift1,
		   imov,imovx,icmp,test,
		   fmov,fcmp,fsgn,
		   sse,ssemov,ssecmp,ssecomi,ssecvt,sseicvt,
		   mmx,mmxmov,mmxcmp,mmxcvt")
	      (match_operand 2 "memory_operand" ""))
	   (const_string "load")
	 (and (eq_attr "type" "icmov")
	      (match_operand 3 "memory_operand" ""))
	   (const_string "load")
	]
	(const_string "none")))

;; Indicates if an instruction has both an immediate and a displacement.

(define_attr "imm_disp" "false,true,unknown"
  (cond [(eq_attr "type" "other,multi")
	   (const_string "unknown")
	 (and (eq_attr "type" "icmp,test,imov,alu1,ishift1,rotate1")
	      (and (match_operand 0 "memory_displacement_operand" "")
		   (match_operand 1 "immediate_operand" "")))
	   (const_string "true")
	 (and (eq_attr "type" "alu,ishift,rotate,imul,idiv")
	      (and (match_operand 0 "memory_displacement_operand" "")
		   (match_operand 2 "immediate_operand" "")))
	   (const_string "true")
	]
	(const_string "false")))

;; Indicates if an FP operation has an integer source.

(define_attr "fp_int_src" "false,true"
  (const_string "false"))

;; Describe a user's asm statement.
(define_asm_attributes
  [(set_attr "length" "128")
   (set_attr "type" "multi")])

(include "pentium.md")
(include "ppro.md")
(include "k6.md")
(include "athlon.md")

;; Compare instructions.

;; All compare insns have expanders that save the operands away without
;; actually generating RTL.  The bCOND or sCOND (emitted immediately
;; after the cmp) will actually emit the cmpM.

(define_expand "cmpdi"
  [(set (reg:CC 17)
	(compare:CC (match_operand:DI 0 "nonimmediate_operand" "")
		    (match_operand:DI 1 "x86_64_general_operand" "")))]
  ""
{
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[0] = force_reg (DImode, operands[0]);
  ix86_compare_op0 = operands[0];
  ix86_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmpsi"
  [(set (reg:CC 17)
	(compare:CC (match_operand:SI 0 "cmpsi_operand" "")
		    (match_operand:SI 1 "general_operand" "")))]
  ""
{
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[0] = force_reg (SImode, operands[0]);
  ix86_compare_op0 = operands[0];
  ix86_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmphi"
  [(set (reg:CC 17)
	(compare:CC (match_operand:HI 0 "nonimmediate_operand" "")
		    (match_operand:HI 1 "general_operand" "")))]
  ""
{
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[0] = force_reg (HImode, operands[0]);
  ix86_compare_op0 = operands[0];
  ix86_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmpqi"
  [(set (reg:CC 17)
	(compare:CC (match_operand:QI 0 "nonimmediate_operand" "")
		    (match_operand:QI 1 "general_operand" "")))]
  "TARGET_QIMODE_MATH"
{
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[0] = force_reg (QImode, operands[0]);
  ix86_compare_op0 = operands[0];
  ix86_compare_op1 = operands[1];
  DONE;
})

(define_insn "cmpdi_ccno_1_rex64"
  [(set (reg 17)
	(compare (match_operand:DI 0 "nonimmediate_operand" "r,?mr")
		 (match_operand:DI 1 "const0_operand" "n,n")))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  "@
   test{q}\t{%0, %0|%0, %0}
   cmp{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test,icmp")
   (set_attr "length_immediate" "0,1")
   (set_attr "mode" "DI")])

(define_insn "*cmpdi_minus_1_rex64"
  [(set (reg 17)
	(compare (minus:DI (match_operand:DI 0 "nonimmediate_operand" "rm,r")
			   (match_operand:DI 1 "x86_64_general_operand" "re,mr"))
		 (const_int 0)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)"
  "cmp{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "DI")])

(define_expand "cmpdi_1_rex64"
  [(set (reg:CC 17)
	(compare:CC (match_operand:DI 0 "nonimmediate_operand" "")
		    (match_operand:DI 1 "general_operand" "")))]
  "TARGET_64BIT"
  "")

(define_insn "cmpdi_1_insn_rex64"
  [(set (reg 17)
	(compare (match_operand:DI 0 "nonimmediate_operand" "mr,r")
		 (match_operand:DI 1 "x86_64_general_operand" "re,mr")))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "DI")])


(define_insn "*cmpsi_ccno_1"
  [(set (reg 17)
	(compare (match_operand:SI 0 "nonimmediate_operand" "r,?mr")
		 (match_operand:SI 1 "const0_operand" "n,n")))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "@
   test{l}\t{%0, %0|%0, %0}
   cmp{l}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test,icmp")
   (set_attr "length_immediate" "0,1")
   (set_attr "mode" "SI")])

(define_insn "*cmpsi_minus_1"
  [(set (reg 17)
	(compare (minus:SI (match_operand:SI 0 "nonimmediate_operand" "rm,r")
			   (match_operand:SI 1 "general_operand" "ri,mr"))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCGOCmode)"
  "cmp{l}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "SI")])

(define_expand "cmpsi_1"
  [(set (reg:CC 17)
	(compare:CC (match_operand:SI 0 "nonimmediate_operand" "rm,r")
		    (match_operand:SI 1 "general_operand" "ri,mr")))]
  ""
  "")

(define_insn "*cmpsi_1_insn"
  [(set (reg 17)
	(compare (match_operand:SI 0 "nonimmediate_operand" "rm,r")
		 (match_operand:SI 1 "general_operand" "ri,mr")))]
  "(GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
    && ix86_match_ccmode (insn, CCmode)"
  "cmp{l}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "SI")])

(define_insn "*cmphi_ccno_1"
  [(set (reg 17)
	(compare (match_operand:HI 0 "nonimmediate_operand" "r,?mr")
		 (match_operand:HI 1 "const0_operand" "n,n")))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "@
   test{w}\t{%0, %0|%0, %0}
   cmp{w}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test,icmp")
   (set_attr "length_immediate" "0,1")
   (set_attr "mode" "HI")])

(define_insn "*cmphi_minus_1"
  [(set (reg 17)
	(compare (minus:HI (match_operand:HI 0 "nonimmediate_operand" "rm,r")
			   (match_operand:HI 1 "general_operand" "ri,mr"))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCGOCmode)"
  "cmp{w}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "HI")])

(define_insn "*cmphi_1"
  [(set (reg 17)
	(compare (match_operand:HI 0 "nonimmediate_operand" "rm,r")
		 (match_operand:HI 1 "general_operand" "ri,mr")))]
  "(GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && ix86_match_ccmode (insn, CCmode)"
  "cmp{w}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "HI")])

(define_insn "*cmpqi_ccno_1"
  [(set (reg 17)
	(compare (match_operand:QI 0 "nonimmediate_operand" "q,?mq")
		 (match_operand:QI 1 "const0_operand" "n,n")))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "@
   test{b}\t{%0, %0|%0, %0}
   cmp{b}\t{$0, %0|%0, 0}"
  [(set_attr "type" "test,icmp")
   (set_attr "length_immediate" "0,1")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_1"
  [(set (reg 17)
	(compare (match_operand:QI 0 "nonimmediate_operand" "qm,q")
		 (match_operand:QI 1 "general_operand" "qi,mq")))]
  "(GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
    && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_minus_1"
  [(set (reg 17)
	(compare (minus:QI (match_operand:QI 0 "nonimmediate_operand" "qm,q")
			   (match_operand:QI 1 "general_operand" "qi,mq"))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCGOCmode)"
  "cmp{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_ext_1"
  [(set (reg 17)
	(compare
	  (match_operand:QI 0 "general_operand" "Qm")
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)))]
  "!TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%h1, %0|%0, %h1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_ext_1_rex64"
  [(set (reg 17)
	(compare
	  (match_operand:QI 0 "register_operand" "Q")
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%h1, %0|%0, %h1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_ext_2"
  [(set (reg 17)
	(compare
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)
	  (match_operand:QI 1 "const0_operand" "n")))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t%h0, %h0"
  [(set_attr "type" "test")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_expand "cmpqi_ext_3"
  [(set (reg:CC 17)
	(compare:CC
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "")
	      (const_int 8)
	      (const_int 8)) 0)
	  (match_operand:QI 1 "general_operand" "")))]
  ""
  "")

(define_insn "cmpqi_ext_3_insn"
  [(set (reg 17)
	(compare
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)
	  (match_operand:QI 1 "general_operand" "Qmn")))]
  "!TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

(define_insn "cmpqi_ext_3_insn_rex64"
  [(set (reg 17)
	(compare
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)
	  (match_operand:QI 1 "nonmemory_operand" "Qn")))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

(define_insn "*cmpqi_ext_4"
  [(set (reg 17)
	(compare
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)
	  (subreg:QI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)) 0)))]
  "ix86_match_ccmode (insn, CCmode)"
  "cmp{b}\t{%h1, %h0|%h0, %h1}"
  [(set_attr "type" "icmp")
   (set_attr "mode" "QI")])

;; These implement float point compares.
;; %%% See if we can get away with VOIDmode operands on the actual insns,
;; which would allow mix and match FP modes on the compares.  Which is what
;; the old patterns did, but with many more of them.

(define_expand "cmpxf"
  [(set (reg:CC 17)
	(compare:CC (match_operand:XF 0 "cmp_fp_expander_operand" "")
		    (match_operand:XF 1 "cmp_fp_expander_operand" "")))]
  "TARGET_80387"
{
  ix86_compare_op0 = operands[0];
  ix86_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmpdf"
  [(set (reg:CC 17)
	(compare:CC (match_operand:DF 0 "cmp_fp_expander_operand" "")
		    (match_operand:DF 1 "cmp_fp_expander_operand" "")))]
  "TARGET_80387 || TARGET_SSE2"
{
  ix86_compare_op0 = operands[0];
  ix86_compare_op1 = operands[1];
  DONE;
})

(define_expand "cmpsf"
  [(set (reg:CC 17)
	(compare:CC (match_operand:SF 0 "cmp_fp_expander_operand" "")
		    (match_operand:SF 1 "cmp_fp_expander_operand" "")))]
  "TARGET_80387 || TARGET_SSE"
{
  ix86_compare_op0 = operands[0];
  ix86_compare_op1 = operands[1];
  DONE;
})

;; FP compares, step 1:
;; Set the FP condition codes.
;;
;; CCFPmode	compare with exceptions
;; CCFPUmode	compare with no exceptions

;; %%% It is an unfortunate fact that ftst has no non-popping variant,
;; and that fp moves clobber the condition codes, and that there is
;; currently no way to describe this fact to reg-stack.  So there are
;; no splitters yet for this.

;; %%% YIKES!  This scheme does not retain a strong connection between 
;; the real compare and the ultimate cc0 user, so CC_REVERSE does not
;; work!  Only allow tos/mem with tos in op 0.
;;
;; Hmm, of course, this is what the actual _hardware_ does.  Perhaps
;; things aren't as bad as they sound...

(define_insn "*cmpfp_0"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFP (match_operand 1 "register_operand" "f")
		         (match_operand 2 "const0_operand" "X"))]
	  UNSPEC_FNSTSW))]
  "TARGET_80387
   && FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])"
{
  if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
    return "ftst\;fnstsw\t%0\;fstp\t%y0";
  else
    return "ftst\;fnstsw\t%0";
}
  [(set_attr "type" "multi")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))])

;; We may not use "#" to split and emit these, since the REG_DEAD notes
;; used to manage the reg stack popping would not be preserved.

(define_insn "*cmpfp_2_sf"
  [(set (reg:CCFP 18)
	(compare:CCFP
	  (match_operand:SF 0 "register_operand" "f")
	  (match_operand:SF 1 "nonimmediate_operand" "fm")))]
  "TARGET_80387"
  "* return output_fp_compare (insn, operands, 0, 0);"
  [(set_attr "type" "fcmp")
   (set_attr "mode" "SF")])

(define_insn "*cmpfp_2_sf_1"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFP
	     (match_operand:SF 1 "register_operand" "f")
	     (match_operand:SF 2 "nonimmediate_operand" "fm"))]
	  UNSPEC_FNSTSW))]
  "TARGET_80387"
  "* return output_fp_compare (insn, operands, 2, 0);"
  [(set_attr "type" "fcmp")
   (set_attr "mode" "SF")])

(define_insn "*cmpfp_2_df"
  [(set (reg:CCFP 18)
	(compare:CCFP
	  (match_operand:DF 0 "register_operand" "f")
	  (match_operand:DF 1 "nonimmediate_operand" "fm")))]
  "TARGET_80387"
  "* return output_fp_compare (insn, operands, 0, 0);"
  [(set_attr "type" "fcmp")
   (set_attr "mode" "DF")])

(define_insn "*cmpfp_2_df_1"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFP
	     (match_operand:DF 1 "register_operand" "f")
	     (match_operand:DF 2 "nonimmediate_operand" "fm"))]
	  UNSPEC_FNSTSW))]
  "TARGET_80387"
  "* return output_fp_compare (insn, operands, 2, 0);"
  [(set_attr "type" "multi")
   (set_attr "mode" "DF")])

(define_insn "*cmpfp_2_xf"
  [(set (reg:CCFP 18)
	(compare:CCFP
	  (match_operand:XF 0 "register_operand" "f")
	  (match_operand:XF 1 "register_operand" "f")))]
  "TARGET_80387"
  "* return output_fp_compare (insn, operands, 0, 0);"
  [(set_attr "type" "fcmp")
   (set_attr "mode" "XF")])

(define_insn "*cmpfp_2_xf_1"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFP
	     (match_operand:XF 1 "register_operand" "f")
	     (match_operand:XF 2 "register_operand" "f"))]
	  UNSPEC_FNSTSW))]
  "TARGET_80387"
  "* return output_fp_compare (insn, operands, 2, 0);"
  [(set_attr "type" "multi")
   (set_attr "mode" "XF")])

(define_insn "*cmpfp_2u"
  [(set (reg:CCFPU 18)
	(compare:CCFPU
	  (match_operand 0 "register_operand" "f")
	  (match_operand 1 "register_operand" "f")))]
  "TARGET_80387
   && FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 0, 1);"
  [(set_attr "type" "fcmp")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))])

(define_insn "*cmpfp_2u_1"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI
	  [(compare:CCFPU
	     (match_operand 1 "register_operand" "f")
	     (match_operand 2 "register_operand" "f"))]
	  UNSPEC_FNSTSW))]
  "TARGET_80387
   && FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])"
  "* return output_fp_compare (insn, operands, 2, 1);"
  [(set_attr "type" "multi")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))])

;; Patterns to match the SImode-in-memory ficom instructions.
;;
;; %%% Play games with accepting gp registers, as otherwise we have to
;; force them to memory during rtl generation, which is no good.  We
;; can get rid of this once we teach reload to do memory input reloads 
;; via pushes.

(define_insn "*ficom_1"
  [(set (reg:CCFP 18)
	(compare:CCFP
	  (match_operand 0 "register_operand" "f,f")
	  (float (match_operand:SI 1 "nonimmediate_operand" "m,?r"))))]
  "0 && TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (XEXP (SET_SRC (PATTERN (insn)), 1)) == GET_MODE (operands[0])"
  "#")

;; Split the not-really-implemented gp register case into a
;; push-op-pop sequence.
;;
;; %%% This is most efficient, but am I gonna get in trouble
;; for separating cc0_setter and cc0_user?

(define_split
  [(set (reg:CCFP 18)
	(compare:CCFP
	  (match_operand:SF 0 "register_operand" "")
	  (float (match_operand:SI 1 "register_operand" ""))))]
  "0 && TARGET_80387 && reload_completed"
  [(set (mem:SI (pre_dec:SI (reg:SI 7))) (match_dup 1))
   (set (reg:CCFP 18) (compare:CCFP (match_dup 0) (match_dup 2)))
   (parallel [(set (match_dup 1) (mem:SI (reg:SI 7)))
              (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))])]
  "operands[2] = gen_rtx_MEM (Pmode, stack_pointer_rtx);
   operands[2] = gen_rtx_FLOAT (GET_MODE (operands[0]), operands[2]);")

;; FP compares, step 2
;; Move the fpsw to ax.

(define_insn "*x86_fnstsw_1"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(unspec:HI [(reg 18)] UNSPEC_FNSTSW))]
  "TARGET_80387"
  "fnstsw\t%0"
  [(set_attr "length" "2")
   (set_attr "mode" "SI")
   (set_attr "unit" "i387")
   (set_attr "ppro_uops" "few")])

;; FP compares, step 3
;; Get ax into flags, general case.

(define_insn "x86_sahf_1"
  [(set (reg:CC 17)
	(unspec:CC [(match_operand:HI 0 "register_operand" "a")] UNSPEC_SAHF))]
  "!TARGET_64BIT"
  "sahf"
  [(set_attr "length" "1")
   (set_attr "athlon_decode" "vector")
   (set_attr "mode" "SI")
   (set_attr "ppro_uops" "one")])

;; Pentium Pro can do steps 1 through 3 in one go.

(define_insn "*cmpfp_i"
  [(set (reg:CCFP 17)
	(compare:CCFP (match_operand 0 "register_operand" "f")
		      (match_operand 1 "register_operand" "f")))]
  "TARGET_80387 && TARGET_CMOVE
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[0])"
  "* return output_fp_compare (insn, operands, 1, 0);"
  [(set_attr "type" "fcmp")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))
   (set_attr "athlon_decode" "vector")])

(define_insn "*cmpfp_i_sse"
  [(set (reg:CCFP 17)
	(compare:CCFP (match_operand 0 "register_operand" "f#x,x#f")
		      (match_operand 1 "nonimmediate_operand" "f#x,xm#f")))]
  "TARGET_80387
   && SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[0])"
  "* return output_fp_compare (insn, operands, 1, 0);"
  [(set_attr "type" "fcmp,ssecomi")
   (set (attr "mode")
     (if_then_else (match_operand:SF 1 "" "")
        (const_string "SF")
        (const_string "DF")))
   (set_attr "athlon_decode" "vector")])

(define_insn "*cmpfp_i_sse_only"
  [(set (reg:CCFP 17)
	(compare:CCFP (match_operand 0 "register_operand" "x")
		      (match_operand 1 "nonimmediate_operand" "xm")))]
  "SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[0])"
  "* return output_fp_compare (insn, operands, 1, 0);"
  [(set_attr "type" "ssecomi")
   (set (attr "mode")
     (if_then_else (match_operand:SF 1 "" "")
        (const_string "SF")
        (const_string "DF")))
   (set_attr "athlon_decode" "vector")])

(define_insn "*cmpfp_iu"
  [(set (reg:CCFPU 17)
	(compare:CCFPU (match_operand 0 "register_operand" "f")
		       (match_operand 1 "register_operand" "f")))]
  "TARGET_80387 && TARGET_CMOVE
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 1);"
  [(set_attr "type" "fcmp")
   (set (attr "mode")
     (cond [(match_operand:SF 1 "" "")
	      (const_string "SF")
	    (match_operand:DF 1 "" "")
	      (const_string "DF")
	   ]
	   (const_string "XF")))
   (set_attr "athlon_decode" "vector")])

(define_insn "*cmpfp_iu_sse"
  [(set (reg:CCFPU 17)
	(compare:CCFPU (match_operand 0 "register_operand" "f#x,x#f")
		       (match_operand 1 "nonimmediate_operand" "f#x,xm#f")))]
  "TARGET_80387
   && SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 1);"
  [(set_attr "type" "fcmp,ssecomi")
   (set (attr "mode")
     (if_then_else (match_operand:SF 1 "" "")
        (const_string "SF")
        (const_string "DF")))
   (set_attr "athlon_decode" "vector")])

(define_insn "*cmpfp_iu_sse_only"
  [(set (reg:CCFPU 17)
	(compare:CCFPU (match_operand 0 "register_operand" "x")
		       (match_operand 1 "nonimmediate_operand" "xm")))]
  "SSE_FLOAT_MODE_P (GET_MODE (operands[0]))
   && GET_MODE (operands[0]) == GET_MODE (operands[1])"
  "* return output_fp_compare (insn, operands, 1, 1);"
  [(set_attr "type" "ssecomi")
   (set (attr "mode")
     (if_then_else (match_operand:SF 1 "" "")
        (const_string "SF")
        (const_string "DF")))
   (set_attr "athlon_decode" "vector")])

;; Move instructions.

;; General case of fullword move.

(define_expand "movsi"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(match_operand:SI 1 "general_operand" ""))]
  ""
  "ix86_expand_move (SImode, operands); DONE;")

;; Push/pop instructions.  They are separate since autoinc/dec is not a
;; general_operand.
;;
;; %%% We don't use a post-inc memory reference because x86 is not a 
;; general AUTO_INC_DEC host, which impacts how it is treated in flow.
;; Changing this impacts compiler performance on other non-AUTO_INC_DEC
;; targets without our curiosities, and it is just as easy to represent
;; this differently.

(define_insn "*pushsi2"
  [(set (match_operand:SI 0 "push_operand" "=<")
	(match_operand:SI 1 "general_no_elim_operand" "ri*m"))]
  "!TARGET_64BIT"
  "push{l}\t%1"
  [(set_attr "type" "push")
   (set_attr "mode" "SI")])

;; For 64BIT abi we always round up to 8 bytes.
(define_insn "*pushsi2_rex64"
  [(set (match_operand:SI 0 "push_operand" "=X")
	(match_operand:SI 1 "nonmemory_no_elim_operand" "ri"))]
  "TARGET_64BIT"
  "push{q}\t%q1"
  [(set_attr "type" "push")
   (set_attr "mode" "SI")])

(define_insn "*pushsi2_prologue"
  [(set (match_operand:SI 0 "push_operand" "=<")
	(match_operand:SI 1 "general_no_elim_operand" "ri*m"))
   (clobber (mem:BLK (scratch)))]
  "!TARGET_64BIT"
  "push{l}\t%1"
  [(set_attr "type" "push")
   (set_attr "mode" "SI")])

(define_insn "*popsi1_epilogue"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r*m")
	(mem:SI (reg:SI 7)))
   (set (reg:SI 7)
	(plus:SI (reg:SI 7) (const_int 4)))
   (clobber (mem:BLK (scratch)))]
  "!TARGET_64BIT"
  "pop{l}\t%0"
  [(set_attr "type" "pop")
   (set_attr "mode" "SI")])

(define_insn "popsi1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r*m")
	(mem:SI (reg:SI 7)))
   (set (reg:SI 7)
	(plus:SI (reg:SI 7) (const_int 4)))]
  "!TARGET_64BIT"
  "pop{l}\t%0"
  [(set_attr "type" "pop")
   (set_attr "mode" "SI")])

(define_insn "*movsi_xor"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "const0_operand" "i"))
   (clobber (reg:CC 17))]
  "reload_completed && (!TARGET_USE_MOV0 || optimize_size)"
  "xor{l}\t{%0, %0|%0, %0}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")
   (set_attr "length_immediate" "0")])
 
(define_insn "*movsi_or"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "immediate_operand" "i"))
   (clobber (reg:CC 17))]
  "reload_completed
   && operands[1] == constm1_rtx
   && (TARGET_PENTIUM || optimize_size)"
{
  operands[1] = constm1_rtx;
  return "or{l}\t{%1, %0|%0, %1}";
}
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")
   (set_attr "length_immediate" "1")])

(define_insn "*movsi_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,m,!*y,!rm,!*y,!*Y,!rm,!*Y")
	(match_operand:SI 1 "general_operand" "rinm,rin,*y,*y,rm,*Y,*Y,rm"))]
  "(TARGET_INTER_UNIT_MOVES || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_SSEMOV:
      if (get_attr_mode (insn) == MODE_TI)
        return "movdqa\t{%1, %0|%0, %1}";
      return "movd\t{%1, %0|%0, %1}";

    case TYPE_MMXMOV:
      if (get_attr_mode (insn) == MODE_DI)
	return "movq\t{%1, %0|%0, %1}";
      return "movd\t{%1, %0|%0, %1}";

    case TYPE_LEA:
      return "lea{l}\t{%1, %0|%0, %1}";

    default:
      if (flag_pic && !LEGITIMATE_PIC_OPERAND_P (operands[1]))
	abort();
      return "mov{l}\t{%1, %0|%0, %1}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "2,3,4")
	      (const_string "mmxmov")
	    (eq_attr "alternative" "5,6,7")
	      (const_string "ssemov")
	    (and (ne (symbol_ref "flag_pic") (const_int 0))
		 (match_operand:SI 1 "symbolic_operand" ""))
	      (const_string "lea")
	   ]
	   (const_string "imov")))
   (set_attr "mode" "SI,SI,DI,SI,SI,TI,SI,SI")])

(define_insn "*movsi_1_nointernunit"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,m,!*y,!m,!*y,!*Y,!m,!*Y")
	(match_operand:SI 1 "general_operand" "rinm,rin,*y,*y,m,*Y,*Y,m"))]
  "(!TARGET_INTER_UNIT_MOVES && !optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_SSEMOV:
      if (get_attr_mode (insn) == MODE_TI)
        return "movdqa\t{%1, %0|%0, %1}";
      return "movd\t{%1, %0|%0, %1}";

    case TYPE_MMXMOV:
      if (get_attr_mode (insn) == MODE_DI)
	return "movq\t{%1, %0|%0, %1}";
      return "movd\t{%1, %0|%0, %1}";

    case TYPE_LEA:
      return "lea{l}\t{%1, %0|%0, %1}";

    default:
      if (flag_pic && !LEGITIMATE_PIC_OPERAND_P (operands[1]))
	abort();
      return "mov{l}\t{%1, %0|%0, %1}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "2,3,4")
	      (const_string "mmxmov")
	    (eq_attr "alternative" "5,6,7")
	      (const_string "ssemov")
	    (and (ne (symbol_ref "flag_pic") (const_int 0))
		 (match_operand:SI 1 "symbolic_operand" ""))
	      (const_string "lea")
	   ]
	   (const_string "imov")))
   (set_attr "mode" "SI,SI,DI,SI,SI,TI,SI,SI")])

;; Stores and loads of ax to arbitrary constant address.
;; We fake an second form of instruction to force reload to load address
;; into register when rax is not available
(define_insn "*movabssi_1_rex64"
  [(set (mem:SI (match_operand:DI 0 "x86_64_movabs_operand" "i,r"))
	(match_operand:SI 1 "nonmemory_operand" "a,er"))]
  "TARGET_64BIT && ix86_check_movabs (insn, 0)"
  "@
   movabs{l}\t{%1, %P0|%P0, %1}
   mov{l}\t{%1, %a0|%a0, %1}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0,*")
   (set_attr "length_address" "8,0")
   (set_attr "length_immediate" "0,*")
   (set_attr "memory" "store")
   (set_attr "mode" "SI")])

(define_insn "*movabssi_2_rex64"
  [(set (match_operand:SI 0 "register_operand" "=a,r")
        (mem:SI (match_operand:DI 1 "x86_64_movabs_operand" "i,r")))]
  "TARGET_64BIT && ix86_check_movabs (insn, 1)"
  "@
   movabs{l}\t{%P1, %0|%0, %P1}
   mov{l}\t{%a1, %0|%0, %a1}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0,*")
   (set_attr "length_address" "8,0")
   (set_attr "length_immediate" "0")
   (set_attr "memory" "load")
   (set_attr "mode" "SI")])

(define_insn "*swapsi"
  [(set (match_operand:SI 0 "register_operand" "+r")
	(match_operand:SI 1 "register_operand" "+r"))
   (set (match_dup 1)
	(match_dup 0))]
  ""
  "xchg{l}\t%1, %0"
  [(set_attr "type" "imov")
   (set_attr "pent_pair" "np")
   (set_attr "athlon_decode" "vector")
   (set_attr "mode" "SI")
   (set_attr "modrm" "0")
   (set_attr "ppro_uops" "few")])

(define_expand "movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
        (match_operand:HI 1 "general_operand" ""))]
  ""
  "ix86_expand_move (HImode, operands); DONE;")

(define_insn "*pushhi2"
  [(set (match_operand:HI 0 "push_operand" "=<,<")
	(match_operand:HI 1 "general_no_elim_operand" "n,r*m"))]
  "!TARGET_64BIT"
  "@
   push{w}\t{|WORD PTR }%1
   push{w}\t%1"
  [(set_attr "type" "push")
   (set_attr "mode" "HI")])

;; For 64BIT abi we always round up to 8 bytes.
(define_insn "*pushhi2_rex64"
  [(set (match_operand:HI 0 "push_operand" "=X")
	(match_operand:HI 1 "nonmemory_no_elim_operand" "ri"))]
  "TARGET_64BIT"
  "push{q}\t%q1"
  [(set_attr "type" "push")
   (set_attr "mode" "QI")])

(define_insn "*movhi_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,r,r,m")
	(match_operand:HI 1 "general_operand" "r,rn,rm,rn"))]
  "GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      /* movzwl is faster than movw on p2 due to partial word stalls,
	 though not as fast as an aligned movl.  */
      return "movz{wl|x}\t{%1, %k0|%k0, %1}";
    default:
      if (get_attr_mode (insn) == MODE_SI)
        return "mov{l}\t{%k1, %k0|%k0, %k1}";
      else
        return "mov{w}\t{%1, %0|%0, %1}";
    }
}
  [(set (attr "type")
     (cond [(and (eq_attr "alternative" "0")
		 (ior (eq (symbol_ref "TARGET_PARTIAL_REG_STALL")
			  (const_int 0))
		      (eq (symbol_ref "TARGET_HIMODE_MATH")
			  (const_int 0))))
	      (const_string "imov")
	    (and (eq_attr "alternative" "1,2")
		 (match_operand:HI 1 "aligned_operand" ""))
	      (const_string "imov")
	    (and (ne (symbol_ref "TARGET_MOVX")
		     (const_int 0))
		 (eq_attr "alternative" "0,2"))
	      (const_string "imovx")
	   ]
	   (const_string "imov")))
    (set (attr "mode")
      (cond [(eq_attr "type" "imovx")
	       (const_string "SI")
	     (and (eq_attr "alternative" "1,2")
		  (match_operand:HI 1 "aligned_operand" ""))
	       (const_string "SI")
	     (and (eq_attr "alternative" "0")
		  (ior (eq (symbol_ref "TARGET_PARTIAL_REG_STALL")
			   (const_int 0))
		       (eq (symbol_ref "TARGET_HIMODE_MATH")
			   (const_int 0))))
	       (const_string "SI")
	    ]
	    (const_string "HI")))])

;; Stores and loads of ax to arbitrary constant address.
;; We fake an second form of instruction to force reload to load address
;; into register when rax is not available
(define_insn "*movabshi_1_rex64"
  [(set (mem:HI (match_operand:DI 0 "x86_64_movabs_operand" "i,r"))
	(match_operand:HI 1 "nonmemory_operand" "a,er"))]
  "TARGET_64BIT && ix86_check_movabs (insn, 0)"
  "@
   movabs{w}\t{%1, %P0|%P0, %1}
   mov{w}\t{%1, %a0|%a0, %1}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0,*")
   (set_attr "length_address" "8,0")
   (set_attr "length_immediate" "0,*")
   (set_attr "memory" "store")
   (set_attr "mode" "HI")])

(define_insn "*movabshi_2_rex64"
  [(set (match_operand:HI 0 "register_operand" "=a,r")
        (mem:HI (match_operand:DI 1 "x86_64_movabs_operand" "i,r")))]
  "TARGET_64BIT && ix86_check_movabs (insn, 1)"
  "@
   movabs{w}\t{%P1, %0|%0, %P1}
   mov{w}\t{%a1, %0|%0, %a1}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0,*")
   (set_attr "length_address" "8,0")
   (set_attr "length_immediate" "0")
   (set_attr "memory" "load")
   (set_attr "mode" "HI")])

(define_insn "*swaphi_1"
  [(set (match_operand:HI 0 "register_operand" "+r")
	(match_operand:HI 1 "register_operand" "+r"))
   (set (match_dup 1)
	(match_dup 0))]
  "TARGET_PARTIAL_REG_STALL"
  "xchg{w}\t%1, %0"
  [(set_attr "type" "imov")
   (set_attr "pent_pair" "np")
   (set_attr "mode" "HI")
   (set_attr "modrm" "0")
   (set_attr "ppro_uops" "few")])

(define_insn "*swaphi_2"
  [(set (match_operand:HI 0 "register_operand" "+r")
	(match_operand:HI 1 "register_operand" "+r"))
   (set (match_dup 1)
	(match_dup 0))]
  "! TARGET_PARTIAL_REG_STALL"
  "xchg{l}\t%k1, %k0"
  [(set_attr "type" "imov")
   (set_attr "pent_pair" "np")
   (set_attr "mode" "SI")
   (set_attr "modrm" "0")
   (set_attr "ppro_uops" "few")])

(define_expand "movstricthi"
  [(set (strict_low_part (match_operand:HI 0 "nonimmediate_operand" ""))
	(match_operand:HI 1 "general_operand" ""))]
  "! TARGET_PARTIAL_REG_STALL || optimize_size"
{
  /* Don't generate memory->memory moves, go through a register */
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[1] = force_reg (HImode, operands[1]);
})

(define_insn "*movstricthi_1"
  [(set (strict_low_part (match_operand:HI 0 "nonimmediate_operand" "+rm,r"))
	(match_operand:HI 1 "general_operand" "rn,m"))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "mov{w}\t{%1, %0|%0, %1}"
  [(set_attr "type" "imov")
   (set_attr "mode" "HI")])

(define_insn "*movstricthi_xor"
  [(set (strict_low_part (match_operand:HI 0 "register_operand" "+r"))
	(match_operand:HI 1 "const0_operand" "i"))
   (clobber (reg:CC 17))]
  "reload_completed
   && ((!TARGET_USE_MOV0 && !TARGET_PARTIAL_REG_STALL) || optimize_size)"
  "xor{w}\t{%0, %0|%0, %0}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "HI")
   (set_attr "length_immediate" "0")])

(define_expand "movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(match_operand:QI 1 "general_operand" ""))]
  ""
  "ix86_expand_move (QImode, operands); DONE;")

;; emit_push_insn when it calls move_by_pieces requires an insn to
;; "push a byte".  But actually we use pushw, which has the effect
;; of rounding the amount pushed up to a halfword.

(define_insn "*pushqi2"
  [(set (match_operand:QI 0 "push_operand" "=X,X")
	(match_operand:QI 1 "nonmemory_no_elim_operand" "n,r"))]
  "!TARGET_64BIT"
  "@
   push{w}\t{|word ptr }%1
   push{w}\t%w1"
  [(set_attr "type" "push")
   (set_attr "mode" "HI")])

;; For 64BIT abi we always round up to 8 bytes.
(define_insn "*pushqi2_rex64"
  [(set (match_operand:QI 0 "push_operand" "=X")
	(match_operand:QI 1 "nonmemory_no_elim_operand" "qi"))]
  "TARGET_64BIT"
  "push{q}\t%q1"
  [(set_attr "type" "push")
   (set_attr "mode" "QI")])

;; Situation is quite tricky about when to choose full sized (SImode) move
;; over QImode moves.  For Q_REG -> Q_REG move we use full size only for
;; partial register dependency machines (such as AMD Athlon), where QImode
;; moves issue extra dependency and for partial register stalls machines
;; that don't use QImode patterns (and QImode move cause stall on the next
;; instruction).
;;
;; For loads of Q_REG to NONQ_REG we use full sized moves except for partial
;; register stall machines with, where we use QImode instructions, since
;; partial register stall can be caused there.  Then we use movzx.
(define_insn "*movqi_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=q,q ,q ,r,r ,?r,m")
	(match_operand:QI 1 "general_operand"      " q,qn,qm,q,rn,qm,qn"))]
  "GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      if (!ANY_QI_REG_P (operands[1]) && GET_CODE (operands[1]) != MEM)
	abort ();
      return "movz{bl|x}\t{%1, %k0|%k0, %1}";
    default:
      if (get_attr_mode (insn) == MODE_SI)
        return "mov{l}\t{%k1, %k0|%k0, %k1}";
      else
        return "mov{b}\t{%1, %0|%0, %1}";
    }
}
  [(set (attr "type")
     (cond [(and (eq_attr "alternative" "3")
		 (ior (eq (symbol_ref "TARGET_PARTIAL_REG_STALL")
			  (const_int 0))
		      (eq (symbol_ref "TARGET_QIMODE_MATH")
			  (const_int 0))))
	      (const_string "imov")
	    (eq_attr "alternative" "3,5")
	      (const_string "imovx")
	    (and (ne (symbol_ref "TARGET_MOVX")
		     (const_int 0))
		 (eq_attr "alternative" "2"))
	      (const_string "imovx")
	   ]
	   (const_string "imov")))
   (set (attr "mode")
      (cond [(eq_attr "alternative" "3,4,5")
	       (const_string "SI")
	     (eq_attr "alternative" "6")
	       (const_string "QI")
	     (eq_attr "type" "imovx")
	       (const_string "SI")
	     (and (eq_attr "type" "imov")
		  (and (eq_attr "alternative" "0,1,2")
		       (ne (symbol_ref "TARGET_PARTIAL_REG_DEPENDENCY")
			   (const_int 0))))
	       (const_string "SI")
	     ;; Avoid partial register stalls when not using QImode arithmetic
	     (and (eq_attr "type" "imov")
		  (and (eq_attr "alternative" "0,1,2")
		       (and (ne (symbol_ref "TARGET_PARTIAL_REG_STALL")
				(const_int 0))
			    (eq (symbol_ref "TARGET_QIMODE_MATH")
				(const_int 0)))))
	       (const_string "SI")
	   ]
	   (const_string "QI")))])

(define_expand "reload_outqi"
  [(parallel [(match_operand:QI 0 "" "=m")
              (match_operand:QI 1 "register_operand" "r")
              (match_operand:QI 2 "register_operand" "=&q")])]
  ""
{
  rtx op0, op1, op2;
  op0 = operands[0]; op1 = operands[1]; op2 = operands[2];

  if (reg_overlap_mentioned_p (op2, op0))
    abort ();
  if (! q_regs_operand (op1, QImode))
    {
      emit_insn (gen_movqi (op2, op1));
      op1 = op2;
    }
  emit_insn (gen_movqi (op0, op1));
  DONE;
})

(define_insn "*swapqi"
  [(set (match_operand:QI 0 "register_operand" "+r")
	(match_operand:QI 1 "register_operand" "+r"))
   (set (match_dup 1)
	(match_dup 0))]
  ""
  "xchg{b}\t%1, %0"
  [(set_attr "type" "imov")
   (set_attr "pent_pair" "np")
   (set_attr "mode" "QI")
   (set_attr "modrm" "0")
   (set_attr "ppro_uops" "few")])

(define_expand "movstrictqi"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" ""))
	(match_operand:QI 1 "general_operand" ""))]
  "! TARGET_PARTIAL_REG_STALL || optimize_size"
{
  /* Don't generate memory->memory moves, go through a register.  */
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[1] = force_reg (QImode, operands[1]);
})

(define_insn "*movstrictqi_1"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,q"))
	(match_operand:QI 1 "general_operand" "*qn,m"))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "mov{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "imov")
   (set_attr "mode" "QI")])

(define_insn "*movstrictqi_xor"
  [(set (strict_low_part (match_operand:QI 0 "q_regs_operand" "+q"))
	(match_operand:QI 1 "const0_operand" "i"))
   (clobber (reg:CC 17))]
  "reload_completed && (!TARGET_USE_MOV0 || optimize_size)"
  "xor{b}\t{%0, %0|%0, %0}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")
   (set_attr "length_immediate" "0")])

(define_insn "*movsi_extv_1"
  [(set (match_operand:SI 0 "register_operand" "=R")
	(sign_extract:SI (match_operand 1 "ext_register_operand" "Q")
			 (const_int 8)
			 (const_int 8)))]
  ""
  "movs{bl|x}\t{%h1, %0|%0, %h1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI")])

(define_insn "*movhi_extv_1"
  [(set (match_operand:HI 0 "register_operand" "=R")
	(sign_extract:HI (match_operand 1 "ext_register_operand" "Q")
			 (const_int 8)
			 (const_int 8)))]
  ""
  "movs{bl|x}\t{%h1, %k0|%k0, %h1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI")])

(define_insn "*movqi_extv_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=Qm,?r")
        (sign_extract:QI (match_operand 1 "ext_register_operand" "Q,Q")
                         (const_int 8)
                         (const_int 8)))]
  "!TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      return "movs{bl|x}\t{%h1, %k0|%k0, %h1}";
    default:
      return "mov{b}\t{%h1, %0|%0, %h1}";
    }
}
  [(set (attr "type")
     (if_then_else (and (match_operand:QI 0 "register_operand" "")
			(ior (not (match_operand:QI 0 "q_regs_operand" ""))
			     (ne (symbol_ref "TARGET_MOVX")
				 (const_int 0))))
	(const_string "imovx")
	(const_string "imov")))
   (set (attr "mode")
     (if_then_else (eq_attr "type" "imovx")
	(const_string "SI")
	(const_string "QI")))])

(define_insn "*movqi_extv_1_rex64"
  [(set (match_operand:QI 0 "register_operand" "=Q,?R")
        (sign_extract:QI (match_operand 1 "ext_register_operand" "Q,Q")
                         (const_int 8)
                         (const_int 8)))]
  "TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      return "movs{bl|x}\t{%h1, %k0|%k0, %h1}";
    default:
      return "mov{b}\t{%h1, %0|%0, %h1}";
    }
}
  [(set (attr "type")
     (if_then_else (and (match_operand:QI 0 "register_operand" "")
			(ior (not (match_operand:QI 0 "q_regs_operand" ""))
			     (ne (symbol_ref "TARGET_MOVX")
				 (const_int 0))))
	(const_string "imovx")
	(const_string "imov")))
   (set (attr "mode")
     (if_then_else (eq_attr "type" "imovx")
	(const_string "SI")
	(const_string "QI")))])

;; Stores and loads of ax to arbitrary constant address.
;; We fake an second form of instruction to force reload to load address
;; into register when rax is not available
(define_insn "*movabsqi_1_rex64"
  [(set (mem:QI (match_operand:DI 0 "x86_64_movabs_operand" "i,r"))
	(match_operand:QI 1 "nonmemory_operand" "a,er"))]
  "TARGET_64BIT && ix86_check_movabs (insn, 0)"
  "@
   movabs{b}\t{%1, %P0|%P0, %1}
   mov{b}\t{%1, %a0|%a0, %1}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0,*")
   (set_attr "length_address" "8,0")
   (set_attr "length_immediate" "0,*")
   (set_attr "memory" "store")
   (set_attr "mode" "QI")])

(define_insn "*movabsqi_2_rex64"
  [(set (match_operand:QI 0 "register_operand" "=a,r")
        (mem:QI (match_operand:DI 1 "x86_64_movabs_operand" "i,r")))]
  "TARGET_64BIT && ix86_check_movabs (insn, 1)"
  "@
   movabs{b}\t{%P1, %0|%0, %P1}
   mov{b}\t{%a1, %0|%0, %a1}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0,*")
   (set_attr "length_address" "8,0")
   (set_attr "length_immediate" "0")
   (set_attr "memory" "load")
   (set_attr "mode" "QI")])

(define_insn "*movsi_extzv_1"
  [(set (match_operand:SI 0 "register_operand" "=R")
	(zero_extract:SI (match_operand 1 "ext_register_operand" "Q")
			 (const_int 8)
			 (const_int 8)))]
  ""
  "movz{bl|x}\t{%h1, %0|%0, %h1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI")])

(define_insn "*movqi_extzv_2"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=Qm,?R")
        (subreg:QI (zero_extract:SI (match_operand 1 "ext_register_operand" "Q,Q")
				    (const_int 8)
				    (const_int 8)) 0))]
  "!TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      return "movz{bl|x}\t{%h1, %k0|%k0, %h1}";
    default:
      return "mov{b}\t{%h1, %0|%0, %h1}";
    }
}
  [(set (attr "type")
     (if_then_else (and (match_operand:QI 0 "register_operand" "")
			(ior (not (match_operand:QI 0 "q_regs_operand" ""))
			     (ne (symbol_ref "TARGET_MOVX")
				 (const_int 0))))
	(const_string "imovx")
	(const_string "imov")))
   (set (attr "mode")
     (if_then_else (eq_attr "type" "imovx")
	(const_string "SI")
	(const_string "QI")))])

(define_insn "*movqi_extzv_2_rex64"
  [(set (match_operand:QI 0 "register_operand" "=Q,?R")
        (subreg:QI (zero_extract:SI (match_operand 1 "ext_register_operand" "Q,Q")
				    (const_int 8)
				    (const_int 8)) 0))]
  "TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      return "movz{bl|x}\t{%h1, %k0|%k0, %h1}";
    default:
      return "mov{b}\t{%h1, %0|%0, %h1}";
    }
}
  [(set (attr "type")
     (if_then_else (ior (not (match_operand:QI 0 "q_regs_operand" ""))
			(ne (symbol_ref "TARGET_MOVX")
			    (const_int 0)))
	(const_string "imovx")
	(const_string "imov")))
   (set (attr "mode")
     (if_then_else (eq_attr "type" "imovx")
	(const_string "SI")
	(const_string "QI")))])

(define_insn "movsi_insv_1"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "+Q")
			 (const_int 8)
			 (const_int 8))
	(match_operand:SI 1 "general_operand" "Qmn"))]
  "!TARGET_64BIT"
  "mov{b}\t{%b1, %h0|%h0, %b1}"
  [(set_attr "type" "imov")
   (set_attr "mode" "QI")])

(define_insn "movdi_insv_1_rex64"
  [(set (zero_extract:DI (match_operand 0 "ext_register_operand" "+Q")
			 (const_int 8)
			 (const_int 8))
	(match_operand:DI 1 "nonmemory_operand" "Qn"))]
  "TARGET_64BIT"
  "mov{b}\t{%b1, %h0|%h0, %b1}"
  [(set_attr "type" "imov")
   (set_attr "mode" "QI")])

(define_insn "*movqi_insv_2"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "+Q")
			 (const_int 8)
			 (const_int 8))
	(lshiftrt:SI (match_operand:SI 1 "register_operand" "Q")
		     (const_int 8)))]
  ""
  "mov{b}\t{%h1, %h0|%h0, %h1}"
  [(set_attr "type" "imov")
   (set_attr "mode" "QI")])

(define_expand "movdi"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(match_operand:DI 1 "general_operand" ""))]
  ""
  "ix86_expand_move (DImode, operands); DONE;")

(define_insn "*pushdi"
  [(set (match_operand:DI 0 "push_operand" "=<")
	(match_operand:DI 1 "general_no_elim_operand" "riF*m"))]
  "!TARGET_64BIT"
  "#")

(define_insn "pushdi2_rex64"
  [(set (match_operand:DI 0 "push_operand" "=<,!<")
	(match_operand:DI 1 "general_no_elim_operand" "re*m,n"))]
  "TARGET_64BIT"
  "@
   push{q}\t%1
   #"
  [(set_attr "type" "push,multi")
   (set_attr "mode" "DI")])

;; Convert impossible pushes of immediate to existing instructions.
;; First try to get scratch register and go through it.  In case this
;; fails, push sign extended lower part first and then overwrite
;; upper part by 32bit move.
(define_peephole2
  [(match_scratch:DI 2 "r")
   (set (match_operand:DI 0 "push_operand" "")
        (match_operand:DI 1 "immediate_operand" ""))]
  "TARGET_64BIT && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode)"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

;; We need to define this as both peepholer and splitter for case
;; peephole2 pass is not run.
(define_peephole2
  [(set (match_operand:DI 0 "push_operand" "")
        (match_operand:DI 1 "immediate_operand" ""))]
  "TARGET_64BIT && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode) && 1"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 2) (match_dup 3))]
  "split_di (operands + 1, 1, operands + 2, operands + 3);
   operands[1] = gen_lowpart (DImode, operands[2]);
   operands[2] = gen_rtx_MEM (SImode, gen_rtx_PLUS (DImode, stack_pointer_rtx,
						    GEN_INT (4)));
  ")

(define_split
  [(set (match_operand:DI 0 "push_operand" "")
        (match_operand:DI 1 "immediate_operand" ""))]
  "TARGET_64BIT && (flow2_completed || (reload_completed && !flag_peephole2))
   && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode)"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 2) (match_dup 3))]
  "split_di (operands + 1, 1, operands + 2, operands + 3);
   operands[1] = gen_lowpart (DImode, operands[2]);
   operands[2] = gen_rtx_MEM (SImode, gen_rtx_PLUS (DImode, stack_pointer_rtx,
						    GEN_INT (4)));
  ")

(define_insn "*pushdi2_prologue_rex64"
  [(set (match_operand:DI 0 "push_operand" "=<")
	(match_operand:DI 1 "general_no_elim_operand" "re*m"))
   (clobber (mem:BLK (scratch)))]
  "TARGET_64BIT"
  "push{q}\t%1"
  [(set_attr "type" "push")
   (set_attr "mode" "DI")])

(define_insn "*popdi1_epilogue_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r*m")
	(mem:DI (reg:DI 7)))
   (set (reg:DI 7)
	(plus:DI (reg:DI 7) (const_int 8)))
   (clobber (mem:BLK (scratch)))]
  "TARGET_64BIT"
  "pop{q}\t%0"
  [(set_attr "type" "pop")
   (set_attr "mode" "DI")])

(define_insn "popdi1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r*m")
	(mem:DI (reg:DI 7)))
   (set (reg:DI 7)
	(plus:DI (reg:DI 7) (const_int 8)))]
  "TARGET_64BIT"
  "pop{q}\t%0"
  [(set_attr "type" "pop")
   (set_attr "mode" "DI")])

(define_insn "*movdi_xor_rex64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(match_operand:DI 1 "const0_operand" "i"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && (!TARGET_USE_MOV0 || optimize_size)
   && reload_completed"
  "xor{l}\t{%k0, %k0|%k0, %k0}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")
   (set_attr "length_immediate" "0")])

(define_insn "*movdi_or_rex64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(match_operand:DI 1 "const_int_operand" "i"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && (TARGET_PENTIUM || optimize_size)
   && reload_completed
   && operands[1] == constm1_rtx"
{
  operands[1] = constm1_rtx;
  return "or{q}\t{%1, %0|%0, %1}";
}
  [(set_attr "type" "alu1")
   (set_attr "mode" "DI")
   (set_attr "length_immediate" "1")])

(define_insn "*movdi_2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,o,!m*y,!*y,!m,!*Y,!*Y")
	(match_operand:DI 1 "general_operand" "riFo,riF,*y,m,*Y,*Y,m"))]
  "!TARGET_64BIT
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
   #
   #
   movq\t{%1, %0|%0, %1}
   movq\t{%1, %0|%0, %1}
   movq\t{%1, %0|%0, %1}
   movdqa\t{%1, %0|%0, %1}
   movq\t{%1, %0|%0, %1}"
  [(set_attr "type" "*,*,mmx,mmx,ssemov,ssemov,ssemov")
   (set_attr "mode" "DI,DI,DI,DI,DI,TI,DI")])

(define_split
  [(set (match_operand:DI 0 "push_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && (! MMX_REG_P (operands[1]) && !SSE_REG_P (operands[1]))"
  [(const_int 0)]
  "ix86_split_long_move (operands); DONE;")

;; %%% This multiword shite has got to go.
(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (match_operand:DI 1 "general_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && (!MMX_REG_P (operands[0]) && !SSE_REG_P (operands[0]))
   && (!MMX_REG_P (operands[1]) && !SSE_REG_P (operands[1]))"
  [(const_int 0)]
  "ix86_split_long_move (operands); DONE;")

(define_insn "*movdi_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,r,r,mr,!mr,!*y,!rm,!*y,!*Y,!rm,!*Y")
	(match_operand:DI 1 "general_operand" "Z,rem,i,re,n,*y,*y,rm,*Y,*Y,rm"))]
  "TARGET_64BIT
   && (TARGET_INTER_UNIT_MOVES || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_SSEMOV:
      if (get_attr_mode (insn) == MODE_TI)
	  return "movdqa\t{%1, %0|%0, %1}";
      /* FALLTHRU */
    case TYPE_MMXMOV:
      /* Moves from and into integer register is done using movd opcode with
 	 REX prefix.  */
      if (GENERAL_REG_P (operands[0]) || GENERAL_REG_P (operands[1]))
	  return "movd\t{%1, %0|%0, %1}";
      return "movq\t{%1, %0|%0, %1}";
    case TYPE_MULTI:
      return "#";
    case TYPE_LEA:
      return "lea{q}\t{%a1, %0|%0, %a1}";
    default:
      if (flag_pic && !LEGITIMATE_PIC_OPERAND_P (operands[1]))
	abort ();
      if (get_attr_mode (insn) == MODE_SI)
	return "mov{l}\t{%k1, %k0|%k0, %k1}";
      else if (which_alternative == 2)
	return "movabs{q}\t{%1, %0|%0, %1}";
      else
	return "mov{q}\t{%1, %0|%0, %1}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "5,6,7")
	      (const_string "mmxmov")
	    (eq_attr "alternative" "8,9,10")
	      (const_string "ssemov")
	    (eq_attr "alternative" "4")
	      (const_string "multi")
 	    (and (ne (symbol_ref "flag_pic") (const_int 0))
		 (match_operand:DI 1 "symbolic_operand" ""))
	      (const_string "lea")
	   ]
	   (const_string "imov")))
   (set_attr "modrm" "*,0,0,*,*,*,*,*,*,*,*")
   (set_attr "length_immediate" "*,4,8,*,*,*,*,*,*,*,*")
   (set_attr "mode" "SI,DI,DI,DI,SI,DI,DI,DI,TI,DI,DI")])

(define_insn "*movdi_1_rex64_nointerunit"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,r,r,mr,!mr,!*y,!m,!*y,!*Y,!m,!*Y")
	(match_operand:DI 1 "general_operand" "Z,rem,i,re,n,*y,*y,m,*Y,*Y,m"))]
  "TARGET_64BIT
   && (!TARGET_INTER_UNIT_MOVES && !optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_SSEMOV:
      if (get_attr_mode (insn) == MODE_TI)
	  return "movdqa\t{%1, %0|%0, %1}";
      /* FALLTHRU */
    case TYPE_MMXMOV:
      return "movq\t{%1, %0|%0, %1}";
    case TYPE_MULTI:
      return "#";
    case TYPE_LEA:
      return "lea{q}\t{%a1, %0|%0, %a1}";
    default:
      if (flag_pic && !LEGITIMATE_PIC_OPERAND_P (operands[1]))
	abort ();
      if (get_attr_mode (insn) == MODE_SI)
	return "mov{l}\t{%k1, %k0|%k0, %k1}";
      else if (which_alternative == 2)
	return "movabs{q}\t{%1, %0|%0, %1}";
      else
	return "mov{q}\t{%1, %0|%0, %1}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "5,6,7")
	      (const_string "mmxmov")
	    (eq_attr "alternative" "8,9,10")
	      (const_string "ssemov")
	    (eq_attr "alternative" "4")
	      (const_string "multi")
 	    (and (ne (symbol_ref "flag_pic") (const_int 0))
		 (match_operand:DI 1 "symbolic_operand" ""))
	      (const_string "lea")
	   ]
	   (const_string "imov")))
   (set_attr "modrm" "*,0,0,*,*,*,*,*,*,*,*")
   (set_attr "length_immediate" "*,4,8,*,*,*,*,*,*,*,*")
   (set_attr "mode" "SI,DI,DI,DI,SI,DI,DI,DI,TI,DI,DI")])

;; Stores and loads of ax to arbitrary constant address.
;; We fake an second form of instruction to force reload to load address
;; into register when rax is not available
(define_insn "*movabsdi_1_rex64"
  [(set (mem:DI (match_operand:DI 0 "x86_64_movabs_operand" "i,r"))
	(match_operand:DI 1 "nonmemory_operand" "a,er"))]
  "TARGET_64BIT && ix86_check_movabs (insn, 0)"
  "@
   movabs{q}\t{%1, %P0|%P0, %1}
   mov{q}\t{%1, %a0|%a0, %1}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0,*")
   (set_attr "length_address" "8,0")
   (set_attr "length_immediate" "0,*")
   (set_attr "memory" "store")
   (set_attr "mode" "DI")])

(define_insn "*movabsdi_2_rex64"
  [(set (match_operand:DI 0 "register_operand" "=a,r")
        (mem:DI (match_operand:DI 1 "x86_64_movabs_operand" "i,r")))]
  "TARGET_64BIT && ix86_check_movabs (insn, 1)"
  "@
   movabs{q}\t{%P1, %0|%0, %P1}
   mov{q}\t{%a1, %0|%0, %a1}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0,*")
   (set_attr "length_address" "8,0")
   (set_attr "length_immediate" "0")
   (set_attr "memory" "load")
   (set_attr "mode" "DI")])

;; Convert impossible stores of immediate to existing instructions.
;; First try to get scratch register and go through it.  In case this
;; fails, move by 32bit parts.
(define_peephole2
  [(match_scratch:DI 2 "r")
   (set (match_operand:DI 0 "memory_operand" "")
        (match_operand:DI 1 "immediate_operand" ""))]
  "TARGET_64BIT && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode)"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

;; We need to define this as both peepholer and splitter for case
;; peephole2 pass is not run.
(define_peephole2
  [(set (match_operand:DI 0 "memory_operand" "")
        (match_operand:DI 1 "immediate_operand" ""))]
  "TARGET_64BIT && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode) && 1"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 5))]
  "split_di (operands, 2, operands + 2, operands + 4);")

(define_split
  [(set (match_operand:DI 0 "memory_operand" "")
        (match_operand:DI 1 "immediate_operand" ""))]
  "TARGET_64BIT && (flow2_completed || (reload_completed && !flag_peephole2))
   && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode)"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 5))]
  "split_di (operands, 2, operands + 2, operands + 4);")

(define_insn "*swapdi_rex64"
  [(set (match_operand:DI 0 "register_operand" "+r")
	(match_operand:DI 1 "register_operand" "+r"))
   (set (match_dup 1)
	(match_dup 0))]
  "TARGET_64BIT"
  "xchg{q}\t%1, %0"
  [(set_attr "type" "imov")
   (set_attr "pent_pair" "np")
   (set_attr "athlon_decode" "vector")
   (set_attr "mode" "DI")
   (set_attr "modrm" "0")
   (set_attr "ppro_uops" "few")])

  
(define_expand "movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "")
	(match_operand:SF 1 "general_operand" ""))]
  ""
  "ix86_expand_move (SFmode, operands); DONE;")

(define_insn "*pushsf"
  [(set (match_operand:SF 0 "push_operand" "=<,<,<")
	(match_operand:SF 1 "general_no_elim_operand" "f#rx,rFm#fx,x#rf"))]
  "!TARGET_64BIT"
{
  switch (which_alternative)
    {
    case 1:
      return "push{l}\t%1";

    default:
      /* This insn should be already split before reg-stack.  */
      abort ();
    }
}
  [(set_attr "type" "multi,push,multi")
   (set_attr "mode" "SF,SI,SF")])

(define_insn "*pushsf_rex64"
  [(set (match_operand:SF 0 "push_operand" "=X,X,X")
	(match_operand:SF 1 "nonmemory_no_elim_operand" "f#rx,rF#fx,x#rf"))]
  "TARGET_64BIT"
{
  switch (which_alternative)
    {
    case 1:
      return "push{q}\t%q1";

    default:
      /* This insn should be already split before reg-stack.  */
      abort ();
    }
}
  [(set_attr "type" "multi,push,multi")
   (set_attr "mode" "SF,DI,SF")])

(define_split
  [(set (match_operand:SF 0 "push_operand" "")
	(match_operand:SF 1 "memory_operand" ""))]
  "reload_completed
   && GET_CODE (operands[1]) == MEM
   && GET_CODE (XEXP (operands[1], 0)) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (XEXP (operands[1], 0))"
  [(set (match_dup 0)
	(match_dup 1))]
  "operands[1] = get_pool_constant (XEXP (operands[1], 0));")


;; %%% Kill this when call knows how to work this out.
(define_split
  [(set (match_operand:SF 0 "push_operand" "")
	(match_operand:SF 1 "any_fp_register_operand" ""))]
  "!TARGET_64BIT"
  [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int -4)))
   (set (mem:SF (reg:SI 7)) (match_dup 1))])

(define_split
  [(set (match_operand:SF 0 "push_operand" "")
	(match_operand:SF 1 "any_fp_register_operand" ""))]
  "TARGET_64BIT"
  [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int -8)))
   (set (mem:SF (reg:DI 7)) (match_dup 1))])

(define_insn "*movsf_1"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=f#xr,m,f#xr,r#xf,m,x#rf,x#rf,x#rf,m,!*y,!rm,!*y")
	(match_operand:SF 1 "general_operand" "fm#rx,f#rx,G,rmF#fx,Fr#fx,C,x,xm#rf,x#rf,rm,*y,*y"))]
  "(TARGET_INTER_UNIT_MOVES || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && (reload_in_progress || reload_completed
       || (ix86_cmodel == CM_MEDIUM || ix86_cmodel == CM_LARGE)
       || GET_CODE (operands[1]) != CONST_DOUBLE
       || memory_operand (operands[0], SFmode))" 
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp\t%y0";
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0";
      else
        return "fst%z0\t%y0";

    case 2:
      return standard_80387_constant_opcode (operands[1]);

    case 3:
    case 4:
      return "mov{l}\t{%1, %0|%0, %1}";
    case 5:
      if (get_attr_mode (insn) == MODE_TI)
	return "pxor\t%0, %0";
      else
	return "xorps\t%0, %0";
    case 6:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movss\t{%1, %0|%0, %1}";
    case 7:
    case 8:
      return "movss\t{%1, %0|%0, %1}";

    case 9:
    case 10:
      return "movd\t{%1, %0|%0, %1}";

    case 11:
      return "movq\t{%1, %0|%0, %1}";

    default:
      abort();
    }
}
  [(set_attr "type" "fmov,fmov,fmov,imov,imov,ssemov,ssemov,ssemov,ssemov,mmxmov,mmxmov,mmxmov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "3,4,9,10")
		 (const_string "SI")
	       (eq_attr "alternative" "5")
		 (if_then_else
		   (and (and (ne (symbol_ref "TARGET_SSE_LOAD0_BY_PXOR")
			    	 (const_int 0))
			     (ne (symbol_ref "TARGET_SSE2")
				 (const_int 0)))
			(eq (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "TI")
		   (const_string "V4SF"))
	       /* For architectures resolving dependencies on
		  whole SSE registers use APS move to break dependency
		  chains, otherwise use short move to avoid extra work. 

		  Do the same for architectures resolving dependencies on
		  the parts.  While in DF mode it is better to always handle
		  just register parts, the SF mode is different due to lack
		  of instructions to load just part of the register.  It is
		  better to maintain the whole registers in single format
		  to avoid problems on using packed logical operations.  */
	       (eq_attr "alternative" "6")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_PARTIAL_REG_DEPENDENCY")
			    (const_int 0))
			(ne (symbol_ref "TARGET_SSE_PARTIAL_REGS")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "SF"))
	       (eq_attr "alternative" "11")
		 (const_string "DI")]
	       (const_string "SF")))])

(define_insn "*movsf_1_nointerunit"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=f#xr,m,f#xr,r#xf,m,x#rf,x#rf,x#rf,m,!*y,!m,!*y")
	(match_operand:SF 1 "general_operand" "fm#rx,f#rx,G,rmF#fx,Fr#fx,C,x,xm#rf,x#rf,m,*y,*y"))]
  "(!TARGET_INTER_UNIT_MOVES && !optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && (reload_in_progress || reload_completed
       || (ix86_cmodel == CM_MEDIUM || ix86_cmodel == CM_LARGE)
       || GET_CODE (operands[1]) != CONST_DOUBLE
       || memory_operand (operands[0], SFmode))" 
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	{
	  if (REGNO (operands[0]) == FIRST_STACK_REG
	      && TARGET_USE_FFREEP)
	    return "ffreep\t%y0";
          return "fstp\t%y0";
	}
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0";
      else
        return "fst%z0\t%y0";

    case 2:
      return standard_80387_constant_opcode (operands[1]);

    case 3:
    case 4:
      return "mov{l}\t{%1, %0|%0, %1}";
    case 5:
      if (get_attr_mode (insn) == MODE_TI)
	return "pxor\t%0, %0";
      else
	return "xorps\t%0, %0";
    case 6:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movss\t{%1, %0|%0, %1}";
    case 7:
    case 8:
      return "movss\t{%1, %0|%0, %1}";

    case 9:
    case 10:
      return "movd\t{%1, %0|%0, %1}";

    case 11:
      return "movq\t{%1, %0|%0, %1}";

    default:
      abort();
    }
}
  [(set_attr "type" "fmov,fmov,fmov,imov,imov,ssemov,ssemov,ssemov,ssemov,mmxmov,mmxmov,mmxmov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "3,4,9,10")
		 (const_string "SI")
	       (eq_attr "alternative" "5")
		 (if_then_else
		   (and (and (ne (symbol_ref "TARGET_SSE_LOAD0_BY_PXOR")
			    	 (const_int 0))
			     (ne (symbol_ref "TARGET_SSE2")
				 (const_int 0)))
			(eq (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "TI")
		   (const_string "V4SF"))
	       /* For architectures resolving dependencies on
		  whole SSE registers use APS move to break dependency
		  chains, otherwise use short move to avoid extra work. 

		  Do the same for architectures resolving dependencies on
		  the parts.  While in DF mode it is better to always handle
		  just register parts, the SF mode is different due to lack
		  of instructions to load just part of the register.  It is
		  better to maintain the whole registers in single format
		  to avoid problems on using packed logical operations.  */
	       (eq_attr "alternative" "6")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_PARTIAL_REG_DEPENDENCY")
			    (const_int 0))
			(ne (symbol_ref "TARGET_SSE_PARTIAL_REGS")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "SF"))
	       (eq_attr "alternative" "11")
		 (const_string "DI")]
	       (const_string "SF")))])

(define_insn "*swapsf"
  [(set (match_operand:SF 0 "register_operand" "+f")
	(match_operand:SF 1 "register_operand" "+f"))
   (set (match_dup 1)
	(match_dup 0))]
  "reload_completed || !TARGET_SSE"
{
  if (STACK_TOP_P (operands[0]))
    return "fxch\t%1";
  else
    return "fxch\t%0";
}
  [(set_attr "type" "fxch")
   (set_attr "mode" "SF")])

(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "general_operand" ""))]
  ""
  "ix86_expand_move (DFmode, operands); DONE;")

;; Size of pushdf is 3 (for sub) + 2 (for fstp) + memory operand size.
;; Size of pushdf using integer instructions is 2+2*memory operand size
;; On the average, pushdf using integers can be still shorter.  Allow this
;; pattern for optimize_size too.

(define_insn "*pushdf_nointeger"
  [(set (match_operand:DF 0 "push_operand" "=<,<,<,<")
	(match_operand:DF 1 "general_no_elim_operand" "f#Y,Fo#fY,*r#fY,Y#f"))]
  "!TARGET_64BIT && !TARGET_INTEGER_DFMODE_MOVES"
{
  /* This insn should be already split before reg-stack.  */
  abort ();
}
  [(set_attr "type" "multi")
   (set_attr "mode" "DF,SI,SI,DF")])

(define_insn "*pushdf_integer"
  [(set (match_operand:DF 0 "push_operand" "=<,<,<")
	(match_operand:DF 1 "general_no_elim_operand" "f#rY,rFo#fY,Y#rf"))]
  "TARGET_64BIT || TARGET_INTEGER_DFMODE_MOVES"
{
  /* This insn should be already split before reg-stack.  */
  abort ();
}
  [(set_attr "type" "multi")
   (set_attr "mode" "DF,SI,DF")])

;; %%% Kill this when call knows how to work this out.
(define_split
  [(set (match_operand:DF 0 "push_operand" "")
	(match_operand:DF 1 "any_fp_register_operand" ""))]
  "!TARGET_64BIT && reload_completed"
  [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int -8)))
   (set (mem:DF (reg:SI 7)) (match_dup 1))]
  "")

(define_split
  [(set (match_operand:DF 0 "push_operand" "")
	(match_operand:DF 1 "any_fp_register_operand" ""))]
  "TARGET_64BIT && reload_completed"
  [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int -8)))
   (set (mem:DF (reg:DI 7)) (match_dup 1))]
  "")

(define_split
  [(set (match_operand:DF 0 "push_operand" "")
	(match_operand:DF 1 "general_operand" ""))]
  "reload_completed"
  [(const_int 0)]
  "ix86_split_long_move (operands); DONE;")

;; Moving is usually shorter when only FP registers are used. This separate
;; movdf pattern avoids the use of integer registers for FP operations
;; when optimizing for size.

(define_insn "*movdf_nointeger"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f#Y,m,f#Y,*r,o,Y#f,Y#f,Y#f,m")
	(match_operand:DF 1 "general_operand" "fm#Y,f#Y,G,*roF,F*r,C,Y#f,YHm#f,Y#f"))]
  "(GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && ((optimize_size || !TARGET_INTEGER_DFMODE_MOVES) && !TARGET_64BIT)
   && (reload_in_progress || reload_completed
       || (ix86_cmodel == CM_MEDIUM || ix86_cmodel == CM_LARGE)
       || GET_CODE (operands[1]) != CONST_DOUBLE
       || memory_operand (operands[0], DFmode))" 
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	{
	  if (REGNO (operands[0]) == FIRST_STACK_REG
	      && TARGET_USE_FFREEP)
	    return "ffreep\t%y0";
          return "fstp\t%y0";
	}
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0";
      else
        return "fst%z0\t%y0";

    case 2:
      return standard_80387_constant_opcode (operands[1]);

    case 3:
    case 4:
      return "#";
    case 5:
      switch (get_attr_mode (insn))
	{
	case MODE_V4SF:
	  return "xorps\t%0, %0";
	case MODE_V2DF:
	  return "xorpd\t%0, %0";
	case MODE_TI:
	  return "pxor\t%0, %0";
	default:
	  abort ();
	}
    case 6:
      switch (get_attr_mode (insn))
	{
	case MODE_V4SF:
	  return "movaps\t{%1, %0|%0, %1}";
	case MODE_V2DF:
	  return "movapd\t{%1, %0|%0, %1}";
	case MODE_DF:
	  return "movsd\t{%1, %0|%0, %1}";
	default:
	  abort ();
	}
    case 7:
      if (get_attr_mode (insn) == MODE_V2DF)
	return "movlpd\t{%1, %0|%0, %1}";
      else
	return "movsd\t{%1, %0|%0, %1}";
    case 8:
      return "movsd\t{%1, %0|%0, %1}";

    default:
      abort();
    }
}
  [(set_attr "type" "fmov,fmov,fmov,multi,multi,ssemov,ssemov,ssemov,ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "3,4")
		 (const_string "SI")
	       /* xorps is one byte shorter.  */
	       (eq_attr "alternative" "5")
		 (cond [(ne (symbol_ref "optimize_size")
			    (const_int 0))
			  (const_string "V4SF")
			(ne (symbol_ref "TARGET_SSE_LOAD0_BY_PXOR")
			    (const_int 0))
			  (const_string "TI")]
		       (const_string "V2DF"))
	       /* For architectures resolving dependencies on
		  whole SSE registers use APD move to break dependency
		  chains, otherwise use short move to avoid extra work.

		  movaps encodes one byte shorter.  */
	       (eq_attr "alternative" "6")
		 (cond
		  [(ne (symbol_ref "optimize_size")
		       (const_int 0))
		     (const_string "V4SF")
		   (ne (symbol_ref "TARGET_SSE_PARTIAL_REG_DEPENDENCY")
		       (const_int 0))
		     (const_string "V2DF")]
		   (const_string "DF"))
	       /* For architectures resolving dependencies on register
		  parts we may avoid extra work to zero out upper part
		  of register.  */
	       (eq_attr "alternative" "7")
		 (if_then_else
		   (ne (symbol_ref "TARGET_SSE_PARTIAL_REGS")
		       (const_int 0))
		   (const_string "V2DF")
		   (const_string "DF"))]
	       (const_string "DF")))])

(define_insn "*movdf_integer"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f#Yr,m,f#Yr,r#Yf,o,Y#rf,Y#rf,Y#rf,m")
	(match_operand:DF 1 "general_operand" "fm#Yr,f#Yr,G,roF#Yf,Fr#Yf,C,Y#rf,Ym#rf,Y#rf"))]
  "(GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && ((!optimize_size && TARGET_INTEGER_DFMODE_MOVES) || TARGET_64BIT)
   && (reload_in_progress || reload_completed
       || (ix86_cmodel == CM_MEDIUM || ix86_cmodel == CM_LARGE)
       || GET_CODE (operands[1]) != CONST_DOUBLE
       || memory_operand (operands[0], DFmode))" 
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	{
	  if (REGNO (operands[0]) == FIRST_STACK_REG
	      && TARGET_USE_FFREEP)
	    return "ffreep\t%y0";
          return "fstp\t%y0";
	}
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0";
      else
        return "fst%z0\t%y0";

    case 2:
      return standard_80387_constant_opcode (operands[1]);

    case 3:
    case 4:
      return "#";

    case 5:
      switch (get_attr_mode (insn))
	{
	case MODE_V4SF:
	  return "xorps\t%0, %0";
	case MODE_V2DF:
	  return "xorpd\t%0, %0";
	case MODE_TI:
	  return "pxor\t%0, %0";
	default:
	  abort ();
	}
    case 6:
      switch (get_attr_mode (insn))
	{
	case MODE_V4SF:
	  return "movaps\t{%1, %0|%0, %1}";
	case MODE_V2DF:
	  return "movapd\t{%1, %0|%0, %1}";
	case MODE_DF:
	  return "movsd\t{%1, %0|%0, %1}";
	default:
	  abort ();
	}
    case 7:
      if (get_attr_mode (insn) == MODE_V2DF)
	return "movlpd\t{%1, %0|%0, %1}";
      else
	return "movsd\t{%1, %0|%0, %1}";
    case 8:
      return "movsd\t{%1, %0|%0, %1}";

    default:
      abort();
    }
}
  [(set_attr "type" "fmov,fmov,fmov,multi,multi,ssemov,ssemov,ssemov,ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "3,4")
		 (const_string "SI")
	       /* xorps is one byte shorter.  */
	       (eq_attr "alternative" "5")
		 (cond [(ne (symbol_ref "optimize_size")
			    (const_int 0))
			  (const_string "V4SF")
			(ne (symbol_ref "TARGET_SSE_LOAD0_BY_PXOR")
			    (const_int 0))
			  (const_string "TI")]
		       (const_string "V2DF"))
	       /* For architectures resolving dependencies on
		  whole SSE registers use APD move to break dependency
		  chains, otherwise use short move to avoid extra work.  

		  movaps encodes one byte shorter.  */
	       (eq_attr "alternative" "6")
		 (cond
		  [(ne (symbol_ref "optimize_size")
		       (const_int 0))
		     (const_string "V4SF")
		   (ne (symbol_ref "TARGET_SSE_PARTIAL_REG_DEPENDENCY")
		       (const_int 0))
		     (const_string "V2DF")]
		   (const_string "DF"))
	       /* For architectures resolving dependencies on register
		  parts we may avoid extra work to zero out upper part
		  of register.  */
	       (eq_attr "alternative" "7")
		 (if_then_else
		   (ne (symbol_ref "TARGET_SSE_PARTIAL_REGS")
		       (const_int 0))
		   (const_string "V2DF")
		   (const_string "DF"))]
	       (const_string "DF")))])

(define_split
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "general_operand" ""))]
  "reload_completed
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && ! (ANY_FP_REG_P (operands[0]) || 
	 (GET_CODE (operands[0]) == SUBREG
	  && ANY_FP_REG_P (SUBREG_REG (operands[0]))))
   && ! (ANY_FP_REG_P (operands[1]) || 
	 (GET_CODE (operands[1]) == SUBREG
	  && ANY_FP_REG_P (SUBREG_REG (operands[1]))))"
  [(const_int 0)]
  "ix86_split_long_move (operands); DONE;")

(define_insn "*swapdf"
  [(set (match_operand:DF 0 "register_operand" "+f")
	(match_operand:DF 1 "register_operand" "+f"))
   (set (match_dup 1)
	(match_dup 0))]
  "reload_completed || !TARGET_SSE2"
{
  if (STACK_TOP_P (operands[0]))
    return "fxch\t%1";
  else
    return "fxch\t%0";
}
  [(set_attr "type" "fxch")
   (set_attr "mode" "DF")])

(define_expand "movxf"
  [(set (match_operand:XF 0 "nonimmediate_operand" "")
	(match_operand:XF 1 "general_operand" ""))]
  ""
  "ix86_expand_move (XFmode, operands); DONE;")

;; Size of pushdf is 3 (for sub) + 2 (for fstp) + memory operand size.
;; Size of pushdf using integer instructions is 3+3*memory operand size
;; Pushing using integer instructions is longer except for constants
;; and direct memory references.
;; (assuming that any given constant is pushed only once, but this ought to be
;;  handled elsewhere).

(define_insn "*pushxf_nointeger"
  [(set (match_operand:XF 0 "push_operand" "=X,X,X")
	(match_operand:XF 1 "general_no_elim_operand" "f,Fo,*r"))]
  "optimize_size"
{
  /* This insn should be already split before reg-stack.  */
  abort ();
}
  [(set_attr "type" "multi")
   (set_attr "mode" "XF,SI,SI")])

(define_insn "*pushxf_integer"
  [(set (match_operand:XF 0 "push_operand" "=<,<")
	(match_operand:XF 1 "general_no_elim_operand" "f#r,ro#f"))]
  "!optimize_size"
{
  /* This insn should be already split before reg-stack.  */
  abort ();
}
  [(set_attr "type" "multi")
   (set_attr "mode" "XF,SI")])

(define_split
  [(set (match_operand 0 "push_operand" "")
	(match_operand 1 "general_operand" ""))]
  "reload_completed
   && (GET_MODE (operands[0]) == XFmode
       || GET_MODE (operands[0]) == DFmode)
   && !ANY_FP_REG_P (operands[1])"
  [(const_int 0)]
  "ix86_split_long_move (operands); DONE;")

(define_split
  [(set (match_operand:XF 0 "push_operand" "")
	(match_operand:XF 1 "any_fp_register_operand" ""))]
  "!TARGET_64BIT"
  [(set (reg:SI 7) (plus:SI (reg:SI 7) (match_dup 2)))
   (set (mem:XF (reg:SI 7)) (match_dup 1))]
  "operands[2] = GEN_INT (TARGET_128BIT_LONG_DOUBLE ? -16 : -12);")

(define_split
  [(set (match_operand:XF 0 "push_operand" "")
	(match_operand:XF 1 "any_fp_register_operand" ""))]
  "TARGET_64BIT"
  [(set (reg:DI 7) (plus:DI (reg:DI 7) (match_dup 2)))
   (set (mem:XF (reg:DI 7)) (match_dup 1))]
  "operands[2] = GEN_INT (TARGET_128BIT_LONG_DOUBLE ? -16 : -12);")

;; Do not use integer registers when optimizing for size
(define_insn "*movxf_nointeger"
  [(set (match_operand:XF 0 "nonimmediate_operand" "=f,m,f,*r,o")
	(match_operand:XF 1 "general_operand" "fm,f,G,*roF,F*r"))]
  "optimize_size
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && (reload_in_progress || reload_completed
       || GET_CODE (operands[1]) != CONST_DOUBLE
       || memory_operand (operands[0], XFmode))" 
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	{
	  if (REGNO (operands[0]) == FIRST_STACK_REG
	      && TARGET_USE_FFREEP)
	    return "ffreep\t%y0";
          return "fstp\t%y0";
	}
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      /* There is no non-popping store to memory for XFmode.  So if
	 we need one, follow the store with a load.  */
      if (! find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0\;fld%z0\t%y0";
      else
        return "fstp%z0\t%y0";

    case 2:
      return standard_80387_constant_opcode (operands[1]);

    case 3: case 4:
      return "#";
    }
  abort();
}
  [(set_attr "type" "fmov,fmov,fmov,multi,multi")
   (set_attr "mode" "XF,XF,XF,SI,SI")])

(define_insn "*movxf_integer"
  [(set (match_operand:XF 0 "nonimmediate_operand" "=f#r,m,f#r,r#f,o")
	(match_operand:XF 1 "general_operand" "fm#r,f#r,G,roF#f,Fr#f"))]
  "!optimize_size
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && (reload_in_progress || reload_completed
       || GET_CODE (operands[1]) != CONST_DOUBLE
       || memory_operand (operands[0], XFmode))" 
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	{
	  if (REGNO (operands[0]) == FIRST_STACK_REG
	      && TARGET_USE_FFREEP)
	    return "ffreep\t%y0";
          return "fstp\t%y0";
	}
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      /* There is no non-popping store to memory for XFmode.  So if
	 we need one, follow the store with a load.  */
      if (! find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0\;fld%z0\t%y0";
      else
        return "fstp%z0\t%y0";

    case 2:
      return standard_80387_constant_opcode (operands[1]);

    case 3: case 4:
      return "#";
    }
  abort();
}
  [(set_attr "type" "fmov,fmov,fmov,multi,multi")
   (set_attr "mode" "XF,XF,XF,SI,SI")])

(define_split
  [(set (match_operand 0 "nonimmediate_operand" "")
	(match_operand 1 "general_operand" ""))]
  "reload_completed
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)
   && GET_MODE (operands[0]) == XFmode
   && ! (ANY_FP_REG_P (operands[0]) || 
	 (GET_CODE (operands[0]) == SUBREG
	  && ANY_FP_REG_P (SUBREG_REG (operands[0]))))
   && ! (ANY_FP_REG_P (operands[1]) || 
	 (GET_CODE (operands[1]) == SUBREG
	  && ANY_FP_REG_P (SUBREG_REG (operands[1]))))"
  [(const_int 0)]
  "ix86_split_long_move (operands); DONE;")

(define_split
  [(set (match_operand 0 "register_operand" "")
	(match_operand 1 "memory_operand" ""))]
  "reload_completed
   && GET_CODE (operands[1]) == MEM
   && (GET_MODE (operands[0]) == XFmode
       || GET_MODE (operands[0]) == SFmode || GET_MODE (operands[0]) == DFmode)
   && GET_CODE (XEXP (operands[1], 0)) == SYMBOL_REF
   && CONSTANT_POOL_ADDRESS_P (XEXP (operands[1], 0))"
  [(set (match_dup 0) (match_dup 1))]
{
  rtx c = get_pool_constant (XEXP (operands[1], 0));
  rtx r = operands[0];

  if (GET_CODE (r) == SUBREG)
    r = SUBREG_REG (r);

  if (SSE_REG_P (r))
    {
      if (!standard_sse_constant_p (c))
	FAIL;
    }
  else if (FP_REG_P (r))
    {
      if (!standard_80387_constant_p (c))
	FAIL;
    }
  else if (MMX_REG_P (r))
    FAIL;

  operands[1] = c;
})

(define_insn "swapxf"
  [(set (match_operand:XF 0 "register_operand" "+f")
	(match_operand:XF 1 "register_operand" "+f"))
   (set (match_dup 1)
	(match_dup 0))]
  ""
{
  if (STACK_TOP_P (operands[0]))
    return "fxch\t%1";
  else
    return "fxch\t%0";
}
  [(set_attr "type" "fxch")
   (set_attr "mode" "XF")])

;; Zero extension instructions

(define_expand "zero_extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "")
     (zero_extend:SI (match_operand:HI 1 "nonimmediate_operand" "")))]
  ""
{
  if (TARGET_ZERO_EXTEND_WITH_AND && !optimize_size)
    {
      operands[1] = force_reg (HImode, operands[1]);
      emit_insn (gen_zero_extendhisi2_and (operands[0], operands[1]));
      DONE;
    }
})

(define_insn "zero_extendhisi2_and"
  [(set (match_operand:SI 0 "register_operand" "=r")
     (zero_extend:SI (match_operand:HI 1 "register_operand" "0")))
   (clobber (reg:CC 17))]
  "TARGET_ZERO_EXTEND_WITH_AND && !optimize_size"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")])

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(zero_extend:SI (match_operand:HI 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed && TARGET_ZERO_EXTEND_WITH_AND && !optimize_size"
  [(parallel [(set (match_dup 0) (and:SI (match_dup 0) (const_int 65535)))
	      (clobber (reg:CC 17))])]
  "")

(define_insn "*zero_extendhisi2_movzwl"
  [(set (match_operand:SI 0 "register_operand" "=r")
     (zero_extend:SI (match_operand:HI 1 "nonimmediate_operand" "rm")))]
  "!TARGET_ZERO_EXTEND_WITH_AND || optimize_size"
  "movz{wl|x}\t{%1, %0|%0, %1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI")])

(define_expand "zero_extendqihi2"
  [(parallel
    [(set (match_operand:HI 0 "register_operand" "")
       (zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "")))
     (clobber (reg:CC 17))])]
  ""
  "")

(define_insn "*zero_extendqihi2_and"
  [(set (match_operand:HI 0 "register_operand" "=r,?&q")
     (zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "0,qm")))
   (clobber (reg:CC 17))]
  "TARGET_ZERO_EXTEND_WITH_AND && !optimize_size"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "HI")])

(define_insn "*zero_extendqihi2_movzbw_and"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
     (zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "qm,0")))
   (clobber (reg:CC 17))]
  "!TARGET_ZERO_EXTEND_WITH_AND || optimize_size"
  "#"
  [(set_attr "type" "imovx,alu1")
   (set_attr "mode" "HI")])

(define_insn "*zero_extendqihi2_movzbw"
  [(set (match_operand:HI 0 "register_operand" "=r")
     (zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "qm")))]
  "(!TARGET_ZERO_EXTEND_WITH_AND || optimize_size) && reload_completed"
  "movz{bw|x}\t{%1, %0|%0, %1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "HI")])

;; For the movzbw case strip only the clobber
(define_split
  [(set (match_operand:HI 0 "register_operand" "")
	(zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed 
   && (!TARGET_ZERO_EXTEND_WITH_AND || optimize_size)
   && (!REG_P (operands[1]) || ANY_QI_REG_P (operands[1]))"
  [(set (match_operand:HI 0 "register_operand" "")
	(zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "")))])

;; When source and destination does not overlap, clear destination
;; first and then do the movb
(define_split
  [(set (match_operand:HI 0 "register_operand" "")
	(zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && ANY_QI_REG_P (operands[0])
   && (TARGET_ZERO_EXTEND_WITH_AND && !optimize_size)
   && !reg_overlap_mentioned_p (operands[0], operands[1])"
  [(set (match_dup 0) (const_int 0))
   (set (strict_low_part (match_dup 2)) (match_dup 1))]
  "operands[2] = gen_lowpart (QImode, operands[0]);")

;; Rest is handled by single and.
(define_split
  [(set (match_operand:HI 0 "register_operand" "")
	(zero_extend:HI (match_operand:QI 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && true_regnum (operands[0]) == true_regnum (operands[1])"
  [(parallel [(set (match_dup 0) (and:HI (match_dup 0) (const_int 255)))
	      (clobber (reg:CC 17))])]
  "")

(define_expand "zero_extendqisi2"
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "")
       (zero_extend:SI (match_operand:QI 1 "nonimmediate_operand" "")))
     (clobber (reg:CC 17))])]
  ""
  "")

(define_insn "*zero_extendqisi2_and"
  [(set (match_operand:SI 0 "register_operand" "=r,?&q")
     (zero_extend:SI (match_operand:QI 1 "nonimmediate_operand" "0,qm")))
   (clobber (reg:CC 17))]
  "TARGET_ZERO_EXTEND_WITH_AND && !optimize_size"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")])

(define_insn "*zero_extendqisi2_movzbw_and"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
     (zero_extend:SI (match_operand:QI 1 "nonimmediate_operand" "qm,0")))
   (clobber (reg:CC 17))]
  "!TARGET_ZERO_EXTEND_WITH_AND || optimize_size"
  "#"
  [(set_attr "type" "imovx,alu1")
   (set_attr "mode" "SI")])

(define_insn "*zero_extendqisi2_movzbw"
  [(set (match_operand:SI 0 "register_operand" "=r")
     (zero_extend:SI (match_operand:QI 1 "nonimmediate_operand" "qm")))]
  "(!TARGET_ZERO_EXTEND_WITH_AND || optimize_size) && reload_completed"
  "movz{bl|x}\t{%1, %0|%0, %1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI")])

;; For the movzbl case strip only the clobber
(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(zero_extend:SI (match_operand:QI 1 "nonimmediate_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed 
   && (!TARGET_ZERO_EXTEND_WITH_AND || optimize_size)
   && (!REG_P (operands[1]) || ANY_QI_REG_P (operands[1]))"
  [(set (match_dup 0)
	(zero_extend:SI (match_dup 1)))])

;; When source and destination does not overlap, clear destination
;; first and then do the movb
(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(zero_extend:SI (match_operand:QI 1 "nonimmediate_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && ANY_QI_REG_P (operands[0])
   && (ANY_QI_REG_P (operands[1]) || GET_CODE (operands[1]) == MEM)
   && (TARGET_ZERO_EXTEND_WITH_AND && !optimize_size)
   && !reg_overlap_mentioned_p (operands[0], operands[1])"
  [(set (match_dup 0) (const_int 0))
   (set (strict_low_part (match_dup 2)) (match_dup 1))]
  "operands[2] = gen_lowpart (QImode, operands[0]);")

;; Rest is handled by single and.
(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(zero_extend:SI (match_operand:QI 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && true_regnum (operands[0]) == true_regnum (operands[1])"
  [(parallel [(set (match_dup 0) (and:SI (match_dup 0) (const_int 255)))
	      (clobber (reg:CC 17))])]
  "")

;; %%% Kill me once multi-word ops are sane.
(define_expand "zero_extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
     (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "rm")))]
  ""
  "if (!TARGET_64BIT)
     {
       emit_insn (gen_zero_extendsidi2_32 (operands[0], operands[1]));
       DONE;
     }
  ")

(define_insn "zero_extendsidi2_32"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,?r,?*o,!?y,!?Y")
	(zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "0,rm,r,m,m")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && !TARGET_INTER_UNIT_MOVES"
  "@
   #
   #
   #
   movd\t{%1, %0|%0, %1}
   movd\t{%1, %0|%0, %1}"
  [(set_attr "mode" "SI,SI,SI,DI,TI")
   (set_attr "type" "multi,multi,multi,mmxmov,ssemov")])

(define_insn "*zero_extendsidi2_32_1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,?r,?*o,!?y,!?Y")
	(zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "0,rm,r,rm,rm")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_INTER_UNIT_MOVES"
  "@
   #
   #
   #
   movd\t{%1, %0|%0, %1}
   movd\t{%1, %0|%0, %1}"
  [(set_attr "mode" "SI,SI,SI,DI,TI")
   (set_attr "type" "multi,multi,multi,mmxmov,ssemov")])

(define_insn "zero_extendsidi2_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,o,!?y,!?Y")
     (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "rm,0,m,m")))]
  "TARGET_64BIT && !TARGET_INTER_UNIT_MOVES"
  "@
   mov\t{%k1, %k0|%k0, %k1}
   #
   movd\t{%1, %0|%0, %1}
   movd\t{%1, %0|%0, %1}"
  [(set_attr "type" "imovx,imov,mmxmov,ssemov")
   (set_attr "mode" "SI,DI,DI,TI")])

(define_insn "*zero_extendsidi2_rex64_1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,o,!?y,!*?")
     (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "rm,0,rm,rm")))]
  "TARGET_64BIT && TARGET_INTER_UNIT_MOVES"
  "@
   mov\t{%k1, %k0|%k0, %k1}
   #
   movd\t{%1, %0|%0, %1}
   movd\t{%1, %0|%0, %1}"
  [(set_attr "type" "imovx,imov,mmxmov,ssemov")
   (set_attr "mode" "SI,DI,SI,SI")])

(define_split
  [(set (match_operand:DI 0 "memory_operand" "")
     (zero_extend:DI (match_dup 0)))]
  "TARGET_64BIT"
  [(set (match_dup 4) (const_int 0))]
  "split_di (&operands[0], 1, &operands[3], &operands[4]);")

(define_split 
  [(set (match_operand:DI 0 "register_operand" "")
	(zero_extend:DI (match_operand:SI 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && reload_completed
   && true_regnum (operands[0]) == true_regnum (operands[1])"
  [(set (match_dup 4) (const_int 0))]
  "split_di (&operands[0], 1, &operands[3], &operands[4]);")

(define_split 
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(zero_extend:DI (match_operand:SI 1 "general_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && reload_completed
   && !SSE_REG_P (operands[0]) && !MMX_REG_P (operands[0])"
  [(set (match_dup 3) (match_dup 1))
   (set (match_dup 4) (const_int 0))]
  "split_di (&operands[0], 1, &operands[3], &operands[4]);")

(define_insn "zero_extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
     (zero_extend:DI (match_operand:HI 1 "nonimmediate_operand" "r,m")))]
  "TARGET_64BIT"
  "@
   movz{wl|x}\t{%1, %k0|%k0, %1} 
   movz{wq|x}\t{%1, %0|%0, %1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI,DI")])

(define_insn "zero_extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
     (zero_extend:DI (match_operand:QI 1 "nonimmediate_operand" "Q,m")))]
  "TARGET_64BIT"
  "@
   movz{bl|x}\t{%1, %k0|%k0, %1} 
   movz{bq|x}\t{%1, %0|%0, %1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI,DI")])

;; Sign extension instructions

(define_expand "extendsidi2"
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (sign_extend:DI (match_operand:SI 1 "register_operand" "")))
	      (clobber (reg:CC 17))
	      (clobber (match_scratch:SI 2 ""))])]
  ""
{
  if (TARGET_64BIT)
    {
      emit_insn (gen_extendsidi2_rex64 (operands[0], operands[1]));
      DONE;
    }
})

(define_insn "*extendsidi2_1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=*A,r,?r,?*o")
	(sign_extend:DI (match_operand:SI 1 "register_operand" "0,0,r,r")))
   (clobber (reg:CC 17))
   (clobber (match_scratch:SI 2 "=X,X,X,&r"))]
  "!TARGET_64BIT"
  "#")

(define_insn "extendsidi2_rex64"
  [(set (match_operand:DI 0 "register_operand" "=*a,r")
	(sign_extend:DI (match_operand:SI 1 "nonimmediate_operand" "*0,rm")))]
  "TARGET_64BIT"
  "@
   {cltq|cdqe}
   movs{lq|x}\t{%1,%0|%0, %1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "DI")
   (set_attr "prefix_0f" "0")
   (set_attr "modrm" "0,1")])

(define_insn "extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(sign_extend:DI (match_operand:HI 1 "nonimmediate_operand" "rm")))]
  "TARGET_64BIT"
  "movs{wq|x}\t{%1,%0|%0, %1}"
  [(set_attr "type" "imovx")
   (set_attr "mode" "DI")])

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(sign_extend:DI (match_operand:QI 1 "nonimmediate_operand" "qm")))]
  "TARGET_64BIT"
  "movs{bq|x}\t{%1,%0|%0, %1}"
   [(set_attr "type" "imovx")
    (set_attr "mode" "DI")])

;; Extend to memory case when source register does die.
(define_split 
  [(set (match_operand:DI 0 "memory_operand" "")
	(sign_extend:DI (match_operand:SI 1 "register_operand" "")))
   (clobber (reg:CC 17))
   (clobber (match_operand:SI 2 "register_operand" ""))]
  "(reload_completed
    && dead_or_set_p (insn, operands[1])
    && !reg_mentioned_p (operands[1], operands[0]))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (match_dup 1) (ashiftrt:SI (match_dup 1) (const_int 31)))
	      (clobber (reg:CC 17))])
   (set (match_dup 4) (match_dup 1))]
  "split_di (&operands[0], 1, &operands[3], &operands[4]);")

;; Extend to memory case when source register does not die.
(define_split 
  [(set (match_operand:DI 0 "memory_operand" "")
	(sign_extend:DI (match_operand:SI 1 "register_operand" "")))
   (clobber (reg:CC 17))
   (clobber (match_operand:SI 2 "register_operand" ""))]
  "reload_completed"
  [(const_int 0)]
{
  split_di (&operands[0], 1, &operands[3], &operands[4]);

  emit_move_insn (operands[3], operands[1]);

  /* Generate a cltd if possible and doing so it profitable.  */
  if (true_regnum (operands[1]) == 0
      && true_regnum (operands[2]) == 1
      && (optimize_size || TARGET_USE_CLTD))
    {
      emit_insn (gen_ashrsi3_31 (operands[2], operands[1], GEN_INT (31)));
    }
  else
    {
      emit_move_insn (operands[2], operands[1]);
      emit_insn (gen_ashrsi3_31 (operands[2], operands[2], GEN_INT (31)));
    }
  emit_move_insn (operands[4], operands[2]);
  DONE;
})

;; Extend to register case.  Optimize case where source and destination
;; registers match and cases where we can use cltd.
(define_split 
  [(set (match_operand:DI 0 "register_operand" "")
	(sign_extend:DI (match_operand:SI 1 "register_operand" "")))
   (clobber (reg:CC 17))
   (clobber (match_scratch:SI 2 ""))]
  "reload_completed"
  [(const_int 0)]
{
  split_di (&operands[0], 1, &operands[3], &operands[4]);

  if (true_regnum (operands[3]) != true_regnum (operands[1]))
    emit_move_insn (operands[3], operands[1]);

  /* Generate a cltd if possible and doing so it profitable.  */
  if (true_regnum (operands[3]) == 0
      && (optimize_size || TARGET_USE_CLTD))
    {
      emit_insn (gen_ashrsi3_31 (operands[4], operands[3], GEN_INT (31)));
      DONE;
    }

  if (true_regnum (operands[4]) != true_regnum (operands[1]))
    emit_move_insn (operands[4], operands[1]);

  emit_insn (gen_ashrsi3_31 (operands[4], operands[4], GEN_INT (31)));
  DONE;
})

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=*a,r")
	(sign_extend:SI (match_operand:HI 1 "nonimmediate_operand" "*0,rm")))]
  ""
{
  switch (get_attr_prefix_0f (insn))
    {
    case 0:
      return "{cwtl|cwde}";
    default:
      return "movs{wl|x}\t{%1,%0|%0, %1}";
    }
}
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI")
   (set (attr "prefix_0f")
     ;; movsx is short decodable while cwtl is vector decoded.
     (if_then_else (and (eq_attr "cpu" "!k6")
			(eq_attr "alternative" "0"))
	(const_string "0")
	(const_string "1")))
   (set (attr "modrm")
     (if_then_else (eq_attr "prefix_0f" "0")
	(const_string "0")
	(const_string "1")))])

(define_insn "*extendhisi2_zext"
  [(set (match_operand:DI 0 "register_operand" "=*a,r")
	(zero_extend:DI
	  (sign_extend:SI (match_operand:HI 1 "nonimmediate_operand" "*0,rm"))))]
  "TARGET_64BIT"
{
  switch (get_attr_prefix_0f (insn))
    {
    case 0:
      return "{cwtl|cwde}";
    default:
      return "movs{wl|x}\t{%1,%k0|%k0, %1}";
    }
}
  [(set_attr "type" "imovx")
   (set_attr "mode" "SI")
   (set (attr "prefix_0f")
     ;; movsx is short decodable while cwtl is vector decoded.
     (if_then_else (and (eq_attr "cpu" "!k6")
			(eq_attr "alternative" "0"))
	(const_string "0")
	(const_string "1")))
   (set (attr "modrm")
     (if_then_else (eq_attr "prefix_0f" "0")
	(const_string "0")
	(const_string "1")))])

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=*a,r")
	(sign_extend:HI (match_operand:QI 1 "nonimmediate_operand" "*0,qm")))]
  ""
{
  switch (get_attr_prefix_0f (insn))
    {
    case 0:
      return "{cbtw|cbw}";
    default:
      return "movs{bw|x}\t{%1,%0|%0, %1}";
    }
}
  [(set_attr "type" "imovx")
   (set_attr "mode" "HI")
   (set (attr "prefix_0f")
     ;; movsx is short decodable while cwtl is vector decoded.
     (if_then_else (and (eq_attr "cpu" "!k6")
			(eq_attr "alternative" "0"))
	(const_string "0")
	(const_string "1")))
   (set (attr "modrm")
     (if_then_else (eq_attr "prefix_0f" "0")
	(const_string "0")
	(const_string "1")))])

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI (match_operand:QI 1 "nonimmediate_operand" "qm")))]
  ""
  "movs{bl|x}\t{%1,%0|%0, %1}"
   [(set_attr "type" "imovx")
    (set_attr "mode" "SI")])

(define_insn "*extendqisi2_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (sign_extend:SI (match_operand:QI 1 "nonimmediate_operand" "qm"))))]
  "TARGET_64BIT"
  "movs{bl|x}\t{%1,%k0|%k0, %1}"
   [(set_attr "type" "imovx")
    (set_attr "mode" "SI")])

;; Conversions between float and double.

;; These are all no-ops in the model used for the 80387.  So just
;; emit moves.

;; %%% Kill these when call knows how to work out a DFmode push earlier. 
(define_insn "*dummy_extendsfdf2"
  [(set (match_operand:DF 0 "push_operand" "=<")
	(float_extend:DF (match_operand:SF 1 "nonimmediate_operand" "fY")))]
  "0"
  "#")

(define_split
  [(set (match_operand:DF 0 "push_operand" "")
	(float_extend:DF (match_operand:SF 1 "fp_register_operand" "")))]
  "!TARGET_64BIT"
  [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int -8)))
   (set (mem:DF (reg:SI 7)) (float_extend:DF (match_dup 1)))])

(define_split
  [(set (match_operand:DF 0 "push_operand" "")
	(float_extend:DF (match_operand:SF 1 "fp_register_operand" "")))]
  "TARGET_64BIT"
  [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int -8)))
   (set (mem:DF (reg:DI 7)) (float_extend:DF (match_dup 1)))])

(define_insn "*dummy_extendsfxf2"
  [(set (match_operand:XF 0 "push_operand" "=<")
	(float_extend:XF (match_operand:SF 1 "nonimmediate_operand" "f")))]
  "0"
  "#")

(define_split
  [(set (match_operand:XF 0 "push_operand" "")
	(float_extend:XF (match_operand:SF 1 "fp_register_operand" "")))]
  ""
  [(set (reg:SI 7) (plus:SI (reg:SI 7) (match_dup 2)))
   (set (mem:XF (reg:SI 7)) (float_extend:XF (match_dup 1)))]
  "operands[2] = GEN_INT (TARGET_128BIT_LONG_DOUBLE ? -16 : -12);")

(define_split
  [(set (match_operand:XF 0 "push_operand" "")
	(float_extend:XF (match_operand:SF 1 "fp_register_operand" "")))]
  "TARGET_64BIT"
  [(set (reg:DI 7) (plus:DI (reg:DI 7) (match_dup 2)))
   (set (mem:DF (reg:DI 7)) (float_extend:XF (match_dup 1)))]
  "operands[2] = GEN_INT (TARGET_128BIT_LONG_DOUBLE ? -16 : -12);")

(define_split
  [(set (match_operand:XF 0 "push_operand" "")
	(float_extend:XF (match_operand:DF 1 "fp_register_operand" "")))]
  ""
  [(set (reg:SI 7) (plus:SI (reg:SI 7) (match_dup 2)))
   (set (mem:DF (reg:SI 7)) (float_extend:XF (match_dup 1)))]
  "operands[2] = GEN_INT (TARGET_128BIT_LONG_DOUBLE ? -16 : -12);")

(define_split
  [(set (match_operand:XF 0 "push_operand" "")
	(float_extend:XF (match_operand:DF 1 "fp_register_operand" "")))]
  "TARGET_64BIT"
  [(set (reg:DI 7) (plus:DI (reg:DI 7) (match_dup 2)))
   (set (mem:XF (reg:DI 7)) (float_extend:XF (match_dup 1)))]
  "operands[2] = GEN_INT (TARGET_128BIT_LONG_DOUBLE ? -16 : -12);")

(define_expand "extendsfdf2"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
        (float_extend:DF (match_operand:SF 1 "general_operand" "")))]
  "TARGET_80387 || TARGET_SSE2"
{
  /* ??? Needed for compress_float_constant since all fp constants
     are LEGITIMATE_CONSTANT_P.  */
  if (GET_CODE (operands[1]) == CONST_DOUBLE)
    operands[1] = validize_mem (force_const_mem (SFmode, operands[1]));
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[1] = force_reg (SFmode, operands[1]);
})

(define_insn "*extendsfdf2_1"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f#Y,mf#Y,Y#f")
        (float_extend:DF (match_operand:SF 1 "nonimmediate_operand" "fm#Y,f#Y,mY#f")))]
  "(TARGET_80387 || TARGET_SSE2)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp\t%y0";
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0";

      else
        return "fst%z0\t%y0";
    case 2:
      return "cvtss2sd\t{%1, %0|%0, %1}";

    default:
      abort ();
    }
}
  [(set_attr "type" "fmov,fmov,ssecvt")
   (set_attr "mode" "SF,XF,DF")])

(define_insn "*extendsfdf2_1_sse_only"
  [(set (match_operand:DF 0 "register_operand" "=Y")
        (float_extend:DF (match_operand:SF 1 "nonimmediate_operand" "mY")))]
  "!TARGET_80387 && TARGET_SSE2
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "cvtss2sd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "DF")])

(define_expand "extendsfxf2"
  [(set (match_operand:XF 0 "nonimmediate_operand" "")
        (float_extend:XF (match_operand:SF 1 "general_operand" "")))]
  "TARGET_80387"
{
  /* ??? Needed for compress_float_constant since all fp constants
     are LEGITIMATE_CONSTANT_P.  */
  if (GET_CODE (operands[1]) == CONST_DOUBLE)
    operands[1] = validize_mem (force_const_mem (SFmode, operands[1]));
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[1] = force_reg (SFmode, operands[1]);
})

(define_insn "*extendsfxf2_1"
  [(set (match_operand:XF 0 "nonimmediate_operand" "=f,m")
        (float_extend:XF (match_operand:SF 1 "nonimmediate_operand" "fm,f")))]
  "TARGET_80387
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp\t%y0";
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      /* There is no non-popping store to memory for XFmode.  So if
	 we need one, follow the store with a load.  */
      if (! find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0\n\tfld%z0\t%y0";
      else
        return "fstp%z0\t%y0";

    default:
      abort ();
    }
}
  [(set_attr "type" "fmov")
   (set_attr "mode" "SF,XF")])

(define_expand "extenddfxf2"
  [(set (match_operand:XF 0 "nonimmediate_operand" "")
        (float_extend:XF (match_operand:DF 1 "general_operand" "")))]
  "TARGET_80387"
{
  /* ??? Needed for compress_float_constant since all fp constants
     are LEGITIMATE_CONSTANT_P.  */
  if (GET_CODE (operands[1]) == CONST_DOUBLE)
    operands[1] = validize_mem (force_const_mem (DFmode, operands[1]));
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    operands[1] = force_reg (DFmode, operands[1]);
})

(define_insn "*extenddfxf2_1"
  [(set (match_operand:XF 0 "nonimmediate_operand" "=f,m")
        (float_extend:XF (match_operand:DF 1 "nonimmediate_operand" "fm,f")))]
  "TARGET_80387
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
      if (REG_P (operands[1])
          && find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp\t%y0";
      else if (STACK_TOP_P (operands[0]))
        return "fld%z1\t%y1";
      else
        return "fst\t%y0";

    case 1:
      /* There is no non-popping store to memory for XFmode.  So if
	 we need one, follow the store with a load.  */
      if (! find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
        return "fstp%z0\t%y0\n\tfld%z0\t%y0";
      else
        return "fstp%z0\t%y0";

    default:
      abort ();
    }
}
  [(set_attr "type" "fmov")
   (set_attr "mode" "DF,XF")])

;; %%% This seems bad bad news.
;; This cannot output into an f-reg because there is no way to be sure
;; of truncating in that case.  Otherwise this is just like a simple move
;; insn.  So we pretend we can output to a reg in order to get better
;; register preferencing, but we really use a stack slot.

(define_expand "truncdfsf2"
  [(parallel [(set (match_operand:SF 0 "nonimmediate_operand" "")
		   (float_truncate:SF
		    (match_operand:DF 1 "register_operand" "")))
	      (clobber (match_dup 2))])]
  "TARGET_80387 || TARGET_SSE2"
  "
   if (TARGET_80387)
     operands[2] = assign_386_stack_local (SFmode, 0);
   else
     {
	emit_insn (gen_truncdfsf2_sse_only (operands[0], operands[1]));
	DONE;
     }
")

(define_insn "*truncdfsf2_1"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=m,?f#rx,?r#fx,?x#rf")
	(float_truncate:SF
	 (match_operand:DF 1 "register_operand" "f,f,f,f")))
   (clobber (match_operand:SF 2 "memory_operand" "=X,m,m,m"))]
  "TARGET_80387 && !TARGET_SSE2"
{
  switch (which_alternative)
    {
    case 0:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	return "fstp%z0\t%y0";
      else
	return "fst%z0\t%y0";
    default:
      abort ();
    }
}
  [(set_attr "type" "fmov,multi,multi,multi")
   (set_attr "mode" "SF,SF,SF,SF")])

(define_insn "*truncdfsf2_1_sse"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=*!m#fxr,?f#xr,?r#fx,?x#fr,Y#fr")
	(float_truncate:SF
	 (match_operand:DF 1 "nonimmediate_operand" "f#Y,f#Y,f#Y,f#Y,mY#f")))
   (clobber (match_operand:SF 2 "memory_operand" "=X,m,m,m,X"))]
  "TARGET_80387 && TARGET_SSE2 && !TARGET_SSE_PARTIAL_REGS_FOR_CVTSD2SS"
{
  switch (which_alternative)
    {
    case 0:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	return "fstp%z0\t%y0";
      else
	return "fst%z0\t%y0";
    case 4:
      return "#";
    default:
      abort ();
    }
}
  [(set_attr "type" "fmov,multi,multi,multi,ssecvt")
   (set_attr "mode" "SF,SF,SF,SF,DF")])

(define_insn "*truncdfsf2_1_sse_nooverlap"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=*!m,?f#rx,?r#fx,?x#rf,&Y")
	(float_truncate:SF
	 (match_operand:DF 1 "nonimmediate_operand" "f#Y,f#Y,f#Y,f#Y,mY#f")))
   (clobber (match_operand:SF 2 "memory_operand" "=X,m,m,m,X"))]
  "TARGET_80387 && TARGET_SSE2 && TARGET_SSE_PARTIAL_REGS_FOR_CVTSD2SS"
{
  switch (which_alternative)
    {
    case 0:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	return "fstp%z0\t%y0";
      else
	return "fst%z0\t%y0";
    case 4:
      return "#";
    default:
      abort ();
    }
}
  [(set_attr "type" "fmov,multi,multi,multi,ssecvt")
   (set_attr "mode" "SF,SF,SF,SF,DF")])

(define_insn "*truncdfsf2_2"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=Y,Y,!m")
	(float_truncate:SF
	 (match_operand:DF 1 "nonimmediate_operand" "Y,mY,f#Y")))]
  "TARGET_80387 && TARGET_SSE2 && !TARGET_SSE_PARTIAL_REGS_FOR_CVTSD2SS
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
    case 1:
      return "cvtsd2ss\t{%1, %0|%0, %1}";
    case 2:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	return "fstp%z0\t%y0";
      else
	return "fst%z0\t%y0";
    default:
      abort ();
    }
}
  [(set_attr "type" "ssecvt,ssecvt,fmov")
   (set_attr "athlon_decode" "vector,double,*")
   (set_attr "mode" "SF,SF,SF")])

(define_insn "*truncdfsf2_2_nooverlap"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=&Y,!m")
	(float_truncate:SF
	 (match_operand:DF 1 "nonimmediate_operand" "mY,f")))]
  "TARGET_80387 && TARGET_SSE2 && TARGET_SSE_PARTIAL_REGS_FOR_CVTSD2SS
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
      return "#";
    case 1:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	return "fstp%z0\t%y0";
      else
	return "fst%z0\t%y0";
    default:
      abort ();
    }
}
  [(set_attr "type" "ssecvt,fmov")
   (set_attr "mode" "DF,SF")])

(define_insn "*truncdfsf2_3"
  [(set (match_operand:SF 0 "memory_operand" "=m")
	(float_truncate:SF
	 (match_operand:DF 1 "register_operand" "f")))]
  "TARGET_80387"
{
  if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
    return "fstp%z0\t%y0";
  else
    return "fst%z0\t%y0";
}
  [(set_attr "type" "fmov")
   (set_attr "mode" "SF")])

(define_insn "truncdfsf2_sse_only"
  [(set (match_operand:SF 0 "register_operand" "=Y,Y")
	(float_truncate:SF
	 (match_operand:DF 1 "nonimmediate_operand" "Y,mY")))]
  "!TARGET_80387 && TARGET_SSE2 && !TARGET_SSE_PARTIAL_REGS_FOR_CVTSD2SS"
  "cvtsd2ss\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "athlon_decode" "vector,double")
   (set_attr "mode" "SF")])

(define_insn "*truncdfsf2_sse_only_nooverlap"
  [(set (match_operand:SF 0 "register_operand" "=&Y")
	(float_truncate:SF
	 (match_operand:DF 1 "nonimmediate_operand" "mY")))]
  "!TARGET_80387 && TARGET_SSE2 && TARGET_SSE_PARTIAL_REGS_FOR_CVTSD2SS"
  "#"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "DF")])

(define_split
  [(set (match_operand:SF 0 "memory_operand" "")
	(float_truncate:SF
	 (match_operand:DF 1 "register_operand" "")))
   (clobber (match_operand:SF 2 "memory_operand" ""))]
  "TARGET_80387"
  [(set (match_dup 0) (float_truncate:SF (match_dup 1)))]
  "")

; Avoid possible reformatting penalty on the destination by first
; zeroing it out
(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(float_truncate:SF
	 (match_operand:DF 1 "nonimmediate_operand" "")))
   (clobber (match_operand 2 "" ""))]
  "TARGET_80387 && reload_completed
   && SSE_REG_P (operands[0])
   && !STACK_REG_P (operands[1])"
  [(const_int 0)]
{
  rtx src, dest;
  if (!TARGET_SSE_PARTIAL_REGS_FOR_CVTSD2SS)
    emit_insn (gen_truncdfsf2_sse_only (operands[0], operands[1]));
  else
    {
      dest = simplify_gen_subreg (V4SFmode, operands[0], SFmode, 0);
      src = simplify_gen_subreg (V2DFmode, operands[1], DFmode, 0);
      /* simplify_gen_subreg refuses to widen memory references.  */
      if (GET_CODE (src) == SUBREG)
	alter_subreg (&src);
      if (reg_overlap_mentioned_p (operands[0], operands[1]))
	abort ();
      emit_insn (gen_sse_clrv4sf (dest, CONST0_RTX (V4SFmode)));
      emit_insn (gen_cvtsd2ss (dest, dest, src));
    }
  DONE;
})

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(float_truncate:SF
	 (match_operand:DF 1 "nonimmediate_operand" "")))]
  "TARGET_80387 && reload_completed
   && SSE_REG_P (operands[0]) && TARGET_SSE_PARTIAL_REGS_FOR_CVTSD2SS"
  [(const_int 0)]
{
  rtx src, dest;
  dest = simplify_gen_subreg (V4SFmode, operands[0], SFmode, 0);
  src = simplify_gen_subreg (V2DFmode, operands[1], DFmode, 0);
  /* simplify_gen_subreg refuses to widen memory references.  */
  if (GET_CODE (src) == SUBREG)
    alter_subreg (&src);
  if (reg_overlap_mentioned_p (operands[0], operands[1]))
    abort ();
  emit_insn (gen_sse_clrv4sf (dest, CONST0_RTX (V4SFmode)));
  emit_insn (gen_cvtsd2ss (dest, dest, src));
  DONE;
})

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(float_truncate:SF
	 (match_operand:DF 1 "fp_register_operand" "")))
   (clobber (match_operand:SF 2 "memory_operand" ""))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 2) (float_truncate:SF (match_dup 1)))
   (set (match_dup 0) (match_dup 2))]
  "")

(define_expand "truncxfsf2"
  [(parallel [(set (match_operand:SF 0 "nonimmediate_operand" "")
		   (float_truncate:SF
		    (match_operand:XF 1 "register_operand" "")))
	      (clobber (match_dup 2))])]
  "TARGET_80387"
  "operands[2] = assign_386_stack_local (SFmode, 0);")

(define_insn "*truncxfsf2_1"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=m,?f#rx,?r#fx,?x#rf")
	(float_truncate:SF
	 (match_operand:XF 1 "register_operand" "f,f,f,f")))
   (clobber (match_operand:SF 2 "memory_operand" "=X,m,m,m"))]
  "TARGET_80387"
{
  switch (which_alternative)
    {
    case 0:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	return "fstp%z0\t%y0";
      else
	return "fst%z0\t%y0";
    default:
      abort();
    }
}
  [(set_attr "type" "fmov,multi,multi,multi")
   (set_attr "mode" "SF")])

(define_insn "*truncxfsf2_2"
  [(set (match_operand:SF 0 "memory_operand" "=m")
	(float_truncate:SF
	 (match_operand:XF 1 "register_operand" "f")))]
  "TARGET_80387"
{
  if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
    return "fstp%z0\t%y0";
  else
    return "fst%z0\t%y0";
}
  [(set_attr "type" "fmov")
   (set_attr "mode" "SF")])

(define_split
  [(set (match_operand:SF 0 "memory_operand" "")
	(float_truncate:SF
	 (match_operand:XF 1 "register_operand" "")))
   (clobber (match_operand:SF 2 "memory_operand" ""))]
  "TARGET_80387"
  [(set (match_dup 0) (float_truncate:SF (match_dup 1)))]
  "")

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(float_truncate:SF
	 (match_operand:XF 1 "register_operand" "")))
   (clobber (match_operand:SF 2 "memory_operand" ""))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 2) (float_truncate:SF (match_dup 1)))
   (set (match_dup 0) (match_dup 2))]
  "")

(define_expand "truncxfdf2"
  [(parallel [(set (match_operand:DF 0 "nonimmediate_operand" "")
		   (float_truncate:DF
		    (match_operand:XF 1 "register_operand" "")))
	      (clobber (match_dup 2))])]
  "TARGET_80387"
  "operands[2] = assign_386_stack_local (DFmode, 0);")

(define_insn "*truncxfdf2_1"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=m,?f#rY,?r#fY,?Y#rf")
	(float_truncate:DF
	 (match_operand:XF 1 "register_operand" "f,f,f,f")))
   (clobber (match_operand:DF 2 "memory_operand" "=X,m,m,m"))]
  "TARGET_80387"
{
  switch (which_alternative)
    {
    case 0:
      if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
	return "fstp%z0\t%y0";
      else
	return "fst%z0\t%y0";
    default:
      abort();
    }
  abort ();
}
  [(set_attr "type" "fmov,multi,multi,multi")
   (set_attr "mode" "DF")])

(define_insn "*truncxfdf2_2"
  [(set (match_operand:DF 0 "memory_operand" "=m")
	(float_truncate:DF
	  (match_operand:XF 1 "register_operand" "f")))]
  "TARGET_80387"
{
  if (find_regno_note (insn, REG_DEAD, REGNO (operands[1])))
    return "fstp%z0\t%y0";
  else
    return "fst%z0\t%y0";
}
  [(set_attr "type" "fmov")
   (set_attr "mode" "DF")])

(define_split
  [(set (match_operand:DF 0 "memory_operand" "")
	(float_truncate:DF
	 (match_operand:XF 1 "register_operand" "")))
   (clobber (match_operand:DF 2 "memory_operand" ""))]
  "TARGET_80387"
  [(set (match_dup 0) (float_truncate:DF (match_dup 1)))]
  "")

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(float_truncate:DF
	 (match_operand:XF 1 "register_operand" "")))
   (clobber (match_operand:DF 2 "memory_operand" ""))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 2) (float_truncate:DF (match_dup 1)))
   (set (match_dup 0) (match_dup 2))]
  "")


;; %%% Break up all these bad boys.

;; Signed conversion to DImode.

(define_expand "fix_truncxfdi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (fix:DI (match_operand:XF 1 "register_operand" "")))]
  "TARGET_80387"
  "")

(define_expand "fix_truncdfdi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (fix:DI (match_operand:DF 1 "register_operand" "")))]
  "TARGET_80387 || (TARGET_SSE2 && TARGET_64BIT)"
{
  if (TARGET_64BIT && TARGET_SSE2)
   {
     rtx out = REG_P (operands[0]) ? operands[0] : gen_reg_rtx (DImode);
     emit_insn (gen_fix_truncdfdi_sse (out, operands[1]));
     if (out != operands[0])
	emit_move_insn (operands[0], out);
     DONE;
   }
})

(define_expand "fix_truncsfdi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(fix:DI (match_operand:SF 1 "register_operand" "")))]
  "TARGET_80387 || (TARGET_SSE && TARGET_64BIT)"
{
  if (TARGET_SSE && TARGET_64BIT)
   {
     rtx out = REG_P (operands[0]) ? operands[0] : gen_reg_rtx (DImode);
     emit_insn (gen_fix_truncsfdi_sse (out, operands[1]));
     if (out != operands[0])
	emit_move_insn (operands[0], out);
     DONE;
   }
})

;; See the comments in i386.h near OPTIMIZE_MODE_SWITCHING for the description
;; of the machinery.
(define_insn_and_split "*fix_truncdi_1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=m,?r")
	(fix:DI (match_operand 1 "register_operand" "f,f")))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && !reload_completed && !reload_in_progress
   && (!SSE_FLOAT_MODE_P (GET_MODE (operands[1])) || !TARGET_64BIT)"
  "#"
  "&& 1"
  [(const_int 0)]
{
  ix86_optimize_mode_switching = 1;
  operands[2] = assign_386_stack_local (HImode, 1);
  operands[3] = assign_386_stack_local (HImode, 2);
  if (memory_operand (operands[0], VOIDmode))
    emit_insn (gen_fix_truncdi_memory (operands[0], operands[1],
				       operands[2], operands[3]));
  else
    {
      operands[4] = assign_386_stack_local (DImode, 0);
      emit_insn (gen_fix_truncdi_nomemory (operands[0], operands[1],
					   operands[2], operands[3],
					   operands[4]));
    }
  DONE;
}
  [(set_attr "type" "fistp")
   (set_attr "mode" "DI")])

(define_insn "fix_truncdi_nomemory"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=m,?r")
	(fix:DI (match_operand 1 "register_operand" "f,f")))
   (use (match_operand:HI 2 "memory_operand" "m,m"))
   (use (match_operand:HI 3 "memory_operand" "m,m"))
   (clobber (match_operand:DI 4 "memory_operand" "=m,m"))
   (clobber (match_scratch:DF 5 "=&1f,&1f"))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && (!SSE_FLOAT_MODE_P (GET_MODE (operands[1])) || !TARGET_64BIT)"
  "#"
  [(set_attr "type" "fistp")
   (set_attr "mode" "DI")])

(define_insn "fix_truncdi_memory"
  [(set (match_operand:DI 0 "memory_operand" "=m")
	(fix:DI (match_operand 1 "register_operand" "f")))
   (use (match_operand:HI 2 "memory_operand" "m"))
   (use (match_operand:HI 3 "memory_operand" "m"))
   (clobber (match_scratch:DF 4 "=&1f"))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && (!SSE_FLOAT_MODE_P (GET_MODE (operands[1])) || !TARGET_64BIT)"
  "* operands[5] = operands[4]; return output_fix_trunc (insn, operands);"
  [(set_attr "type" "fistp")
   (set_attr "mode" "DI")])

(define_split 
  [(set (match_operand:DI 0 "register_operand" "")
	(fix:DI (match_operand 1 "register_operand" "")))
   (use (match_operand:HI 2 "memory_operand" ""))
   (use (match_operand:HI 3 "memory_operand" ""))
   (clobber (match_operand:DI 4 "memory_operand" ""))
   (clobber (match_scratch 5 ""))]
  "reload_completed"
  [(parallel [(set (match_dup 4) (fix:DI (match_dup 1)))
	      (use (match_dup 2))
	      (use (match_dup 3))
	      (clobber (match_dup 5))])
   (set (match_dup 0) (match_dup 4))]
  "")

(define_split 
  [(set (match_operand:DI 0 "memory_operand" "")
	(fix:DI (match_operand 1 "register_operand" "")))
   (use (match_operand:HI 2 "memory_operand" ""))
   (use (match_operand:HI 3 "memory_operand" ""))
   (clobber (match_operand:DI 4 "memory_operand" ""))
   (clobber (match_scratch 5 ""))]
  "reload_completed"
  [(parallel [(set (match_dup 0) (fix:DI (match_dup 1)))
	      (use (match_dup 2))
	      (use (match_dup 3))
	      (clobber (match_dup 5))])]
  "")

;; When SSE available, it is always faster to use it!
(define_insn "fix_truncsfdi_sse"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(fix:DI (match_operand:SF 1 "nonimmediate_operand" "x,xm")))]
  "TARGET_64BIT && TARGET_SSE"
  "cvttss2si{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "double,vector")])

;; Avoid vector decoded form of the instruction.
(define_peephole2
  [(match_scratch:SF 2 "x")
   (set (match_operand:DI 0 "register_operand" "")
	(fix:DI (match_operand:SF 1 "memory_operand" "")))]
  "TARGET_K8 && !optimize_size"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (fix:DI (match_dup 2)))]
  "")

(define_insn "fix_truncdfdi_sse"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(fix:DI (match_operand:DF 1 "nonimmediate_operand" "Y,Ym")))]
  "TARGET_64BIT && TARGET_SSE2"
  "cvttsd2si{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt,sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "double,vector")])

;; Avoid vector decoded form of the instruction.
(define_peephole2
  [(match_scratch:DF 2 "Y")
   (set (match_operand:DI 0 "register_operand" "")
	(fix:DI (match_operand:DF 1 "memory_operand" "")))]
  "TARGET_K8 && !optimize_size"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (fix:DI (match_dup 2)))]
  "")

;; Signed conversion to SImode.

(define_expand "fix_truncxfsi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(fix:SI (match_operand:XF 1 "register_operand" "")))]
  "TARGET_80387"
  "")

(define_expand "fix_truncdfsi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(fix:SI (match_operand:DF 1 "register_operand" "")))]
  "TARGET_80387 || TARGET_SSE2"
{
  if (TARGET_SSE2)
   {
     rtx out = REG_P (operands[0]) ? operands[0] : gen_reg_rtx (SImode);
     emit_insn (gen_fix_truncdfsi_sse (out, operands[1]));
     if (out != operands[0])
	emit_move_insn (operands[0], out);
     DONE;
   }
})

(define_expand "fix_truncsfsi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(fix:SI (match_operand:SF 1 "register_operand" "")))]
  "TARGET_80387 || TARGET_SSE"
{
  if (TARGET_SSE)
   {
     rtx out = REG_P (operands[0]) ? operands[0] : gen_reg_rtx (SImode);
     emit_insn (gen_fix_truncsfsi_sse (out, operands[1]));
     if (out != operands[0])
	emit_move_insn (operands[0], out);
     DONE;
   }
})

;; See the comments in i386.h near OPTIMIZE_MODE_SWITCHING for the description
;; of the machinery.
(define_insn_and_split "*fix_truncsi_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=m,?r")
	(fix:SI (match_operand 1 "register_operand" "f,f")))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && !reload_completed && !reload_in_progress
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[1]))"
  "#"
  "&& 1"
  [(const_int 0)]
{
  ix86_optimize_mode_switching = 1;
  operands[2] = assign_386_stack_local (HImode, 1);
  operands[3] = assign_386_stack_local (HImode, 2);
  if (memory_operand (operands[0], VOIDmode))
    emit_insn (gen_fix_truncsi_memory (operands[0], operands[1],
				       operands[2], operands[3]));
  else
    {
      operands[4] = assign_386_stack_local (SImode, 0);
      emit_insn (gen_fix_truncsi_nomemory (operands[0], operands[1],
					   operands[2], operands[3],
					   operands[4]));
    }
  DONE;
}
  [(set_attr "type" "fistp")
   (set_attr "mode" "SI")])

(define_insn "fix_truncsi_nomemory"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=m,?r")
	(fix:SI (match_operand 1 "register_operand" "f,f")))
   (use (match_operand:HI 2 "memory_operand" "m,m"))
   (use (match_operand:HI 3 "memory_operand" "m,m"))
   (clobber (match_operand:SI 4 "memory_operand" "=m,m"))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[1]))"
  "#"
  [(set_attr "type" "fistp")
   (set_attr "mode" "SI")])

(define_insn "fix_truncsi_memory"
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(fix:SI (match_operand 1 "register_operand" "f")))
   (use (match_operand:HI 2 "memory_operand" "m"))
   (use (match_operand:HI 3 "memory_operand" "m"))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[1]))"
  "* return output_fix_trunc (insn, operands);"
  [(set_attr "type" "fistp")
   (set_attr "mode" "SI")])

;; When SSE available, it is always faster to use it!
(define_insn "fix_truncsfsi_sse"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(fix:SI (match_operand:SF 1 "nonimmediate_operand" "x,xm")))]
  "TARGET_SSE"
  "cvttss2si\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "double,vector")])

;; Avoid vector decoded form of the instruction.
(define_peephole2
  [(match_scratch:SF 2 "x")
   (set (match_operand:SI 0 "register_operand" "")
	(fix:SI (match_operand:SF 1 "memory_operand" "")))]
  "TARGET_K8 && !optimize_size"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (fix:SI (match_dup 2)))]
  "")

(define_insn "fix_truncdfsi_sse"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(fix:SI (match_operand:DF 1 "nonimmediate_operand" "Y,Ym")))]
  "TARGET_SSE2"
  "cvttsd2si\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "double,vector")])

;; Avoid vector decoded form of the instruction.
(define_peephole2
  [(match_scratch:DF 2 "Y")
   (set (match_operand:SI 0 "register_operand" "")
	(fix:SI (match_operand:DF 1 "memory_operand" "")))]
  "TARGET_K8 && !optimize_size"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (fix:SI (match_dup 2)))]
  "")

(define_split 
  [(set (match_operand:SI 0 "register_operand" "")
	(fix:SI (match_operand 1 "register_operand" "")))
   (use (match_operand:HI 2 "memory_operand" ""))
   (use (match_operand:HI 3 "memory_operand" ""))
   (clobber (match_operand:SI 4 "memory_operand" ""))]
  "reload_completed"
  [(parallel [(set (match_dup 4) (fix:SI (match_dup 1)))
	      (use (match_dup 2))
	      (use (match_dup 3))])
   (set (match_dup 0) (match_dup 4))]
  "")

(define_split 
  [(set (match_operand:SI 0 "memory_operand" "")
	(fix:SI (match_operand 1 "register_operand" "")))
   (use (match_operand:HI 2 "memory_operand" ""))
   (use (match_operand:HI 3 "memory_operand" ""))
   (clobber (match_operand:SI 4 "memory_operand" ""))]
  "reload_completed"
  [(parallel [(set (match_dup 0) (fix:SI (match_dup 1)))
	      (use (match_dup 2))
	      (use (match_dup 3))])]
  "")

;; Signed conversion to HImode.

(define_expand "fix_truncxfhi2"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
        (fix:HI (match_operand:XF 1 "register_operand" "")))]
  "TARGET_80387"
  "")

(define_expand "fix_truncdfhi2"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(fix:HI (match_operand:DF 1 "register_operand" "")))]
  "TARGET_80387 && !TARGET_SSE2"
  "")

(define_expand "fix_truncsfhi2"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(fix:HI (match_operand:SF 1 "register_operand" "")))]
  "TARGET_80387 && !TARGET_SSE"
  "")

;; See the comments in i386.h near OPTIMIZE_MODE_SWITCHING for the description
;; of the machinery.
(define_insn_and_split "*fix_trunchi_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=m,?r")
	(fix:HI (match_operand 1 "register_operand" "f,f")))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && !reload_completed && !reload_in_progress
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[1]))"
  "#"
  ""
  [(const_int 0)]
{
  ix86_optimize_mode_switching = 1;
  operands[2] = assign_386_stack_local (HImode, 1);
  operands[3] = assign_386_stack_local (HImode, 2);
  if (memory_operand (operands[0], VOIDmode))
    emit_insn (gen_fix_trunchi_memory (operands[0], operands[1],
				       operands[2], operands[3]));
  else
    {
      operands[4] = assign_386_stack_local (HImode, 0);
      emit_insn (gen_fix_trunchi_nomemory (operands[0], operands[1],
					   operands[2], operands[3],
					   operands[4]));
    }
  DONE;
}
  [(set_attr "type" "fistp")
   (set_attr "mode" "HI")])

(define_insn "fix_trunchi_nomemory"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=m,?r")
	(fix:HI (match_operand 1 "register_operand" "f,f")))
   (use (match_operand:HI 2 "memory_operand" "m,m"))
   (use (match_operand:HI 3 "memory_operand" "m,m"))
   (clobber (match_operand:HI 4 "memory_operand" "=m,m"))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[1]))"
  "#"
  [(set_attr "type" "fistp")
   (set_attr "mode" "HI")])

(define_insn "fix_trunchi_memory"
  [(set (match_operand:HI 0 "memory_operand" "=m")
	(fix:HI (match_operand 1 "register_operand" "f")))
   (use (match_operand:HI 2 "memory_operand" "m"))
   (use (match_operand:HI 3 "memory_operand" "m"))]
  "TARGET_80387 && FLOAT_MODE_P (GET_MODE (operands[1]))
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[1]))"
  "* return output_fix_trunc (insn, operands);"
  [(set_attr "type" "fistp")
   (set_attr "mode" "HI")])

(define_split 
  [(set (match_operand:HI 0 "memory_operand" "")
	(fix:HI (match_operand 1 "register_operand" "")))
   (use (match_operand:HI 2 "memory_operand" ""))
   (use (match_operand:HI 3 "memory_operand" ""))
   (clobber (match_operand:HI 4 "memory_operand" ""))]
  "reload_completed"
  [(parallel [(set (match_dup 0) (fix:HI (match_dup 1)))
	      (use (match_dup 2))
	      (use (match_dup 3))])]
  "")

(define_split 
  [(set (match_operand:HI 0 "register_operand" "")
	(fix:HI (match_operand 1 "register_operand" "")))
   (use (match_operand:HI 2 "memory_operand" ""))
   (use (match_operand:HI 3 "memory_operand" ""))
   (clobber (match_operand:HI 4 "memory_operand" ""))]
  "reload_completed"
  [(parallel [(set (match_dup 4) (fix:HI (match_dup 1)))
	      (use (match_dup 2))
	      (use (match_dup 3))
	      (clobber (match_dup 4))])
   (set (match_dup 0) (match_dup 4))]
  "")

;; %% Not used yet.
(define_insn "x86_fnstcw_1"
  [(set (match_operand:HI 0 "memory_operand" "=m")
	(unspec:HI [(reg:HI 18)] UNSPEC_FSTCW))]
  "TARGET_80387"
  "fnstcw\t%0"
  [(set_attr "length" "2")
   (set_attr "mode" "HI")
   (set_attr "unit" "i387")
   (set_attr "ppro_uops" "few")])

(define_insn "x86_fldcw_1"
  [(set (reg:HI 18)
	(unspec:HI [(match_operand:HI 0 "memory_operand" "m")] UNSPEC_FLDCW))]
  "TARGET_80387"
  "fldcw\t%0"
  [(set_attr "length" "2")
   (set_attr "mode" "HI")
   (set_attr "unit" "i387")
   (set_attr "athlon_decode" "vector")
   (set_attr "ppro_uops" "few")])

;; Conversion between fixed point and floating point.

;; Even though we only accept memory inputs, the backend _really_
;; wants to be able to do this between registers.

(define_expand "floathisf2"
  [(set (match_operand:SF 0 "register_operand" "")
	(float:SF (match_operand:HI 1 "nonimmediate_operand" "")))]
  "TARGET_SSE || TARGET_80387"
{
  if (TARGET_SSE && TARGET_SSE_MATH)
    {
      emit_insn (gen_floatsisf2 (operands[0],
				 convert_to_mode (SImode, operands[1], 0)));
      DONE;
    }
})

(define_insn "*floathisf2_1"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
	(float:SF (match_operand:HI 1 "nonimmediate_operand" "m,r")))]
  "TARGET_80387 && (!TARGET_SSE || !TARGET_SSE_MATH)"
  "@
   fild%z1\t%1
   #"
  [(set_attr "type" "fmov,multi")
   (set_attr "mode" "SF")
   (set_attr "fp_int_src" "true")])

(define_expand "floatsisf2"
  [(set (match_operand:SF 0 "register_operand" "")
	(float:SF (match_operand:SI 1 "nonimmediate_operand" "")))]
  "TARGET_SSE || TARGET_80387"
  "")

(define_insn "*floatsisf2_i387"
  [(set (match_operand:SF 0 "register_operand" "=f#x,?f#x,x#f,x#f")
	(float:SF (match_operand:SI 1 "nonimmediate_operand" "m,r,r,mr")))]
  "TARGET_80387 && (!TARGET_SSE || TARGET_MIX_SSE_I387)"
  "@
   fild%z1\t%1
   #
   cvtsi2ss\t{%1, %0|%0, %1}
   cvtsi2ss\t{%1, %0|%0, %1}"
  [(set_attr "type" "fmov,multi,sseicvt,sseicvt")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "*,*,vector,double")
   (set_attr "fp_int_src" "true")])

(define_insn "*floatsisf2_sse"
  [(set (match_operand:SF 0 "register_operand" "=x,x")
	(float:SF (match_operand:SI 1 "nonimmediate_operand" "r,mr")))]
  "TARGET_SSE"
  "cvtsi2ss\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "vector,double")
   (set_attr "fp_int_src" "true")])

; Avoid possible reformatting penalty on the destination by first
; zeroing it out
(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(float:SF (match_operand:SI 1 "nonimmediate_operand" "")))]
  "TARGET_80387 && reload_completed && TARGET_SSE_PARTIAL_REGS
   && SSE_REG_P (operands[0])"
  [(const_int 0)]
{
  rtx dest;
  dest = simplify_gen_subreg (V4SFmode, operands[0], SFmode, 0);
  emit_insn (gen_sse_clrv4sf (dest, CONST0_RTX (V4SFmode)));
  emit_insn (gen_cvtsi2ss (dest, dest, operands[1]));
  DONE;
})

(define_expand "floatdisf2"
  [(set (match_operand:SF 0 "register_operand" "")
	(float:SF (match_operand:DI 1 "nonimmediate_operand" "")))]
  "(TARGET_64BIT && TARGET_SSE) || TARGET_80387"
  "")

(define_insn "*floatdisf2_i387_only"
  [(set (match_operand:SF 0 "register_operand" "=f,?f")
	(float:SF (match_operand:DI 1 "nonimmediate_operand" "m,r")))]
  "TARGET_80387 && (!TARGET_SSE || !TARGET_64BIT || TARGET_MIX_SSE_I387)"
  "@
   fild%z1\t%1
   #"
  [(set_attr "type" "fmov,multi")
   (set_attr "mode" "SF")
   (set_attr "fp_int_src" "true")])

(define_insn "*floatdisf2_i387"
  [(set (match_operand:SF 0 "register_operand" "=f#x,?f#x,x#f,x#f")
	(float:SF (match_operand:DI 1 "nonimmediate_operand" "m,r,r,mr")))]
  "TARGET_64BIT && TARGET_80387 && (!TARGET_SSE || TARGET_MIX_SSE_I387)"
  "@
   fild%z1\t%1
   #
   cvtsi2ss{q}\t{%1, %0|%0, %1}
   cvtsi2ss{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "fmov,multi,sseicvt,sseicvt")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "*,*,vector,double")
   (set_attr "fp_int_src" "true")])

(define_insn "*floatdisf2_sse"
  [(set (match_operand:SF 0 "register_operand" "=x,x")
	(float:SF (match_operand:DI 1 "nonimmediate_operand" "r,mr")))]
  "TARGET_64BIT && TARGET_SSE"
  "cvtsi2ss{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "vector,double")
   (set_attr "fp_int_src" "true")])

; Avoid possible reformatting penalty on the destination by first
; zeroing it out
(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(float:SF (match_operand:DI 1 "nonimmediate_operand" "")))]
  "TARGET_80387 && reload_completed && TARGET_SSE_PARTIAL_REGS
   && SSE_REG_P (operands[0])"
  [(const_int 0)]
{
  rtx dest;
  dest = simplify_gen_subreg (V4SFmode, operands[0], SFmode, 0);
  emit_insn (gen_sse_clrv4sf (dest, CONST0_RTX (V4SFmode)));
  emit_insn (gen_cvtsi2ssq (dest, dest, operands[1]));
  DONE;
})

(define_expand "floathidf2"
  [(set (match_operand:DF 0 "register_operand" "")
	(float:DF (match_operand:HI 1 "nonimmediate_operand" "")))]
  "TARGET_SSE2 || TARGET_80387"
{
  if (TARGET_SSE && TARGET_SSE_MATH)
    {
      emit_insn (gen_floatsidf2 (operands[0],
				 convert_to_mode (SImode, operands[1], 0)));
      DONE;
    }
})

(define_insn "*floathidf2_1"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(float:DF (match_operand:HI 1 "nonimmediate_operand" "m,r")))]
  "TARGET_80387 && (!TARGET_SSE2 || !TARGET_SSE_MATH)"
  "@
   fild%z1\t%1
   #"
  [(set_attr "type" "fmov,multi")
   (set_attr "mode" "DF")
   (set_attr "fp_int_src" "true")])

(define_expand "floatsidf2"
  [(set (match_operand:DF 0 "register_operand" "")
	(float:DF (match_operand:SI 1 "nonimmediate_operand" "")))]
  "TARGET_80387 || TARGET_SSE2"
  "")

(define_insn "*floatsidf2_i387"
  [(set (match_operand:DF 0 "register_operand" "=f#Y,?f#Y,Y#f,Y#f")
	(float:DF (match_operand:SI 1 "nonimmediate_operand" "m,r,r,mr")))]
  "TARGET_80387 && (!TARGET_SSE2 || TARGET_MIX_SSE_I387)"
  "@
   fild%z1\t%1
   #
   cvtsi2sd\t{%1, %0|%0, %1}
   cvtsi2sd\t{%1, %0|%0, %1}"
  [(set_attr "type" "fmov,multi,sseicvt,sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "*,*,double,direct")
   (set_attr "fp_int_src" "true")])

(define_insn "*floatsidf2_sse"
  [(set (match_operand:DF 0 "register_operand" "=Y,Y")
	(float:DF (match_operand:SI 1 "nonimmediate_operand" "r,mr")))]
  "TARGET_SSE2"
  "cvtsi2sd\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "double,direct")
   (set_attr "fp_int_src" "true")])

(define_expand "floatdidf2"
  [(set (match_operand:DF 0 "register_operand" "")
	(float:DF (match_operand:DI 1 "nonimmediate_operand" "")))]
  "(TARGET_64BIT && TARGET_SSE2) || TARGET_80387"
  "")

(define_insn "*floatdidf2_i387_only"
  [(set (match_operand:DF 0 "register_operand" "=f,?f")
	(float:DF (match_operand:DI 1 "nonimmediate_operand" "m,r")))]
  "TARGET_80387 && (!TARGET_SSE2 || !TARGET_64BIT)"
  "@
   fild%z1\t%1
   #"
  [(set_attr "type" "fmov,multi")
   (set_attr "mode" "DF")
   (set_attr "fp_int_src" "true")])

(define_insn "*floatdidf2_i387"
  [(set (match_operand:DF 0 "register_operand" "=f#Y,?f#Y,Y#f,Y#f")
	(float:DF (match_operand:DI 1 "nonimmediate_operand" "m,r,r,mr")))]
  "TARGET_64BIT && TARGET_80387 && (!TARGET_SSE2 || TARGET_MIX_SSE_I387)"
  "@
   fild%z1\t%1
   #
   cvtsi2sd{q}\t{%1, %0|%0, %1}
   cvtsi2sd{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "fmov,multi,sseicvt,sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "*,*,double,direct")
   (set_attr "fp_int_src" "true")])

(define_insn "*floatdidf2_sse"
  [(set (match_operand:DF 0 "register_operand" "=Y,Y")
	(float:DF (match_operand:DI 1 "nonimmediate_operand" "r,mr")))]
  "TARGET_SSE2"
  "cvtsi2sd{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "double,direct")
   (set_attr "fp_int_src" "true")])

(define_insn "floathixf2"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(float:XF (match_operand:HI 1 "nonimmediate_operand" "m,r")))]
  "TARGET_80387"
  "@
   fild%z1\t%1
   #"
  [(set_attr "type" "fmov,multi")
   (set_attr "mode" "XF")
   (set_attr "fp_int_src" "true")])

(define_insn "floatsixf2"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(float:XF (match_operand:SI 1 "nonimmediate_operand" "m,r")))]
  "TARGET_80387"
  "@
   fild%z1\t%1
   #"
  [(set_attr "type" "fmov,multi")
   (set_attr "mode" "XF")
   (set_attr "fp_int_src" "true")])

(define_insn "floatdixf2"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(float:XF (match_operand:DI 1 "nonimmediate_operand" "m,r")))]
  "TARGET_80387"
  "@
   fild%z1\t%1
   #"
  [(set_attr "type" "fmov,multi")
   (set_attr "mode" "XF")
   (set_attr "fp_int_src" "true")])

;; %%% Kill these when reload knows how to do it.
(define_split
  [(set (match_operand 0 "fp_register_operand" "")
	(float (match_operand 1 "register_operand" "")))]
  "reload_completed && FLOAT_MODE_P (GET_MODE (operands[0]))"
  [(const_int 0)]
{
  operands[2] = ix86_force_to_memory (GET_MODE (operands[1]), operands[1]);
  operands[2] = gen_rtx_FLOAT (GET_MODE (operands[0]), operands[2]);
  emit_insn (gen_rtx_SET (VOIDmode, operands[0], operands[2]));
  ix86_free_from_memory (GET_MODE (operands[1]));
  DONE;
})

(define_expand "floatunssisf2"
  [(use (match_operand:SF 0 "register_operand" ""))
   (use (match_operand:SI 1 "register_operand" ""))]
  "TARGET_SSE && TARGET_SSE_MATH && !TARGET_64BIT"
  "x86_emit_floatuns (operands); DONE;")

(define_expand "floatunsdisf2"
  [(use (match_operand:SF 0 "register_operand" ""))
   (use (match_operand:DI 1 "register_operand" ""))]
  "TARGET_SSE && TARGET_SSE_MATH && TARGET_64BIT"
  "x86_emit_floatuns (operands); DONE;")

(define_expand "floatunsdidf2"
  [(use (match_operand:DF 0 "register_operand" ""))
   (use (match_operand:DI 1 "register_operand" ""))]
  "TARGET_SSE2 && TARGET_SSE_MATH && TARGET_64BIT"
  "x86_emit_floatuns (operands); DONE;")

;; SSE extract/set expanders

(define_expand "vec_setv2df"
  [(match_operand:V2DF 0 "register_operand" "")
   (match_operand:DF 1 "register_operand" "")
   (match_operand 2 "const_int_operand" "")]
  "TARGET_SSE2"
{
  switch (INTVAL (operands[2]))
    {
    case 0:
      emit_insn (gen_sse2_movsd (operands[0], operands[0],
				 simplify_gen_subreg (V2DFmode, operands[1],
						      DFmode, 0)));
      break;
    case 1:
      {
	rtx op1 = simplify_gen_subreg (V2DFmode, operands[1], DFmode, 0);

	emit_insn (gen_sse2_unpcklpd (operands[0], operands[0], op1));
      }
      break;
    default:
      abort ();
    }
  DONE;
})

(define_expand "vec_extractv2df"
  [(match_operand:DF 0 "register_operand" "")
   (match_operand:V2DF 1 "register_operand" "")
   (match_operand 2 "const_int_operand" "")]
  "TARGET_SSE2"
{
  switch (INTVAL (operands[2]))
    {
    case 0:
      emit_move_insn (operands[0], gen_lowpart (DFmode, operands[1]));
      break;
    case 1:
      {
	rtx dest = simplify_gen_subreg (V2DFmode, operands[0], DFmode, 0);

	emit_insn (gen_sse2_unpckhpd (dest, operands[1], operands[1]));
      }
      break;
    default:
      abort ();
    }
  DONE;
})

(define_expand "vec_initv2df"
  [(match_operand:V2DF 0 "register_operand" "")
   (match_operand 1 "" "")]
  "TARGET_SSE2"
{
  ix86_expand_vector_init (operands[0], operands[1]);
  DONE;
})

(define_expand "vec_setv4sf"
  [(match_operand:V4SF 0 "register_operand" "")
   (match_operand:SF 1 "register_operand" "")
   (match_operand 2 "const_int_operand" "")]
  "TARGET_SSE"
{
  switch (INTVAL (operands[2]))
    {
    case 0:
      emit_insn (gen_sse_movss (operands[0], operands[0],
				simplify_gen_subreg (V4SFmode, operands[1],
						     SFmode, 0)));
      break;
    case 1:
      {
	rtx op1 = simplify_gen_subreg (V4SFmode, operands[1], SFmode, 0);
	rtx tmp = gen_reg_rtx (V4SFmode);
 
        emit_move_insn (tmp, operands[0]);
	emit_insn (gen_sse_unpcklps (operands[0], operands[0], operands[0]));
	emit_insn (gen_sse_movss (operands[0], operands[0], op1));
        emit_insn (gen_sse_shufps (operands[0], operands[0], tmp,
                                   GEN_INT (1 + (0<<2) + (2<<4) + (3<<6))));
      }
    case 2:
      {
        rtx op1 = simplify_gen_subreg (V4SFmode, operands[1], SFmode, 0);
        rtx tmp = gen_reg_rtx (V4SFmode);

        emit_move_insn (tmp, operands[0]);
        emit_insn (gen_sse_movss (tmp, tmp, op1));
        emit_insn (gen_sse_shufps (operands[0], operands[0], tmp,
                                   GEN_INT (0 + (1<<2) + (0<<4) + (3<<6))));
      }
      break;
    case 3:
      {
        rtx op1 = simplify_gen_subreg (V4SFmode, operands[1], SFmode, 0);
        rtx tmp = gen_reg_rtx (V4SFmode);

        emit_move_insn (tmp, operands[0]);
        emit_insn (gen_sse_movss (tmp, tmp, op1));
        emit_insn (gen_sse_shufps (operands[0], operands[0], tmp,
                                   GEN_INT (0 + (1<<2) + (2<<4) + (0<<6))));
      }
      break;
    default:
      abort ();
    }
  DONE;
})

(define_expand "vec_extractv4sf"
  [(match_operand:SF 0 "register_operand" "")
   (match_operand:V4SF 1 "register_operand" "")
   (match_operand 2 "const_int_operand" "")]
  "TARGET_SSE"
{
  switch (INTVAL (operands[2]))
    {
    case 0:
      emit_move_insn (operands[0], gen_lowpart (SFmode, operands[1]));
      break;
    case 1:
      {
	rtx op0 = simplify_gen_subreg (V4SFmode, operands[1], SFmode, 0);
	rtx tmp = gen_reg_rtx (V4SFmode);
 
        emit_move_insn (tmp, operands[1]);
        emit_insn (gen_sse_shufps (op0, tmp, tmp,
                                   GEN_INT (1)));
      }
    case 2:
      {
	rtx op0 = simplify_gen_subreg (V4SFmode, operands[1], SFmode, 0);
	rtx tmp = gen_reg_rtx (V4SFmode);
 
        emit_move_insn (tmp, operands[1]);
        emit_insn (gen_sse_unpckhps (op0, tmp, tmp));
      }
    case 3:
      {
	rtx op0 = simplify_gen_subreg (V4SFmode, operands[1], SFmode, 0);
	rtx tmp = gen_reg_rtx (V4SFmode);
 
        emit_move_insn (tmp, operands[1]);
        emit_insn (gen_sse_shufps (op0, tmp, tmp,
                                   GEN_INT (3)));
      }
    default:
      abort ();
    }
  DONE;
})

(define_expand "vec_initv4sf"
  [(match_operand:V4SF 0 "register_operand" "")
   (match_operand 1 "" "")]
  "TARGET_SSE"
{
  ix86_expand_vector_init (operands[0], operands[1]);
  DONE;
})

;; Add instructions

;; %%% splits for addsidi3
;  [(set (match_operand:DI 0 "nonimmediate_operand" "")
;	(plus:DI (match_operand:DI 1 "general_operand" "")
;		 (zero_extend:DI (match_operand:SI 2 "general_operand" ""))))]

(define_expand "adddi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(plus:DI (match_operand:DI 1 "nonimmediate_operand" "")
		 (match_operand:DI 2 "x86_64_general_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (PLUS, DImode, operands); DONE;")

(define_insn "*adddi3_1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,o")
	(plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
		 (match_operand:DI 2 "general_operand" "roiF,riF")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && ix86_binary_operator_ok (PLUS, DImode, operands)"
  "#")

(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(plus:DI (match_operand:DI 1 "nonimmediate_operand" "")
		 (match_operand:DI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && reload_completed"
  [(parallel [(set (reg:CC 17) (unspec:CC [(match_dup 1) (match_dup 2)]
					  UNSPEC_ADD_CARRY))
	      (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 2)))])
   (parallel [(set (match_dup 3)
		   (plus:SI (plus:SI (ltu:SI (reg:CC 17) (const_int 0))
				     (match_dup 4))
			    (match_dup 5)))
	      (clobber (reg:CC 17))])]
  "split_di (operands+0, 1, operands+0, operands+3);
   split_di (operands+1, 1, operands+1, operands+4);
   split_di (operands+2, 1, operands+2, operands+5);")

(define_insn "adddi3_carry_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	  (plus:DI (plus:DI (match_operand:DI 3 "ix86_carry_flag_operator" "")
			    (match_operand:DI 1 "nonimmediate_operand" "%0,0"))
		   (match_operand:DI 2 "x86_64_general_operand" "re,rm")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (PLUS, DImode, operands)"
  "adc{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "mode" "DI")
   (set_attr "ppro_uops" "few")])

(define_insn "*adddi3_cc_rex64"
  [(set (reg:CC 17)
	(unspec:CC [(match_operand:DI 1 "nonimmediate_operand" "%0,0")
		    (match_operand:DI 2 "x86_64_general_operand" "re,rm")]
		   UNSPEC_ADD_CARRY))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_binary_operator_ok (PLUS, DImode, operands)"
  "add{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "addqi3_carry"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,q")
	  (plus:QI (plus:QI (match_operand:QI 3 "ix86_carry_flag_operator" "")
			    (match_operand:QI 1 "nonimmediate_operand" "%0,0"))
		   (match_operand:QI 2 "general_operand" "qi,qm")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (PLUS, QImode, operands)"
  "adc{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "mode" "QI")
   (set_attr "ppro_uops" "few")])

(define_insn "addhi3_carry"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,r")
	  (plus:HI (plus:HI (match_operand:HI 3 "ix86_carry_flag_operator" "")
			    (match_operand:HI 1 "nonimmediate_operand" "%0,0"))
		   (match_operand:HI 2 "general_operand" "ri,rm")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (PLUS, HImode, operands)"
  "adc{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "mode" "HI")
   (set_attr "ppro_uops" "few")])

(define_insn "addsi3_carry"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	  (plus:SI (plus:SI (match_operand:SI 3 "ix86_carry_flag_operator" "")
			    (match_operand:SI 1 "nonimmediate_operand" "%0,0"))
		   (match_operand:SI 2 "general_operand" "ri,rm")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (PLUS, SImode, operands)"
  "adc{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "mode" "SI")
   (set_attr "ppro_uops" "few")])

(define_insn "*addsi3_carry_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	  (zero_extend:DI 
	    (plus:SI (plus:SI (match_operand:SI 3 "ix86_carry_flag_operator" "")
			      (match_operand:SI 1 "nonimmediate_operand" "%0"))
		     (match_operand:SI 2 "general_operand" "rim"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (PLUS, SImode, operands)"
  "adc{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "mode" "SI")
   (set_attr "ppro_uops" "few")])

(define_insn "*addsi3_cc"
  [(set (reg:CC 17)
	(unspec:CC [(match_operand:SI 1 "nonimmediate_operand" "%0,0")
		    (match_operand:SI 2 "general_operand" "ri,rm")]
		   UNSPEC_ADD_CARRY))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "ix86_binary_operator_ok (PLUS, SImode, operands)"
  "add{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "addqi3_cc"
  [(set (reg:CC 17)
	(unspec:CC [(match_operand:QI 1 "nonimmediate_operand" "%0,0")
		    (match_operand:QI 2 "general_operand" "qi,qm")]
		   UNSPEC_ADD_CARRY))
   (set (match_operand:QI 0 "nonimmediate_operand" "=qm,q")
	(plus:QI (match_dup 1) (match_dup 2)))]
  "ix86_binary_operator_ok (PLUS, QImode, operands)"
  "add{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_expand "addsi3"
  [(parallel [(set (match_operand:SI 0 "nonimmediate_operand" "")
		   (plus:SI (match_operand:SI 1 "nonimmediate_operand" "")
			    (match_operand:SI 2 "general_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
  "ix86_expand_binary_operator (PLUS, SImode, operands); DONE;")

(define_insn "*lea_1"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "no_seg_address_operand" "p"))]
  "!TARGET_64BIT"
  "lea{l}\t{%a1, %0|%0, %a1}"
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn "*lea_1_rex64"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(subreg:SI (match_operand:DI 1 "no_seg_address_operand" "p") 0))]
  "TARGET_64BIT"
  "lea{l}\t{%a1, %0|%0, %a1}"
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn "*lea_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	 (subreg:SI (match_operand:DI 1 "no_seg_address_operand" "p") 0)))]
  "TARGET_64BIT"
  "lea{l}\t{%a1, %k0|%k0, %a1}"
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn "*lea_2_rex64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(match_operand:DI 1 "no_seg_address_operand" "p"))]
  "TARGET_64BIT"
  "lea{q}\t{%a1, %0|%0, %a1}"
  [(set_attr "type" "lea")
   (set_attr "mode" "DI")])

;; The lea patterns for non-Pmodes needs to be matched by several
;; insns converted to real lea by splitters.

(define_insn_and_split "*lea_general_1"
  [(set (match_operand 0 "register_operand" "=r")
	(plus (plus (match_operand 1 "index_register_operand" "r")
		    (match_operand 2 "register_operand" "r"))
	      (match_operand 3 "immediate_operand" "i")))]
  "(GET_MODE (operands[0]) == QImode || GET_MODE (operands[0]) == HImode
    || (TARGET_64BIT && GET_MODE (operands[0]) == SImode))
   && (!TARGET_PARTIAL_REG_STALL || optimize_size)
   && GET_MODE (operands[0]) == GET_MODE (operands[1])
   && GET_MODE (operands[0]) == GET_MODE (operands[2])
   && (GET_MODE (operands[0]) == GET_MODE (operands[3])
       || GET_MODE (operands[3]) == VOIDmode)"
  "#"
  "&& reload_completed"
  [(const_int 0)]
{
  rtx pat;
  operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[2] = gen_lowpart (Pmode, operands[2]);
  operands[3] = gen_lowpart (Pmode, operands[3]);
  pat = gen_rtx_PLUS (Pmode, gen_rtx_PLUS (Pmode, operands[1], operands[2]),
  		      operands[3]);
  if (Pmode != SImode)
    pat = gen_rtx_SUBREG (SImode, pat, 0);
  emit_insn (gen_rtx_SET (VOIDmode, operands[0], pat));
  DONE;
}
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn_and_split "*lea_general_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (plus:SI (plus:SI (match_operand:SI 1 "index_register_operand" "r")
			    (match_operand:SI 2 "register_operand" "r"))
		   (match_operand:SI 3 "immediate_operand" "i"))))]
  "TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (subreg:SI (plus:DI (plus:DI (match_dup 1)
						     (match_dup 2))
					    (match_dup 3)) 0)))]
{
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[2] = gen_lowpart (Pmode, operands[2]);
  operands[3] = gen_lowpart (Pmode, operands[3]);
}
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn_and_split "*lea_general_2"
  [(set (match_operand 0 "register_operand" "=r")
	(plus (mult (match_operand 1 "index_register_operand" "r")
		    (match_operand 2 "const248_operand" "i"))
	      (match_operand 3 "nonmemory_operand" "ri")))]
  "(GET_MODE (operands[0]) == QImode || GET_MODE (operands[0]) == HImode
    || (TARGET_64BIT && GET_MODE (operands[0]) == SImode))
   && (!TARGET_PARTIAL_REG_STALL || optimize_size)
   && GET_MODE (operands[0]) == GET_MODE (operands[1])
   && (GET_MODE (operands[0]) == GET_MODE (operands[3])
       || GET_MODE (operands[3]) == VOIDmode)"
  "#"
  "&& reload_completed"
  [(const_int 0)]
{
  rtx pat;
  operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[3] = gen_lowpart (Pmode, operands[3]);
  pat = gen_rtx_PLUS (Pmode, gen_rtx_MULT (Pmode, operands[1], operands[2]),
  		      operands[3]);
  if (Pmode != SImode)
    pat = gen_rtx_SUBREG (SImode, pat, 0);
  emit_insn (gen_rtx_SET (VOIDmode, operands[0], pat));
  DONE;
}
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn_and_split "*lea_general_2_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (plus:SI (mult:SI (match_operand:SI 1 "index_register_operand" "r")
			    (match_operand:SI 2 "const248_operand" "n"))
		   (match_operand:SI 3 "nonmemory_operand" "ri"))))]
  "TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (subreg:SI (plus:DI (mult:DI (match_dup 1)
						     (match_dup 2))
					    (match_dup 3)) 0)))]
{
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[3] = gen_lowpart (Pmode, operands[3]);
}
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn_and_split "*lea_general_3"
  [(set (match_operand 0 "register_operand" "=r")
	(plus (plus (mult (match_operand 1 "index_register_operand" "r")
			  (match_operand 2 "const248_operand" "i"))
		    (match_operand 3 "register_operand" "r"))
	      (match_operand 4 "immediate_operand" "i")))]
  "(GET_MODE (operands[0]) == QImode || GET_MODE (operands[0]) == HImode
    || (TARGET_64BIT && GET_MODE (operands[0]) == SImode))
   && (!TARGET_PARTIAL_REG_STALL || optimize_size)
   && GET_MODE (operands[0]) == GET_MODE (operands[1])
   && GET_MODE (operands[0]) == GET_MODE (operands[3])"
  "#"
  "&& reload_completed"
  [(const_int 0)]
{
  rtx pat;
  operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[3] = gen_lowpart (Pmode, operands[3]);
  operands[4] = gen_lowpart (Pmode, operands[4]);
  pat = gen_rtx_PLUS (Pmode,
  		      gen_rtx_PLUS (Pmode, gen_rtx_MULT (Pmode, operands[1],
		      					 operands[2]),
				    operands[3]),
  		      operands[4]);
  if (Pmode != SImode)
    pat = gen_rtx_SUBREG (SImode, pat, 0);
  emit_insn (gen_rtx_SET (VOIDmode, operands[0], pat));
  DONE;
}
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn_and_split "*lea_general_3_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (plus:SI (plus:SI (mult:SI (match_operand:SI 1 "index_register_operand" "r")
				     (match_operand:SI 2 "const248_operand" "n"))
			    (match_operand:SI 3 "register_operand" "r"))
		   (match_operand:SI 4 "immediate_operand" "i"))))]
  "TARGET_64BIT"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (subreg:SI (plus:DI (plus:DI (mult:DI (match_dup 1)
							      (match_dup 2))
						     (match_dup 3))
					    (match_dup 4)) 0)))]
{
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[3] = gen_lowpart (Pmode, operands[3]);
  operands[4] = gen_lowpart (Pmode, operands[4]);
}
  [(set_attr "type" "lea")
   (set_attr "mode" "SI")])

(define_insn "*adddi_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,rm,r")
	(plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,r")
		 (match_operand:DI 2 "x86_64_general_operand" "rme,re,re")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (PLUS, DImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_LEA:
      operands[2] = SET_SRC (XVECEXP (PATTERN (insn), 0, 0));
      return "lea{q}\t{%a2, %0|%0, %a2}";

    case TYPE_INCDEC:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (operands[2] == const1_rtx)
        return "inc{q}\t%0";
      else if (operands[2] == constm1_rtx)
        return "dec{q}\t%0";
      else
	abort ();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();

      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
	  /* Avoid overflows.  */
	  && ((INTVAL (operands[2]) & ((((unsigned int) 1) << 31) - 1)))
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{q}\t{%2, %0|%0, %2}";
        }
      return "add{q}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "2")
	      (const_string "lea")
	    ; Current assemblers are broken and do not allow @GOTOFF in
	    ; ought but a memory context.
	    (match_operand:DI 2 "pic_symbolic_operand" "")
	      (const_string "lea")
	    (match_operand:DI 2 "incdec_operand" "")
	      (const_string "incdec")
	   ]
	   (const_string "alu")))
   (set_attr "mode" "DI")])

;; Convert lea to the lea pattern to avoid flags dependency.
(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(plus:DI (match_operand:DI 1 "register_operand" "")
		 (match_operand:DI 2 "x86_64_nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && reload_completed
   && true_regnum (operands[0]) != true_regnum (operands[1])"
  [(set (match_dup 0)
	(plus:DI (match_dup 1)
		 (match_dup 2)))]
  "")

(define_insn "*adddi_2_rex64"
  [(set (reg 17)
	(compare
	  (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
		   (match_operand:DI 2 "x86_64_general_operand" "rme,re"))
	  (const_int 0)))			
   (set (match_operand:DI 0 "nonimmediate_operand" "=r,rm")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, DImode, operands)
   /* Current assemblers are broken and do not allow @GOTOFF in
      ought but a memory context.  */
   && ! pic_symbolic_operand (operands[2], VOIDmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (operands[2] == const1_rtx)
        return "inc{q}\t%0";
      else if (operands[2] == constm1_rtx)
        return "dec{q}\t%0";
      else
	abort ();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* ???? We ought to handle there the 32bit case too
	 - do we need new constraint?  */
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
	  /* Avoid overflows.  */
	  && ((INTVAL (operands[2]) & ((((unsigned int) 1) << 31) - 1)))
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{q}\t{%2, %0|%0, %2}";
        }
      return "add{q}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:DI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "DI")])

(define_insn "*adddi_3_rex64"
  [(set (reg 17)
	(compare (neg:DI (match_operand:DI 2 "x86_64_general_operand" "rme"))
		 (match_operand:DI 1 "x86_64_general_operand" "%0")))
   (clobber (match_scratch:DI 0 "=r"))]
  "TARGET_64BIT
   && ix86_match_ccmode (insn, CCZmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)
   /* Current assemblers are broken and do not allow @GOTOFF in
      ought but a memory context.  */
   && ! pic_symbolic_operand (operands[2], VOIDmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (operands[2] == const1_rtx)
        return "inc{q}\t%0";
      else if (operands[2] == constm1_rtx)
        return "dec{q}\t%0";
      else
	abort ();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* ???? We ought to handle there the 32bit case too
	 - do we need new constraint?  */
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
	  /* Avoid overflows.  */
	  && ((INTVAL (operands[2]) & ((((unsigned int) 1) << 31) - 1)))
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{q}\t{%2, %0|%0, %2}";
        }
      return "add{q}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:DI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "DI")])

; For comparisons against 1, -1 and 128, we may generate better code
; by converting cmp to add, inc or dec as done by peephole2.  This pattern
; is matched then.  We can't accept general immediate, because for
; case of overflows,  the result is messed up.
; This pattern also don't hold of 0x8000000000000000, since the value overflows
; when negated.
; Also carry flag is reversed compared to cmp, so this conversion is valid
; only for comparisons not depending on it.
(define_insn "*adddi_4_rex64"
  [(set (reg 17)
	(compare (match_operand:DI 1 "nonimmediate_operand" "0")
		 (match_operand:DI 2 "x86_64_immediate_operand" "e")))
   (clobber (match_scratch:DI 0 "=rm"))]
  "TARGET_64BIT
   &&  ix86_match_ccmode (insn, CCGCmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == constm1_rtx)
        return "inc{q}\t%0";
      else if (operands[2] == const1_rtx)
        return "dec{q}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if ((INTVAL (operands[2]) == -128
	   || (INTVAL (operands[2]) > 0
	       && INTVAL (operands[2]) != 128))
	  /* Avoid overflows.  */
	  && ((INTVAL (operands[2]) & ((((unsigned int) 1) << 31) - 1))))
	return "sub{q}\t{%2, %0|%0, %2}";
      operands[2] = GEN_INT (-INTVAL (operands[2]));
      return "add{q}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:DI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "DI")])

(define_insn "*adddi_5_rex64"
  [(set (reg 17)
	(compare
	  (plus:DI (match_operand:DI 1 "nonimmediate_operand" "%0")
		   (match_operand:DI 2 "x86_64_general_operand" "rme"))
	  (const_int 0)))			
   (clobber (match_scratch:DI 0 "=r"))]
  "TARGET_64BIT
   && ix86_match_ccmode (insn, CCGOCmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)
   /* Current assemblers are broken and do not allow @GOTOFF in
      ought but a memory context.  */
   && ! pic_symbolic_operand (operands[2], VOIDmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (operands[2] == const1_rtx)
        return "inc{q}\t%0";
      else if (operands[2] == constm1_rtx)
        return "dec{q}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
	  /* Avoid overflows.  */
	  && ((INTVAL (operands[2]) & ((((unsigned int) 1) << 31) - 1)))
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{q}\t{%2, %0|%0, %2}";
        }
      return "add{q}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:DI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "DI")])


(define_insn "*addsi_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,rm,r")
	(plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,r")
		 (match_operand:SI 2 "general_operand" "rmni,rni,rni")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (PLUS, SImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_LEA:
      operands[2] = SET_SRC (XVECEXP (PATTERN (insn), 0, 0));
      return "lea{l}\t{%a2, %0|%0, %a2}";

    case TYPE_INCDEC:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (operands[2] == const1_rtx)
        return "inc{l}\t%0";
      else if (operands[2] == constm1_rtx)
        return "dec{l}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();

      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{l}\t{%2, %0|%0, %2}";
        }
      return "add{l}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "2")
	      (const_string "lea")
	    ; Current assemblers are broken and do not allow @GOTOFF in
	    ; ought but a memory context.
	    (match_operand:SI 2 "pic_symbolic_operand" "")
	      (const_string "lea")
	    (match_operand:SI 2 "incdec_operand" "")
	      (const_string "incdec")
	   ]
	   (const_string "alu")))
   (set_attr "mode" "SI")])

;; Convert lea to the lea pattern to avoid flags dependency.
(define_split
  [(set (match_operand 0 "register_operand" "")
	(plus (match_operand 1 "register_operand" "")
              (match_operand 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && true_regnum (operands[0]) != true_regnum (operands[1])"
  [(const_int 0)]
{
  rtx pat;
  /* In -fPIC mode the constructs like (const (unspec [symbol_ref]))
     may confuse gen_lowpart.  */
  if (GET_MODE (operands[0]) != Pmode)
    {
      operands[1] = gen_lowpart (Pmode, operands[1]);
      operands[2] = gen_lowpart (Pmode, operands[2]);
    }
  operands[0] = gen_lowpart (SImode, operands[0]);
  pat = gen_rtx_PLUS (Pmode, operands[1], operands[2]);
  if (Pmode != SImode)
    pat = gen_rtx_SUBREG (SImode, pat, 0);
  emit_insn (gen_rtx_SET (VOIDmode, operands[0], pat));
  DONE;
})

;; It may seem that nonimmediate operand is proper one for operand 1.
;; The addsi_1 pattern allows nonimmediate operand at that place and
;; we take care in ix86_binary_operator_ok to not allow two memory
;; operands so proper swapping will be done in reload.  This allow
;; patterns constructed from addsi_1 to match.
(define_insn "addsi_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(zero_extend:DI
	  (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,r")
		   (match_operand:SI 2 "general_operand" "rmni,rni"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (PLUS, SImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_LEA:
      operands[2] = SET_SRC (XVECEXP (PATTERN (insn), 0, 0));
      return "lea{l}\t{%a2, %k0|%k0, %a2}";

    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
        return "inc{l}\t%k0";
      else if (operands[2] == constm1_rtx)
        return "dec{l}\t%k0";
      else
	abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{l}\t{%2, %k0|%k0, %2}";
        }
      return "add{l}\t{%2, %k0|%k0, %2}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "1")
	      (const_string "lea")
	    ; Current assemblers are broken and do not allow @GOTOFF in
	    ; ought but a memory context.
	    (match_operand:SI 2 "pic_symbolic_operand" "")
	      (const_string "lea")
	    (match_operand:SI 2 "incdec_operand" "")
	      (const_string "incdec")
	   ]
	   (const_string "alu")))
   (set_attr "mode" "SI")])

;; Convert lea to the lea pattern to avoid flags dependency.
(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(zero_extend:DI
	  (plus:SI (match_operand:SI 1 "register_operand" "")
		   (match_operand:SI 2 "nonmemory_operand" ""))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && reload_completed
   && true_regnum (operands[0]) != true_regnum (operands[1])"
  [(set (match_dup 0)
	(zero_extend:DI (subreg:SI (plus:DI (match_dup 1) (match_dup 2)) 0)))]
{
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[2] = gen_lowpart (Pmode, operands[2]);
})

(define_insn "*addsi_2"
  [(set (reg 17)
	(compare
	  (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
		   (match_operand:SI 2 "general_operand" "rmni,rni"))
	  (const_int 0)))			
   (set (match_operand:SI 0 "nonimmediate_operand" "=r,rm")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, SImode, operands)
   /* Current assemblers are broken and do not allow @GOTOFF in
      ought but a memory context.  */
   && ! pic_symbolic_operand (operands[2], VOIDmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (operands[2] == const1_rtx)
        return "inc{l}\t%0";
      else if (operands[2] == constm1_rtx)
        return "dec{l}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{l}\t{%2, %0|%0, %2}";
        }
      return "add{l}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:SI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "SI")])

;; See comment for addsi_1_zext why we do use nonimmediate_operand
(define_insn "*addsi_2_zext"
  [(set (reg 17)
	(compare
	  (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
		   (match_operand:SI 2 "general_operand" "rmni"))
	  (const_int 0)))			
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (plus:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, SImode, operands)
   /* Current assemblers are broken and do not allow @GOTOFF in
      ought but a memory context.  */
   && ! pic_symbolic_operand (operands[2], VOIDmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
        return "inc{l}\t%k0";
      else if (operands[2] == constm1_rtx)
        return "dec{l}\t%k0";
      else
	abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{l}\t{%2, %k0|%k0, %2}";
        }
      return "add{l}\t{%2, %k0|%k0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:SI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "SI")])

(define_insn "*addsi_3"
  [(set (reg 17)
	(compare (neg:SI (match_operand:SI 2 "general_operand" "rmni"))
		 (match_operand:SI 1 "nonimmediate_operand" "%0")))
   (clobber (match_scratch:SI 0 "=r"))]
  "ix86_match_ccmode (insn, CCZmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)
   /* Current assemblers are broken and do not allow @GOTOFF in
      ought but a memory context.  */
   && ! pic_symbolic_operand (operands[2], VOIDmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (operands[2] == const1_rtx)
        return "inc{l}\t%0";
      else if (operands[2] == constm1_rtx)
        return "dec{l}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{l}\t{%2, %0|%0, %2}";
        }
      return "add{l}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:SI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "SI")])

;; See comment for addsi_1_zext why we do use nonimmediate_operand
(define_insn "*addsi_3_zext"
  [(set (reg 17)
	(compare (neg:SI (match_operand:SI 2 "general_operand" "rmni"))
		 (match_operand:SI 1 "nonimmediate_operand" "%0")))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (plus:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCZmode)
   && ix86_binary_operator_ok (PLUS, SImode, operands)
   /* Current assemblers are broken and do not allow @GOTOFF in
      ought but a memory context.  */
   && ! pic_symbolic_operand (operands[2], VOIDmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
        return "inc{l}\t%k0";
      else if (operands[2] == constm1_rtx)
        return "dec{l}\t%k0";
      else
	abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{l}\t{%2, %k0|%k0, %2}";
        }
      return "add{l}\t{%2, %k0|%k0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:SI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "SI")])

; For comparisons against 1, -1 and 128, we may generate better code
; by converting cmp to add, inc or dec as done by peephole2.  This pattern
; is matched then.  We can't accept general immediate, because for
; case of overflows,  the result is messed up.
; This pattern also don't hold of 0x80000000, since the value overflows
; when negated.
; Also carry flag is reversed compared to cmp, so this conversion is valid
; only for comparisons not depending on it.
(define_insn "*addsi_4"
  [(set (reg 17)
	(compare (match_operand:SI 1 "nonimmediate_operand" "0")
		 (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (match_scratch:SI 0 "=rm"))]
  "ix86_match_ccmode (insn, CCGCmode)
   && (INTVAL (operands[2]) & 0xffffffff) != 0x80000000"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == constm1_rtx)
        return "inc{l}\t%0";
      else if (operands[2] == const1_rtx)
        return "dec{l}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if ((INTVAL (operands[2]) == -128
	   || (INTVAL (operands[2]) > 0
	       && INTVAL (operands[2]) != 128)))
	return "sub{l}\t{%2, %0|%0, %2}";
      operands[2] = GEN_INT (-INTVAL (operands[2]));
      return "add{l}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:SI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "SI")])

(define_insn "*addsi_5"
  [(set (reg 17)
	(compare
	  (plus:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
		   (match_operand:SI 2 "general_operand" "rmni"))
	  (const_int 0)))			
   (clobber (match_scratch:SI 0 "=r"))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)
   /* Current assemblers are broken and do not allow @GOTOFF in
      ought but a memory context.  */
   && ! pic_symbolic_operand (operands[2], VOIDmode)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (operands[2] == const1_rtx)
        return "inc{l}\t%0";
      else if (operands[2] == constm1_rtx)
        return "dec{l}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "sub{l}\t{%2, %0|%0, %2}";
        }
      return "add{l}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:SI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "SI")])

(define_expand "addhi3"
  [(parallel [(set (match_operand:HI 0 "nonimmediate_operand" "")
		   (plus:HI (match_operand:HI 1 "nonimmediate_operand" "")
			    (match_operand:HI 2 "general_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (PLUS, HImode, operands); DONE;")

;; %%% After Dave's SUBREG_BYTE stuff goes in, re-enable incb %ah
;; type optimizations enabled by define-splits.  This is not important
;; for PII, and in fact harmful because of partial register stalls.

(define_insn "*addhi_1_lea"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,r,r")
	(plus:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0,r")
		 (match_operand:HI 2 "general_operand" "ri,rm,rni")))
   (clobber (reg:CC 17))]
  "!TARGET_PARTIAL_REG_STALL
   && ix86_binary_operator_ok (PLUS, HImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_LEA:
      return "#";
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{w}\t%0";
      else if (operands[2] == constm1_rtx)
	return "dec{w}\t%0";
      abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{w}\t{%2, %0|%0, %2}";
	}
      return "add{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (eq_attr "alternative" "2")
	(const_string "lea")
	(if_then_else (match_operand:HI 2 "incdec_operand" "")
	   (const_string "incdec")
	   (const_string "alu"))))
   (set_attr "mode" "HI,HI,SI")])

(define_insn "*addhi_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,r")
	(plus:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0")
		 (match_operand:HI 2 "general_operand" "ri,rm")))
   (clobber (reg:CC 17))]
  "TARGET_PARTIAL_REG_STALL
   && ix86_binary_operator_ok (PLUS, HImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{w}\t%0";
      else if (operands[2] == constm1_rtx)
	return "dec{w}\t%0";
      abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{w}\t{%2, %0|%0, %2}";
	}
      return "add{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:HI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "HI")])

(define_insn "*addhi_2"
  [(set (reg 17)
	(compare
	  (plus:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0")
		   (match_operand:HI 2 "general_operand" "rmni,rni"))
	  (const_int 0)))			
   (set (match_operand:HI 0 "nonimmediate_operand" "=r,rm")
	(plus:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, HImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{w}\t%0";
      else if (operands[2] == constm1_rtx)
	return "dec{w}\t%0";
      abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{w}\t{%2, %0|%0, %2}";
	}
      return "add{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:HI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "HI")])

(define_insn "*addhi_3"
  [(set (reg 17)
	(compare (neg:HI (match_operand:HI 2 "general_operand" "rmni"))
		 (match_operand:HI 1 "nonimmediate_operand" "%0")))
   (clobber (match_scratch:HI 0 "=r"))]
  "ix86_match_ccmode (insn, CCZmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{w}\t%0";
      else if (operands[2] == constm1_rtx)
	return "dec{w}\t%0";
      abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{w}\t{%2, %0|%0, %2}";
	}
      return "add{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:HI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "HI")])

; See comments above addsi_3_imm for details.
(define_insn "*addhi_4"
  [(set (reg 17)
	(compare (match_operand:HI 1 "nonimmediate_operand" "0")
		 (match_operand:HI 2 "const_int_operand" "n")))
   (clobber (match_scratch:HI 0 "=rm"))]
  "ix86_match_ccmode (insn, CCGCmode)
   && (INTVAL (operands[2]) & 0xffff) != 0x8000"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == constm1_rtx)
        return "inc{w}\t%0";
      else if (operands[2] == const1_rtx)
        return "dec{w}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if ((INTVAL (operands[2]) == -128
	   || (INTVAL (operands[2]) > 0
	       && INTVAL (operands[2]) != 128)))
	return "sub{w}\t{%2, %0|%0, %2}";
      operands[2] = GEN_INT (-INTVAL (operands[2]));
      return "add{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:HI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "SI")])


(define_insn "*addhi_5"
  [(set (reg 17)
	(compare
	  (plus:HI (match_operand:HI 1 "nonimmediate_operand" "%0")
		   (match_operand:HI 2 "general_operand" "rmni"))
	  (const_int 0)))			
   (clobber (match_scratch:HI 0 "=r"))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{w}\t%0";
      else if (operands[2] == constm1_rtx)
	return "dec{w}\t%0";
      abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{w}\t{%2, %0|%0, %2}";
	}
      return "add{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:HI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "HI")])

(define_expand "addqi3"
  [(parallel [(set (match_operand:QI 0 "nonimmediate_operand" "")
		   (plus:QI (match_operand:QI 1 "nonimmediate_operand" "")
			    (match_operand:QI 2 "general_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (PLUS, QImode, operands); DONE;")

;; %%% Potential partial reg stall on alternative 2.  What to do?
(define_insn "*addqi_1_lea"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,q,r,r")
	(plus:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0,r")
		 (match_operand:QI 2 "general_operand" "qn,qmn,rn,rn")))
   (clobber (reg:CC 17))]
  "!TARGET_PARTIAL_REG_STALL
   && ix86_binary_operator_ok (PLUS, QImode, operands)"
{
  int widen = (which_alternative == 2);
  switch (get_attr_type (insn))
    {
    case TYPE_LEA:
      return "#";
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return widen ? "inc{l}\t%k0" : "inc{b}\t%0";
      else if (operands[2] == constm1_rtx)
	return widen ? "dec{l}\t%k0" : "dec{b}\t%0";
      abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  if (widen)
	    return "sub{l}\t{%2, %k0|%k0, %2}";
	  else
	    return "sub{b}\t{%2, %0|%0, %2}";
	}
      if (widen)
        return "add{l}\t{%k2, %k0|%k0, %k2}";
      else
        return "add{b}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (eq_attr "alternative" "3")
	(const_string "lea")
	(if_then_else (match_operand:QI 2 "incdec_operand" "")
	   (const_string "incdec")
	   (const_string "alu"))))
   (set_attr "mode" "QI,QI,SI,SI")])

(define_insn "*addqi_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,q,r")
	(plus:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		 (match_operand:QI 2 "general_operand" "qn,qmn,rn")))
   (clobber (reg:CC 17))]
  "TARGET_PARTIAL_REG_STALL
   && ix86_binary_operator_ok (PLUS, QImode, operands)"
{
  int widen = (which_alternative == 2);
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return widen ? "inc{l}\t%k0" : "inc{b}\t%0";
      else if (operands[2] == constm1_rtx)
	return widen ? "dec{l}\t%k0" : "dec{b}\t%0";
      abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.
	 Exceptions: -128 encodes smaller than 128, so swap sign and op.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
		  && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  if (widen)
	    return "sub{l}\t{%2, %k0|%k0, %2}";
	  else
	    return "sub{b}\t{%2, %0|%0, %2}";
	}
      if (widen)
        return "add{l}\t{%k2, %k0|%k0, %k2}";
      else
        return "add{b}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:QI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "QI,QI,SI")])

(define_insn "*addqi_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,q"))
	(plus:QI (match_dup 0)
		 (match_operand:QI 1 "general_operand" "qn,qnm")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[1] == const1_rtx)
	return "inc{b}\t%0";
      else if (operands[1] == constm1_rtx)
	return "dec{b}\t%0";
      abort();

    default:
      /* Make things pretty and `subl $4,%eax' rather than `addl $-4, %eax'.  */
      if (GET_CODE (operands[1]) == CONST_INT
	  && INTVAL (operands[1]) < 0)
	{
	  operands[1] = GEN_INT (-INTVAL (operands[1]));
	  return "sub{b}\t{%1, %0|%0, %1}";
	}
      return "add{b}\t{%1, %0|%0, %1}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:QI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu1")))
   (set_attr "mode" "QI")])

(define_insn "*addqi_2"
  [(set (reg 17)
	(compare
	  (plus:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0")
		   (match_operand:QI 2 "general_operand" "qmni,qni"))
	  (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=q,qm")
	(plus:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (PLUS, QImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{b}\t%0";
      else if (operands[2] == constm1_rtx
	       || (GET_CODE (operands[2]) == CONST_INT
		   && INTVAL (operands[2]) == 255))
	return "dec{b}\t%0";
      abort();

    default:
      /* Make things pretty and `subb $4,%al' rather than `addb $-4, %al'.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && INTVAL (operands[2]) < 0)
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{b}\t{%2, %0|%0, %2}";
	}
      return "add{b}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:QI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "QI")])

(define_insn "*addqi_3"
  [(set (reg 17)
	(compare (neg:QI (match_operand:QI 2 "general_operand" "qmni"))
		 (match_operand:QI 1 "nonimmediate_operand" "%0")))
   (clobber (match_scratch:QI 0 "=q"))]
  "ix86_match_ccmode (insn, CCZmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{b}\t%0";
      else if (operands[2] == constm1_rtx
	       || (GET_CODE (operands[2]) == CONST_INT
		   && INTVAL (operands[2]) == 255))
	return "dec{b}\t%0";
      abort();

    default:
      /* Make things pretty and `subb $4,%al' rather than `addb $-4, %al'.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && INTVAL (operands[2]) < 0)
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{b}\t{%2, %0|%0, %2}";
	}
      return "add{b}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:QI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "QI")])

; See comments above addsi_3_imm for details.
(define_insn "*addqi_4"
  [(set (reg 17)
	(compare (match_operand:QI 1 "nonimmediate_operand" "0")
		 (match_operand:QI 2 "const_int_operand" "n")))
   (clobber (match_scratch:QI 0 "=qm"))]
  "ix86_match_ccmode (insn, CCGCmode)
   && (INTVAL (operands[2]) & 0xff) != 0x80"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == constm1_rtx
	  || (GET_CODE (operands[2]) == CONST_INT
	      && INTVAL (operands[2]) == 255))
        return "inc{b}\t%0";
      else if (operands[2] == const1_rtx)
        return "dec{b}\t%0";
      else
	abort();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (INTVAL (operands[2]) < 0)
        {
          operands[2] = GEN_INT (-INTVAL (operands[2]));
          return "add{b}\t{%2, %0|%0, %2}";
        }
      return "sub{b}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:HI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "QI")])


(define_insn "*addqi_5"
  [(set (reg 17)
	(compare
	  (plus:QI (match_operand:QI 1 "nonimmediate_operand" "%0")
		   (match_operand:QI 2 "general_operand" "qmni"))
	  (const_int 0)))
   (clobber (match_scratch:QI 0 "=q"))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{b}\t%0";
      else if (operands[2] == constm1_rtx
	       || (GET_CODE (operands[2]) == CONST_INT
		   && INTVAL (operands[2]) == 255))
	return "dec{b}\t%0";
      abort();

    default:
      /* Make things pretty and `subb $4,%al' rather than `addb $-4, %al'.  */
      if (GET_CODE (operands[2]) == CONST_INT
          && INTVAL (operands[2]) < 0)
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{b}\t{%2, %0|%0, %2}";
	}
      return "add{b}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:QI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "QI")])


(define_insn "addqi_ext_1"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(plus:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (match_operand:QI 2 "general_operand" "Qmn")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{b}\t%h0";
      else if (operands[2] == constm1_rtx
	       || (GET_CODE (operands[2]) == CONST_INT
		   && INTVAL (operands[2]) == 255))
	return "dec{b}\t%h0";
      abort();

    default:
      return "add{b}\t{%2, %h0|%h0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:QI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "QI")])

(define_insn "*addqi_ext_1_rex64"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(plus:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (match_operand:QI 2 "nonmemory_operand" "Qn")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_INCDEC:
      if (operands[2] == const1_rtx)
	return "inc{b}\t%h0";
      else if (operands[2] == constm1_rtx
	       || (GET_CODE (operands[2]) == CONST_INT
		   && INTVAL (operands[2]) == 255))
	return "dec{b}\t%h0";
      abort();

    default:
      return "add{b}\t{%2, %h0|%h0, %2}";
    }
}
  [(set (attr "type")
     (if_then_else (match_operand:QI 2 "incdec_operand" "")
	(const_string "incdec")
	(const_string "alu")))
   (set_attr "mode" "QI")])

(define_insn "*addqi_ext_2"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(plus:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "%0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extract:SI
	    (match_operand 2 "ext_register_operand" "Q")
	    (const_int 8)
	    (const_int 8))))
   (clobber (reg:CC 17))]
  ""
  "add{b}\t{%h2, %h0|%h0, %h2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

;; The patterns that match these are at the end of this file.

(define_expand "addxf3"
  [(set (match_operand:XF 0 "register_operand" "")
	(plus:XF (match_operand:XF 1 "register_operand" "")
		 (match_operand:XF 2 "register_operand" "")))]
  "TARGET_80387"
  "")

(define_expand "adddf3"
  [(set (match_operand:DF 0 "register_operand" "")
	(plus:DF (match_operand:DF 1 "register_operand" "")
		 (match_operand:DF 2 "nonimmediate_operand" "")))]
  "TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)"
  "")

(define_expand "addsf3"
  [(set (match_operand:SF 0 "register_operand" "")
	(plus:SF (match_operand:SF 1 "register_operand" "")
		 (match_operand:SF 2 "nonimmediate_operand" "")))]
  "TARGET_80387 || TARGET_SSE_MATH"
  "")

;; Subtract instructions

;; %%% splits for subsidi3

(define_expand "subdi3"
  [(parallel [(set (match_operand:DI 0 "nonimmediate_operand" "")
		   (minus:DI (match_operand:DI 1 "nonimmediate_operand" "")
			     (match_operand:DI 2 "x86_64_general_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
  "ix86_expand_binary_operator (MINUS, DImode, operands); DONE;")

(define_insn "*subdi3_1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,o")
	(minus:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
		  (match_operand:DI 2 "general_operand" "roiF,riF")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && ix86_binary_operator_ok (MINUS, DImode, operands)"
  "#")

(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(minus:DI (match_operand:DI 1 "nonimmediate_operand" "")
		  (match_operand:DI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && reload_completed"
  [(parallel [(set (reg:CC 17) (compare:CC (match_dup 1) (match_dup 2)))
	      (set (match_dup 0) (minus:SI (match_dup 1) (match_dup 2)))])
   (parallel [(set (match_dup 3)
		   (minus:SI (match_dup 4)
			     (plus:SI (ltu:SI (reg:CC 17) (const_int 0))
				      (match_dup 5))))
	      (clobber (reg:CC 17))])]
  "split_di (operands+0, 1, operands+0, operands+3);
   split_di (operands+1, 1, operands+1, operands+4);
   split_di (operands+2, 1, operands+2, operands+5);")

(define_insn "subdi3_carry_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	  (minus:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
	    (plus:DI (match_operand:DI 3 "ix86_carry_flag_operator" "")
	       (match_operand:DI 2 "x86_64_general_operand" "re,rm"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (MINUS, DImode, operands)"
  "sbb{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "ppro_uops" "few")
   (set_attr "mode" "DI")])

(define_insn "*subdi_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	(minus:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
		  (match_operand:DI 2 "x86_64_general_operand" "re,rm")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (MINUS, DImode, operands)"
  "sub{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "*subdi_2_rex64"
  [(set (reg 17)
	(compare
	  (minus:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
		    (match_operand:DI 2 "x86_64_general_operand" "re,rm"))
	  (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	(minus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (MINUS, DImode, operands)"
  "sub{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "*subdi_3_rex63"
  [(set (reg 17)
	(compare (match_operand:DI 1 "nonimmediate_operand" "0,0")
		 (match_operand:DI 2 "x86_64_general_operand" "re,rm")))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	(minus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sub{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "subqi3_carry"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,q")
	  (minus:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")
	    (plus:QI (match_operand:QI 3 "ix86_carry_flag_operator" "")
	       (match_operand:QI 2 "general_operand" "qi,qm"))))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (MINUS, QImode, operands)"
  "sbb{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "ppro_uops" "few")
   (set_attr "mode" "QI")])

(define_insn "subhi3_carry"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,r")
	  (minus:HI (match_operand:HI 1 "nonimmediate_operand" "0,0")
	    (plus:HI (match_operand:HI 3 "ix86_carry_flag_operator" "")
	       (match_operand:HI 2 "general_operand" "ri,rm"))))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (MINUS, HImode, operands)"
  "sbb{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "ppro_uops" "few")
   (set_attr "mode" "HI")])

(define_insn "subsi3_carry"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	  (minus:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
	    (plus:SI (match_operand:SI 3 "ix86_carry_flag_operator" "")
	       (match_operand:SI 2 "general_operand" "ri,rm"))))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sbb{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "ppro_uops" "few")
   (set_attr "mode" "SI")])

(define_insn "subsi3_carry_zext"
  [(set (match_operand:DI 0 "register_operand" "=rm,r")
	  (zero_extend:DI
	    (minus:SI (match_operand:SI 1 "register_operand" "0,0")
	      (plus:SI (match_operand:SI 3 "ix86_carry_flag_operator" "")
		 (match_operand:SI 2 "general_operand" "ri,rm")))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sbb{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "ppro_uops" "few")
   (set_attr "mode" "SI")])

(define_expand "subsi3"
  [(parallel [(set (match_operand:SI 0 "nonimmediate_operand" "")
		   (minus:SI (match_operand:SI 1 "nonimmediate_operand" "")
			     (match_operand:SI 2 "general_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
  "ix86_expand_binary_operator (MINUS, SImode, operands); DONE;")

(define_insn "*subsi_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	(minus:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
		  (match_operand:SI 2 "general_operand" "ri,rm")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sub{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*subsi_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (minus:SI (match_operand:SI 1 "register_operand" "0")
		    (match_operand:SI 2 "general_operand" "rim"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sub{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*subsi_2"
  [(set (reg 17)
	(compare
	  (minus:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
		    (match_operand:SI 2 "general_operand" "ri,rm"))
	  (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	(minus:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sub{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*subsi_2_zext"
  [(set (reg 17)
	(compare
	  (minus:SI (match_operand:SI 1 "register_operand" "0")
		    (match_operand:SI 2 "general_operand" "rim"))
	  (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (minus:SI (match_dup 1)
		    (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sub{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*subsi_3"
  [(set (reg 17)
	(compare (match_operand:SI 1 "nonimmediate_operand" "0,0")
		 (match_operand:SI 2 "general_operand" "ri,rm")))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	(minus:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sub{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*subsi_3_zext"
  [(set (reg 17)
	(compare (match_operand:SI 1 "register_operand" "0")
		 (match_operand:SI 2 "general_operand" "rim")))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (minus:SI (match_dup 1)
		    (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, SImode, operands)"
  "sub{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_expand "subhi3"
  [(parallel [(set (match_operand:HI 0 "nonimmediate_operand" "")
		   (minus:HI (match_operand:HI 1 "nonimmediate_operand" "")
			     (match_operand:HI 2 "general_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (MINUS, HImode, operands); DONE;")

(define_insn "*subhi_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,r")
	(minus:HI (match_operand:HI 1 "nonimmediate_operand" "0,0")
		  (match_operand:HI 2 "general_operand" "ri,rm")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (MINUS, HImode, operands)"
  "sub{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_insn "*subhi_2"
  [(set (reg 17)
	(compare
	  (minus:HI (match_operand:HI 1 "nonimmediate_operand" "0,0")
		    (match_operand:HI 2 "general_operand" "ri,rm"))
	  (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm,r")
	(minus:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (MINUS, HImode, operands)"
  "sub{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_insn "*subhi_3"
  [(set (reg 17)
	(compare (match_operand:HI 1 "nonimmediate_operand" "0,0")
		 (match_operand:HI 2 "general_operand" "ri,rm")))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm,r")
	(minus:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, HImode, operands)"
  "sub{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_expand "subqi3"
  [(parallel [(set (match_operand:QI 0 "nonimmediate_operand" "")
		   (minus:QI (match_operand:QI 1 "nonimmediate_operand" "")
			     (match_operand:QI 2 "general_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (MINUS, QImode, operands); DONE;")

(define_insn "*subqi_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,q")
	(minus:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")
		  (match_operand:QI 2 "general_operand" "qn,qmn")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (MINUS, QImode, operands)"
  "sub{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_insn "*subqi_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,q"))
	(minus:QI (match_dup 0)
		  (match_operand:QI 1 "general_operand" "qn,qmn")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "sub{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_insn "*subqi_2"
  [(set (reg 17)
	(compare
	  (minus:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")
		    (match_operand:QI 2 "general_operand" "qi,qm"))
	  (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=qm,q")
	(minus:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (MINUS, QImode, operands)"
  "sub{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_insn "*subqi_3"
  [(set (reg 17)
	(compare (match_operand:QI 1 "nonimmediate_operand" "0,0")
		 (match_operand:QI 2 "general_operand" "qi,qm")))
   (set (match_operand:HI 0 "nonimmediate_operand" "=qm,q")
	(minus:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, QImode, operands)"
  "sub{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

;; The patterns that match these are at the end of this file.

(define_expand "subxf3"
  [(set (match_operand:XF 0 "register_operand" "")
	(minus:XF (match_operand:XF 1 "register_operand" "")
		  (match_operand:XF 2 "register_operand" "")))]
  "TARGET_80387"
  "")

(define_expand "subdf3"
  [(set (match_operand:DF 0 "register_operand" "")
	(minus:DF (match_operand:DF 1 "register_operand" "")
		  (match_operand:DF 2 "nonimmediate_operand" "")))]
  "TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)"
  "")

(define_expand "subsf3"
  [(set (match_operand:SF 0 "register_operand" "")
	(minus:SF (match_operand:SF 1 "register_operand" "")
		  (match_operand:SF 2 "nonimmediate_operand" "")))]
  "TARGET_80387 || TARGET_SSE_MATH"
  "")

;; Multiply instructions

(define_expand "muldi3"
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (mult:DI (match_operand:DI 1 "register_operand" "")
			    (match_operand:DI 2 "x86_64_general_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_64BIT"
  "")

(define_insn "*muldi3_1_rex64"
  [(set (match_operand:DI 0 "register_operand" "=r,r,r")
	(mult:DI (match_operand:DI 1 "nonimmediate_operand" "%rm,rm,0")
		 (match_operand:DI 2 "x86_64_general_operand" "K,e,mr")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "@
   imul{q}\t{%2, %1, %0|%0, %1, %2}
   imul{q}\t{%2, %1, %0|%0, %1, %2}
   imul{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "imul")
   (set_attr "prefix_0f" "0,0,1")
   (set (attr "athlon_decode")
	(cond [(eq_attr "cpu" "athlon")
		  (const_string "vector")
	       (eq_attr "alternative" "1")
		  (const_string "vector")
	       (and (eq_attr "alternative" "2")
		    (match_operand 1 "memory_operand" ""))
		  (const_string "vector")]
	      (const_string "direct")))
   (set_attr "mode" "DI")])

(define_expand "mulsi3"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (mult:SI (match_operand:SI 1 "register_operand" "")
			    (match_operand:SI 2 "general_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
  "")

(define_insn "*mulsi3_1"
  [(set (match_operand:SI 0 "register_operand" "=r,r,r")
	(mult:SI (match_operand:SI 1 "nonimmediate_operand" "%rm,rm,0")
		 (match_operand:SI 2 "general_operand" "K,i,mr")))
   (clobber (reg:CC 17))]
  "GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM"
  "@
   imul{l}\t{%2, %1, %0|%0, %1, %2}
   imul{l}\t{%2, %1, %0|%0, %1, %2}
   imul{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "imul")
   (set_attr "prefix_0f" "0,0,1")
   (set (attr "athlon_decode")
	(cond [(eq_attr "cpu" "athlon")
		  (const_string "vector")
	       (eq_attr "alternative" "1")
		  (const_string "vector")
	       (and (eq_attr "alternative" "2")
		    (match_operand 1 "memory_operand" ""))
		  (const_string "vector")]
	      (const_string "direct")))
   (set_attr "mode" "SI")])

(define_insn "*mulsi3_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r,r,r")
	(zero_extend:DI
	  (mult:SI (match_operand:SI 1 "nonimmediate_operand" "%rm,rm,0")
		   (match_operand:SI 2 "general_operand" "K,i,mr"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "@
   imul{l}\t{%2, %1, %k0|%k0, %1, %2}
   imul{l}\t{%2, %1, %k0|%k0, %1, %2}
   imul{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "imul")
   (set_attr "prefix_0f" "0,0,1")
   (set (attr "athlon_decode")
	(cond [(eq_attr "cpu" "athlon")
		  (const_string "vector")
	       (eq_attr "alternative" "1")
		  (const_string "vector")
	       (and (eq_attr "alternative" "2")
		    (match_operand 1 "memory_operand" ""))
		  (const_string "vector")]
	      (const_string "direct")))
   (set_attr "mode" "SI")])

(define_expand "mulhi3"
  [(parallel [(set (match_operand:HI 0 "register_operand" "")
		   (mult:HI (match_operand:HI 1 "register_operand" "")
			    (match_operand:HI 2 "general_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_HIMODE_MATH"
  "")

(define_insn "*mulhi3_1"
  [(set (match_operand:HI 0 "register_operand" "=r,r,r")
	(mult:HI (match_operand:HI 1 "nonimmediate_operand" "%rm,rm,0")
		 (match_operand:HI 2 "general_operand" "K,i,mr")))
   (clobber (reg:CC 17))]
  "GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM"
  "@
   imul{w}\t{%2, %1, %0|%0, %1, %2}
   imul{w}\t{%2, %1, %0|%0, %1, %2}
   imul{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "imul")
   (set_attr "prefix_0f" "0,0,1")
   (set (attr "athlon_decode")
	(cond [(eq_attr "cpu" "athlon")
		  (const_string "vector")
	       (eq_attr "alternative" "1,2")
		  (const_string "vector")]
	      (const_string "direct")))
   (set_attr "mode" "HI")])

(define_expand "mulqi3"
  [(parallel [(set (match_operand:QI 0 "register_operand" "")
		   (mult:QI (match_operand:QI 1 "nonimmediate_operand" "")
			    (match_operand:QI 2 "register_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_QIMODE_MATH"
  "")

(define_insn "*mulqi3_1"
  [(set (match_operand:QI 0 "register_operand" "=a")
	(mult:QI (match_operand:QI 1 "nonimmediate_operand" "%0")
		 (match_operand:QI 2 "nonimmediate_operand" "qm")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "mul{b}\t%2"
  [(set_attr "type" "imul")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "direct")))
   (set_attr "mode" "QI")])

(define_expand "umulqihi3"
  [(parallel [(set (match_operand:HI 0 "register_operand" "")
		   (mult:HI (zero_extend:HI
			      (match_operand:QI 1 "nonimmediate_operand" ""))
			    (zero_extend:HI
			      (match_operand:QI 2 "register_operand" ""))))
	      (clobber (reg:CC 17))])]
  "TARGET_QIMODE_MATH"
  "")

(define_insn "*umulqihi3_1"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(mult:HI (zero_extend:HI (match_operand:QI 1 "nonimmediate_operand" "%0"))
		 (zero_extend:HI (match_operand:QI 2 "nonimmediate_operand" "qm"))))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "mul{b}\t%2"
  [(set_attr "type" "imul")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "direct")))
   (set_attr "mode" "QI")])

(define_expand "mulqihi3"
  [(parallel [(set (match_operand:HI 0 "register_operand" "")
		   (mult:HI (sign_extend:HI (match_operand:QI 1 "nonimmediate_operand" ""))
			    (sign_extend:HI (match_operand:QI 2 "register_operand" ""))))
	      (clobber (reg:CC 17))])]
  "TARGET_QIMODE_MATH"
  "")

(define_insn "*mulqihi3_insn"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(mult:HI (sign_extend:HI (match_operand:QI 1 "nonimmediate_operand" "%0"))
		 (sign_extend:HI (match_operand:QI 2 "nonimmediate_operand" "qm"))))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "imul{b}\t%2"
  [(set_attr "type" "imul")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "direct")))
   (set_attr "mode" "QI")])

(define_expand "umulditi3"
  [(parallel [(set (match_operand:TI 0 "register_operand" "")
		   (mult:TI (zero_extend:TI
			      (match_operand:DI 1 "nonimmediate_operand" ""))
			    (zero_extend:TI
			      (match_operand:DI 2 "register_operand" ""))))
	      (clobber (reg:CC 17))])]
  "TARGET_64BIT"
  "")

(define_insn "*umulditi3_insn"
  [(set (match_operand:TI 0 "register_operand" "=A")
	(mult:TI (zero_extend:TI (match_operand:DI 1 "nonimmediate_operand" "%0"))
		 (zero_extend:TI (match_operand:DI 2 "nonimmediate_operand" "rm"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "mul{q}\t%2"
  [(set_attr "type" "imul")
   (set_attr "ppro_uops" "few")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "DI")])

;; We can't use this pattern in 64bit mode, since it results in two separate 32bit registers
(define_expand "umulsidi3"
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (mult:DI (zero_extend:DI
			      (match_operand:SI 1 "nonimmediate_operand" ""))
			    (zero_extend:DI
			      (match_operand:SI 2 "register_operand" ""))))
	      (clobber (reg:CC 17))])]
  "!TARGET_64BIT"
  "")

(define_insn "*umulsidi3_insn"
  [(set (match_operand:DI 0 "register_operand" "=A")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "nonimmediate_operand" "%0"))
		 (zero_extend:DI (match_operand:SI 2 "nonimmediate_operand" "rm"))))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "mul{l}\t%2"
  [(set_attr "type" "imul")
   (set_attr "ppro_uops" "few")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "SI")])

(define_expand "mulditi3"
  [(parallel [(set (match_operand:TI 0 "register_operand" "")
		   (mult:TI (sign_extend:TI
			      (match_operand:DI 1 "nonimmediate_operand" ""))
			    (sign_extend:TI
			      (match_operand:DI 2 "register_operand" ""))))
	      (clobber (reg:CC 17))])]
  "TARGET_64BIT"
  "")

(define_insn "*mulditi3_insn"
  [(set (match_operand:TI 0 "register_operand" "=A")
	(mult:TI (sign_extend:TI (match_operand:DI 1 "nonimmediate_operand" "%0"))
		 (sign_extend:TI (match_operand:DI 2 "nonimmediate_operand" "rm"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "imul{q}\t%2"
  [(set_attr "type" "imul")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "DI")])

(define_expand "mulsidi3"
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (mult:DI (sign_extend:DI
			      (match_operand:SI 1 "nonimmediate_operand" ""))
			    (sign_extend:DI
			      (match_operand:SI 2 "register_operand" ""))))
	      (clobber (reg:CC 17))])]
  "!TARGET_64BIT"
  "")

(define_insn "*mulsidi3_insn"
  [(set (match_operand:DI 0 "register_operand" "=A")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "nonimmediate_operand" "%0"))
		 (sign_extend:DI (match_operand:SI 2 "nonimmediate_operand" "rm"))))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "imul{l}\t%2"
  [(set_attr "type" "imul")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "SI")])

(define_expand "umuldi3_highpart"
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (truncate:DI
		     (lshiftrt:TI
		       (mult:TI (zero_extend:TI
				  (match_operand:DI 1 "nonimmediate_operand" ""))
				(zero_extend:TI
				  (match_operand:DI 2 "register_operand" "")))
		       (const_int 64))))
	      (clobber (match_scratch:DI 3 ""))
	      (clobber (reg:CC 17))])]
  "TARGET_64BIT"
  "")

(define_insn "*umuldi3_highpart_rex64"
  [(set (match_operand:DI 0 "register_operand" "=d")
	(truncate:DI
	  (lshiftrt:TI
	    (mult:TI (zero_extend:TI
		       (match_operand:DI 1 "nonimmediate_operand" "%a"))
		     (zero_extend:TI
		       (match_operand:DI 2 "nonimmediate_operand" "rm")))
	    (const_int 64))))
   (clobber (match_scratch:DI 3 "=1"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "mul{q}\t%2"
  [(set_attr "type" "imul")
   (set_attr "ppro_uops" "few")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "DI")])

(define_expand "umulsi3_highpart"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (truncate:SI
		     (lshiftrt:DI
		       (mult:DI (zero_extend:DI
				  (match_operand:SI 1 "nonimmediate_operand" ""))
				(zero_extend:DI
				  (match_operand:SI 2 "register_operand" "")))
		       (const_int 32))))
	      (clobber (match_scratch:SI 3 ""))
	      (clobber (reg:CC 17))])]
  ""
  "")

(define_insn "*umulsi3_highpart_insn"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(truncate:SI
	  (lshiftrt:DI
	    (mult:DI (zero_extend:DI
		       (match_operand:SI 1 "nonimmediate_operand" "%a"))
		     (zero_extend:DI
		       (match_operand:SI 2 "nonimmediate_operand" "rm")))
	    (const_int 32))))
   (clobber (match_scratch:SI 3 "=1"))
   (clobber (reg:CC 17))]
  "GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM"
  "mul{l}\t%2"
  [(set_attr "type" "imul")
   (set_attr "ppro_uops" "few")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "SI")])

(define_insn "*umulsi3_highpart_zext"
  [(set (match_operand:DI 0 "register_operand" "=d")
	(zero_extend:DI (truncate:SI
	  (lshiftrt:DI
	    (mult:DI (zero_extend:DI
		       (match_operand:SI 1 "nonimmediate_operand" "%a"))
		     (zero_extend:DI
		       (match_operand:SI 2 "nonimmediate_operand" "rm")))
	    (const_int 32)))))
   (clobber (match_scratch:SI 3 "=1"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "mul{l}\t%2"
  [(set_attr "type" "imul")
   (set_attr "ppro_uops" "few")
   (set_attr "length_immediate" "0")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "SI")])

(define_expand "smuldi3_highpart"
  [(parallel [(set (match_operand:DI 0 "register_operand" "=d")
		   (truncate:DI
		     (lshiftrt:TI
		       (mult:TI (sign_extend:TI
				  (match_operand:DI 1 "nonimmediate_operand" ""))
				(sign_extend:TI
				  (match_operand:DI 2 "register_operand" "")))
		       (const_int 64))))
	      (clobber (match_scratch:DI 3 ""))
	      (clobber (reg:CC 17))])]
  "TARGET_64BIT"
  "")

(define_insn "*smuldi3_highpart_rex64"
  [(set (match_operand:DI 0 "register_operand" "=d")
	(truncate:DI
	  (lshiftrt:TI
	    (mult:TI (sign_extend:TI
		       (match_operand:DI 1 "nonimmediate_operand" "%a"))
		     (sign_extend:TI
		       (match_operand:DI 2 "nonimmediate_operand" "rm")))
	    (const_int 64))))
   (clobber (match_scratch:DI 3 "=1"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "imul{q}\t%2"
  [(set_attr "type" "imul")
   (set_attr "ppro_uops" "few")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "DI")])

(define_expand "smulsi3_highpart"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (truncate:SI
		     (lshiftrt:DI
		       (mult:DI (sign_extend:DI
				  (match_operand:SI 1 "nonimmediate_operand" ""))
				(sign_extend:DI
				  (match_operand:SI 2 "register_operand" "")))
		       (const_int 32))))
	      (clobber (match_scratch:SI 3 ""))
	      (clobber (reg:CC 17))])]
  ""
  "")

(define_insn "*smulsi3_highpart_insn"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(truncate:SI
	  (lshiftrt:DI
	    (mult:DI (sign_extend:DI
		       (match_operand:SI 1 "nonimmediate_operand" "%a"))
		     (sign_extend:DI
		       (match_operand:SI 2 "nonimmediate_operand" "rm")))
	    (const_int 32))))
   (clobber (match_scratch:SI 3 "=1"))
   (clobber (reg:CC 17))]
  "GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM"
  "imul{l}\t%2"
  [(set_attr "type" "imul")
   (set_attr "ppro_uops" "few")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "SI")])

(define_insn "*smulsi3_highpart_zext"
  [(set (match_operand:DI 0 "register_operand" "=d")
	(zero_extend:DI (truncate:SI
	  (lshiftrt:DI
	    (mult:DI (sign_extend:DI
		       (match_operand:SI 1 "nonimmediate_operand" "%a"))
		     (sign_extend:DI
		       (match_operand:SI 2 "nonimmediate_operand" "rm")))
	    (const_int 32)))))
   (clobber (match_scratch:SI 3 "=1"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "imul{l}\t%2"
  [(set_attr "type" "imul")
   (set_attr "ppro_uops" "few")
   (set (attr "athlon_decode")
     (if_then_else (eq_attr "cpu" "athlon")
        (const_string "vector")
        (const_string "double")))
   (set_attr "mode" "SI")])

;; The patterns that match these are at the end of this file.

(define_expand "mulxf3"
  [(set (match_operand:XF 0 "register_operand" "")
	(mult:XF (match_operand:XF 1 "register_operand" "")
		 (match_operand:XF 2 "register_operand" "")))]
  "TARGET_80387"
  "")

(define_expand "muldf3"
  [(set (match_operand:DF 0 "register_operand" "")
	(mult:DF (match_operand:DF 1 "register_operand" "")
		 (match_operand:DF 2 "nonimmediate_operand" "")))]
  "TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)"
  "")

(define_expand "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "")
	(mult:SF (match_operand:SF 1 "register_operand" "")
		 (match_operand:SF 2 "nonimmediate_operand" "")))]
  "TARGET_80387 || TARGET_SSE_MATH"
  "")

;; Divide instructions

(define_insn "divqi3"
  [(set (match_operand:QI 0 "register_operand" "=a")
	(div:QI (match_operand:HI 1 "register_operand" "0")
		(match_operand:QI 2 "nonimmediate_operand" "qm")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "idiv{b}\t%2"
  [(set_attr "type" "idiv")
   (set_attr "mode" "QI")
   (set_attr "ppro_uops" "few")])

(define_insn "udivqi3"
  [(set (match_operand:QI 0 "register_operand" "=a")
	(udiv:QI (match_operand:HI 1 "register_operand" "0")
		 (match_operand:QI 2 "nonimmediate_operand" "qm")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "div{b}\t%2"
  [(set_attr "type" "idiv")
   (set_attr "mode" "QI")
   (set_attr "ppro_uops" "few")])

;; The patterns that match these are at the end of this file.

(define_expand "divxf3"
  [(set (match_operand:XF 0 "register_operand" "")
	(div:XF (match_operand:XF 1 "register_operand" "")
		(match_operand:XF 2 "register_operand" "")))]
  "TARGET_80387"
  "")

(define_expand "divdf3"
  [(set (match_operand:DF 0 "register_operand" "")
 	(div:DF (match_operand:DF 1 "register_operand" "")
 		(match_operand:DF 2 "nonimmediate_operand" "")))]
   "TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)"
   "")
 
(define_expand "divsf3"
  [(set (match_operand:SF 0 "register_operand" "")
	(div:SF (match_operand:SF 1 "register_operand" "")
		(match_operand:SF 2 "nonimmediate_operand" "")))]
  "TARGET_80387 || TARGET_SSE_MATH"
  "")

;; Remainder instructions.

(define_expand "divmoddi4"
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (div:DI (match_operand:DI 1 "register_operand" "")
			   (match_operand:DI 2 "nonimmediate_operand" "")))
	      (set (match_operand:DI 3 "register_operand" "")
		   (mod:DI (match_dup 1) (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "TARGET_64BIT"
  "")

;; Allow to come the parameter in eax or edx to avoid extra moves.
;; Penalize eax case slightly because it results in worse scheduling
;; of code.
(define_insn "*divmoddi4_nocltd_rex64"
  [(set (match_operand:DI 0 "register_operand" "=&a,?a")
	(div:DI (match_operand:DI 2 "register_operand" "1,0")
		(match_operand:DI 3 "nonimmediate_operand" "rm,rm")))
   (set (match_operand:DI 1 "register_operand" "=&d,&d")
	(mod:DI (match_dup 2) (match_dup 3)))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && !optimize_size && !TARGET_USE_CLTD"
  "#"
  [(set_attr "type" "multi")])

(define_insn "*divmoddi4_cltd_rex64"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(div:DI (match_operand:DI 2 "register_operand" "a")
		(match_operand:DI 3 "nonimmediate_operand" "rm")))
   (set (match_operand:DI 1 "register_operand" "=&d")
	(mod:DI (match_dup 2) (match_dup 3)))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && (optimize_size || TARGET_USE_CLTD)"
  "#"
  [(set_attr "type" "multi")])

(define_insn "*divmoddi_noext_rex64"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(div:DI (match_operand:DI 1 "register_operand" "0")
		(match_operand:DI 2 "nonimmediate_operand" "rm")))
   (set (match_operand:DI 3 "register_operand" "=d")
	(mod:DI (match_dup 1) (match_dup 2)))
   (use (match_operand:DI 4 "register_operand" "3"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "idiv{q}\t%2"
  [(set_attr "type" "idiv")
   (set_attr "mode" "DI")
   (set_attr "ppro_uops" "few")])

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(div:DI (match_operand:DI 1 "register_operand" "")
		(match_operand:DI 2 "nonimmediate_operand" "")))
   (set (match_operand:DI 3 "register_operand" "")
	(mod:DI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && reload_completed"
  [(parallel [(set (match_dup 3)
		   (ashiftrt:DI (match_dup 4) (const_int 63)))
	      (clobber (reg:CC 17))])
   (parallel [(set (match_dup 0)
	           (div:DI (reg:DI 0) (match_dup 2)))
	      (set (match_dup 3)
		   (mod:DI (reg:DI 0) (match_dup 2)))
	      (use (match_dup 3))
	      (clobber (reg:CC 17))])]
{
  /* Avoid use of cltd in favor of a mov+shift.  */
  if (!TARGET_USE_CLTD && !optimize_size)
    {
      if (true_regnum (operands[1]))
        emit_move_insn (operands[0], operands[1]);
      else
	emit_move_insn (operands[3], operands[1]);
      operands[4] = operands[3];
    }
  else
    {
      if (true_regnum (operands[1]))
	abort();
      operands[4] = operands[1];
    }
})


(define_expand "divmodsi4"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (div:SI (match_operand:SI 1 "register_operand" "")
			   (match_operand:SI 2 "nonimmediate_operand" "")))
	      (set (match_operand:SI 3 "register_operand" "")
		   (mod:SI (match_dup 1) (match_dup 2)))
	      (clobber (reg:CC 17))])]
  ""
  "")

;; Allow to come the parameter in eax or edx to avoid extra moves.
;; Penalize eax case slightly because it results in worse scheduling
;; of code.
(define_insn "*divmodsi4_nocltd"
  [(set (match_operand:SI 0 "register_operand" "=&a,?a")
	(div:SI (match_operand:SI 2 "register_operand" "1,0")
		(match_operand:SI 3 "nonimmediate_operand" "rm,rm")))
   (set (match_operand:SI 1 "register_operand" "=&d,&d")
	(mod:SI (match_dup 2) (match_dup 3)))
   (clobber (reg:CC 17))]
  "!optimize_size && !TARGET_USE_CLTD"
  "#"
  [(set_attr "type" "multi")])

(define_insn "*divmodsi4_cltd"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(div:SI (match_operand:SI 2 "register_operand" "a")
		(match_operand:SI 3 "nonimmediate_operand" "rm")))
   (set (match_operand:SI 1 "register_operand" "=&d")
	(mod:SI (match_dup 2) (match_dup 3)))
   (clobber (reg:CC 17))]
  "optimize_size || TARGET_USE_CLTD"
  "#"
  [(set_attr "type" "multi")])

(define_insn "*divmodsi_noext"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(div:SI (match_operand:SI 1 "register_operand" "0")
		(match_operand:SI 2 "nonimmediate_operand" "rm")))
   (set (match_operand:SI 3 "register_operand" "=d")
	(mod:SI (match_dup 1) (match_dup 2)))
   (use (match_operand:SI 4 "register_operand" "3"))
   (clobber (reg:CC 17))]
  ""
  "idiv{l}\t%2"
  [(set_attr "type" "idiv")
   (set_attr "mode" "SI")
   (set_attr "ppro_uops" "few")])

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(div:SI (match_operand:SI 1 "register_operand" "")
		(match_operand:SI 2 "nonimmediate_operand" "")))
   (set (match_operand:SI 3 "register_operand" "")
	(mod:SI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC 17))]
  "reload_completed"
  [(parallel [(set (match_dup 3)
		   (ashiftrt:SI (match_dup 4) (const_int 31)))
	      (clobber (reg:CC 17))])
   (parallel [(set (match_dup 0)
	           (div:SI (reg:SI 0) (match_dup 2)))
	      (set (match_dup 3)
		   (mod:SI (reg:SI 0) (match_dup 2)))
	      (use (match_dup 3))
	      (clobber (reg:CC 17))])]
{
  /* Avoid use of cltd in favor of a mov+shift.  */
  if (!TARGET_USE_CLTD && !optimize_size)
    {
      if (true_regnum (operands[1]))
        emit_move_insn (operands[0], operands[1]);
      else
	emit_move_insn (operands[3], operands[1]);
      operands[4] = operands[3];
    }
  else
    {
      if (true_regnum (operands[1]))
	abort();
      operands[4] = operands[1];
    }
})
;; %%% Split me.
(define_insn "divmodhi4"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(div:HI (match_operand:HI 1 "register_operand" "0")
		(match_operand:HI 2 "nonimmediate_operand" "rm")))
   (set (match_operand:HI 3 "register_operand" "=&d")
	(mod:HI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "cwtd\;idiv{w}\t%2"
  [(set_attr "type" "multi")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "SI")])

(define_insn "udivmoddi4"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(udiv:DI (match_operand:DI 1 "register_operand" "0")
		 (match_operand:DI 2 "nonimmediate_operand" "rm")))
   (set (match_operand:DI 3 "register_operand" "=&d")
	(umod:DI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "xor{q}\t%3, %3\;div{q}\t%2"
  [(set_attr "type" "multi")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "DI")])

(define_insn "*udivmoddi4_noext"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(udiv:DI (match_operand:DI 1 "register_operand" "0")
		 (match_operand:DI 2 "nonimmediate_operand" "rm")))
   (set (match_operand:DI 3 "register_operand" "=d")
	(umod:DI (match_dup 1) (match_dup 2)))
   (use (match_dup 3))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "div{q}\t%2"
  [(set_attr "type" "idiv")
   (set_attr "ppro_uops" "few")
   (set_attr "mode" "DI")])

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(udiv:DI (match_operand:DI 1 "register_operand" "")
		 (match_operand:DI 2 "nonimmediate_operand" "")))
   (set (match_operand:DI 3 "register_operand" "")
	(umod:DI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 3) (const_int 0))
   (parallel [(set (match_dup 0)
		   (udiv:DI (match_dup 1) (match_dup 2)))
	      (set (match_dup 3)
		   (umod:DI (match_dup 1) (match_dup 2)))
	      (use (match_dup 3))
	      (clobber (reg:CC 17))])]
  "")

(define_insn "udivmodsi4"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(udiv:SI (match_operand:SI 1 "register_operand" "0")
		 (match_operand:SI 2 "nonimmediate_operand" "rm")))
   (set (match_operand:SI 3 "register_operand" "=&d")
	(umod:SI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC 17))]
  ""
  "xor{l}\t%3, %3\;div{l}\t%2"
  [(set_attr "type" "multi")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "SI")])

(define_insn "*udivmodsi4_noext"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(udiv:SI (match_operand:SI 1 "register_operand" "0")
		 (match_operand:SI 2 "nonimmediate_operand" "rm")))
   (set (match_operand:SI 3 "register_operand" "=d")
	(umod:SI (match_dup 1) (match_dup 2)))
   (use (match_dup 3))
   (clobber (reg:CC 17))]
  ""
  "div{l}\t%2"
  [(set_attr "type" "idiv")
   (set_attr "ppro_uops" "few")
   (set_attr "mode" "SI")])

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(udiv:SI (match_operand:SI 1 "register_operand" "")
		 (match_operand:SI 2 "nonimmediate_operand" "")))
   (set (match_operand:SI 3 "register_operand" "")
	(umod:SI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC 17))]
  "reload_completed"
  [(set (match_dup 3) (const_int 0))
   (parallel [(set (match_dup 0)
		   (udiv:SI (match_dup 1) (match_dup 2)))
	      (set (match_dup 3)
		   (umod:SI (match_dup 1) (match_dup 2)))
	      (use (match_dup 3))
	      (clobber (reg:CC 17))])]
  "")

(define_expand "udivmodhi4"
  [(set (match_dup 4) (const_int 0))
   (parallel [(set (match_operand:HI 0 "register_operand" "")
		   (udiv:HI (match_operand:HI 1 "register_operand" "")
		 	    (match_operand:HI 2 "nonimmediate_operand" "")))
	      (set (match_operand:HI 3 "register_operand" "")
	   	   (umod:HI (match_dup 1) (match_dup 2)))
	      (use (match_dup 4))
	      (clobber (reg:CC 17))])]
  "TARGET_HIMODE_MATH"
  "operands[4] = gen_reg_rtx (HImode);")

(define_insn "*udivmodhi_noext"
  [(set (match_operand:HI 0 "register_operand" "=a")
	(udiv:HI (match_operand:HI 1 "register_operand" "0")
		 (match_operand:HI 2 "nonimmediate_operand" "rm")))
   (set (match_operand:HI 3 "register_operand" "=d")
	(umod:HI (match_dup 1) (match_dup 2)))
   (use (match_operand:HI 4 "register_operand" "3"))
   (clobber (reg:CC 17))]
  ""
  "div{w}\t%2"
  [(set_attr "type" "idiv")
   (set_attr "mode" "HI")
   (set_attr "ppro_uops" "few")])

;; We can not use div/idiv for double division, because it causes
;; "division by zero" on the overflow and that's not what we expect
;; from truncate.  Because true (non truncating) double division is
;; never generated, we can't create this insn anyway.
;
;(define_insn ""
;  [(set (match_operand:SI 0 "register_operand" "=a")
;	(truncate:SI
;	  (udiv:DI (match_operand:DI 1 "register_operand" "A")
;		   (zero_extend:DI
;		     (match_operand:SI 2 "nonimmediate_operand" "rm")))))
;   (set (match_operand:SI 3 "register_operand" "=d")
;	(truncate:SI
;	  (umod:DI (match_dup 1) (zero_extend:DI (match_dup 2)))))
;   (clobber (reg:CC 17))]
;  ""
;  "div{l}\t{%2, %0|%0, %2}"
;  [(set_attr "type" "idiv")
;   (set_attr "ppro_uops" "few")])

;;- Logical AND instructions

;; On Pentium, "test imm, reg" is pairable only with eax, ax, and al.
;; Note that this excludes ah.

(define_insn "*testdi_1_rex64"
  [(set (reg 17)
	(compare
	  (and:DI (match_operand:DI 0 "nonimmediate_operand" "%!*a,r,!*a,r,rm")
		  (match_operand:DI 1 "x86_64_szext_general_operand" "Z,Z,e,e,re"))
	  (const_int 0)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
   test{l}\t{%k1, %k0|%k0, %k1} 
   test{l}\t{%k1, %k0|%k0, %k1} 
   test{q}\t{%1, %0|%0, %1} 
   test{q}\t{%1, %0|%0, %1} 
   test{q}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test")
   (set_attr "modrm" "0,1,0,1,1")
   (set_attr "mode" "SI,SI,DI,DI,DI")
   (set_attr "pent_pair" "uv,np,uv,np,uv")])

(define_insn "testsi_1"
  [(set (reg 17)
	(compare
	  (and:SI (match_operand:SI 0 "nonimmediate_operand" "%!*a,r,rm")
		  (match_operand:SI 1 "general_operand" "in,in,rin"))
	  (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "test{l}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test")
   (set_attr "modrm" "0,1,1")
   (set_attr "mode" "SI")
   (set_attr "pent_pair" "uv,np,uv")])

(define_expand "testsi_ccno_1"
  [(set (reg:CCNO 17)
	(compare:CCNO
	  (and:SI (match_operand:SI 0 "nonimmediate_operand" "")
		  (match_operand:SI 1 "nonmemory_operand" ""))
	  (const_int 0)))]
  ""
  "")

(define_insn "*testhi_1"
  [(set (reg 17)
        (compare (and:HI (match_operand:HI 0 "nonimmediate_operand" "%!*a,r,rm")
			 (match_operand:HI 1 "general_operand" "n,n,rn"))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "test{w}\t{%1, %0|%0, %1}"
  [(set_attr "type" "test")
   (set_attr "modrm" "0,1,1")
   (set_attr "mode" "HI")
   (set_attr "pent_pair" "uv,np,uv")])

(define_expand "testqi_ccz_1"
  [(set (reg:CCZ 17)
        (compare:CCZ (and:QI (match_operand:QI 0 "nonimmediate_operand" "")
			     (match_operand:QI 1 "nonmemory_operand" ""))
		 (const_int 0)))]
  ""
  "")

(define_insn "*testqi_1"
  [(set (reg 17)
        (compare (and:QI (match_operand:QI 0 "nonimmediate_operand" "%!*a,q,qm,r")
			 (match_operand:QI 1 "general_operand" "n,n,qn,n"))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  if (which_alternative == 3)
    {
      if (GET_CODE (operands[1]) == CONST_INT
	  && (INTVAL (operands[1]) & 0xffffff00))
	operands[1] = GEN_INT (INTVAL (operands[1]) & 0xff);
      return "test{l}\t{%1, %k0|%k0, %1}";
    }
  return "test{b}\t{%1, %0|%0, %1}";
}
  [(set_attr "type" "test")
   (set_attr "modrm" "0,1,1,1")
   (set_attr "mode" "QI,QI,QI,SI")
   (set_attr "pent_pair" "uv,np,uv,np")])

(define_expand "testqi_ext_ccno_0"
  [(set (reg:CCNO 17)
	(compare:CCNO
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "")
	      (const_int 8)
	      (const_int 8))
	    (match_operand 1 "const_int_operand" ""))
	  (const_int 0)))]
  ""
  "")

(define_insn "*testqi_ext_0"
  [(set (reg 17)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8))
	    (match_operand 1 "const_int_operand" "n"))
	  (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "test")
   (set_attr "mode" "QI")
   (set_attr "length_immediate" "1")
   (set_attr "pent_pair" "np")])

(define_insn "*testqi_ext_1"
  [(set (reg 17)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8))
	    (zero_extend:SI
	      (match_operand:QI 1 "general_operand" "Qm")))
	  (const_int 0)))]
  "!TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "test{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "test")
   (set_attr "mode" "QI")])

(define_insn "*testqi_ext_1_rex64"
  [(set (reg 17)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8))
	    (zero_extend:SI
	      (match_operand:QI 1 "register_operand" "Q")))
	  (const_int 0)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t{%1, %h0|%h0, %1}"
  [(set_attr "type" "test")
   (set_attr "mode" "QI")])

(define_insn "*testqi_ext_2"
  [(set (reg 17)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8))
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "Q")
	      (const_int 8)
	      (const_int 8)))
	  (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "test{b}\t{%h1, %h0|%h0, %h1}"
  [(set_attr "type" "test")
   (set_attr "mode" "QI")])

;; Combine likes to form bit extractions for some tests.  Humor it.
(define_insn "*testqi_ext_3"
  [(set (reg 17)
        (compare (zero_extract:SI
		   (match_operand 0 "nonimmediate_operand" "rm")
		   (match_operand:SI 1 "const_int_operand" "")
		   (match_operand:SI 2 "const_int_operand" ""))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_MODE (operands[0]) == SImode
       || (TARGET_64BIT && GET_MODE (operands[0]) == DImode)
       || GET_MODE (operands[0]) == HImode
       || GET_MODE (operands[0]) == QImode)"
  "#")

(define_insn "*testqi_ext_3_rex64"
  [(set (reg 17)
        (compare (zero_extract:DI
		   (match_operand 0 "nonimmediate_operand" "rm")
		   (match_operand:DI 1 "const_int_operand" "")
		   (match_operand:DI 2 "const_int_operand" ""))
		 (const_int 0)))]
  "TARGET_64BIT
   && ix86_match_ccmode (insn, CCNOmode)
   /* The code below cannot deal with constants outside HOST_WIDE_INT.  */
   && INTVAL (operands[1]) + INTVAL (operands[2]) < HOST_BITS_PER_WIDE_INT
   /* Ensure that resulting mask is zero or sign extended operand.  */
   && (INTVAL (operands[1]) + INTVAL (operands[2]) <= 32
       || (INTVAL (operands[1]) + INTVAL (operands[2]) == 64
	   && INTVAL (operands[1]) > 32))
   && (GET_MODE (operands[0]) == SImode
       || GET_MODE (operands[0]) == DImode
       || GET_MODE (operands[0]) == HImode
       || GET_MODE (operands[0]) == QImode)"
  "#")

(define_split
  [(set (reg 17)
        (compare (zero_extract
		   (match_operand 0 "nonimmediate_operand" "")
		   (match_operand 1 "const_int_operand" "")
		   (match_operand 2 "const_int_operand" ""))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(set (reg:CCNO 17) (compare:CCNO (match_dup 3) (const_int 0)))]
{
  HOST_WIDE_INT len = INTVAL (operands[1]);
  HOST_WIDE_INT pos = INTVAL (operands[2]);
  HOST_WIDE_INT mask;
  enum machine_mode mode, submode;

  mode = GET_MODE (operands[0]);
  if (GET_CODE (operands[0]) == MEM)
    {
      /* ??? Combine likes to put non-volatile mem extractions in QImode
	 no matter the size of the test.  So find a mode that works.  */
      if (! MEM_VOLATILE_P (operands[0]))
	{
	  mode = smallest_mode_for_size (pos + len, MODE_INT);
	  operands[0] = adjust_address (operands[0], mode, 0);
	}
    }
  else if (GET_CODE (operands[0]) == SUBREG
	   && (submode = GET_MODE (SUBREG_REG (operands[0])),
	       GET_MODE_BITSIZE (mode) > GET_MODE_BITSIZE (submode))
	   && pos + len <= GET_MODE_BITSIZE (submode))
    {
      /* Narrow a paradoxical subreg to prevent partial register stalls.  */
      mode = submode;
      operands[0] = SUBREG_REG (operands[0]);
    }
  else if (mode == HImode && pos + len <= 8)
    {
      /* Small HImode tests can be converted to QImode.  */
      mode = QImode;
      operands[0] = gen_lowpart (QImode, operands[0]);
    }

  mask  = ((HOST_WIDE_INT)1 << (pos + len)) - 1;
  mask &= ~(((HOST_WIDE_INT)1 << pos) - 1);

  operands[3] = gen_rtx_AND (mode, operands[0], gen_int_mode (mask, mode));
})

;; Convert HImode/SImode test instructions with immediate to QImode ones.
;; i386 does not allow to encode test with 8bit sign extended immediate, so
;; this is relatively important trick.
;; Do the conversion only post-reload to avoid limiting of the register class
;; to QI regs.
(define_split
  [(set (reg 17)
	(compare
	  (and (match_operand 0 "register_operand" "")
	       (match_operand 1 "const_int_operand" ""))
	  (const_int 0)))]
   "reload_completed
    && QI_REG_P (operands[0])
    && ((ix86_match_ccmode (insn, CCZmode)
    	 && !(INTVAL (operands[1]) & ~(255 << 8)))
	|| (ix86_match_ccmode (insn, CCNOmode)
	    && !(INTVAL (operands[1]) & ~(127 << 8))))
    && GET_MODE (operands[0]) != QImode"
  [(set (reg:CCNO 17)
	(compare:CCNO
	  (and:SI (zero_extract:SI (match_dup 0) (const_int 8) (const_int 8))
		  (match_dup 1))
	  (const_int 0)))]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_int_mode (INTVAL (operands[1]) >> 8, SImode);")

(define_split
  [(set (reg 17)
	(compare
	  (and (match_operand 0 "nonimmediate_operand" "")
	       (match_operand 1 "const_int_operand" ""))
	  (const_int 0)))]
   "reload_completed
    && (!REG_P (operands[0]) || ANY_QI_REG_P (operands[0]))
    && ((ix86_match_ccmode (insn, CCZmode)
	 && !(INTVAL (operands[1]) & ~255))
	|| (ix86_match_ccmode (insn, CCNOmode)
	    && !(INTVAL (operands[1]) & ~127)))
    && GET_MODE (operands[0]) != QImode"
  [(set (reg:CCNO 17)
	(compare:CCNO
	  (and:QI (match_dup 0)
		  (match_dup 1))
	  (const_int 0)))]
  "operands[0] = gen_lowpart (QImode, operands[0]);
   operands[1] = gen_lowpart (QImode, operands[1]);")


;; %%% This used to optimize known byte-wide and operations to memory,
;; and sometimes to QImode registers.  If this is considered useful,
;; it should be done with splitters.

(define_expand "anddi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(and:DI (match_operand:DI 1 "nonimmediate_operand" "")
		(match_operand:DI 2 "x86_64_szext_general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "ix86_expand_binary_operator (AND, DImode, operands); DONE;")

(define_insn "*anddi_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,rm,r,r")
	(and:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0,qm")
		(match_operand:DI 2 "x86_64_szext_general_operand" "Z,re,rm,L")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (AND, DImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      {
	enum machine_mode mode;

	if (GET_CODE (operands[2]) != CONST_INT)
	  abort ();
        if (INTVAL (operands[2]) == 0xff)
	  mode = QImode;
	else if (INTVAL (operands[2]) == 0xffff)
	  mode = HImode;
	else
	  abort ();
	
	operands[1] = gen_lowpart (mode, operands[1]);
	if (mode == QImode)
	  return "movz{bq|x}\t{%1,%0|%0, %1}";
	else
	  return "movz{wq|x}\t{%1,%0|%0, %1}";
      }

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      if (get_attr_mode (insn) == MODE_SI)
	return "and{l}\t{%k2, %k0|%k0, %k2}";
      else
	return "and{q}\t{%2, %0|%0, %2}";
    }
}
  [(set_attr "type" "alu,alu,alu,imovx")
   (set_attr "length_immediate" "*,*,*,0")
   (set_attr "mode" "SI,DI,DI,DI")])

(define_insn "*anddi_2"
  [(set (reg 17)
	(compare (and:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0,0")
			 (match_operand:DI 2 "x86_64_szext_general_operand" "Z,rem,re"))
		 (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=r,r,rm")
	(and:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (AND, DImode, operands)"
  "@
   and{l}\t{%k2, %k0|%k0, %k2} 
   and{q}\t{%2, %0|%0, %2} 
   and{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI,DI,DI")])

(define_expand "andsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(and:SI (match_operand:SI 1 "nonimmediate_operand" "")
		(match_operand:SI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (AND, SImode, operands); DONE;")

(define_insn "*andsi_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,r,r")
	(and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0,qm")
		(match_operand:SI 2 "general_operand" "ri,rm,L")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (AND, SImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      {
	enum machine_mode mode;

	if (GET_CODE (operands[2]) != CONST_INT)
	  abort ();
        if (INTVAL (operands[2]) == 0xff)
	  mode = QImode;
	else if (INTVAL (operands[2]) == 0xffff)
	  mode = HImode;
	else
	  abort ();
	
	operands[1] = gen_lowpart (mode, operands[1]);
	if (mode == QImode)
	  return "movz{bl|x}\t{%1,%0|%0, %1}";
	else
	  return "movz{wl|x}\t{%1,%0|%0, %1}";
      }

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();
      return "and{l}\t{%2, %0|%0, %2}";
    }
}
  [(set_attr "type" "alu,alu,imovx")
   (set_attr "length_immediate" "*,*,0")
   (set_attr "mode" "SI")])

(define_split
  [(set (match_operand 0 "register_operand" "")
	(and (match_dup 0)
	     (const_int -65536)))
   (clobber (reg:CC 17))]
  "optimize_size || (TARGET_FAST_PREFIX && !TARGET_PARTIAL_REG_STALL)"
  [(set (strict_low_part (match_dup 1)) (const_int 0))]
  "operands[1] = gen_lowpart (HImode, operands[0]);")

(define_split
  [(set (match_operand 0 "ext_register_operand" "")
	(and (match_dup 0)
	     (const_int -256)))
   (clobber (reg:CC 17))]
  "(optimize_size || !TARGET_PARTIAL_REG_STALL) && reload_completed"
  [(set (strict_low_part (match_dup 1)) (const_int 0))]
  "operands[1] = gen_lowpart (QImode, operands[0]);")

(define_split
  [(set (match_operand 0 "ext_register_operand" "")
	(and (match_dup 0)
	     (const_int -65281)))
   (clobber (reg:CC 17))]
  "(optimize_size || !TARGET_PARTIAL_REG_STALL) && reload_completed"
  [(parallel [(set (zero_extract:SI (match_dup 0)
				    (const_int 8)
				    (const_int 8))
		   (xor:SI 
		     (zero_extract:SI (match_dup 0)
				      (const_int 8)
				      (const_int 8))
		     (zero_extract:SI (match_dup 0)
				      (const_int 8)
				      (const_int 8))))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);")

;; See comment for addsi_1_zext why we do use nonimmediate_operand
(define_insn "*andsi_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
		  (match_operand:SI 2 "general_operand" "rim"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (AND, SImode, operands)"
  "and{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*andsi_2"
  [(set (reg 17)
	(compare (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:SI 2 "general_operand" "rim,ri"))
		 (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=r,rm")
	(and:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (AND, SImode, operands)"
  "and{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

;; See comment for addsi_1_zext why we do use nonimmediate_operand
(define_insn "*andsi_2_zext"
  [(set (reg 17)
	(compare (and:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
			 (match_operand:SI 2 "general_operand" "rim"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (and:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (AND, SImode, operands)"
  "and{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_expand "andhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(and:HI (match_operand:HI 1 "nonimmediate_operand" "")
		(match_operand:HI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (AND, HImode, operands); DONE;")

(define_insn "*andhi_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,r,r")
	(and:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0,qm")
		(match_operand:HI 2 "general_operand" "ri,rm,L")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (AND, HImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOVX:
      if (GET_CODE (operands[2]) != CONST_INT)
	abort ();
      if (INTVAL (operands[2]) == 0xff)
	return "movz{bl|x}\t{%b1, %k0|%k0, %b1}";
      abort ();

    default:
      if (! rtx_equal_p (operands[0], operands[1]))
	abort ();

      return "and{w}\t{%2, %0|%0, %2}";
    }
}
  [(set_attr "type" "alu,alu,imovx")
   (set_attr "length_immediate" "*,*,0")
   (set_attr "mode" "HI,HI,SI")])

(define_insn "*andhi_2"
  [(set (reg 17)
	(compare (and:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:HI 2 "general_operand" "rim,ri"))
		 (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=r,rm")
	(and:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (AND, HImode, operands)"
  "and{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_expand "andqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(and:QI (match_operand:QI 1 "nonimmediate_operand" "")
		(match_operand:QI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (AND, QImode, operands); DONE;")

;; %%% Potential partial reg stall on alternative 2.  What to do?
(define_insn "*andqi_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,q,r")
	(and:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		(match_operand:QI 2 "general_operand" "qi,qmi,ri")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (AND, QImode, operands)"
  "@
   and{b}\t{%2, %0|%0, %2}
   and{b}\t{%2, %0|%0, %2}
   and{l}\t{%k2, %k0|%k0, %k2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI,QI,SI")])

(define_insn "*andqi_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,q"))
	(and:QI (match_dup 0)
		(match_operand:QI 1 "general_operand" "qi,qmi")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "and{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_insn "*andqi_2"
  [(set (reg 17)
	(compare (and:QI
		   (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		   (match_operand:QI 2 "general_operand" "qim,qi,i"))
		 (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=q,qm,*r")
	(and:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (AND, QImode, operands)"
{
  if (which_alternative == 2)
    {
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) & 0xffffff00))
        operands[2] = GEN_INT (INTVAL (operands[2]) & 0xff);
      return "and{l}\t{%2, %k0|%k0, %2}";
    }
  return "and{b}\t{%2, %0|%0, %2}";
}
  [(set_attr "type" "alu")
   (set_attr "mode" "QI,QI,SI")])

(define_insn "*andqi_2_slp"
  [(set (reg 17)
	(compare (and:QI
		   (match_operand:QI 0 "nonimmediate_operand" "+q,qm")
		   (match_operand:QI 1 "nonimmediate_operand" "qmi,qi"))
		 (const_int 0)))
   (set (strict_low_part (match_dup 0))
	(and:QI (match_dup 0) (match_dup 1)))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "and{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

;; ??? A bug in recog prevents it from recognizing a const_int as an
;; operand to zero_extend in andqi_ext_1.  It was checking explicitly
;; for a QImode operand, which of course failed.

(define_insn "andqi_ext_0"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (match_operand 2 "const_int_operand" "n")))
   (clobber (reg:CC 17))]
  ""
  "and{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "1")
   (set_attr "mode" "QI")])

;; Generated by peephole translating test to and.  This shows up
;; often in fp comparisons.

(define_insn "*andqi_ext_0_cc"
  [(set (reg 17)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "0")
	      (const_int 8)
	      (const_int 8))
	    (match_operand 2 "const_int_operand" "n"))
	  (const_int 0)))
   (set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI 
	  (zero_extract:SI
	    (match_dup 1)
	    (const_int 8)
	    (const_int 8))
	  (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  "and{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "1")
   (set_attr "mode" "QI")])

(define_insn "*andqi_ext_1"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand:QI 2 "general_operand" "Qm"))))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT"
  "and{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*andqi_ext_1_rex64"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand 2 "ext_register_operand" "Q"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "and{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*andqi_ext_2"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(and:SI
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "%0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extract:SI
	    (match_operand 2 "ext_register_operand" "Q")
	    (const_int 8)
	    (const_int 8))))
   (clobber (reg:CC 17))]
  ""
  "and{b}\t{%h2, %h0|%h0, %h2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

;; Convert wide AND instructions with immediate operand to shorter QImode
;; equivalents when possible.
;; Don't do the splitting with memory operands, since it introduces risk
;; of memory mismatch stalls.  We may want to do the splitting for optimizing
;; for size, but that can (should?) be handled by generic code instead.
(define_split
  [(set (match_operand 0 "register_operand" "")
	(and (match_operand 1 "register_operand" "")
	     (match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC 17))]
   "reload_completed
    && QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_size)
    && !(~INTVAL (operands[2]) & ~(255 << 8))
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (zero_extract:SI (match_dup 0) (const_int 8) (const_int 8))
		   (and:SI (zero_extract:SI (match_dup 1)
					    (const_int 8) (const_int 8))
			   (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);
   operands[2] = gen_int_mode ((INTVAL (operands[2]) >> 8) & 0xff, SImode);")

;; Since AND can be encoded with sign extended immediate, this is only
;; profitable when 7th bit is not set.
(define_split
  [(set (match_operand 0 "register_operand" "")
	(and (match_operand 1 "general_operand" "")
	     (match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC 17))]
   "reload_completed
    && ANY_QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_size)
    && !(~INTVAL (operands[2]) & ~255)
    && !(INTVAL (operands[2]) & 128)
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (strict_low_part (match_dup 0))
		   (and:QI (match_dup 1)
			   (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (QImode, operands[0]);
   operands[1] = gen_lowpart (QImode, operands[1]);
   operands[2] = gen_lowpart (QImode, operands[2]);")

;; Logical inclusive OR instructions

;; %%% This used to optimize known byte-wide and operations to memory.
;; If this is considered useful, it should be done with splitters.

(define_expand "iordi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(ior:DI (match_operand:DI 1 "nonimmediate_operand" "")
		(match_operand:DI 2 "x86_64_general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "ix86_expand_binary_operator (IOR, DImode, operands); DONE;")

(define_insn "*iordi_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	(ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
		(match_operand:DI 2 "x86_64_general_operand" "re,rme")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && ix86_binary_operator_ok (IOR, DImode, operands)"
  "or{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "*iordi_2_rex64"
  [(set (reg 17)
	(compare (ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:DI 2 "x86_64_general_operand" "rem,re"))
		 (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=r,rm")
	(ior:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT
   && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (IOR, DImode, operands)"
  "or{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_insn "*iordi_3_rex64"
  [(set (reg 17)
	(compare (ior:DI (match_operand:DI 1 "nonimmediate_operand" "%0")
			 (match_operand:DI 2 "x86_64_general_operand" "rem"))
		 (const_int 0)))
   (clobber (match_scratch:DI 0 "=r"))]
  "TARGET_64BIT
   && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (IOR, DImode, operands)"
  "or{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])


(define_expand "iorsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(ior:SI (match_operand:SI 1 "nonimmediate_operand" "")
		(match_operand:SI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (IOR, SImode, operands); DONE;")

(define_insn "*iorsi_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	(ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
		(match_operand:SI 2 "general_operand" "ri,rmi")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (IOR, SImode, operands)"
  "or{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

;; See comment for addsi_1_zext why we do use nonimmediate_operand
(define_insn "*iorsi_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=rm")
	(zero_extend:DI
	  (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
		  (match_operand:SI 2 "general_operand" "rim"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (IOR, SImode, operands)"
  "or{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*iorsi_1_zext_imm"
  [(set (match_operand:DI 0 "register_operand" "=rm")
	(ior:DI (zero_extend:DI (match_operand:SI 1 "register_operand" "%0"))
		(match_operand:DI 2 "x86_64_zext_immediate_operand" "Z")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "or{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*iorsi_2"
  [(set (reg 17)
	(compare (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:SI 2 "general_operand" "rim,ri"))
		 (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=r,rm")
	(ior:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (IOR, SImode, operands)"
  "or{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

;; See comment for addsi_1_zext why we do use nonimmediate_operand
;; ??? Special case for immediate operand is missing - it is tricky.
(define_insn "*iorsi_2_zext"
  [(set (reg 17)
	(compare (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
			 (match_operand:SI 2 "general_operand" "rim"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (ior:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (IOR, SImode, operands)"
  "or{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*iorsi_2_zext_imm"
  [(set (reg 17)
	(compare (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
			 (match_operand 2 "x86_64_zext_immediate_operand" "Z"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(ior:DI (zero_extend:DI (match_dup 1)) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (IOR, SImode, operands)"
  "or{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*iorsi_3"
  [(set (reg 17)
	(compare (ior:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
			 (match_operand:SI 2 "general_operand" "rim"))
		 (const_int 0)))
   (clobber (match_scratch:SI 0 "=r"))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "or{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_expand "iorhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(ior:HI (match_operand:HI 1 "nonimmediate_operand" "")
		(match_operand:HI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (IOR, HImode, operands); DONE;")

(define_insn "*iorhi_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,m")
	(ior:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0")
		(match_operand:HI 2 "general_operand" "rmi,ri")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (IOR, HImode, operands)"
  "or{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_insn "*iorhi_2"
  [(set (reg 17)
	(compare (ior:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:HI 2 "general_operand" "rim,ri"))
		 (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=r,rm")
	(ior:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (IOR, HImode, operands)"
  "or{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_insn "*iorhi_3"
  [(set (reg 17)
	(compare (ior:HI (match_operand:HI 1 "nonimmediate_operand" "%0")
			 (match_operand:HI 2 "general_operand" "rim"))
		 (const_int 0)))
   (clobber (match_scratch:HI 0 "=r"))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "or{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_expand "iorqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(ior:QI (match_operand:QI 1 "nonimmediate_operand" "")
		(match_operand:QI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (IOR, QImode, operands); DONE;")

;; %%% Potential partial reg stall on alternative 2.  What to do?
(define_insn "*iorqi_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=q,m,r")
	(ior:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		(match_operand:QI 2 "general_operand" "qmi,qi,ri")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (IOR, QImode, operands)"
  "@
   or{b}\t{%2, %0|%0, %2}
   or{b}\t{%2, %0|%0, %2}
   or{l}\t{%k2, %k0|%k0, %k2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI,QI,SI")])

(define_insn "*iorqi_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+q,m"))
	(ior:QI (match_dup 0)
		(match_operand:QI 1 "general_operand" "qmi,qi")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "or{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_insn "*iorqi_2"
  [(set (reg 17)
	(compare (ior:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:QI 2 "general_operand" "qim,qi"))
		 (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=q,qm")
	(ior:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (IOR, QImode, operands)"
  "or{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_insn "*iorqi_2_slp"
  [(set (reg 17)
	(compare (ior:QI (match_operand:QI 0 "nonimmediate_operand" "+q,qm")
			 (match_operand:QI 1 "general_operand" "qim,qi"))
		 (const_int 0)))
   (set (strict_low_part (match_dup 0))
	(ior:QI (match_dup 0) (match_dup 1)))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "or{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_insn "*iorqi_3"
  [(set (reg 17)
	(compare (ior:QI (match_operand:QI 1 "nonimmediate_operand" "%0")
			 (match_operand:QI 2 "general_operand" "qim"))
		 (const_int 0)))
   (clobber (match_scratch:QI 0 "=q"))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "or{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_insn "iorqi_ext_0"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(ior:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (match_operand 2 "const_int_operand" "n")))
   (clobber (reg:CC 17))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_size)"
  "or{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "1")
   (set_attr "mode" "QI")])

(define_insn "*iorqi_ext_1"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(ior:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand:QI 2 "general_operand" "Qm"))))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT
   && (!TARGET_PARTIAL_REG_STALL || optimize_size)"
  "or{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*iorqi_ext_1_rex64"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(ior:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand 2 "ext_register_operand" "Q"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (!TARGET_PARTIAL_REG_STALL || optimize_size)"
  "or{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*iorqi_ext_2"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(ior:SI 
	  (zero_extract:SI (match_operand 1 "ext_register_operand" "0")
	  		   (const_int 8)
			   (const_int 8))
	  (zero_extract:SI (match_operand 2 "ext_register_operand" "Q")
	  		   (const_int 8)
			   (const_int 8))))
   (clobber (reg:CC 17))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_size)"
  "ior{b}\t{%h2, %h0|%h0, %h2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_split
  [(set (match_operand 0 "register_operand" "")
	(ior (match_operand 1 "register_operand" "")
	     (match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC 17))]
   "reload_completed
    && QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_size)
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (zero_extract:SI (match_dup 0) (const_int 8) (const_int 8))
		   (ior:SI (zero_extract:SI (match_dup 1)
					    (const_int 8) (const_int 8))
			   (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);
   operands[2] = gen_int_mode ((INTVAL (operands[2]) >> 8) & 0xff, SImode);")

;; Since OR can be encoded with sign extended immediate, this is only
;; profitable when 7th bit is set.
(define_split
  [(set (match_operand 0 "register_operand" "")
	(ior (match_operand 1 "general_operand" "")
	     (match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC 17))]
   "reload_completed
    && ANY_QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_size)
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (strict_low_part (match_dup 0))
		   (ior:QI (match_dup 1)
			   (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (QImode, operands[0]);
   operands[1] = gen_lowpart (QImode, operands[1]);
   operands[2] = gen_lowpart (QImode, operands[2]);")

;; Logical XOR instructions

;; %%% This used to optimize known byte-wide and operations to memory.
;; If this is considered useful, it should be done with splitters.

(define_expand "xordi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(xor:DI (match_operand:DI 1 "nonimmediate_operand" "")
		(match_operand:DI 2 "x86_64_general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "ix86_expand_binary_operator (XOR, DImode, operands); DONE;")

(define_insn "*xordi_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	(xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
		(match_operand:DI 2 "x86_64_general_operand" "re,rm")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && ix86_binary_operator_ok (XOR, DImode, operands)"
  "@
   xor{q}\t{%2, %0|%0, %2} 
   xor{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI,DI")])

(define_insn "*xordi_2_rex64"
  [(set (reg 17)
	(compare (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:DI 2 "x86_64_general_operand" "rem,re"))
		 (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=r,rm")
	(xor:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT
   && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (XOR, DImode, operands)"
  "@
   xor{q}\t{%2, %0|%0, %2} 
   xor{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI,DI")])

(define_insn "*xordi_3_rex64"
  [(set (reg 17)
	(compare (xor:DI (match_operand:DI 1 "nonimmediate_operand" "%0")
			 (match_operand:DI 2 "x86_64_general_operand" "rem"))
		 (const_int 0)))
   (clobber (match_scratch:DI 0 "=r"))]
  "TARGET_64BIT
   && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (XOR, DImode, operands)"
  "xor{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "DI")])

(define_expand "xorsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(xor:SI (match_operand:SI 1 "nonimmediate_operand" "")
		(match_operand:SI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (XOR, SImode, operands); DONE;")

(define_insn "*xorsi_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	(xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
		(match_operand:SI 2 "general_operand" "ri,rm")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (XOR, SImode, operands)"
  "xor{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

;; See comment for addsi_1_zext why we do use nonimmediate_operand
;; Add speccase for immediates
(define_insn "*xorsi_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
		  (match_operand:SI 2 "general_operand" "rim"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (XOR, SImode, operands)"
  "xor{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*xorsi_1_zext_imm"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(xor:DI (zero_extend:DI (match_operand:SI 1 "register_operand" "%0"))
		(match_operand:DI 2 "x86_64_zext_immediate_operand" "Z")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (XOR, SImode, operands)"
  "xor{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*xorsi_2"
  [(set (reg 17)
	(compare (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:SI 2 "general_operand" "rim,ri"))
		 (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=r,rm")
	(xor:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (XOR, SImode, operands)"
  "xor{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

;; See comment for addsi_1_zext why we do use nonimmediate_operand
;; ??? Special case for immediate operand is missing - it is tricky.
(define_insn "*xorsi_2_zext"
  [(set (reg 17)
	(compare (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
			 (match_operand:SI 2 "general_operand" "rim"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (xor:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (XOR, SImode, operands)"
  "xor{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*xorsi_2_zext_imm"
  [(set (reg 17)
	(compare (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
			 (match_operand 2 "x86_64_zext_immediate_operand" "Z"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(xor:DI (zero_extend:DI (match_dup 1)) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (XOR, SImode, operands)"
  "xor{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_insn "*xorsi_3"
  [(set (reg 17)
	(compare (xor:SI (match_operand:SI 1 "nonimmediate_operand" "%0")
			 (match_operand:SI 2 "general_operand" "rim"))
		 (const_int 0)))
   (clobber (match_scratch:SI 0 "=r"))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "xor{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "SI")])

(define_expand "xorhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(xor:HI (match_operand:HI 1 "nonimmediate_operand" "")
		(match_operand:HI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (XOR, HImode, operands); DONE;")

(define_insn "*xorhi_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,m")
	(xor:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0")
		(match_operand:HI 2 "general_operand" "rmi,ri")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (XOR, HImode, operands)"
  "xor{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_insn "*xorhi_2"
  [(set (reg 17)
	(compare (xor:HI (match_operand:HI 1 "nonimmediate_operand" "%0,0")
			 (match_operand:HI 2 "general_operand" "rim,ri"))
		 (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=r,rm")
	(xor:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (XOR, HImode, operands)"
  "xor{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_insn "*xorhi_3"
  [(set (reg 17)
	(compare (xor:HI (match_operand:HI 1 "nonimmediate_operand" "%0")
			 (match_operand:HI 2 "general_operand" "rim"))
		 (const_int 0)))
   (clobber (match_scratch:HI 0 "=r"))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "xor{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "HI")])

(define_expand "xorqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(xor:QI (match_operand:QI 1 "nonimmediate_operand" "")
		(match_operand:QI 2 "general_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (XOR, QImode, operands); DONE;")

;; %%% Potential partial reg stall on alternative 2.  What to do?
(define_insn "*xorqi_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=q,m,r")
	(xor:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		(match_operand:QI 2 "general_operand" "qmi,qi,ri")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (XOR, QImode, operands)"
  "@
   xor{b}\t{%2, %0|%0, %2}
   xor{b}\t{%2, %0|%0, %2}
   xor{l}\t{%k2, %k0|%k0, %k2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI,QI,SI")])

(define_insn "*xorqi_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,q"))
	(xor:QI (match_dup 0)
		(match_operand:QI 1 "general_operand" "qi,qmi")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "xor{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_insn "xorqi_ext_0"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(xor:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (match_operand 2 "const_int_operand" "n")))
   (clobber (reg:CC 17))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_size)"
  "xor{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "1")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_ext_1"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(xor:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand:QI 2 "general_operand" "Qm"))))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT
   && (!TARGET_PARTIAL_REG_STALL || optimize_size)"
  "xor{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_ext_1_rex64"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(xor:SI 
	  (zero_extract:SI
	    (match_operand 1 "ext_register_operand" "0")
	    (const_int 8)
	    (const_int 8))
	  (zero_extend:SI
	    (match_operand 2 "ext_register_operand" "Q"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT
   && (!TARGET_PARTIAL_REG_STALL || optimize_size)"
  "xor{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_ext_2"
  [(set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(xor:SI 
	  (zero_extract:SI (match_operand 1 "ext_register_operand" "0")
	  		   (const_int 8)
			   (const_int 8))
	  (zero_extract:SI (match_operand 2 "ext_register_operand" "Q")
	  		   (const_int 8)
			   (const_int 8))))
   (clobber (reg:CC 17))]
  "(!TARGET_PARTIAL_REG_STALL || optimize_size)"
  "xor{b}\t{%h2, %h0|%h0, %h2}"
  [(set_attr "type" "alu")
   (set_attr "length_immediate" "0")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_cc_1"
  [(set (reg 17)
	(compare
	  (xor:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0")
		  (match_operand:QI 2 "general_operand" "qim,qi"))
	  (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=q,qm")
	(xor:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_binary_operator_ok (XOR, QImode, operands)"
  "xor{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_2_slp"
  [(set (reg 17)
	(compare (xor:QI (match_operand:QI 0 "nonimmediate_operand" "+q,qm")
			 (match_operand:QI 1 "general_operand" "qim,qi"))
		 (const_int 0)))
   (set (strict_low_part (match_dup 0))
	(xor:QI (match_dup 0) (match_dup 1)))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "xor{b}\t{%1, %0|%0, %1}"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_cc_2"
  [(set (reg 17)
	(compare
	  (xor:QI (match_operand:QI 1 "nonimmediate_operand" "%0")
		  (match_operand:QI 2 "general_operand" "qim"))
	  (const_int 0)))
   (clobber (match_scratch:QI 0 "=q"))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "xor{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_cc_ext_1"
  [(set (reg 17)
	(compare
	  (xor:SI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "0")
	      (const_int 8)
	      (const_int 8))
	    (match_operand:QI 2 "general_operand" "qmn"))
	  (const_int 0)))
   (set (zero_extract:SI (match_operand 0 "ext_register_operand" "=q")
			 (const_int 8)
			 (const_int 8))
	(xor:SI 
	  (zero_extract:SI (match_dup 1) (const_int 8) (const_int 8))
	  (match_dup 2)))]
  "!TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  "xor{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_insn "*xorqi_cc_ext_1_rex64"
  [(set (reg 17)
	(compare
	  (xor:SI
	    (zero_extract:SI
	      (match_operand 1 "ext_register_operand" "0")
	      (const_int 8)
	      (const_int 8))
	    (match_operand:QI 2 "nonmemory_operand" "Qn"))
	  (const_int 0)))
   (set (zero_extract:SI (match_operand 0 "ext_register_operand" "=Q")
			 (const_int 8)
			 (const_int 8))
	(xor:SI 
	  (zero_extract:SI (match_dup 1) (const_int 8) (const_int 8))
	  (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  "xor{b}\t{%2, %h0|%h0, %2}"
  [(set_attr "type" "alu")
   (set_attr "mode" "QI")])

(define_expand "xorqi_cc_ext_1"
  [(parallel [
     (set (reg:CCNO 17)
	  (compare:CCNO
	    (xor:SI
	      (zero_extract:SI
		(match_operand 1 "ext_register_operand" "")
		(const_int 8)
		(const_int 8))
	      (match_operand:QI 2 "general_operand" ""))
	    (const_int 0)))
     (set (zero_extract:SI (match_operand 0 "ext_register_operand" "")
			   (const_int 8)
			   (const_int 8))
	  (xor:SI 
	    (zero_extract:SI (match_dup 1) (const_int 8) (const_int 8))
	    (match_dup 2)))])]
  ""
  "")

(define_split
  [(set (match_operand 0 "register_operand" "")
	(xor (match_operand 1 "register_operand" "")
	     (match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC 17))]
   "reload_completed
    && QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_size)
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (zero_extract:SI (match_dup 0) (const_int 8) (const_int 8))
		   (xor:SI (zero_extract:SI (match_dup 1)
					    (const_int 8) (const_int 8))
			   (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);
   operands[2] = gen_int_mode ((INTVAL (operands[2]) >> 8) & 0xff, SImode);")

;; Since XOR can be encoded with sign extended immediate, this is only
;; profitable when 7th bit is set.
(define_split
  [(set (match_operand 0 "register_operand" "")
	(xor (match_operand 1 "general_operand" "")
	     (match_operand 2 "const_int_operand" "")))
   (clobber (reg:CC 17))]
   "reload_completed
    && ANY_QI_REG_P (operands[0])
    && (!TARGET_PARTIAL_REG_STALL || optimize_size)
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && GET_MODE (operands[0]) != QImode"
  [(parallel [(set (strict_low_part (match_dup 0))
		   (xor:QI (match_dup 1)
			   (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (QImode, operands[0]);
   operands[1] = gen_lowpart (QImode, operands[1]);
   operands[2] = gen_lowpart (QImode, operands[2]);")

;; Negation instructions

(define_expand "negdi2"
  [(parallel [(set (match_operand:DI 0 "nonimmediate_operand" "")
		   (neg:DI (match_operand:DI 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
  "ix86_expand_unary_operator (NEG, DImode, operands); DONE;")

(define_insn "*negdi2_1"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=ro")
	(neg:DI (match_operand:DI 1 "general_operand" "0")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT
   && ix86_unary_operator_ok (NEG, DImode, operands)"
  "#")

(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(neg:DI (match_operand:DI 1 "general_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && reload_completed"
  [(parallel
    [(set (reg:CCZ 17)
	  (compare:CCZ (neg:SI (match_dup 2)) (const_int 0)))
     (set (match_dup 0) (neg:SI (match_dup 2)))])
   (parallel
    [(set (match_dup 1)
	  (plus:SI (plus:SI (ltu:SI (reg:CC 17) (const_int 0))
			    (match_dup 3))
		   (const_int 0)))
     (clobber (reg:CC 17))])
   (parallel
    [(set (match_dup 1)
	  (neg:SI (match_dup 1)))
     (clobber (reg:CC 17))])]
  "split_di (operands+1, 1, operands+2, operands+3);
   split_di (operands+0, 1, operands+0, operands+1);")

(define_insn "*negdi2_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(neg:DI (match_operand:DI 1 "nonimmediate_operand" "0")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_unary_operator_ok (NEG, DImode, operands)"
  "neg{q}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "DI")])

;; The problem with neg is that it does not perform (compare x 0),
;; it really performs (compare 0 x), which leaves us with the zero
;; flag being the only useful item.

(define_insn "*negdi2_cmpz_rex64"
  [(set (reg:CCZ 17)
	(compare:CCZ (neg:DI (match_operand:DI 1 "nonimmediate_operand" "0"))
		     (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(neg:DI (match_dup 1)))]
  "TARGET_64BIT && ix86_unary_operator_ok (NEG, DImode, operands)"
  "neg{q}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "DI")])


(define_expand "negsi2"
  [(parallel [(set (match_operand:SI 0 "nonimmediate_operand" "")
		   (neg:SI (match_operand:SI 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
  "ix86_expand_unary_operator (NEG, SImode, operands); DONE;")

(define_insn "*negsi2_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(neg:SI (match_operand:SI 1 "nonimmediate_operand" "0")))
   (clobber (reg:CC 17))]
  "ix86_unary_operator_ok (NEG, SImode, operands)"
  "neg{l}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])

;; Combine is quite creative about this pattern.
(define_insn "*negsi2_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI (neg:DI (ashift:DI (match_operand:DI 1 "register_operand" "0")
					(const_int 32)))
		     (const_int 32)))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_unary_operator_ok (NEG, SImode, operands)"
  "neg{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])

;; The problem with neg is that it does not perform (compare x 0),
;; it really performs (compare 0 x), which leaves us with the zero
;; flag being the only useful item.

(define_insn "*negsi2_cmpz"
  [(set (reg:CCZ 17)
	(compare:CCZ (neg:SI (match_operand:SI 1 "nonimmediate_operand" "0"))
		     (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(neg:SI (match_dup 1)))]
  "ix86_unary_operator_ok (NEG, SImode, operands)"
  "neg{l}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])

(define_insn "*negsi2_cmpz_zext"
  [(set (reg:CCZ 17)
	(compare:CCZ (lshiftrt:DI
		       (neg:DI (ashift:DI
				 (match_operand:DI 1 "register_operand" "0")
				 (const_int 32)))
		       (const_int 32))
		     (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI (neg:DI (ashift:DI (match_dup 1)
					(const_int 32)))
		     (const_int 32)))]
  "TARGET_64BIT && ix86_unary_operator_ok (NEG, SImode, operands)"
  "neg{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])

(define_expand "neghi2"
  [(parallel [(set (match_operand:HI 0 "nonimmediate_operand" "")
		   (neg:HI (match_operand:HI 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_HIMODE_MATH"
  "ix86_expand_unary_operator (NEG, HImode, operands); DONE;")

(define_insn "*neghi2_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(neg:HI (match_operand:HI 1 "nonimmediate_operand" "0")))
   (clobber (reg:CC 17))]
  "ix86_unary_operator_ok (NEG, HImode, operands)"
  "neg{w}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "HI")])

(define_insn "*neghi2_cmpz"
  [(set (reg:CCZ 17)
	(compare:CCZ (neg:HI (match_operand:HI 1 "nonimmediate_operand" "0"))
		     (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(neg:HI (match_dup 1)))]
  "ix86_unary_operator_ok (NEG, HImode, operands)"
  "neg{w}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "HI")])

(define_expand "negqi2"
  [(parallel [(set (match_operand:QI 0 "nonimmediate_operand" "")
		   (neg:QI (match_operand:QI 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_QIMODE_MATH"
  "ix86_expand_unary_operator (NEG, QImode, operands); DONE;")

(define_insn "*negqi2_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(neg:QI (match_operand:QI 1 "nonimmediate_operand" "0")))
   (clobber (reg:CC 17))]
  "ix86_unary_operator_ok (NEG, QImode, operands)"
  "neg{b}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "QI")])

(define_insn "*negqi2_cmpz"
  [(set (reg:CCZ 17)
	(compare:CCZ (neg:QI (match_operand:QI 1 "nonimmediate_operand" "0"))
		     (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(neg:QI (match_dup 1)))]
  "ix86_unary_operator_ok (NEG, QImode, operands)"
  "neg{b}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "QI")])

;; Changing of sign for FP values is doable using integer unit too.

(define_expand "negsf2"
  [(parallel [(set (match_operand:SF 0 "nonimmediate_operand" "")
		   (neg:SF (match_operand:SF 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_80387"
  "if (TARGET_SSE)
     {
       /* In case operand is in memory,  we will not use SSE.  */
       if (memory_operand (operands[0], VOIDmode)
	   && rtx_equal_p (operands[0], operands[1]))
	 emit_insn (gen_negsf2_memory (operands[0], operands[1]));
       else
	{
	  /* Using SSE is tricky, since we need bitwise negation of -0
	     in register.  */
	  rtx reg = gen_reg_rtx (SFmode);
	  rtx dest = operands[0];
	  rtx imm = gen_lowpart (SFmode, gen_int_mode (0x80000000, SImode));

	  operands[1] = force_reg (SFmode, operands[1]);
	  operands[0] = force_reg (SFmode, operands[0]);
	  reg = force_reg (V4SFmode,
			   gen_rtx_CONST_VECTOR (V4SFmode,
			     gen_rtvec (4, imm, CONST0_RTX (SFmode),
					CONST0_RTX (SFmode),
					CONST0_RTX (SFmode))));
	  emit_insn (gen_negsf2_ifs (operands[0], operands[1], reg));
	  if (dest != operands[0])
	    emit_move_insn (dest, operands[0]);
	}
       DONE;
     }
   ix86_expand_unary_operator (NEG, SFmode, operands); DONE;")

(define_insn "negsf2_memory"
  [(set (match_operand:SF 0 "memory_operand" "=m")
	(neg:SF (match_operand:SF 1 "memory_operand" "0")))
   (clobber (reg:CC 17))]
  "ix86_unary_operator_ok (NEG, SFmode, operands)"
  "#")

(define_insn "negsf2_ifs"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=x#fr,x#fr,f#xr,rm#xf")
	(neg:SF (match_operand:SF 1 "nonimmediate_operand" "0,x#fr,0,0")))
   (use (match_operand:V4SF 2 "nonimmediate_operand" "xm,0,xm*r,xm*r"))
   (clobber (reg:CC 17))]
  "TARGET_SSE
   && (reload_in_progress || reload_completed
       || (register_operand (operands[0], VOIDmode)
	   && register_operand (operands[1], VOIDmode)))"
  "#")

(define_split
  [(set (match_operand:SF 0 "memory_operand" "")
	(neg:SF (match_operand:SF 1 "memory_operand" "")))
   (use (match_operand:SF 2 "" ""))
   (clobber (reg:CC 17))]
  ""
  [(parallel [(set (match_dup 0)
		   (neg:SF (match_dup 1)))
	      (clobber (reg:CC 17))])])

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(neg:SF (match_operand:SF 1 "register_operand" "")))
   (use (match_operand:V4SF 2 "" ""))
   (clobber (reg:CC 17))]
  "reload_completed && !SSE_REG_P (operands[0])"
  [(parallel [(set (match_dup 0)
		   (neg:SF (match_dup 1)))
	      (clobber (reg:CC 17))])])

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(neg:SF (match_operand:SF 1 "register_operand" "")))
   (use (match_operand:V4SF 2 "nonimmediate_operand" ""))
   (clobber (reg:CC 17))]
  "reload_completed && SSE_REG_P (operands[0])"
  [(set (subreg:TI (match_dup 0) 0)
	(xor:TI (match_dup 1)
		(match_dup 2)))]
{
  operands[1] = simplify_gen_subreg (TImode, operands[1], SFmode, 0);
  operands[2] = simplify_gen_subreg (TImode, operands[2], V4SFmode, 0);
  if (operands_match_p (operands[0], operands[2]))
    {
      rtx tmp;
      tmp = operands[1];
      operands[1] = operands[2];
      operands[2] = tmp;
    }
})


;; Keep 'f' and 'r' in separate alternatives to avoid reload problems
;; because of secondary memory needed to reload from class FLOAT_INT_REGS
;; to itself.
(define_insn "*negsf2_if"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=f#r,rm#f")
	(neg:SF (match_operand:SF 1 "nonimmediate_operand" "0,0")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && !TARGET_SSE
   && ix86_unary_operator_ok (NEG, SFmode, operands)"
  "#")

(define_split
  [(set (match_operand:SF 0 "fp_register_operand" "")
	(neg:SF (match_operand:SF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 0)
	(neg:SF (match_dup 1)))]
  "")

(define_split
  [(set (match_operand:SF 0 "register_and_not_fp_reg_operand" "")
	(neg:SF (match_operand:SF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(parallel [(set (match_dup 0) (xor:SI (match_dup 0) (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "operands[1] = gen_int_mode (0x80000000, SImode);
   operands[0] = gen_lowpart (SImode, operands[0]);")

(define_split
  [(set (match_operand 0 "memory_operand" "")
	(neg (match_operand 1 "memory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed && FLOAT_MODE_P (GET_MODE (operands[0]))"
  [(parallel [(set (match_dup 0) (xor:QI (match_dup 0) (match_dup 1)))
	      (clobber (reg:CC 17))])]
{
  int size = GET_MODE_SIZE (GET_MODE (operands[1]));

  if (GET_MODE (operands[1]) == XFmode)
    size = 10;
  operands[0] = adjust_address (operands[0], QImode, size - 1);
  operands[1] = gen_int_mode (0x80, QImode);
})

(define_expand "negdf2"
  [(parallel [(set (match_operand:DF 0 "nonimmediate_operand" "")
		   (neg:DF (match_operand:DF 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_80387"
  "if (TARGET_SSE2)
     {
       /* In case operand is in memory,  we will not use SSE.  */
       if (memory_operand (operands[0], VOIDmode)
	   && rtx_equal_p (operands[0], operands[1]))
	 emit_insn (gen_negdf2_memory (operands[0], operands[1]));
       else
	{
	  /* Using SSE is tricky, since we need bitwise negation of -0
	     in register.  */
	  rtx reg;
#if HOST_BITS_PER_WIDE_INT >= 64
	  rtx imm = gen_int_mode (((HOST_WIDE_INT)1) << 63, DImode);
#else
	  rtx imm = immed_double_const (0, 0x80000000, DImode);
#endif
	  rtx dest = operands[0];

	  operands[1] = force_reg (DFmode, operands[1]);
	  operands[0] = force_reg (DFmode, operands[0]);
	  imm = gen_lowpart (DFmode, imm);
	  reg = force_reg (V2DFmode,
			   gen_rtx_CONST_VECTOR (V2DFmode,
			     gen_rtvec (2, imm, CONST0_RTX (DFmode))));
	  emit_insn (gen_negdf2_ifs (operands[0], operands[1], reg));
	  if (dest != operands[0])
	    emit_move_insn (dest, operands[0]);
	}
       DONE;
     }
   ix86_expand_unary_operator (NEG, DFmode, operands); DONE;")

(define_insn "negdf2_memory"
  [(set (match_operand:DF 0 "memory_operand" "=m")
	(neg:DF (match_operand:DF 1 "memory_operand" "0")))
   (clobber (reg:CC 17))]
  "ix86_unary_operator_ok (NEG, DFmode, operands)"
  "#")

(define_insn "negdf2_ifs"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=Y#fr,Y#fr,f#Yr,rm#Yf")
	(neg:DF (match_operand:DF 1 "nonimmediate_operand" "0,Y#fr,0,0")))
   (use (match_operand:V2DF 2 "nonimmediate_operand" "Ym,0,Ym*r,Ym*r"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_SSE2
   && (reload_in_progress || reload_completed
       || (register_operand (operands[0], VOIDmode)
	   && register_operand (operands[1], VOIDmode)))"
  "#")

(define_insn "*negdf2_ifs_rex64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=Y#f,Y#f,fm#Y")
	(neg:DF (match_operand:DF 1 "nonimmediate_operand" "0,Y#fr,0")))
   (use (match_operand:V2DF 2 "nonimmediate_operand" "Ym,0,Ym*r"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && TARGET_SSE2
   && (reload_in_progress || reload_completed
       || (register_operand (operands[0], VOIDmode)
	   && register_operand (operands[1], VOIDmode)))"
  "#")

(define_split
  [(set (match_operand:DF 0 "memory_operand" "")
	(neg:DF (match_operand:DF 1 "memory_operand" "")))
   (use (match_operand:V2DF 2 "" ""))
   (clobber (reg:CC 17))]
  ""
  [(parallel [(set (match_dup 0)
		   (neg:DF (match_dup 1)))
	      (clobber (reg:CC 17))])])

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(neg:DF (match_operand:DF 1 "register_operand" "")))
   (use (match_operand:V2DF 2 "" ""))
   (clobber (reg:CC 17))]
  "reload_completed && !SSE_REG_P (operands[0])
   && (!TARGET_64BIT || FP_REG_P (operands[0]))"
  [(parallel [(set (match_dup 0)
		   (neg:DF (match_dup 1)))
	      (clobber (reg:CC 17))])])

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(neg:DF (match_operand:DF 1 "register_operand" "")))
   (use (match_operand:V2DF 2 "" ""))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && reload_completed && GENERAL_REG_P (operands[0])"
  [(parallel [(set (match_dup 0)
		   (xor:DI (match_dup 1) (match_dup 2)))
	      (clobber (reg:CC 17))])]
   "operands[0] = gen_lowpart (DImode, operands[0]);
    operands[1] = gen_lowpart (DImode, operands[1]);
    operands[2] = gen_lowpart (DImode, operands[2]);")

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(neg:DF (match_operand:DF 1 "register_operand" "")))
   (use (match_operand:V2DF 2 "nonimmediate_operand" ""))
   (clobber (reg:CC 17))]
  "reload_completed && SSE_REG_P (operands[0])"
  [(set (subreg:TI (match_dup 0) 0)
	(xor:TI (match_dup 1)
		(match_dup 2)))]
{
  operands[0] = simplify_gen_subreg (V2DFmode, operands[0], DFmode, 0);
  operands[1] = simplify_gen_subreg (TImode, operands[1], DFmode, 0);
  operands[2] = simplify_gen_subreg (TImode, operands[2], V2DFmode, 0);
  /* Avoid possible reformatting on the operands.  */
  if (TARGET_SSE_PARTIAL_REGS && !optimize_size)
    emit_insn (gen_sse2_unpcklpd (operands[0], operands[0], operands[0]));
  if (operands_match_p (operands[0], operands[2]))
    {
      rtx tmp;
      tmp = operands[1];
      operands[1] = operands[2];
      operands[2] = tmp;
    }
})

;; Keep 'f' and 'r' in separate alternatives to avoid reload problems
;; because of secondary memory needed to reload from class FLOAT_INT_REGS
;; to itself.
(define_insn "*negdf2_if"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f#r,rm#f")
	(neg:DF (match_operand:DF 1 "nonimmediate_operand" "0,0")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_80387
   && ix86_unary_operator_ok (NEG, DFmode, operands)"
  "#")

;; FIXME: We should to allow integer registers here.  Problem is that
;; we need another scratch register to get constant from.
;; Forcing constant to mem if no register available in peep2 should be
;; safe even for PIC mode, because of RIP relative addressing.
(define_insn "*negdf2_if_rex64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f,mf")
	(neg:DF (match_operand:DF 1 "nonimmediate_operand" "0,0")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && TARGET_80387
   && ix86_unary_operator_ok (NEG, DFmode, operands)"
  "#")

(define_split
  [(set (match_operand:DF 0 "fp_register_operand" "")
	(neg:DF (match_operand:DF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 0)
	(neg:DF (match_dup 1)))]
  "")

(define_split
  [(set (match_operand:DF 0 "register_and_not_fp_reg_operand" "")
	(neg:DF (match_operand:DF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_80387 && reload_completed"
  [(parallel [(set (match_dup 3) (xor:SI (match_dup 3) (match_dup 4)))
	      (clobber (reg:CC 17))])]
  "operands[4] = gen_int_mode (0x80000000, SImode);
   split_di (operands+0, 1, operands+2, operands+3);")

(define_expand "negxf2"
  [(parallel [(set (match_operand:XF 0 "nonimmediate_operand" "")
		   (neg:XF (match_operand:XF 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_80387"
  "ix86_expand_unary_operator (NEG, XFmode, operands); DONE;")

;; Keep 'f' and 'r' in separate alternatives to avoid reload problems
;; because of secondary memory needed to reload from class FLOAT_INT_REGS
;; to itself.
(define_insn "*negxf2_if"
  [(set (match_operand:XF 0 "nonimmediate_operand" "=f#r,rm#f")
	(neg:XF (match_operand:XF 1 "nonimmediate_operand" "0,0")))
   (clobber (reg:CC 17))]
  "TARGET_80387
   && ix86_unary_operator_ok (NEG, XFmode, operands)"
  "#")

(define_split
  [(set (match_operand:XF 0 "fp_register_operand" "")
	(neg:XF (match_operand:XF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 0)
	(neg:XF (match_dup 1)))]
  "")

(define_split
  [(set (match_operand:XF 0 "register_and_not_fp_reg_operand" "")
	(neg:XF (match_operand:XF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(parallel [(set (match_dup 0) (xor:SI (match_dup 0) (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "operands[1] = GEN_INT (0x8000);
   operands[0] = gen_rtx_REG (SImode,
			      true_regnum (operands[0]) + (TARGET_64BIT ? 1 : 2));")

;; Conditionalize these after reload. If they matches before reload, we 
;; lose the clobber and ability to use integer instructions.

(define_insn "*negsf2_1"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(neg:SF (match_operand:SF 1 "register_operand" "0")))]
  "TARGET_80387 && reload_completed"
  "fchs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "SF")
   (set_attr "ppro_uops" "few")])

(define_insn "*negdf2_1"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(neg:DF (match_operand:DF 1 "register_operand" "0")))]
  "TARGET_80387 && reload_completed"
  "fchs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "DF")
   (set_attr "ppro_uops" "few")])

(define_insn "*negextendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(neg:DF (float_extend:DF
		  (match_operand:SF 1 "register_operand" "0"))))]
  "TARGET_80387"
  "fchs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "DF")
   (set_attr "ppro_uops" "few")])

(define_insn "*negxf2_1"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(neg:XF (match_operand:XF 1 "register_operand" "0")))]
  "TARGET_80387 && reload_completed"
  "fchs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "XF")
   (set_attr "ppro_uops" "few")])

(define_insn "*negextenddfxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(neg:XF (float_extend:XF
		  (match_operand:DF 1 "register_operand" "0"))))]
  "TARGET_80387"
  "fchs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "XF")
   (set_attr "ppro_uops" "few")])

(define_insn "*negextendsfxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(neg:XF (float_extend:XF
		  (match_operand:SF 1 "register_operand" "0"))))]
  "TARGET_80387"
  "fchs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "XF")
   (set_attr "ppro_uops" "few")])

;; Absolute value instructions

(define_expand "abssf2"
  [(parallel [(set (match_operand:SF 0 "nonimmediate_operand" "")
		   (neg:SF (match_operand:SF 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_80387"
  "if (TARGET_SSE)
     {
       /* In case operand is in memory,  we will not use SSE.  */
       if (memory_operand (operands[0], VOIDmode)
	   && rtx_equal_p (operands[0], operands[1]))
	 emit_insn (gen_abssf2_memory (operands[0], operands[1]));
       else
	{
	  /* Using SSE is tricky, since we need bitwise negation of -0
	     in register.  */
	  rtx reg = gen_reg_rtx (V4SFmode);
	  rtx dest = operands[0];
	  rtx imm;

	  operands[1] = force_reg (SFmode, operands[1]);
	  operands[0] = force_reg (SFmode, operands[0]);
	  imm = gen_lowpart (SFmode, gen_int_mode(~0x80000000, SImode));
	  reg = force_reg (V4SFmode,
			   gen_rtx_CONST_VECTOR (V4SFmode,
			   gen_rtvec (4, imm, CONST0_RTX (SFmode),
				      CONST0_RTX (SFmode),
				      CONST0_RTX (SFmode))));
	  emit_insn (gen_abssf2_ifs (operands[0], operands[1], reg));
	  if (dest != operands[0])
	    emit_move_insn (dest, operands[0]);
	}
       DONE;
     }
   ix86_expand_unary_operator (ABS, SFmode, operands); DONE;")

(define_insn "abssf2_memory"
  [(set (match_operand:SF 0 "memory_operand" "=m")
	(abs:SF (match_operand:SF 1 "memory_operand" "0")))
   (clobber (reg:CC 17))]
  "ix86_unary_operator_ok (ABS, SFmode, operands)"
  "#")

(define_insn "abssf2_ifs"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=x#fr,x#fr,f#xr,rm#xf")
	(abs:SF (match_operand:SF 1 "nonimmediate_operand" "0,x#fr,0,0")))
   (use (match_operand:V4SF 2 "nonimmediate_operand" "xm,0,xm*r,xm*r"))
   (clobber (reg:CC 17))]
  "TARGET_SSE
   && (reload_in_progress || reload_completed
       || (register_operand (operands[0], VOIDmode)
	    && register_operand (operands[1], VOIDmode)))"
  "#")

(define_split
  [(set (match_operand:SF 0 "memory_operand" "")
	(abs:SF (match_operand:SF 1 "memory_operand" "")))
   (use (match_operand:V4SF 2 "" ""))
   (clobber (reg:CC 17))]
  ""
  [(parallel [(set (match_dup 0)
		   (abs:SF (match_dup 1)))
	      (clobber (reg:CC 17))])])

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(abs:SF (match_operand:SF 1 "register_operand" "")))
   (use (match_operand:V4SF 2 "" ""))
   (clobber (reg:CC 17))]
  "reload_completed && !SSE_REG_P (operands[0])"
  [(parallel [(set (match_dup 0)
		   (abs:SF (match_dup 1)))
	      (clobber (reg:CC 17))])])

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(abs:SF (match_operand:SF 1 "register_operand" "")))
   (use (match_operand:V4SF 2 "nonimmediate_operand" ""))
   (clobber (reg:CC 17))]
  "reload_completed && SSE_REG_P (operands[0])"
  [(set (subreg:TI (match_dup 0) 0)
	(and:TI (match_dup 1)
		(match_dup 2)))]
{
  operands[1] = simplify_gen_subreg (TImode, operands[1], SFmode, 0);
  operands[2] = simplify_gen_subreg (TImode, operands[2], V4SFmode, 0);
  if (operands_match_p (operands[0], operands[2]))
    {
      rtx tmp;
      tmp = operands[1];
      operands[1] = operands[2];
      operands[2] = tmp;
    }
})

;; Keep 'f' and 'r' in separate alternatives to avoid reload problems
;; because of secondary memory needed to reload from class FLOAT_INT_REGS
;; to itself.
(define_insn "*abssf2_if"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=f#r,rm#f")
	(abs:SF (match_operand:SF 1 "nonimmediate_operand" "0,0")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && ix86_unary_operator_ok (ABS, SFmode, operands) && !TARGET_SSE"
  "#")

(define_split
  [(set (match_operand:SF 0 "fp_register_operand" "")
	(abs:SF (match_operand:SF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 0)
	(abs:SF (match_dup 1)))]
  "")

(define_split
  [(set (match_operand:SF 0 "register_and_not_fp_reg_operand" "")
	(abs:SF (match_operand:SF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(parallel [(set (match_dup 0) (and:SI (match_dup 0) (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "operands[1] = gen_int_mode (~0x80000000, SImode);
   operands[0] = gen_lowpart (SImode, operands[0]);")

(define_split
  [(set (match_operand 0 "memory_operand" "")
	(abs (match_operand 1 "memory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed && FLOAT_MODE_P (GET_MODE (operands[0]))"
  [(parallel [(set (match_dup 0) (and:QI (match_dup 0) (match_dup 1)))
	      (clobber (reg:CC 17))])]
{
  int size = GET_MODE_SIZE (GET_MODE (operands[1]));

  if (GET_MODE (operands[1]) == XFmode)
    size = 10;
  operands[0] = adjust_address (operands[0], QImode, size - 1);
  operands[1] = gen_int_mode (~0x80, QImode);
})

(define_expand "absdf2"
  [(parallel [(set (match_operand:DF 0 "nonimmediate_operand" "")
		   (neg:DF (match_operand:DF 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_80387"
  "if (TARGET_SSE2)
     {
       /* In case operand is in memory,  we will not use SSE.  */
       if (memory_operand (operands[0], VOIDmode)
	   && rtx_equal_p (operands[0], operands[1]))
	 emit_insn (gen_absdf2_memory (operands[0], operands[1]));
       else
	{
	  /* Using SSE is tricky, since we need bitwise negation of -0
	     in register.  */
	  rtx reg = gen_reg_rtx (V2DFmode);
#if HOST_BITS_PER_WIDE_INT >= 64
	  rtx imm = gen_int_mode (~(((HOST_WIDE_INT)1) << 63), DImode);
#else
	  rtx imm = immed_double_const (~0, ~0x80000000, DImode);
#endif
	  rtx dest = operands[0];

	  operands[1] = force_reg (DFmode, operands[1]);
	  operands[0] = force_reg (DFmode, operands[0]);

	  /* Produce LONG_DOUBLE with the proper immediate argument.  */
	  imm = gen_lowpart (DFmode, imm);
	  reg = force_reg (V2DFmode,
			   gen_rtx_CONST_VECTOR (V2DFmode,
			   gen_rtvec (2, imm, CONST0_RTX (DFmode))));
	  emit_insn (gen_absdf2_ifs (operands[0], operands[1], reg));
	  if (dest != operands[0])
	    emit_move_insn (dest, operands[0]);
	}
       DONE;
     }
   ix86_expand_unary_operator (ABS, DFmode, operands); DONE;")

(define_insn "absdf2_memory"
  [(set (match_operand:DF 0 "memory_operand" "=m")
	(abs:DF (match_operand:DF 1 "memory_operand" "0")))
   (clobber (reg:CC 17))]
  "ix86_unary_operator_ok (ABS, DFmode, operands)"
  "#")

(define_insn "absdf2_ifs"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=Y#fr,Y#fr,mf#Yr,mr#Yf")
	(abs:DF (match_operand:DF 1 "nonimmediate_operand" "0,Y#fr,0,0")))
   (use (match_operand:V2DF 2 "nonimmediate_operand" "Ym,0,Ym*r,Ym*r"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_SSE2
   && (reload_in_progress || reload_completed
       || (register_operand (operands[0], VOIDmode)
	   && register_operand (operands[1], VOIDmode)))"
  "#")

(define_insn "*absdf2_ifs_rex64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=Y#fr,Y#fr,mf#Yr")
	(abs:DF (match_operand:DF 1 "nonimmediate_operand" "0,Y#fr,0")))
   (use (match_operand:V2DF 2 "nonimmediate_operand" "Ym,0,Ym*r"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && TARGET_SSE2
   && (reload_in_progress || reload_completed
       || (register_operand (operands[0], VOIDmode)
	   && register_operand (operands[1], VOIDmode)))"
  "#")

(define_split
  [(set (match_operand:DF 0 "memory_operand" "")
	(abs:DF (match_operand:DF 1 "memory_operand" "")))
   (use (match_operand:V2DF 2 "" ""))
   (clobber (reg:CC 17))]
  ""
  [(parallel [(set (match_dup 0)
		   (abs:DF (match_dup 1)))
	      (clobber (reg:CC 17))])])

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(abs:DF (match_operand:DF 1 "register_operand" "")))
   (use (match_operand:V2DF 2 "" ""))
   (clobber (reg:CC 17))]
  "reload_completed && !SSE_REG_P (operands[0])"
  [(parallel [(set (match_dup 0)
		   (abs:DF (match_dup 1)))
	      (clobber (reg:CC 17))])])

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(abs:DF (match_operand:DF 1 "register_operand" "")))
   (use (match_operand:V2DF 2 "nonimmediate_operand" ""))
   (clobber (reg:CC 17))]
  "reload_completed && SSE_REG_P (operands[0])"
  [(set (subreg:TI (match_dup 0) 0)
	(and:TI (match_dup 1)
		(match_dup 2)))]
{
  operands[0] = simplify_gen_subreg (V2DFmode, operands[0], DFmode, 0);
  operands[1] = simplify_gen_subreg (TImode, operands[1], DFmode, 0);
  operands[2] = simplify_gen_subreg (TImode, operands[2], V2DFmode, 0);
  /* Avoid possible reformatting on the operands.  */
  if (TARGET_SSE_PARTIAL_REGS && !optimize_size)
    emit_insn (gen_sse2_unpcklpd (operands[0], operands[0], operands[0]));
  if (operands_match_p (operands[0], operands[2]))
    {
      rtx tmp;
      tmp = operands[1];
      operands[1] = operands[2];
      operands[2] = tmp;
    }
})


;; Keep 'f' and 'r' in separate alternatives to avoid reload problems
;; because of secondary memory needed to reload from class FLOAT_INT_REGS
;; to itself.
(define_insn "*absdf2_if"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f#r,rm#f")
	(abs:DF (match_operand:DF 1 "nonimmediate_operand" "0,0")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_80387
   && ix86_unary_operator_ok (ABS, DFmode, operands)"
  "#")

;; FIXME: We should to allow integer registers here.  Problem is that
;; we need another scratch register to get constant from.
;; Forcing constant to mem if no register available in peep2 should be
;; safe even for PIC mode, because of RIP relative addressing.
(define_insn "*absdf2_if_rex64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=f,mf")
	(abs:DF (match_operand:DF 1 "nonimmediate_operand" "0,0")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && TARGET_80387
   && ix86_unary_operator_ok (ABS, DFmode, operands)"
  "#")

(define_split
  [(set (match_operand:DF 0 "fp_register_operand" "")
	(abs:DF (match_operand:DF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 0)
	(abs:DF (match_dup 1)))]
  "")

(define_split
  [(set (match_operand:DF 0 "register_and_not_fp_reg_operand" "")
	(abs:DF (match_operand:DF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_80387 && reload_completed"
  [(parallel [(set (match_dup 3) (and:SI (match_dup 3) (match_dup 4)))
	      (clobber (reg:CC 17))])]
  "operands[4] = gen_int_mode (~0x80000000, SImode);
   split_di (operands+0, 1, operands+2, operands+3);")

(define_expand "absxf2"
  [(parallel [(set (match_operand:XF 0 "nonimmediate_operand" "")
		   (neg:XF (match_operand:XF 1 "nonimmediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_80387"
  "ix86_expand_unary_operator (ABS, XFmode, operands); DONE;")

;; Keep 'f' and 'r' in separate alternatives to avoid reload problems
;; because of secondary memory needed to reload from class FLOAT_INT_REGS
;; to itself.
(define_insn "*absxf2_if"
  [(set (match_operand:XF 0 "nonimmediate_operand" "=f#r,rm#f")
	(abs:XF (match_operand:XF 1 "nonimmediate_operand" "0,0")))
   (clobber (reg:CC 17))]
  "TARGET_80387
   && ix86_unary_operator_ok (ABS, XFmode, operands)"
  "#")

(define_split
  [(set (match_operand:XF 0 "fp_register_operand" "")
	(abs:XF (match_operand:XF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(set (match_dup 0)
	(abs:XF (match_dup 1)))]
  "")

(define_split
  [(set (match_operand:XF 0 "register_and_not_fp_reg_operand" "")
	(abs:XF (match_operand:XF 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_80387 && reload_completed"
  [(parallel [(set (match_dup 0) (and:SI (match_dup 0) (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "operands[1] = GEN_INT (~0x8000);
   operands[0] = gen_rtx_REG (SImode,
			      true_regnum (operands[0]) + (TARGET_64BIT ? 1 : 2));")

(define_insn "*abssf2_1"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(abs:SF (match_operand:SF 1 "register_operand" "0")))]
  "TARGET_80387 && reload_completed"
  "fabs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "SF")])

(define_insn "*absdf2_1"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(abs:DF (match_operand:DF 1 "register_operand" "0")))]
  "TARGET_80387 && reload_completed"
  "fabs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "DF")])

(define_insn "*absextendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(abs:DF (float_extend:DF
		  (match_operand:SF 1 "register_operand" "0"))))]
  "TARGET_80387"
  "fabs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "DF")])

(define_insn "*absxf2_1"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(abs:XF (match_operand:XF 1 "register_operand" "0")))]
  "TARGET_80387 && reload_completed"
  "fabs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "DF")])

(define_insn "*absextenddfxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(abs:XF (float_extend:XF
	  (match_operand:DF 1 "register_operand" "0"))))]
  "TARGET_80387"
  "fabs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "XF")])

(define_insn "*absextendsfxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(abs:XF (float_extend:XF
	  (match_operand:SF 1 "register_operand" "0"))))]
  "TARGET_80387"
  "fabs"
  [(set_attr "type" "fsgn")
   (set_attr "mode" "XF")])

;; One complement instructions

(define_expand "one_cmpldi2"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(not:DI (match_operand:DI 1 "nonimmediate_operand" "")))]
  "TARGET_64BIT"
  "ix86_expand_unary_operator (NOT, DImode, operands); DONE;")

(define_insn "*one_cmpldi2_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(not:DI (match_operand:DI 1 "nonimmediate_operand" "0")))]
  "TARGET_64BIT && ix86_unary_operator_ok (NOT, DImode, operands)"
  "not{q}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "DI")])

(define_insn "*one_cmpldi2_2_rex64"
  [(set (reg 17)
	(compare (not:DI (match_operand:DI 1 "nonimmediate_operand" "0"))
		 (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(not:DI (match_dup 1)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NOT, DImode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "DI")])

(define_split
  [(set (reg 17)
	(compare (not:DI (match_operand:DI 1 "nonimmediate_operand" ""))
		 (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "")
	(not:DI (match_dup 1)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (reg:CCNO 17)
		   (compare:CCNO (xor:DI (match_dup 1) (const_int -1))
				 (const_int 0)))
	      (set (match_dup 0)
		   (xor:DI (match_dup 1) (const_int -1)))])]
  "")

(define_expand "one_cmplsi2"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(not:SI (match_operand:SI 1 "nonimmediate_operand" "")))]
  ""
  "ix86_expand_unary_operator (NOT, SImode, operands); DONE;")

(define_insn "*one_cmplsi2_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(not:SI (match_operand:SI 1 "nonimmediate_operand" "0")))]
  "ix86_unary_operator_ok (NOT, SImode, operands)"
  "not{l}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])

;; ??? Currently never generated - xor is used instead.
(define_insn "*one_cmplsi2_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (not:SI (match_operand:SI 1 "register_operand" "0"))))]
  "TARGET_64BIT && ix86_unary_operator_ok (NOT, SImode, operands)"
  "not{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "SI")])

(define_insn "*one_cmplsi2_2"
  [(set (reg 17)
	(compare (not:SI (match_operand:SI 1 "nonimmediate_operand" "0"))
		 (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(not:SI (match_dup 1)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NOT, SImode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")])

(define_split
  [(set (reg 17)
	(compare (not:SI (match_operand:SI 1 "nonimmediate_operand" ""))
		 (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "")
	(not:SI (match_dup 1)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (reg:CCNO 17)
		   (compare:CCNO (xor:SI (match_dup 1) (const_int -1))
				 (const_int 0)))
	      (set (match_dup 0)
		   (xor:SI (match_dup 1) (const_int -1)))])]
  "")

;; ??? Currently never generated - xor is used instead.
(define_insn "*one_cmplsi2_2_zext"
  [(set (reg 17)
	(compare (not:SI (match_operand:SI 1 "register_operand" "0"))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (not:SI (match_dup 1))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NOT, SImode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "SI")])

(define_split
  [(set (reg 17)
	(compare (not:SI (match_operand:SI 1 "register_operand" ""))
		 (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "")
	(zero_extend:DI (not:SI (match_dup 1))))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (reg:CCNO 17)
		   (compare:CCNO (xor:SI (match_dup 1) (const_int -1))
				 (const_int 0)))
	      (set (match_dup 0)
		   (zero_extend:DI (xor:SI (match_dup 1) (const_int -1))))])]
  "")

(define_expand "one_cmplhi2"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(not:HI (match_operand:HI 1 "nonimmediate_operand" "")))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_unary_operator (NOT, HImode, operands); DONE;")

(define_insn "*one_cmplhi2_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(not:HI (match_operand:HI 1 "nonimmediate_operand" "0")))]
  "ix86_unary_operator_ok (NOT, HImode, operands)"
  "not{w}\t%0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "HI")])

(define_insn "*one_cmplhi2_2"
  [(set (reg 17)
	(compare (not:HI (match_operand:HI 1 "nonimmediate_operand" "0"))
		 (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(not:HI (match_dup 1)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NEG, HImode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "HI")])

(define_split
  [(set (reg 17)
	(compare (not:HI (match_operand:HI 1 "nonimmediate_operand" ""))
		 (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "")
	(not:HI (match_dup 1)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (reg:CCNO 17)
		   (compare:CCNO (xor:HI (match_dup 1) (const_int -1))
		      		 (const_int 0)))
	      (set (match_dup 0)
		   (xor:HI (match_dup 1) (const_int -1)))])]
  "")

;; %%% Potential partial reg stall on alternative 1.  What to do?
(define_expand "one_cmplqi2"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(not:QI (match_operand:QI 1 "nonimmediate_operand" "")))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_unary_operator (NOT, QImode, operands); DONE;")

(define_insn "*one_cmplqi2_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,r")
	(not:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")))]
  "ix86_unary_operator_ok (NOT, QImode, operands)"
  "@
   not{b}\t%0
   not{l}\t%k0"
  [(set_attr "type" "negnot")
   (set_attr "mode" "QI,SI")])

(define_insn "*one_cmplqi2_2"
  [(set (reg 17)
	(compare (not:QI (match_operand:QI 1 "nonimmediate_operand" "0"))
		 (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(not:QI (match_dup 1)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && ix86_unary_operator_ok (NOT, QImode, operands)"
  "#"
  [(set_attr "type" "alu1")
   (set_attr "mode" "QI")])

(define_split
  [(set (reg 17)
	(compare (not:QI (match_operand:QI 1 "nonimmediate_operand" ""))
		 (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "")
	(not:QI (match_dup 1)))]
  "ix86_match_ccmode (insn, CCNOmode)"
  [(parallel [(set (reg:CCNO 17)
		   (compare:CCNO (xor:QI (match_dup 1) (const_int -1))
		      		 (const_int 0)))
	      (set (match_dup 0)
		   (xor:QI (match_dup 1) (const_int -1)))])]
  "")

;; Arithmetic shift instructions

;; DImode shifts are implemented using the i386 "shift double" opcode,
;; which is written as "sh[lr]d[lw] imm,reg,reg/mem".  If the shift count
;; is variable, then the count is in %cl and the "imm" operand is dropped
;; from the assembler input.
;;
;; This instruction shifts the target reg/mem as usual, but instead of
;; shifting in zeros, bits are shifted in from reg operand.  If the insn
;; is a left shift double, bits are taken from the high order bits of
;; reg, else if the insn is a shift right double, bits are taken from the
;; low order bits of reg.  So if %eax is "1234" and %edx is "5678",
;; "shldl $8,%edx,%eax" leaves %edx unchanged and sets %eax to "2345".
;;
;; Since sh[lr]d does not change the `reg' operand, that is done
;; separately, making all shifts emit pairs of shift double and normal
;; shift.  Since sh[lr]d does not shift more than 31 bits, and we wish to
;; support a 63 bit shift, each shift where the count is in a reg expands
;; to a pair of shifts, a branch, a shift by 32 and a label.
;;
;; If the shift count is a constant, we need never emit more than one
;; shift pair, instead using moves and sign extension for counts greater
;; than 31.

(define_expand "ashldi3"
  [(parallel [(set (match_operand:DI 0 "shiftdi_operand" "")
		   (ashift:DI (match_operand:DI 1 "shiftdi_operand" "")
			      (match_operand:QI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
{
  if (!TARGET_64BIT && TARGET_CMOVE && ! immediate_operand (operands[2], QImode))
    {
      emit_insn (gen_ashldi3_1 (operands[0], operands[1], operands[2]));
      DONE;
    }
  ix86_expand_binary_operator (ASHIFT, DImode, operands);
  DONE;
})

(define_insn "*ashldi3_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,r")
	(ashift:DI (match_operand:DI 1 "nonimmediate_operand" "0,r")
		   (match_operand:QI 2 "nonmemory_operand" "cJ,M")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ASHIFT, DImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      if (!rtx_equal_p (operands[0], operands[1]))
	abort ();
      return "add{q}\t{%0, %0|%0, %0}";

    case TYPE_LEA:
      if (GET_CODE (operands[2]) != CONST_INT
	  || (unsigned HOST_WIDE_INT) INTVAL (operands[2]) > 3)
	abort ();
      operands[1] = gen_rtx_MULT (DImode, operands[1],
				  GEN_INT (1 << INTVAL (operands[2])));
      return "lea{q}\t{%a1, %0|%0, %a1}";

    default:
      if (REG_P (operands[2]))
	return "sal{q}\t{%b2, %0|%0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{q}\t%0";
      else
	return "sal{q}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "1")
	      (const_string "lea")
            (and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "DI")])

;; Convert lea to the lea pattern to avoid flags dependency.
(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(ashift:DI (match_operand:DI 1 "register_operand" "")
		   (match_operand:QI 2 "immediate_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && reload_completed
   && true_regnum (operands[0]) != true_regnum (operands[1])"
  [(set (match_dup 0)
	(mult:DI (match_dup 1)
		 (match_dup 2)))]
  "operands[2] = gen_int_mode (1 << INTVAL (operands[2]), DImode);")

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashldi3_cmp_rex64"
  [(set (reg 17)
	(compare
	  (ashift:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "immediate_operand" "e"))
	  (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(ashift:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFT, DImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      return "add{q}\t{%0, %0|%0, %0}";

    default:
      if (REG_P (operands[2]))
	return "sal{q}\t{%b2, %0|%0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{q}\t%0";
      else
	return "sal{q}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "DI")])

(define_insn "ashldi3_1"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(ashift:DI (match_operand:DI 1 "register_operand" "0")
		   (match_operand:QI 2 "nonmemory_operand" "Jc")))
   (clobber (match_scratch:SI 3 "=&r"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_CMOVE"
  "#"
  [(set_attr "type" "multi")])

(define_insn "*ashldi3_2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(ashift:DI (match_operand:DI 1 "register_operand" "0")
		   (match_operand:QI 2 "nonmemory_operand" "Jc")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT"
  "#"
  [(set_attr "type" "multi")])

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(ashift:DI (match_operand:DI 1 "register_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (match_scratch:SI 3 ""))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_CMOVE && reload_completed"
  [(const_int 0)]
  "ix86_split_ashldi (operands, operands[3]); DONE;")

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(ashift:DI (match_operand:DI 1 "register_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && reload_completed"
  [(const_int 0)]
  "ix86_split_ashldi (operands, NULL_RTX); DONE;")

(define_insn "x86_shld_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "+r*m,r*m")
        (ior:SI (ashift:SI (match_dup 0)
		  (match_operand:QI 2 "nonmemory_operand" "I,c"))
		(lshiftrt:SI (match_operand:SI 1 "register_operand" "r,r")
		  (minus:QI (const_int 32) (match_dup 2)))))
   (clobber (reg:CC 17))]
  ""
  "@
   shld{l}\t{%2, %1, %0|%0, %1, %2}
   shld{l}\t{%s2%1, %0|%0, %1, %2}"
  [(set_attr "type" "ishift")
   (set_attr "prefix_0f" "1")
   (set_attr "mode" "SI")
   (set_attr "pent_pair" "np")
   (set_attr "athlon_decode" "vector")
   (set_attr "ppro_uops" "few")])

(define_expand "x86_shift_adj_1"
  [(set (reg:CCZ 17)
	(compare:CCZ (and:QI (match_operand:QI 2 "register_operand" "")
			     (const_int 32))
		     (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "")
        (if_then_else:SI (ne (reg:CCZ 17) (const_int 0))
			 (match_operand:SI 1 "register_operand" "")
			 (match_dup 0)))
   (set (match_dup 1)
	(if_then_else:SI (ne (reg:CCZ 17) (const_int 0))
			 (match_operand:SI 3 "register_operand" "r")
			 (match_dup 1)))]
  "TARGET_CMOVE"
  "")

(define_expand "x86_shift_adj_2"
  [(use (match_operand:SI 0 "register_operand" ""))
   (use (match_operand:SI 1 "register_operand" ""))
   (use (match_operand:QI 2 "register_operand" ""))]
  ""
{
  rtx label = gen_label_rtx ();
  rtx tmp;

  emit_insn (gen_testqi_ccz_1 (operands[2], GEN_INT (32)));

  tmp = gen_rtx_REG (CCZmode, FLAGS_REG);
  tmp = gen_rtx_EQ (VOIDmode, tmp, const0_rtx);
  tmp = gen_rtx_IF_THEN_ELSE (VOIDmode, tmp,
			      gen_rtx_LABEL_REF (VOIDmode, label),
			      pc_rtx);
  tmp = emit_jump_insn (gen_rtx_SET (VOIDmode, pc_rtx, tmp));
  JUMP_LABEL (tmp) = label;

  emit_move_insn (operands[0], operands[1]);
  emit_move_insn (operands[1], const0_rtx);

  emit_label (label);
  LABEL_NUSES (label) = 1;

  DONE;
})

(define_expand "ashlsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(ashift:SI (match_operand:SI 1 "nonimmediate_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (ASHIFT, SImode, operands); DONE;")

(define_insn "*ashlsi3_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,r")
	(ashift:SI (match_operand:SI 1 "nonimmediate_operand" "0,r")
		   (match_operand:QI 2 "nonmemory_operand" "cI,M")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ASHIFT, SImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      if (!rtx_equal_p (operands[0], operands[1]))
	abort ();
      return "add{l}\t{%0, %0|%0, %0}";

    case TYPE_LEA:
      return "#";

    default:
      if (REG_P (operands[2]))
	return "sal{l}\t{%b2, %0|%0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{l}\t%0";
      else
	return "sal{l}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "1")
	      (const_string "lea")
            (and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "SI")])

;; Convert lea to the lea pattern to avoid flags dependency.
(define_split
  [(set (match_operand 0 "register_operand" "")
	(ashift (match_operand 1 "index_register_operand" "")
                (match_operand:QI 2 "const_int_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && true_regnum (operands[0]) != true_regnum (operands[1])"
  [(const_int 0)]
{
  rtx pat;
  operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[2] = gen_int_mode (1 << INTVAL (operands[2]), Pmode);
  pat = gen_rtx_MULT (Pmode, operands[1], operands[2]);
  if (Pmode != SImode)
    pat = gen_rtx_SUBREG (SImode, pat, 0);
  emit_insn (gen_rtx_SET (VOIDmode, operands[0], pat));
  DONE;
})

;; Rare case of shifting RSP is handled by generating move and shift
(define_split
  [(set (match_operand 0 "register_operand" "")
	(ashift (match_operand 1 "register_operand" "")
                (match_operand:QI 2 "const_int_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && true_regnum (operands[0]) != true_regnum (operands[1])"
  [(const_int 0)]
{
  rtx pat, clob;
  emit_move_insn (operands[1], operands[0]);
  pat = gen_rtx_SET (VOIDmode, operands[0],
		     gen_rtx_ASHIFT (GET_MODE (operands[0]),
				     operands[0], operands[2]));
  clob = gen_rtx_CLOBBER (VOIDmode, gen_rtx_REG (CCmode, FLAGS_REG));
  emit_insn (gen_rtx_PARALLEL (VOIDmode, gen_rtvec (2, pat, clob)));
  DONE;
})

(define_insn "*ashlsi3_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(zero_extend:DI (ashift:SI (match_operand:SI 1 "register_operand" "0,r")
			(match_operand:QI 2 "nonmemory_operand" "cI,M"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ASHIFT, SImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      return "add{l}\t{%k0, %k0|%k0, %k0}";

    case TYPE_LEA:
      return "#";

    default:
      if (REG_P (operands[2]))
	return "sal{l}\t{%b2, %k0|%k0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{l}\t%k0";
      else
	return "sal{l}\t{%2, %k0|%k0, %2}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "1")
	      (const_string "lea")
            (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		     (const_int 0))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "SI")])

;; Convert lea to the lea pattern to avoid flags dependency.
(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(zero_extend:DI (ashift (match_operand 1 "register_operand" "")
				(match_operand:QI 2 "const_int_operand" ""))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && reload_completed
   && true_regnum (operands[0]) != true_regnum (operands[1])"
  [(set (match_dup 0) (zero_extend:DI
			(subreg:SI (mult:SI (match_dup 1)
					    (match_dup 2)) 0)))]
{
  operands[1] = gen_lowpart (Pmode, operands[1]);
  operands[2] = gen_int_mode (1 << INTVAL (operands[2]), Pmode);
})

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashlsi3_cmp"
  [(set (reg 17)
	(compare
	  (ashift:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(ashift:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFT, SImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      return "add{l}\t{%0, %0|%0, %0}";

    default:
      if (REG_P (operands[2]))
	return "sal{l}\t{%b2, %0|%0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{l}\t%0";
      else
	return "sal{l}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "SI")])

(define_insn "*ashlsi3_cmp_zext"
  [(set (reg 17)
	(compare
	  (ashift:SI (match_operand:SI 1 "register_operand" "0")
		     (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (ashift:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFT, SImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      return "add{l}\t{%k0, %k0|%k0, %k0}";

    default:
      if (REG_P (operands[2]))
	return "sal{l}\t{%b2, %k0|%k0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{l}\t%k0";
      else
	return "sal{l}\t{%2, %k0|%k0, %2}";
    }
}
  [(set (attr "type")
     (cond [(and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		     (const_int 0))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "SI")])

(define_expand "ashlhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(ashift:HI (match_operand:HI 1 "nonimmediate_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (ASHIFT, HImode, operands); DONE;")

(define_insn "*ashlhi3_1_lea"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,r")
	(ashift:HI (match_operand:HI 1 "nonimmediate_operand" "0,r")
		   (match_operand:QI 2 "nonmemory_operand" "cI,M")))
   (clobber (reg:CC 17))]
  "!TARGET_PARTIAL_REG_STALL
   && ix86_binary_operator_ok (ASHIFT, HImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_LEA:
      return "#";
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      return "add{w}\t{%0, %0|%0, %0}";

    default:
      if (REG_P (operands[2]))
	return "sal{w}\t{%b2, %0|%0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{w}\t%0";
      else
	return "sal{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "1")
	      (const_string "lea")
            (and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "HI,SI")])

(define_insn "*ashlhi3_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(ashift:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		   (match_operand:QI 2 "nonmemory_operand" "cI")))
   (clobber (reg:CC 17))]
  "TARGET_PARTIAL_REG_STALL
   && ix86_binary_operator_ok (ASHIFT, HImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      return "add{w}\t{%0, %0|%0, %0}";

    default:
      if (REG_P (operands[2]))
	return "sal{w}\t{%b2, %0|%0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{w}\t%0";
      else
	return "sal{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "HI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashlhi3_cmp"
  [(set (reg 17)
	(compare
	  (ashift:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(ashift:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFT, HImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      return "add{w}\t{%0, %0|%0, %0}";

    default:
      if (REG_P (operands[2]))
	return "sal{w}\t{%b2, %0|%0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{w}\t%0";
      else
	return "sal{w}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "HI")])

(define_expand "ashlqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(ashift:QI (match_operand:QI 1 "nonimmediate_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (ASHIFT, QImode, operands); DONE;")

;; %%% Potential partial reg stall on alternative 2.  What to do?

(define_insn "*ashlqi3_1_lea"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,r,r")
	(ashift:QI (match_operand:QI 1 "nonimmediate_operand" "0,0,r")
		   (match_operand:QI 2 "nonmemory_operand" "cI,cI,M")))
   (clobber (reg:CC 17))]
  "!TARGET_PARTIAL_REG_STALL
   && ix86_binary_operator_ok (ASHIFT, QImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_LEA:
      return "#";
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      if (REG_P (operands[1]) && !ANY_QI_REG_P (operands[1]))
        return "add{l}\t{%k0, %k0|%k0, %k0}";
      else
        return "add{b}\t{%0, %0|%0, %0}";

    default:
      if (REG_P (operands[2]))
	{
	  if (get_attr_mode (insn) == MODE_SI)
	    return "sal{l}\t{%b2, %k0|%k0, %b2}";
	  else
	    return "sal{b}\t{%b2, %0|%0, %b2}";
	}
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	{
	  if (get_attr_mode (insn) == MODE_SI)
	    return "sal{l}\t%0";
	  else
	    return "sal{b}\t%0";
	}
      else
	{
	  if (get_attr_mode (insn) == MODE_SI)
	    return "sal{l}\t{%2, %k0|%k0, %2}";
	  else
	    return "sal{b}\t{%2, %0|%0, %2}";
	}
    }
}
  [(set (attr "type")
     (cond [(eq_attr "alternative" "2")
	      (const_string "lea")
            (and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "QI,SI,SI")])

(define_insn "*ashlqi3_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,r")
	(ashift:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")
		   (match_operand:QI 2 "nonmemory_operand" "cI,cI")))
   (clobber (reg:CC 17))]
  "TARGET_PARTIAL_REG_STALL
   && ix86_binary_operator_ok (ASHIFT, QImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      if (REG_P (operands[1]) && !ANY_QI_REG_P (operands[1]))
        return "add{l}\t{%k0, %k0|%k0, %k0}";
      else
        return "add{b}\t{%0, %0|%0, %0}";

    default:
      if (REG_P (operands[2]))
	{
	  if (get_attr_mode (insn) == MODE_SI)
	    return "sal{l}\t{%b2, %k0|%k0, %b2}";
	  else
	    return "sal{b}\t{%b2, %0|%0, %b2}";
	}
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	{
	  if (get_attr_mode (insn) == MODE_SI)
	    return "sal{l}\t%0";
	  else
	    return "sal{b}\t%0";
	}
      else
	{
	  if (get_attr_mode (insn) == MODE_SI)
	    return "sal{l}\t{%2, %k0|%k0, %2}";
	  else
	    return "sal{b}\t{%2, %0|%0, %2}";
	}
    }
}
  [(set (attr "type")
     (cond [(and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "QI,SI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashlqi3_cmp"
  [(set (reg 17)
	(compare
	  (ashift:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(ashift:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFT, QImode, operands)"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      if (operands[2] != const1_rtx)
	abort ();
      return "add{b}\t{%0, %0|%0, %0}";

    default:
      if (REG_P (operands[2]))
	return "sal{b}\t{%b2, %0|%0, %b2}";
      else if (GET_CODE (operands[2]) == CONST_INT
	       && INTVAL (operands[2]) == 1
	       && (TARGET_SHIFT1 || optimize_size))
	return "sal{b}\t%0";
      else
	return "sal{b}\t{%2, %0|%0, %2}";
    }
}
  [(set (attr "type")
     (cond [(and (and (ne (symbol_ref "TARGET_DOUBLE_WITH_ADD")
		          (const_int 0))
		      (match_operand 0 "register_operand" ""))
		 (match_operand 2 "const1_operand" ""))
	      (const_string "alu")
	   ]
	   (const_string "ishift")))
   (set_attr "mode" "QI")])

;; See comment above `ashldi3' about how this works.

(define_expand "ashrdi3"
  [(parallel [(set (match_operand:DI 0 "shiftdi_operand" "")
		   (ashiftrt:DI (match_operand:DI 1 "shiftdi_operand" "")
				(match_operand:QI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
{
  if (!TARGET_64BIT && TARGET_CMOVE && ! immediate_operand (operands[2], QImode))
    {
      emit_insn (gen_ashrdi3_1 (operands[0], operands[1], operands[2]));
      DONE;
    }
  ix86_expand_binary_operator (ASHIFTRT, DImode, operands);
  DONE;
})

(define_insn "ashrdi3_63_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=*d,rm")
	(ashiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "*a,0")
		     (match_operand:DI 2 "const_int_operand" "i,i")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && INTVAL (operands[2]) == 63 && (TARGET_USE_CLTD || optimize_size)
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands)"
  "@
   {cqto|cqo}
   sar{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "imovx,ishift")
   (set_attr "prefix_0f" "0,*")
   (set_attr "length_immediate" "0,*")
   (set_attr "modrm" "0,1")
   (set_attr "mode" "DI")])

(define_insn "*ashrdi3_1_one_bit_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ASHIFTRT, DImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "sar{q}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:DI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*ashrdi3_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
	(ashiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "J,c")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ASHIFTRT, DImode, operands)"
  "@
   sar{q}\t{%2, %0|%0, %2}
   sar{q}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "DI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashrdi3_one_bit_cmp_rex64"
  [(set (reg 17)
	(compare
	  (ashiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands)"
  "sar{q}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:DI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashrdi3_cmp_rex64"
  [(set (reg 17)
	(compare
	  (ashiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const_int_operand" "n"))
	  (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands)"
  "sar{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "DI")])


(define_insn "ashrdi3_1"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
		     (match_operand:QI 2 "nonmemory_operand" "Jc")))
   (clobber (match_scratch:SI 3 "=&r"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_CMOVE"
  "#"
  [(set_attr "type" "multi")])

(define_insn "*ashrdi3_2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(ashiftrt:DI (match_operand:DI 1 "register_operand" "0")
		     (match_operand:QI 2 "nonmemory_operand" "Jc")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT"
  "#"
  [(set_attr "type" "multi")])

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(ashiftrt:DI (match_operand:DI 1 "register_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (match_scratch:SI 3 ""))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_CMOVE && reload_completed"
  [(const_int 0)]
  "ix86_split_ashrdi (operands, operands[3]); DONE;")

(define_split
  [(set (match_operand:DI 0 "register_operand" "")
	(ashiftrt:DI (match_operand:DI 1 "register_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && reload_completed"
  [(const_int 0)]
  "ix86_split_ashrdi (operands, NULL_RTX); DONE;")

(define_insn "x86_shrd_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "+r*m,r*m")
        (ior:SI (ashiftrt:SI (match_dup 0)
		  (match_operand:QI 2 "nonmemory_operand" "I,c"))
		(ashift:SI (match_operand:SI 1 "register_operand" "r,r")
		  (minus:QI (const_int 32) (match_dup 2)))))
   (clobber (reg:CC 17))]
  ""
  "@
   shrd{l}\t{%2, %1, %0|%0, %1, %2}
   shrd{l}\t{%s2%1, %0|%0, %1, %2}"
  [(set_attr "type" "ishift")
   (set_attr "prefix_0f" "1")
   (set_attr "pent_pair" "np")
   (set_attr "ppro_uops" "few")
   (set_attr "mode" "SI")])

(define_expand "x86_shift_adj_3"
  [(use (match_operand:SI 0 "register_operand" ""))
   (use (match_operand:SI 1 "register_operand" ""))
   (use (match_operand:QI 2 "register_operand" ""))]
  ""
{
  rtx label = gen_label_rtx ();
  rtx tmp;

  emit_insn (gen_testqi_ccz_1 (operands[2], GEN_INT (32)));

  tmp = gen_rtx_REG (CCZmode, FLAGS_REG);
  tmp = gen_rtx_EQ (VOIDmode, tmp, const0_rtx);
  tmp = gen_rtx_IF_THEN_ELSE (VOIDmode, tmp,
			      gen_rtx_LABEL_REF (VOIDmode, label),
			      pc_rtx);
  tmp = emit_jump_insn (gen_rtx_SET (VOIDmode, pc_rtx, tmp));
  JUMP_LABEL (tmp) = label;

  emit_move_insn (operands[0], operands[1]);
  emit_insn (gen_ashrsi3_31 (operands[1], operands[1], GEN_INT (31)));

  emit_label (label);
  LABEL_NUSES (label) = 1;

  DONE;
})

(define_insn "ashrsi3_31"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=*d,rm")
	(ashiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "*a,0")
		     (match_operand:SI 2 "const_int_operand" "i,i")))
   (clobber (reg:CC 17))]
  "INTVAL (operands[2]) == 31 && (TARGET_USE_CLTD || optimize_size)
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands)"
  "@
   {cltd|cdq}
   sar{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "imovx,ishift")
   (set_attr "prefix_0f" "0,*")
   (set_attr "length_immediate" "0,*")
   (set_attr "modrm" "0,1")
   (set_attr "mode" "SI")])

(define_insn "*ashrsi3_31_zext"
  [(set (match_operand:DI 0 "register_operand" "=*d,r")
	(zero_extend:DI (ashiftrt:SI (match_operand:SI 1 "register_operand" "*a,0")
				     (match_operand:SI 2 "const_int_operand" "i,i"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && (TARGET_USE_CLTD || optimize_size)
   && INTVAL (operands[2]) == 31
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands)"
  "@
   {cltd|cdq}
   sar{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "imovx,ishift")
   (set_attr "prefix_0f" "0,*")
   (set_attr "length_immediate" "0,*")
   (set_attr "modrm" "0,1")
   (set_attr "mode" "SI")])

(define_expand "ashrsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(ashiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (ASHIFTRT, SImode, operands); DONE;")

(define_insn "*ashrsi3_1_one_bit"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ASHIFTRT, SImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "sar{l}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*ashrsi3_1_one_bit_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (ashiftrt:SI (match_operand:SI 1 "register_operand" "0")
				     (match_operand:QI 2 "const1_operand" ""))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ASHIFTRT, SImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "sar{l}\t%k0"
  [(set_attr "type" "ishift")
   (set_attr "length" "2")])

(define_insn "*ashrsi3_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,rm")
	(ashiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ASHIFTRT, SImode, operands)"
  "@
   sar{l}\t{%2, %0|%0, %2}
   sar{l}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "SI")])

(define_insn "*ashrsi3_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(zero_extend:DI (ashiftrt:SI (match_operand:SI 1 "register_operand" "0,0")
				     (match_operand:QI 2 "nonmemory_operand" "I,c"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ASHIFTRT, SImode, operands)"
  "@
   sar{l}\t{%2, %k0|%k0, %2}
   sar{l}\t{%b2, %k0|%k0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "SI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashrsi3_one_bit_cmp"
  [(set (reg 17)
	(compare
	  (ashiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands)"
  "sar{l}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*ashrsi3_one_bit_cmp_zext"
  [(set (reg 17)
	(compare
	  (ashiftrt:SI (match_operand:SI 1 "register_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (ashiftrt:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands)"
  "sar{l}\t%k0"
  [(set_attr "type" "ishift")
   (set_attr "length" "2")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashrsi3_cmp"
  [(set (reg 17)
	(compare
	  (ashiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands)"
  "sar{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "SI")])

(define_insn "*ashrsi3_cmp_zext"
  [(set (reg 17)
	(compare
	  (ashiftrt:SI (match_operand:SI 1 "register_operand" "0")
		       (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI (ashiftrt:SI (match_dup 1) (match_dup 2))))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands)"
  "sar{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "SI")])

(define_expand "ashrhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(ashiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (ASHIFTRT, HImode, operands); DONE;")

(define_insn "*ashrhi3_1_one_bit"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ASHIFTRT, HImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "sar{w}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*ashrhi3_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,rm")
	(ashiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ASHIFTRT, HImode, operands)"
  "@
   sar{w}\t{%2, %0|%0, %2}
   sar{w}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "HI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashrhi3_one_bit_cmp"
  [(set (reg 17)
	(compare
	  (ashiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (ASHIFTRT, HImode, operands)"
  "sar{w}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashrhi3_cmp"
  [(set (reg 17)
	(compare
	  (ashiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(ashiftrt:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFTRT, HImode, operands)"
  "sar{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "HI")])

(define_expand "ashrqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(ashiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (ASHIFTRT, QImode, operands); DONE;")

(define_insn "*ashrqi3_1_one_bit"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(ashiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ASHIFTRT, QImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "sar{b}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*ashrqi3_1_one_bit_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm"))
	(ashiftrt:QI (match_dup 0)
		     (match_operand:QI 1 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ASHIFTRT, QImode, operands)
   && (! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (TARGET_SHIFT1 || optimize_size)"
  "sar{b}\t%0"
  [(set_attr "type" "ishift1")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*ashrqi3_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,qm")
	(ashiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ASHIFTRT, QImode, operands)"
  "@
   sar{b}\t{%2, %0|%0, %2}
   sar{b}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "QI")])

(define_insn "*ashrqi3_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,qm"))
	(ashiftrt:QI (match_dup 0)
		     (match_operand:QI 1 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
   sar{b}\t{%1, %0|%0, %1}
   sar{b}\t{%b1, %0|%0, %b1}"
  [(set_attr "type" "ishift1")
   (set_attr "mode" "QI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashrqi3_one_bit_cmp"
  [(set (reg 17)
	(compare
	  (ashiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const1_operand" "I"))
	  (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(ashiftrt:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (ASHIFTRT, QImode, operands)"
  "sar{b}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*ashrqi3_cmp"
  [(set (reg 17)
	(compare
	  (ashiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(ashiftrt:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (ASHIFTRT, QImode, operands)"
  "sar{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "QI")])

;; Logical shift instructions

;; See comment above `ashldi3' about how this works.

(define_expand "lshrdi3"
  [(parallel [(set (match_operand:DI 0 "shiftdi_operand" "")
		   (lshiftrt:DI (match_operand:DI 1 "shiftdi_operand" "")
			        (match_operand:QI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC 17))])]
  ""
{
  if (!TARGET_64BIT && TARGET_CMOVE && ! immediate_operand (operands[2], QImode))
    {
      emit_insn (gen_lshrdi3_1 (operands[0], operands[1], operands[2]));
      DONE;
    }
  ix86_expand_binary_operator (LSHIFTRT, DImode, operands);
  DONE;
})

(define_insn "*lshrdi3_1_one_bit_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "shr{q}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:DI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*lshrdi3_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
	(lshiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "J,c")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "@
   shr{q}\t{%2, %0|%0, %2}
   shr{q}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "DI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*lshrdi3_cmp_one_bit_rex64"
  [(set (reg 17)
	(compare
	  (lshiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "shr{q}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:DI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*lshrdi3_cmp_rex64"
  [(set (reg 17)
	(compare
	  (lshiftrt:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const_int_operand" "e"))
	  (const_int 0)))
   (set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "shr{q}\t{%2, %0|%0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "DI")])

(define_insn "lshrdi3_1"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI (match_operand:DI 1 "register_operand" "0")
		     (match_operand:QI 2 "nonmemory_operand" "Jc")))
   (clobber (match_scratch:SI 3 "=&r"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_CMOVE"
  "#"
  [(set_attr "type" "multi")])

(define_insn "*lshrdi3_2"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI (match_operand:DI 1 "register_operand" "0")
		     (match_operand:QI 2 "nonmemory_operand" "Jc")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT"
  "#"
  [(set_attr "type" "multi")])

(define_split 
  [(set (match_operand:DI 0 "register_operand" "")
	(lshiftrt:DI (match_operand:DI 1 "register_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (match_scratch:SI 3 ""))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_CMOVE && reload_completed"
  [(const_int 0)]
  "ix86_split_lshrdi (operands, operands[3]); DONE;")

(define_split 
  [(set (match_operand:DI 0 "register_operand" "")
	(lshiftrt:DI (match_operand:DI 1 "register_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && reload_completed"
  [(const_int 0)]
  "ix86_split_lshrdi (operands, NULL_RTX); DONE;")

(define_expand "lshrsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(lshiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (LSHIFTRT, SImode, operands); DONE;")

(define_insn "*lshrsi3_1_one_bit"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (LSHIFTRT, HImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "shr{l}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*lshrsi3_1_one_bit_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI (zero_extend:DI (match_operand:SI 1 "register_operand" "0"))
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "shr{l}\t%k0"
  [(set_attr "type" "ishift")
   (set_attr "length" "2")])

(define_insn "*lshrsi3_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,rm")
	(lshiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "@
   shr{l}\t{%2, %0|%0, %2}
   shr{l}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "SI")])

(define_insn "*lshrsi3_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(zero_extend:DI
	  (lshiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
		       (match_operand:QI 2 "nonmemory_operand" "I,c"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "@
   shr{l}\t{%2, %k0|%k0, %2}
   shr{l}\t{%b2, %k0|%k0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "SI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*lshrsi3_one_bit_cmp"
  [(set (reg 17)
	(compare
	  (lshiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "shr{l}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*lshrsi3_cmp_one_bit_zext"
  [(set (reg 17)
	(compare
	  (lshiftrt:SI (match_operand:SI 1 "register_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI (zero_extend:DI (match_dup 1)) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "shr{l}\t%k0"
  [(set_attr "type" "ishift")
   (set_attr "length" "2")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*lshrsi3_cmp"
  [(set (reg 17)
	(compare
	  (lshiftrt:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "shr{l}\t{%2, %0|%0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "SI")])

(define_insn "*lshrsi3_cmp_zext"
  [(set (reg 17)
	(compare
	  (lshiftrt:SI (match_operand:SI 1 "register_operand" "0")
		       (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:DI 0 "register_operand" "=r")
	(lshiftrt:DI (zero_extend:DI (match_dup 1)) (match_dup 2)))]
  "TARGET_64BIT && ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "shr{l}\t{%2, %k0|%k0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "SI")])

(define_expand "lshrhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(lshiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (LSHIFTRT, HImode, operands); DONE;")

(define_insn "*lshrhi3_1_one_bit"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (LSHIFTRT, HImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "shr{w}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*lshrhi3_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,rm")
	(lshiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "@
   shr{w}\t{%2, %0|%0, %2}
   shr{w}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "HI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*lshrhi3_one_bit_cmp"
  [(set (reg 17)
	(compare
	  (lshiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "shr{w}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*lshrhi3_cmp"
  [(set (reg 17)
	(compare
	  (lshiftrt:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(lshiftrt:HI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (LSHIFTRT, HImode, operands)"
  "shr{w}\t{%2, %0|%0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "HI")])

(define_expand "lshrqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(lshiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (LSHIFTRT, QImode, operands); DONE;")

(define_insn "*lshrqi3_1_one_bit"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(lshiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (LSHIFTRT, QImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "shr{b}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*lshrqi3_1_one_bit_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm"))
	(lshiftrt:QI (match_dup 0)
		     (match_operand:QI 1 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (TARGET_SHIFT1 || optimize_size)"
  "shr{b}\t%0"
  [(set_attr "type" "ishift1")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*lshrqi3_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,qm")
	(lshiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (LSHIFTRT, QImode, operands)"
  "@
   shr{b}\t{%2, %0|%0, %2}
   shr{b}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "QI")])

(define_insn "*lshrqi3_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,qm"))
	(lshiftrt:QI (match_dup 0)
		     (match_operand:QI 1 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
   shr{b}\t{%1, %0|%0, %1}
   shr{b}\t{%b1, %0|%0, %b1}"
  [(set_attr "type" "ishift1")
   (set_attr "mode" "QI")])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*lshrqi2_one_bit_cmp"
  [(set (reg 17)
	(compare
	  (lshiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))
	  (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(lshiftrt:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && (TARGET_SHIFT1 || optimize_size)
   && ix86_binary_operator_ok (LSHIFTRT, QImode, operands)"
  "shr{b}\t%0"
  [(set_attr "type" "ishift")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

;; This pattern can't accept a variable shift count, since shifts by
;; zero don't affect the flags.  We assume that shifts by constant
;; zero are optimized away.
(define_insn "*lshrqi2_cmp"
  [(set (reg 17)
	(compare
	  (lshiftrt:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		       (match_operand:QI 2 "const_int_1_31_operand" "I"))
	  (const_int 0)))
   (set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(lshiftrt:QI (match_dup 1) (match_dup 2)))]
  "ix86_match_ccmode (insn, CCGOCmode)
   && ix86_binary_operator_ok (LSHIFTRT, QImode, operands)"
  "shr{b}\t{%2, %0|%0, %2}"
  [(set_attr "type" "ishift")
   (set_attr "mode" "QI")])

;; Rotate instructions

(define_expand "rotldi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(rotate:DI (match_operand:DI 1 "nonimmediate_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "ix86_expand_binary_operator (ROTATE, DImode, operands); DONE;")

(define_insn "*rotlsi3_1_one_bit_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(rotate:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		   (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "rol{q}\t%0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand:DI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotldi3_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
	(rotate:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
		   (match_operand:QI 2 "nonmemory_operand" "e,c")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ROTATE, DImode, operands)"
  "@
   rol{q}\t{%2, %0|%0, %2}
   rol{q}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "DI")])

(define_expand "rotlsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(rotate:SI (match_operand:SI 1 "nonimmediate_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (ROTATE, SImode, operands); DONE;")

(define_insn "*rotlsi3_1_one_bit"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(rotate:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		   (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "rol{l}\t%0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotlsi3_1_one_bit_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (rotate:SI (match_operand:SI 1 "register_operand" "0")
		     (match_operand:QI 2 "const1_operand" ""))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "rol{l}\t%k0"
  [(set_attr "type" "rotate")
   (set_attr "length" "2")])

(define_insn "*rotlsi3_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,rm")
	(rotate:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
		   (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATE, SImode, operands)"
  "@
   rol{l}\t{%2, %0|%0, %2}
   rol{l}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "SI")])

(define_insn "*rotlsi3_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(zero_extend:DI
	  (rotate:SI (match_operand:SI 1 "register_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ROTATE, SImode, operands)"
  "@
   rol{l}\t{%2, %k0|%k0, %2}
   rol{l}\t{%b2, %k0|%k0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "SI")])

(define_expand "rotlhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(rotate:HI (match_operand:HI 1 "nonimmediate_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (ROTATE, HImode, operands); DONE;")

(define_insn "*rotlhi3_1_one_bit"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(rotate:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		   (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "rol{w}\t%0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotlhi3_1"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,rm")
	(rotate:HI (match_operand:HI 1 "nonimmediate_operand" "0,0")
		   (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATE, HImode, operands)"
  "@
   rol{w}\t{%2, %0|%0, %2}
   rol{w}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "HI")])

(define_expand "rotlqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(rotate:QI (match_operand:QI 1 "nonimmediate_operand" "")
		   (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (ROTATE, QImode, operands); DONE;")

(define_insn "*rotlqi3_1_one_bit_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm"))
	(rotate:QI (match_dup 0)
		   (match_operand:QI 1 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (TARGET_SHIFT1 || optimize_size)"
  "rol{b}\t%0"
  [(set_attr "type" "rotate1")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotlqi3_1_one_bit"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(rotate:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		   (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "rol{b}\t%0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotlqi3_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,qm"))
	(rotate:QI (match_dup 0)
		   (match_operand:QI 1 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
   rol{b}\t{%1, %0|%0, %1}
   rol{b}\t{%b1, %0|%0, %b1}"
  [(set_attr "type" "rotate1")
   (set_attr "mode" "QI")])

(define_insn "*rotlqi3_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,qm")
	(rotate:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")
		   (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATE, QImode, operands)"
  "@
   rol{b}\t{%2, %0|%0, %2}
   rol{b}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "QI")])

(define_expand "rotrdi3"
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
	(rotatert:DI (match_operand:DI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "ix86_expand_binary_operator (ROTATERT, DImode, operands); DONE;")

(define_insn "*rotrdi3_1_one_bit_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm")
	(rotatert:DI (match_operand:DI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "ror{q}\t%0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand:DI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotrdi3_1_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=rm,rm")
	(rotatert:DI (match_operand:DI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "J,c")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, DImode, operands)"
  "@
   ror{q}\t{%2, %0|%0, %2}
   ror{q}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "DI")])

(define_expand "rotrsi3"
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(rotatert:SI (match_operand:SI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  ""
  "ix86_expand_binary_operator (ROTATERT, SImode, operands); DONE;")

(define_insn "*rotrsi3_1_one_bit"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm")
	(rotatert:SI (match_operand:SI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "ror{l}\t%0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotrsi3_1_one_bit_zext"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(zero_extend:DI
	  (rotatert:SI (match_operand:SI 1 "register_operand" "0")
		       (match_operand:QI 2 "const1_operand" ""))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "ror{l}\t%k0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand:SI 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotrsi3_1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=rm,rm")
	(rotatert:SI (match_operand:SI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATERT, SImode, operands)"
  "@
   ror{l}\t{%2, %0|%0, %2}
   ror{l}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "SI")])

(define_insn "*rotrsi3_1_zext"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(zero_extend:DI
	  (rotatert:SI (match_operand:SI 1 "register_operand" "0,0")
		       (match_operand:QI 2 "nonmemory_operand" "I,c"))))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, SImode, operands)"
  "@
   ror{l}\t{%2, %k0|%k0, %2}
   ror{l}\t{%b2, %k0|%k0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "SI")])

(define_expand "rotrhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(rotatert:HI (match_operand:HI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_HIMODE_MATH"
  "ix86_expand_binary_operator (ROTATERT, HImode, operands); DONE;")

(define_insn "*rotrhi3_one_bit"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm")
	(rotatert:HI (match_operand:HI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATERT, HImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "ror{w}\t%0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotrhi3"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=rm,rm")
	(rotatert:HI (match_operand:HI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATERT, HImode, operands)"
  "@
   ror{w}\t{%2, %0|%0, %2}
   ror{w}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "HI")])

(define_expand "rotrqi3"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(rotatert:QI (match_operand:QI 1 "nonimmediate_operand" "")
		     (match_operand:QI 2 "nonmemory_operand" "")))
   (clobber (reg:CC 17))]
  "TARGET_QIMODE_MATH"
  "ix86_expand_binary_operator (ROTATERT, QImode, operands); DONE;")

(define_insn "*rotrqi3_1_one_bit"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(rotatert:QI (match_operand:QI 1 "nonimmediate_operand" "0")
		     (match_operand:QI 2 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATERT, QImode, operands)
   && (TARGET_SHIFT1 || optimize_size)"
  "ror{b}\t%0"
  [(set_attr "type" "rotate")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotrqi3_1_one_bit_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm"))
	(rotatert:QI (match_dup 0)
		     (match_operand:QI 1 "const1_operand" "")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (TARGET_SHIFT1 || optimize_size)"
  "ror{b}\t%0"
  [(set_attr "type" "rotate1")
   (set (attr "length") 
     (if_then_else (match_operand 0 "register_operand" "") 
	(const_string "2")
	(const_string "*")))])

(define_insn "*rotrqi3_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm,qm")
	(rotatert:QI (match_operand:QI 1 "nonimmediate_operand" "0,0")
		     (match_operand:QI 2 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "ix86_binary_operator_ok (ROTATERT, QImode, operands)"
  "@
   ror{b}\t{%2, %0|%0, %2}
   ror{b}\t{%b2, %0|%0, %b2}"
  [(set_attr "type" "rotate")
   (set_attr "mode" "QI")])

(define_insn "*rotrqi3_1_slp"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm,qm"))
	(rotatert:QI (match_dup 0)
		     (match_operand:QI 1 "nonmemory_operand" "I,c")))
   (clobber (reg:CC 17))]
  "(! TARGET_PARTIAL_REG_STALL || optimize_size)
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
   ror{b}\t{%1, %0|%0, %1}
   ror{b}\t{%b1, %0|%0, %b1}"
  [(set_attr "type" "rotate1")
   (set_attr "mode" "QI")])

;; Bit set / bit test instructions

(define_expand "extv"
  [(set (match_operand:SI 0 "register_operand" "")
	(sign_extract:SI (match_operand:SI 1 "register_operand" "")
			 (match_operand:SI 2 "immediate_operand" "")
			 (match_operand:SI 3 "immediate_operand" "")))]
  ""
{
  /* Handle extractions from %ah et al.  */
  if (INTVAL (operands[2]) != 8 || INTVAL (operands[3]) != 8)
    FAIL;

  /* From mips.md: extract_bit_field doesn't verify that our source
     matches the predicate, so check it again here.  */
  if (! register_operand (operands[1], VOIDmode))
    FAIL;
})

(define_expand "extzv"
  [(set (match_operand:SI 0 "register_operand" "")
	(zero_extract:SI (match_operand 1 "ext_register_operand" "")
			 (match_operand:SI 2 "immediate_operand" "")
			 (match_operand:SI 3 "immediate_operand" "")))]
  ""
{
  /* Handle extractions from %ah et al.  */
  if (INTVAL (operands[2]) != 8 || INTVAL (operands[3]) != 8)
    FAIL;

  /* From mips.md: extract_bit_field doesn't verify that our source
     matches the predicate, so check it again here.  */
  if (! register_operand (operands[1], VOIDmode))
    FAIL;
})

(define_expand "insv"
  [(set (zero_extract (match_operand 0 "ext_register_operand" "")
		      (match_operand 1 "immediate_operand" "")
		      (match_operand 2 "immediate_operand" ""))
        (match_operand 3 "register_operand" ""))]
  ""
{
  /* Handle extractions from %ah et al.  */
  if (INTVAL (operands[1]) != 8 || INTVAL (operands[2]) != 8)
    FAIL;

  /* From mips.md: insert_bit_field doesn't verify that our source
     matches the predicate, so check it again here.  */
  if (! register_operand (operands[0], VOIDmode))
    FAIL;

  if (TARGET_64BIT)
    emit_insn (gen_movdi_insv_1_rex64 (operands[0], operands[3]));
  else
    emit_insn (gen_movsi_insv_1 (operands[0], operands[3]));

  DONE;
})

;; %%% bts, btr, btc, bt.

;; Store-flag instructions.

;; For all sCOND expanders, also expand the compare or test insn that
;; generates cc0.  Generate an equality comparison if `seq' or `sne'.

;; %%% Do the expansion to SImode.  If PII, do things the xor+setcc way
;; to avoid partial register stalls.  Otherwise do things the setcc+movzx
;; way, which can later delete the movzx if only QImode is needed.

(define_expand "seq"
  [(set (match_operand:QI 0 "register_operand" "")
        (eq:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (EQ, operands[0])) DONE; else FAIL;")

(define_expand "sne"
  [(set (match_operand:QI 0 "register_operand" "")
        (ne:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (NE, operands[0])) DONE; else FAIL;")

(define_expand "sgt"
  [(set (match_operand:QI 0 "register_operand" "")
        (gt:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (GT, operands[0])) DONE; else FAIL;")

(define_expand "sgtu"
  [(set (match_operand:QI 0 "register_operand" "")
        (gtu:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (GTU, operands[0])) DONE; else FAIL;")

(define_expand "slt"
  [(set (match_operand:QI 0 "register_operand" "")
        (lt:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (LT, operands[0])) DONE; else FAIL;")

(define_expand "sltu"
  [(set (match_operand:QI 0 "register_operand" "")
        (ltu:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (LTU, operands[0])) DONE; else FAIL;")

(define_expand "sge"
  [(set (match_operand:QI 0 "register_operand" "")
        (ge:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (GE, operands[0])) DONE; else FAIL;")

(define_expand "sgeu"
  [(set (match_operand:QI 0 "register_operand" "")
        (geu:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (GEU, operands[0])) DONE; else FAIL;")

(define_expand "sle"
  [(set (match_operand:QI 0 "register_operand" "")
        (le:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (LE, operands[0])) DONE; else FAIL;")

(define_expand "sleu"
  [(set (match_operand:QI 0 "register_operand" "")
        (leu:QI (reg:CC 17) (const_int 0)))]
  ""
  "if (ix86_expand_setcc (LEU, operands[0])) DONE; else FAIL;")

(define_expand "sunordered"
  [(set (match_operand:QI 0 "register_operand" "")
        (unordered:QI (reg:CC 17) (const_int 0)))]
  "TARGET_80387 || TARGET_SSE"
  "if (ix86_expand_setcc (UNORDERED, operands[0])) DONE; else FAIL;")

(define_expand "sordered"
  [(set (match_operand:QI 0 "register_operand" "")
        (ordered:QI (reg:CC 17) (const_int 0)))]
  "TARGET_80387"
  "if (ix86_expand_setcc (ORDERED, operands[0])) DONE; else FAIL;")

(define_expand "suneq"
  [(set (match_operand:QI 0 "register_operand" "")
        (uneq:QI (reg:CC 17) (const_int 0)))]
  "TARGET_80387 || TARGET_SSE"
  "if (ix86_expand_setcc (UNEQ, operands[0])) DONE; else FAIL;")

(define_expand "sunge"
  [(set (match_operand:QI 0 "register_operand" "")
        (unge:QI (reg:CC 17) (const_int 0)))]
  "TARGET_80387 || TARGET_SSE"
  "if (ix86_expand_setcc (UNGE, operands[0])) DONE; else FAIL;")

(define_expand "sungt"
  [(set (match_operand:QI 0 "register_operand" "")
        (ungt:QI (reg:CC 17) (const_int 0)))]
  "TARGET_80387 || TARGET_SSE"
  "if (ix86_expand_setcc (UNGT, operands[0])) DONE; else FAIL;")

(define_expand "sunle"
  [(set (match_operand:QI 0 "register_operand" "")
        (unle:QI (reg:CC 17) (const_int 0)))]
  "TARGET_80387 || TARGET_SSE"
  "if (ix86_expand_setcc (UNLE, operands[0])) DONE; else FAIL;")

(define_expand "sunlt"
  [(set (match_operand:QI 0 "register_operand" "")
        (unlt:QI (reg:CC 17) (const_int 0)))]
  "TARGET_80387 || TARGET_SSE"
  "if (ix86_expand_setcc (UNLT, operands[0])) DONE; else FAIL;")

(define_expand "sltgt"
  [(set (match_operand:QI 0 "register_operand" "")
        (ltgt:QI (reg:CC 17) (const_int 0)))]
  "TARGET_80387 || TARGET_SSE"
  "if (ix86_expand_setcc (LTGT, operands[0])) DONE; else FAIL;")

(define_insn "*setcc_1"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=qm")
	(match_operator:QI 1 "ix86_comparison_operator"
	  [(reg 17) (const_int 0)]))]
  ""
  "set%C1\t%0"
  [(set_attr "type" "setcc")
   (set_attr "mode" "QI")])

(define_insn "setcc_2"
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" "+qm"))
	(match_operator:QI 1 "ix86_comparison_operator"
	  [(reg 17) (const_int 0)]))]
  ""
  "set%C1\t%0"
  [(set_attr "type" "setcc")
   (set_attr "mode" "QI")])

;; In general it is not safe to assume too much about CCmode registers,
;; so simplify-rtx stops when it sees a second one.  Under certain 
;; conditions this is safe on x86, so help combine not create
;;
;;	seta	%al
;;	testb	%al, %al
;;	sete	%al

(define_split 
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(ne:QI (match_operator 1 "ix86_comparison_operator"
	         [(reg 17) (const_int 0)])
	    (const_int 0)))]
  ""
  [(set (match_dup 0) (match_dup 1))]
{
  PUT_MODE (operands[1], QImode);
})

(define_split 
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" ""))
	(ne:QI (match_operator 1 "ix86_comparison_operator"
	         [(reg 17) (const_int 0)])
	    (const_int 0)))]
  ""
  [(set (match_dup 0) (match_dup 1))]
{
  PUT_MODE (operands[1], QImode);
})

(define_split 
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(eq:QI (match_operator 1 "ix86_comparison_operator"
	         [(reg 17) (const_int 0)])
	    (const_int 0)))]
  ""
  [(set (match_dup 0) (match_dup 1))]
{
  rtx new_op1 = copy_rtx (operands[1]);
  operands[1] = new_op1;
  PUT_MODE (new_op1, QImode);
  PUT_CODE (new_op1, REVERSE_CONDITION (GET_CODE (new_op1),
					GET_MODE (XEXP (new_op1, 0))));

  /* Make sure that (a) the CCmode we have for the flags is strong
     enough for the reversed compare or (b) we have a valid FP compare.  */
  if (! ix86_comparison_operator (new_op1, VOIDmode))
    FAIL;
})

(define_split 
  [(set (strict_low_part (match_operand:QI 0 "nonimmediate_operand" ""))
	(eq:QI (match_operator 1 "ix86_comparison_operator"
	         [(reg 17) (const_int 0)])
	    (const_int 0)))]
  ""
  [(set (match_dup 0) (match_dup 1))]
{
  rtx new_op1 = copy_rtx (operands[1]);
  operands[1] = new_op1;
  PUT_MODE (new_op1, QImode);
  PUT_CODE (new_op1, REVERSE_CONDITION (GET_CODE (new_op1),
					GET_MODE (XEXP (new_op1, 0))));

  /* Make sure that (a) the CCmode we have for the flags is strong
     enough for the reversed compare or (b) we have a valid FP compare.  */
  if (! ix86_comparison_operator (new_op1, VOIDmode))
    FAIL;
})

;; The SSE store flag instructions saves 0 or 0xffffffff to the result.
;; subsequent logical operations are used to imitate conditional moves.
;; 0xffffffff is NaN, but not in normalized form, so we can't represent
;; it directly.  Further holding this value in pseudo register might bring
;; problem in implicit normalization in spill code.
;; So we don't define FLOAT_STORE_FLAG_VALUE and create these
;; instructions after reload by splitting the conditional move patterns.

(define_insn "*sse_setccsf"
  [(set (match_operand:SF 0 "register_operand" "=x")
	(match_operator:SF 1 "sse_comparison_operator"
	  [(match_operand:SF 2 "register_operand" "0")
	   (match_operand:SF 3 "nonimmediate_operand" "xm")]))]
  "TARGET_SSE && reload_completed"
  "cmp%D1ss\t{%3, %0|%0, %3}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "SF")])

(define_insn "*sse_setccdf"
  [(set (match_operand:DF 0 "register_operand" "=Y")
	(match_operator:DF 1 "sse_comparison_operator"
	  [(match_operand:DF 2 "register_operand" "0")
	   (match_operand:DF 3 "nonimmediate_operand" "Ym")]))]
  "TARGET_SSE2 && reload_completed"
  "cmp%D1sd\t{%3, %0|%0, %3}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "DF")])

;; Basic conditional jump instructions.
;; We ignore the overflow flag for signed branch instructions.

;; For all bCOND expanders, also expand the compare or test insn that
;; generates reg 17.  Generate an equality comparison if `beq' or `bne'.

(define_expand "beq"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (EQ, operands[0]); DONE;")

(define_expand "bne"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (NE, operands[0]); DONE;")

(define_expand "bgt"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (GT, operands[0]); DONE;")

(define_expand "bgtu"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (GTU, operands[0]); DONE;")

(define_expand "blt"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (LT, operands[0]); DONE;")

(define_expand "bltu"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (LTU, operands[0]); DONE;")

(define_expand "bge"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (GE, operands[0]); DONE;")

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (GEU, operands[0]); DONE;")

(define_expand "ble"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (LE, operands[0]); DONE;")

(define_expand "bleu"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ix86_expand_branch (LEU, operands[0]); DONE;")

(define_expand "bunordered"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_80387 || TARGET_SSE"
  "ix86_expand_branch (UNORDERED, operands[0]); DONE;")

(define_expand "bordered"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_80387 || TARGET_SSE"
  "ix86_expand_branch (ORDERED, operands[0]); DONE;")

(define_expand "buneq"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_80387 || TARGET_SSE"
  "ix86_expand_branch (UNEQ, operands[0]); DONE;")

(define_expand "bunge"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_80387 || TARGET_SSE"
  "ix86_expand_branch (UNGE, operands[0]); DONE;")

(define_expand "bungt"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_80387 || TARGET_SSE"
  "ix86_expand_branch (UNGT, operands[0]); DONE;")

(define_expand "bunle"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_80387 || TARGET_SSE"
  "ix86_expand_branch (UNLE, operands[0]); DONE;")

(define_expand "bunlt"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_80387 || TARGET_SSE"
  "ix86_expand_branch (UNLT, operands[0]); DONE;")

(define_expand "bltgt"
  [(set (pc)
	(if_then_else (match_dup 1)
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_80387 || TARGET_SSE"
  "ix86_expand_branch (LTGT, operands[0]); DONE;")

(define_insn "*jcc_1"
  [(set (pc)
	(if_then_else (match_operator 1 "ix86_comparison_operator"
				      [(reg 17) (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "%+j%C1\t%l0"
  [(set_attr "type" "ibr")
   (set_attr "modrm" "0")
   (set (attr "length")
	   (if_then_else (and (ge (minus (match_dup 0) (pc))
				  (const_int -126))
			      (lt (minus (match_dup 0) (pc))
				  (const_int 128)))
	     (const_int 2)
	     (const_int 6)))])

(define_insn "*jcc_2"
  [(set (pc)
	(if_then_else (match_operator 1 "ix86_comparison_operator"
				      [(reg 17) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "%+j%c1\t%l0"
  [(set_attr "type" "ibr")
   (set_attr "modrm" "0")
   (set (attr "length")
	   (if_then_else (and (ge (minus (match_dup 0) (pc))
				  (const_int -126))
			      (lt (minus (match_dup 0) (pc))
				  (const_int 128)))
	     (const_int 2)
	     (const_int 6)))])

;; In general it is not safe to assume too much about CCmode registers,
;; so simplify-rtx stops when it sees a second one.  Under certain 
;; conditions this is safe on x86, so help combine not create
;;
;;	seta	%al
;;	testb	%al, %al
;;	je	Lfoo

(define_split 
  [(set (pc)
	(if_then_else (ne (match_operator 0 "ix86_comparison_operator"
				      [(reg 17) (const_int 0)])
			  (const_int 0))
		      (label_ref (match_operand 1 "" ""))
		      (pc)))]
  ""
  [(set (pc)
	(if_then_else (match_dup 0)
		      (label_ref (match_dup 1))
		      (pc)))]
{
  PUT_MODE (operands[0], VOIDmode);
})
  
(define_split 
  [(set (pc)
	(if_then_else (eq (match_operator 0 "ix86_comparison_operator"
				      [(reg 17) (const_int 0)])
			  (const_int 0))
		      (label_ref (match_operand 1 "" ""))
		      (pc)))]
  ""
  [(set (pc)
	(if_then_else (match_dup 0)
		      (label_ref (match_dup 1))
		      (pc)))]
{
  rtx new_op0 = copy_rtx (operands[0]);
  operands[0] = new_op0;
  PUT_MODE (new_op0, VOIDmode);
  PUT_CODE (new_op0, REVERSE_CONDITION (GET_CODE (new_op0),
					GET_MODE (XEXP (new_op0, 0))));

  /* Make sure that (a) the CCmode we have for the flags is strong
     enough for the reversed compare or (b) we have a valid FP compare.  */
  if (! ix86_comparison_operator (new_op0, VOIDmode))
    FAIL;
})

;; Define combination compare-and-branch fp compare instructions to use
;; during early optimization.  Splitting the operation apart early makes
;; for bad code when we want to reverse the operation.

(define_insn "*fp_jcc_1"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "f")
			 (match_operand 2 "register_operand" "f")])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))]
  "TARGET_CMOVE && TARGET_80387
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
   && FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_1_sse"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "f#x,x#f")
			 (match_operand 2 "nonimmediate_operand" "f#x,xm#f")])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))]
  "TARGET_80387
   && SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_1_sse_only"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "x")
			 (match_operand 2 "nonimmediate_operand" "xm")])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))]
  "SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_2"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "f")
			 (match_operand 2 "register_operand" "f")])
	  (pc)
	  (label_ref (match_operand 3 "" ""))))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))]
  "TARGET_CMOVE && TARGET_80387
   && !SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
   && FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_2_sse"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "f#x,x#f")
			 (match_operand 2 "nonimmediate_operand" "f#x,xm#f")])
	  (pc)
	  (label_ref (match_operand 3 "" ""))))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))]
  "TARGET_80387
   && SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_2_sse_only"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "x")
			 (match_operand 2 "nonimmediate_operand" "xm")])
	  (pc)
	  (label_ref (match_operand 3 "" ""))))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))]
  "SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_3"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "f")
			 (match_operand 2 "nonimmediate_operand" "fm")])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))
   (clobber (match_scratch:HI 4 "=a"))]
  "TARGET_80387
   && (GET_MODE (operands[1]) == SFmode || GET_MODE (operands[1]) == DFmode)
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && !ix86_use_fcomi_compare (GET_CODE (operands[0]))
   && SELECT_CC_MODE (GET_CODE (operands[0]),
		      operands[1], operands[2]) == CCFPmode
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_4"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "f")
			 (match_operand 2 "nonimmediate_operand" "fm")])
	  (pc)
	  (label_ref (match_operand 3 "" ""))))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))
   (clobber (match_scratch:HI 4 "=a"))]
  "TARGET_80387
   && (GET_MODE (operands[1]) == SFmode || GET_MODE (operands[1]) == DFmode)
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && !ix86_use_fcomi_compare (GET_CODE (operands[0]))
   && SELECT_CC_MODE (GET_CODE (operands[0]),
		      operands[1], operands[2]) == CCFPmode
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_5"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "f")
			 (match_operand 2 "register_operand" "f")])
	  (label_ref (match_operand 3 "" ""))
	  (pc)))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))
   (clobber (match_scratch:HI 4 "=a"))]
  "TARGET_80387
   && FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_insn "*fp_jcc_6"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "f")
			 (match_operand 2 "register_operand" "f")])
	  (pc)
	  (label_ref (match_operand 3 "" ""))))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))
   (clobber (match_scratch:HI 4 "=a"))]
  "TARGET_80387
   && FLOAT_MODE_P (GET_MODE (operands[1]))
   && GET_MODE (operands[1]) == GET_MODE (operands[2])
   && ix86_fp_jump_nontrivial_p (GET_CODE (operands[0]))"
  "#")

(define_split
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "")
			 (match_operand 2 "nonimmediate_operand" "")])
	  (match_operand 3 "" "")
	  (match_operand 4 "" "")))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))]
  "reload_completed"
  [(const_int 0)]
{
  ix86_split_fp_branch (GET_CODE (operands[0]), operands[1], operands[2],
			operands[3], operands[4], NULL_RTX);
  DONE;
})

(define_split
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
			[(match_operand 1 "register_operand" "")
			 (match_operand 2 "nonimmediate_operand" "")])
	  (match_operand 3 "" "")
	  (match_operand 4 "" "")))
   (clobber (reg:CCFP 18))
   (clobber (reg:CCFP 17))
   (clobber (match_scratch:HI 5 "=a"))]
  "reload_completed"
  [(set (pc)
	(if_then_else (match_dup 6)
	  (match_dup 3)
	  (match_dup 4)))]
{
  ix86_split_fp_branch (GET_CODE (operands[0]), operands[1], operands[2],
			operands[3], operands[4], operands[5]);
  DONE;
})

;; Unconditional and other jump instructions

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "jmp\t%l0"
  [(set_attr "type" "ibr")
   (set (attr "length")
	   (if_then_else (and (ge (minus (match_dup 0) (pc))
				  (const_int -126))
			      (lt (minus (match_dup 0) (pc))
				  (const_int 128)))
	     (const_int 2)
	     (const_int 5)))
   (set_attr "modrm" "0")])

(define_expand "indirect_jump"
  [(set (pc) (match_operand 0 "nonimmediate_operand" "rm"))]
  ""
  "")

(define_insn "*indirect_jump"
  [(set (pc) (match_operand:SI 0 "nonimmediate_operand" "rm"))]
  "!TARGET_64BIT"
  "jmp\t%A0"
  [(set_attr "type" "ibr")
   (set_attr "length_immediate" "0")])

(define_insn "*indirect_jump_rtx64"
  [(set (pc) (match_operand:DI 0 "nonimmediate_operand" "rm"))]
  "TARGET_64BIT"
  "jmp\t%A0"
  [(set_attr "type" "ibr")
   (set_attr "length_immediate" "0")])

(define_expand "tablejump"
  [(parallel [(set (pc) (match_operand 0 "nonimmediate_operand" "rm"))
	      (use (label_ref (match_operand 1 "" "")))])]
  ""
{
  /* In PIC mode, the table entries are stored GOT (32-bit) or PC (64-bit)
     relative.  Convert the relative address to an absolute address.  */
  if (flag_pic)
    {
      rtx op0, op1;
      enum rtx_code code;

      if (TARGET_64BIT)
	{
	  code = PLUS;
	  op0 = operands[0];
	  op1 = gen_rtx_LABEL_REF (Pmode, operands[1]);
	}
      else if (TARGET_MACHO || HAVE_AS_GOTOFF_IN_DATA)
	{
	  code = PLUS;
	  op0 = operands[0];
	  op1 = pic_offset_table_rtx;
	}
      else
	{
	  code = MINUS;
	  op0 = pic_offset_table_rtx;
	  op1 = operands[0];
	}

      operands[0] = expand_simple_binop (Pmode, code, op0, op1, NULL_RTX, 0,
					 OPTAB_DIRECT);
    }
})

(define_insn "*tablejump_1"
  [(set (pc) (match_operand:SI 0 "nonimmediate_operand" "rm"))
   (use (label_ref (match_operand 1 "" "")))]
  "!TARGET_64BIT"
  "jmp\t%A0"
  [(set_attr "type" "ibr")
   (set_attr "length_immediate" "0")])

(define_insn "*tablejump_1_rtx64"
  [(set (pc) (match_operand:DI 0 "nonimmediate_operand" "rm"))
   (use (label_ref (match_operand 1 "" "")))]
  "TARGET_64BIT"
  "jmp\t%A0"
  [(set_attr "type" "ibr")
   (set_attr "length_immediate" "0")])

;; Loop instruction
;;
;; This is all complicated by the fact that since this is a jump insn
;; we must handle our own reloads.

(define_expand "doloop_end"
  [(use (match_operand 0 "" ""))        ; loop pseudo
   (use (match_operand 1 "" ""))        ; iterations; zero if unknown
   (use (match_operand 2 "" ""))        ; max iterations
   (use (match_operand 3 "" ""))        ; loop level 
   (use (match_operand 4 "" ""))]       ; label
  "!TARGET_64BIT && TARGET_USE_LOOP"
  "                                 
{
  /* Only use cloop on innermost loops.  */
  if (INTVAL (operands[3]) > 1)
    FAIL;
  if (GET_MODE (operands[0]) != SImode)
    FAIL;
  emit_jump_insn (gen_doloop_end_internal (operands[4], operands[0],
					   operands[0]));
  DONE;
}")

(define_insn "doloop_end_internal"
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "c,?*r,?*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,1,*m*r")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:SI 3 "=X,X,r"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_USE_LOOP"
{
  if (which_alternative != 0)
    return "#";
  if (get_attr_length (insn) == 2)
    return "%+loop\t%l0";
  else
    return "dec{l}\t%1\;%+jne\t%l0";
}
  [(set_attr "ppro_uops" "many")
   (set (attr "length")
	(if_then_else (and (eq_attr "alternative" "0")
			   (and (ge (minus (match_dup 0) (pc))
			            (const_int -126))
			        (lt (minus (match_dup 0) (pc))
			            (const_int 128))))
		      (const_int 2)
		      (const_int 16)))
   ;; We don't know the type before shorten branches.  Optimistically expect
   ;; the loop instruction to match.
   (set (attr "type") (const_string "ibr"))])

(define_split
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "")
			  (const_int 1))
		      (match_operand 0 "" "")
		      (pc)))
   (set (match_dup 1)
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:SI 2 ""))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_USE_LOOP
   && reload_completed
   && REGNO (operands[1]) != 2"
  [(parallel [(set (reg:CCZ 17)
		   (compare:CCZ (plus:SI (match_dup 1) (const_int -1))
				 (const_int 0)))
	      (set (match_dup 1) (plus:SI (match_dup 1) (const_int -1)))])
   (set (pc) (if_then_else (ne (reg:CCZ 17) (const_int 0))
			   (match_dup 0)
			   (pc)))]
  "")
  
(define_split
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "")
			  (const_int 1))
		      (match_operand 0 "" "")
		      (pc)))
   (set (match_operand:SI 2 "nonimmediate_operand" "")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_USE_LOOP
   && reload_completed
   && (! REG_P (operands[2])
       || ! rtx_equal_p (operands[1], operands[2]))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (reg:CCZ 17)
		   (compare:CCZ (plus:SI (match_dup 3) (const_int -1))
				(const_int 0)))
	      (set (match_dup 3) (plus:SI (match_dup 3) (const_int -1)))])
   (set (match_dup 2) (match_dup 3))
   (set (pc) (if_then_else (ne (reg:CCZ 17) (const_int 0))
			   (match_dup 0)
			   (pc)))]
  "")

;; Convert setcc + movzbl to xor + setcc if operands don't overlap.

(define_peephole2
  [(set (reg 17) (match_operand 0 "" ""))
   (set (match_operand:QI 1 "register_operand" "")
	(match_operator:QI 2 "ix86_comparison_operator"
	  [(reg 17) (const_int 0)]))
   (set (match_operand 3 "q_regs_operand" "")
	(zero_extend (match_dup 1)))]
  "(peep2_reg_dead_p (3, operands[1])
    || operands_match_p (operands[1], operands[3]))
   && ! reg_overlap_mentioned_p (operands[3], operands[0])"
  [(set (match_dup 4) (match_dup 0))
   (set (strict_low_part (match_dup 5))
	(match_dup 2))]
{
  operands[4] = gen_rtx_REG (GET_MODE (operands[0]), 17);
  operands[5] = gen_lowpart (QImode, operands[3]);
  ix86_expand_clear (operands[3]);
})

;; Similar, but match zero_extendhisi2_and, which adds a clobber.

(define_peephole2
  [(set (reg 17) (match_operand 0 "" ""))
   (set (match_operand:QI 1 "register_operand" "")
	(match_operator:QI 2 "ix86_comparison_operator"
	  [(reg 17) (const_int 0)]))
   (parallel [(set (match_operand 3 "q_regs_operand" "")
		   (zero_extend (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "(peep2_reg_dead_p (3, operands[1])
    || operands_match_p (operands[1], operands[3]))
   && ! reg_overlap_mentioned_p (operands[3], operands[0])"
  [(set (match_dup 4) (match_dup 0))
   (set (strict_low_part (match_dup 5))
	(match_dup 2))]
{
  operands[4] = gen_rtx_REG (GET_MODE (operands[0]), 17);
  operands[5] = gen_lowpart (QImode, operands[3]);
  ix86_expand_clear (operands[3]);
})

;; Call instructions.

;; The predicates normally associated with named expanders are not properly
;; checked for calls.  This is a bug in the generic code, but it isn't that
;; easy to fix.  Ignore it for now and be prepared to fix things up.

;; Call subroutine returning no value.

(define_expand "call_pop"
  [(parallel [(call (match_operand:QI 0 "" "")
		    (match_operand:SI 1 "" ""))
	      (set (reg:SI 7)
		   (plus:SI (reg:SI 7)
			    (match_operand:SI 3 "" "")))])]
  "!TARGET_64BIT"
{
  ix86_expand_call (NULL, operands[0], operands[1], operands[2], operands[3], 0);
  DONE;
})

(define_insn "*call_pop_0"
  [(call (mem:QI (match_operand:SI 0 "constant_call_address_operand" ""))
	 (match_operand:SI 1 "" ""))
   (set (reg:SI 7) (plus:SI (reg:SI 7)
			    (match_operand:SI 2 "immediate_operand" "")))]
  "!TARGET_64BIT"
{
  if (SIBLING_CALL_P (insn))
    return "jmp\t%P0";
  else
    return "call\t%P0";
}
  [(set_attr "type" "call")])
  
(define_insn "*call_pop_1"
  [(call (mem:QI (match_operand:SI 0 "call_insn_operand" "rsm"))
	 (match_operand:SI 1 "" ""))
   (set (reg:SI 7) (plus:SI (reg:SI 7)
			    (match_operand:SI 2 "immediate_operand" "i")))]
  "!TARGET_64BIT"
{
  if (constant_call_address_operand (operands[0], Pmode))
    {
      if (SIBLING_CALL_P (insn))
	return "jmp\t%P0";
      else
	return "call\t%P0";
    }
  if (SIBLING_CALL_P (insn))
    return "jmp\t%A0";
  else
    return "call\t%A0";
}
  [(set_attr "type" "call")])

(define_expand "call"
  [(call (match_operand:QI 0 "" "")
	 (match_operand 1 "" ""))
   (use (match_operand 2 "" ""))]
  ""
{
  ix86_expand_call (NULL, operands[0], operands[1], operands[2], NULL, 0);
  DONE;
})

(define_expand "sibcall"
  [(call (match_operand:QI 0 "" "")
	 (match_operand 1 "" ""))
   (use (match_operand 2 "" ""))]
  ""
{
  ix86_expand_call (NULL, operands[0], operands[1], operands[2], NULL, 1);
  DONE;
})

(define_insn "*call_0"
  [(call (mem:QI (match_operand 0 "constant_call_address_operand" ""))
	 (match_operand 1 "" ""))]
  ""
{
  if (SIBLING_CALL_P (insn))
    return "jmp\t%P0";
  else
    return "call\t%P0";
}
  [(set_attr "type" "call")])

(define_insn "*call_1"
  [(call (mem:QI (match_operand:SI 0 "call_insn_operand" "rsm"))
	 (match_operand 1 "" ""))]
  "!SIBLING_CALL_P (insn) && !TARGET_64BIT"
{
  if (constant_call_address_operand (operands[0], QImode))
    return "call\t%P0";
  return "call\t%A0";
}
  [(set_attr "type" "call")])

(define_insn "*sibcall_1"
  [(call (mem:QI (match_operand:SI 0 "sibcall_insn_operand" "s,c,d,a"))
	 (match_operand 1 "" ""))]
  "SIBLING_CALL_P (insn) && !TARGET_64BIT"
{
  if (constant_call_address_operand (operands[0], QImode))
    return "jmp\t%P0";
  return "jmp\t%A0";
}
  [(set_attr "type" "call")])

(define_insn "*call_1_rex64"
  [(call (mem:QI (match_operand:DI 0 "call_insn_operand" "rsm"))
	 (match_operand 1 "" ""))]
  "!SIBLING_CALL_P (insn) && TARGET_64BIT"
{
  if (constant_call_address_operand (operands[0], QImode))
    return "call\t%P0";
  return "call\t%A0";
}
  [(set_attr "type" "call")])

(define_insn "*sibcall_1_rex64"
  [(call (mem:QI (match_operand:DI 0 "constant_call_address_operand" ""))
	 (match_operand 1 "" ""))]
  "SIBLING_CALL_P (insn) && TARGET_64BIT"
  "jmp\t%P0"
  [(set_attr "type" "call")])

(define_insn "*sibcall_1_rex64_v"
  [(call (mem:QI (reg:DI 40))
	 (match_operand 0 "" ""))]
  "SIBLING_CALL_P (insn) && TARGET_64BIT"
  "jmp\t*%%r11"
  [(set_attr "type" "call")])


;; Call subroutine, returning value in operand 0

(define_expand "call_value_pop"
  [(parallel [(set (match_operand 0 "" "")
		   (call (match_operand:QI 1 "" "")
			 (match_operand:SI 2 "" "")))
	      (set (reg:SI 7)
		   (plus:SI (reg:SI 7)
			    (match_operand:SI 4 "" "")))])]
  "!TARGET_64BIT"
{
  ix86_expand_call (operands[0], operands[1], operands[2],
		    operands[3], operands[4], 0);
  DONE;
})

(define_expand "call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:QI 1 "" "")
	      (match_operand:SI 2 "" "")))
   (use (match_operand:SI 3 "" ""))]
  ;; Operand 2 not used on the i386.
  ""
{
  ix86_expand_call (operands[0], operands[1], operands[2], operands[3], NULL, 0);
  DONE;
})

(define_expand "sibcall_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:QI 1 "" "")
	      (match_operand:SI 2 "" "")))
   (use (match_operand:SI 3 "" ""))]
  ;; Operand 2 not used on the i386.
  ""
{
  ix86_expand_call (operands[0], operands[1], operands[2], operands[3], NULL, 1);
  DONE;
})

;; Call subroutine returning any type.

(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
		    (const_int 0))
	      (match_operand 1 "" "")
	      (match_operand 2 "" "")])]
  ""
{
  int i;

  /* In order to give reg-stack an easier job in validating two
     coprocessor registers as containing a possible return value,
     simply pretend the untyped call returns a complex long double
     value.  */

  ix86_expand_call ((TARGET_FLOAT_RETURNS_IN_80387
		     ? gen_rtx_REG (XCmode, FIRST_FLOAT_REG) : NULL),
		    operands[0], const0_rtx, GEN_INT (SSE_REGPARM_MAX - 1),
		    NULL, 0);

  for (i = 0; i < XVECLEN (operands[2], 0); i++)
    {
      rtx set = XVECEXP (operands[2], 0, i);
      emit_move_insn (SET_DEST (set), SET_SRC (set));
    }

  /* The optimizer does not know that the call sets the function value
     registers we stored in the result block.  We avoid problems by
     claiming that all hard registers are used and clobbered at this
     point.  */
  emit_insn (gen_blockage (const0_rtx));

  DONE;
})

;; Prologue and epilogue instructions

;; UNSPEC_VOLATILE is considered to use and clobber all hard registers and
;; all of memory.  This blocks insns from being moved across this point.

(define_insn "blockage"
  [(unspec_volatile [(match_operand 0 "" "")] UNSPECV_BLOCKAGE)]
  ""
  ""
  [(set_attr "length" "0")])

;; Insn emitted into the body of a function to return from a function.
;; This is only done if the function's epilogue is known to be simple.
;; See comments for ix86_can_use_return_insn_p in i386.c.

(define_expand "return"
  [(return)]
  "ix86_can_use_return_insn_p ()"
{
  if (current_function_pops_args)
    {
      rtx popc = GEN_INT (current_function_pops_args);
      emit_jump_insn (gen_return_pop_internal (popc));
      DONE;
    }
})

(define_insn "return_internal"
  [(return)]
  "reload_completed"
  "ret"
  [(set_attr "length" "1")
   (set_attr "length_immediate" "0")
   (set_attr "modrm" "0")])

;; Used by x86_machine_dependent_reorg to avoid penalty on single byte RET
;; instruction Athlon and K8 have.

(define_insn "return_internal_long"
  [(return)
   (unspec [(const_int 0)] UNSPEC_REP)]
  "reload_completed"
  "rep {;} ret"
  [(set_attr "length" "1")
   (set_attr "length_immediate" "0")
   (set_attr "prefix_rep" "1")
   (set_attr "modrm" "0")])

(define_insn "return_pop_internal"
  [(return)
   (use (match_operand:SI 0 "const_int_operand" ""))]
  "reload_completed"
  "ret\t%0"
  [(set_attr "length" "3")
   (set_attr "length_immediate" "2")
   (set_attr "modrm" "0")])

(define_insn "return_indirect_internal"
  [(return)
   (use (match_operand:SI 0 "register_operand" "r"))]
  "reload_completed"
  "jmp\t%A0"
  [(set_attr "type" "ibr")
   (set_attr "length_immediate" "0")])

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop"
  [(set_attr "length" "1")
   (set_attr "length_immediate" "0")
   (set_attr "modrm" "0")
   (set_attr "ppro_uops" "one")])

;; Align to 16-byte boundary, max skip in op0.  Used to avoid
;; branch prediction penalty for the third jump in a 16-byte
;; block on K8.

(define_insn "align"
  [(unspec_volatile [(match_operand 0 "" "")] UNSPECV_ALIGN)]
  ""
{
#ifdef ASM_OUTPUT_MAX_SKIP_ALIGN
  ASM_OUTPUT_MAX_SKIP_ALIGN (asm_out_file, 4, (int)INTVAL (operands[0]));
#else
  /* It is tempting to use ASM_OUTPUT_ALIGN here, but we don't want to do that.
     The align insn is used to avoid 3 jump instructions in the row to improve
     branch prediction and the benefits hardly outweight the cost of extra 8
     nops on the average inserted by full alignment pseudo operation.  */
#endif
  return "";
}
  [(set_attr "length" "16")])

(define_expand "prologue"
  [(const_int 1)]
  ""
  "ix86_expand_prologue (); DONE;")

(define_insn "set_got"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(const_int 0)] UNSPEC_SET_GOT))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT"
  { return output_set_got (operands[0]); }
  [(set_attr "type" "multi")
   (set_attr "length" "12")])

(define_expand "epilogue"
  [(const_int 1)]
  ""
  "ix86_expand_epilogue (1); DONE;")

(define_expand "sibcall_epilogue"
  [(const_int 1)]
  ""
  "ix86_expand_epilogue (0); DONE;")

(define_expand "eh_return"
  [(use (match_operand 0 "register_operand" ""))]
  ""
{
  rtx tmp, sa = EH_RETURN_STACKADJ_RTX, ra = operands[0];

  /* Tricky bit: we write the address of the handler to which we will
     be returning into someone else's stack frame, one word below the
     stack address we wish to restore.  */
  tmp = gen_rtx_PLUS (Pmode, arg_pointer_rtx, sa);
  tmp = plus_constant (tmp, -UNITS_PER_WORD);
  tmp = gen_rtx_MEM (Pmode, tmp);
  emit_move_insn (tmp, ra);

  if (Pmode == SImode)
    emit_insn (gen_eh_return_si (sa));
  else
    emit_insn (gen_eh_return_di (sa));
  emit_barrier ();
  DONE;
})

(define_insn_and_split "eh_return_si"
  [(unspec_volatile [(match_operand:SI 0 "register_operand" "c")]
		    UNSPECV_EH_RETURN)]
  "!TARGET_64BIT"
  "#"
  "reload_completed"
  [(const_int 1)]
  "ix86_expand_epilogue (2); DONE;")

(define_insn_and_split "eh_return_di"
  [(unspec_volatile [(match_operand:DI 0 "register_operand" "c")]
		    UNSPECV_EH_RETURN)]
  "TARGET_64BIT"
  "#"
  "reload_completed"
  [(const_int 1)]
  "ix86_expand_epilogue (2); DONE;")

(define_insn "leave"
  [(set (reg:SI 7) (plus:SI (reg:SI 6) (const_int 4)))
   (set (reg:SI 6) (mem:SI (reg:SI 6)))
   (clobber (mem:BLK (scratch)))]
  "!TARGET_64BIT"
  "leave"
  [(set_attr "type" "leave")])

(define_insn "leave_rex64"
  [(set (reg:DI 7) (plus:DI (reg:DI 6) (const_int 8)))
   (set (reg:DI 6) (mem:DI (reg:DI 6)))
   (clobber (mem:BLK (scratch)))]
  "TARGET_64BIT"
  "leave"
  [(set_attr "type" "leave")])

(define_expand "ffssi2"
  [(parallel
     [(set (match_operand:SI 0 "register_operand" "") 
	   (ffs:SI (match_operand:SI 1 "nonimmediate_operand" "")))
      (clobber (match_scratch:SI 2 ""))
      (clobber (reg:CC 17))])]
  ""
  "")

(define_insn_and_split "*ffs_cmove"
  [(set (match_operand:SI 0 "register_operand" "=r") 
	(ffs:SI (match_operand:SI 1 "nonimmediate_operand" "rm")))
   (clobber (match_scratch:SI 2 "=&r"))
   (clobber (reg:CC 17))]
  "TARGET_CMOVE"
  "#"
  "&& reload_completed"
  [(set (match_dup 2) (const_int -1))
   (parallel [(set (reg:CCZ 17) (compare:CCZ (match_dup 1) (const_int 0)))
	      (set (match_dup 0) (ctz:SI (match_dup 1)))])
   (set (match_dup 0) (if_then_else:SI
			(eq (reg:CCZ 17) (const_int 0))
			(match_dup 2)
			(match_dup 0)))
   (parallel [(set (match_dup 0) (plus:SI (match_dup 0) (const_int 1)))
	      (clobber (reg:CC 17))])]
  "")

(define_insn_and_split "*ffs_no_cmove"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r") 
	(ffs:SI (match_operand:SI 1 "nonimmediate_operand" "rm")))
   (clobber (match_scratch:SI 2 "=&q"))
   (clobber (reg:CC 17))]
  ""
  "#"
  "reload_completed"
  [(parallel [(set (reg:CCZ 17) (compare:CCZ (match_dup 1) (const_int 0)))
	      (set (match_dup 0) (ctz:SI (match_dup 1)))])
   (set (strict_low_part (match_dup 3))
	(eq:QI (reg:CCZ 17) (const_int 0)))
   (parallel [(set (match_dup 2) (neg:SI (match_dup 2)))
	      (clobber (reg:CC 17))])
   (parallel [(set (match_dup 0) (ior:SI (match_dup 0) (match_dup 2)))
	      (clobber (reg:CC 17))])
   (parallel [(set (match_dup 0) (plus:SI (match_dup 0) (const_int 1)))
	      (clobber (reg:CC 17))])]
{
  operands[3] = gen_lowpart (QImode, operands[2]);
  ix86_expand_clear (operands[2]);
})

(define_insn "*ffssi_1"
  [(set (reg:CCZ 17)
	(compare:CCZ (match_operand:SI 1 "nonimmediate_operand" "rm")
		     (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=r")
	(ctz:SI (match_dup 1)))]
  ""
  "bsf{l}\t{%1, %0|%0, %1}"
  [(set_attr "prefix_0f" "1")
   (set_attr "ppro_uops" "few")])

(define_insn "ctzsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ctz:SI (match_operand:SI 1 "nonimmediate_operand" "rm")))
   (clobber (reg:CC 17))]
  ""
  "bsf{l}\t{%1, %0|%0, %1}"
  [(set_attr "prefix_0f" "1")
   (set_attr "ppro_uops" "few")])

(define_expand "clzsi2"
  [(parallel
     [(set (match_operand:SI 0 "register_operand" "")
	   (minus:SI (const_int 31)
		     (clz:SI (match_operand:SI 1 "nonimmediate_operand" ""))))
      (clobber (reg:CC 17))])
   (parallel
     [(set (match_dup 0) (xor:SI (match_dup 0) (const_int 31)))
      (clobber (reg:CC 17))])]
  ""
  "")

(define_insn "*bsr"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(minus:SI (const_int 31)
		  (clz:SI (match_operand:SI 1 "nonimmediate_operand" "rm"))))
   (clobber (reg:CC 17))]
  ""
  "bsr{l}\t{%1, %0|%0, %1}"
  [(set_attr "prefix_0f" "1")
   (set_attr "ppro_uops" "few")])

;; Thread-local storage patterns for ELF.
;;
;; Note that these code sequences must appear exactly as shown
;; in order to allow linker relaxation.

(define_insn "*tls_global_dynamic_32_gnu"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "tls_symbolic_operand" "")
		    (match_operand:SI 3 "call_insn_operand" "")]
		    UNSPEC_TLS_GD))
   (clobber (match_scratch:SI 4 "=d"))
   (clobber (match_scratch:SI 5 "=c"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_GNU_TLS"
  "lea{l}\t{%a2@TLSGD(,%1,1), %0|%0, %a2@TLSGD[%1*1]}\;call\t%P3"
  [(set_attr "type" "multi")
   (set_attr "length" "12")])

(define_insn "*tls_global_dynamic_32_sun"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "tls_symbolic_operand" "")
		    (match_operand:SI 3 "call_insn_operand" "")]
		    UNSPEC_TLS_GD))
   (clobber (match_scratch:SI 4 "=d"))
   (clobber (match_scratch:SI 5 "=c"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_SUN_TLS"
  "lea{l}\t{%a2@DTLNDX(%1), %4|%4, %a2@DTLNDX[%1]}
	push{l}\t%4\;call\t%a2@TLSPLT\;pop{l}\t%4\;nop"
  [(set_attr "type" "multi")
   (set_attr "length" "14")])

(define_expand "tls_global_dynamic_32"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (unspec:SI
		    [(match_dup 2)
		     (match_operand:SI 1 "tls_symbolic_operand" "")
		     (match_dup 3)]
		    UNSPEC_TLS_GD))
	      (clobber (match_scratch:SI 4 ""))
	      (clobber (match_scratch:SI 5 ""))
	      (clobber (reg:CC 17))])]
  ""
{
  if (flag_pic)
    operands[2] = pic_offset_table_rtx;
  else
    {
      operands[2] = gen_reg_rtx (Pmode);
      emit_insn (gen_set_got (operands[2]));
    }
  operands[3] = ix86_tls_get_addr ();
})

(define_insn "*tls_global_dynamic_64"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(call (mem:QI (match_operand:DI 2 "call_insn_operand" ""))
		      (match_operand:DI 3 "" "")))
   (unspec:DI [(match_operand:DI 1 "tls_symbolic_operand" "")]
	      UNSPEC_TLS_GD)]
  "TARGET_64BIT"
  ".byte\t0x66\;lea{q}\t{%a1@TLSGD(%%rip), %%rdi|%%rdi, %a1@TLSGD[%%rip]}\;.word\t0x6666\;rex64\;call\t%P2"
  [(set_attr "type" "multi")
   (set_attr "length" "16")])

(define_expand "tls_global_dynamic_64"
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (call (mem:QI (match_dup 2)) (const_int 0)))
	      (unspec:DI [(match_operand:DI 1 "tls_symbolic_operand" "")]
			 UNSPEC_TLS_GD)])]
  ""
{
  operands[2] = ix86_tls_get_addr ();
})

(define_insn "*tls_local_dynamic_base_32_gnu"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
                    (match_operand:SI 2 "call_insn_operand" "")]
		   UNSPEC_TLS_LD_BASE))
   (clobber (match_scratch:SI 3 "=d"))
   (clobber (match_scratch:SI 4 "=c"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_GNU_TLS"
  "lea{l}\t{%&@TLSLDM(%1), %0|%0, %&@TLSLDM[%1]}\;call\t%P2"
  [(set_attr "type" "multi")
   (set_attr "length" "11")])

(define_insn "*tls_local_dynamic_base_32_sun"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
                    (match_operand:SI 2 "call_insn_operand" "")]
		   UNSPEC_TLS_LD_BASE))
   (clobber (match_scratch:SI 3 "=d"))
   (clobber (match_scratch:SI 4 "=c"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_SUN_TLS"
  "lea{l}\t{%&@TMDNX(%1), %3|%3, %&@TMDNX[%1]}
	push{l}\t%3\;call\t%&@TLSPLT\;pop{l}\t%3"
  [(set_attr "type" "multi")
   (set_attr "length" "13")])

(define_expand "tls_local_dynamic_base_32"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (unspec:SI [(match_dup 1) (match_dup 2)]
			      UNSPEC_TLS_LD_BASE))
	      (clobber (match_scratch:SI 3 ""))
	      (clobber (match_scratch:SI 4 ""))
	      (clobber (reg:CC 17))])]
  ""
{
  if (flag_pic)
    operands[1] = pic_offset_table_rtx;
  else
    {
      operands[1] = gen_reg_rtx (Pmode);
      emit_insn (gen_set_got (operands[1]));
    }
  operands[2] = ix86_tls_get_addr ();
})

(define_insn "*tls_local_dynamic_base_64"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(call (mem:QI (match_operand:DI 1 "call_insn_operand" ""))
		      (match_operand:DI 2 "" "")))
   (unspec:DI [(const_int 0)] UNSPEC_TLS_LD_BASE)]
  "TARGET_64BIT"
  "lea{q}\t{%&@TLSLD(%%rip), %%rdi|%%rdi, %&@TLSLD[%%rip]}\;call\t%P1"
  [(set_attr "type" "multi")
   (set_attr "length" "12")])

(define_expand "tls_local_dynamic_base_64"
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (call (mem:QI (match_dup 1)) (const_int 0)))
	      (unspec:DI [(const_int 0)] UNSPEC_TLS_LD_BASE)])]
  ""
{
  operands[1] = ix86_tls_get_addr ();
})

;; Local dynamic of a single variable is a lose.  Show combine how
;; to convert that back to global dynamic.

(define_insn_and_split "*tls_local_dynamic_32_once"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(plus:SI (unspec:SI [(match_operand:SI 1 "register_operand" "b")
			     (match_operand:SI 2 "call_insn_operand" "")]
			    UNSPEC_TLS_LD_BASE)
		 (const:SI (unspec:SI
			    [(match_operand:SI 3 "tls_symbolic_operand" "")]
			    UNSPEC_DTPOFF))))
   (clobber (match_scratch:SI 4 "=d"))
   (clobber (match_scratch:SI 5 "=c"))
   (clobber (reg:CC 17))]
  ""
  "#"
  ""
  [(parallel [(set (match_dup 0)
		   (unspec:SI [(match_dup 1) (match_dup 3) (match_dup 2)]
			      UNSPEC_TLS_GD))
	      (clobber (match_dup 4))
	      (clobber (match_dup 5))
	      (clobber (reg:CC 17))])]
  "")

;; Load and add the thread base pointer from %gs:0.

(define_insn "*load_tp_si"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(const_int 0)] UNSPEC_TP))]
  "!TARGET_64BIT"
  "mov{l}\t{%%gs:0, %0|%0, DWORD PTR %%gs:0}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0")
   (set_attr "length" "7")
   (set_attr "memory" "load")
   (set_attr "imm_disp" "false")])

(define_insn "*add_tp_si"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (unspec:SI [(const_int 0)] UNSPEC_TP)
		 (match_operand:SI 1 "register_operand" "0")))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT"
  "add{l}\t{%%gs:0, %0|%0, DWORD PTR %%gs:0}"
  [(set_attr "type" "alu")
   (set_attr "modrm" "0")
   (set_attr "length" "7")
   (set_attr "memory" "load")
   (set_attr "imm_disp" "false")])

(define_insn "*load_tp_di"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(const_int 0)] UNSPEC_TP))]
  "TARGET_64BIT"
  "mov{q}\t{%%fs:0, %0|%0, QWORD PTR %%fs:0}"
  [(set_attr "type" "imov")
   (set_attr "modrm" "0")
   (set_attr "length" "7")
   (set_attr "memory" "load")
   (set_attr "imm_disp" "false")])

(define_insn "*add_tp_di"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(plus:DI (unspec:DI [(const_int 0)] UNSPEC_TP)
		 (match_operand:DI 1 "register_operand" "0")))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "add{q}\t{%%fs:0, %0|%0, QWORD PTR %%fs:0}"
  [(set_attr "type" "alu")
   (set_attr "modrm" "0")
   (set_attr "length" "7")
   (set_attr "memory" "load")
   (set_attr "imm_disp" "false")])

;; These patterns match the binary 387 instructions for addM3, subM3,
;; mulM3 and divM3.  There are three patterns for each of DFmode and
;; SFmode.  The first is the normal insn, the second the same insn but
;; with one operand a conversion, and the third the same insn but with
;; the other operand a conversion.  The conversion may be SFmode or
;; SImode if the target mode DFmode, but only SImode if the target mode
;; is SFmode.

;; Gcc is slightly more smart about handling normal two address instructions
;; so use special patterns for add and mull.
(define_insn "*fop_sf_comm_nosse"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(match_operator:SF 3 "binary_fp_operator"
			[(match_operand:SF 1 "nonimmediate_operand" "%0")
			 (match_operand:SF 2 "nonimmediate_operand" "fm")]))]
  "TARGET_80387 && !TARGET_SSE_MATH
   && GET_RTX_CLASS (GET_CODE (operands[3])) == 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
	(if_then_else (match_operand:SF 3 "mult_operator" "") 
	   (const_string "fmul")
	   (const_string "fop")))
   (set_attr "mode" "SF")])

(define_insn "*fop_sf_comm"
  [(set (match_operand:SF 0 "register_operand" "=f#x,x#f")
	(match_operator:SF 3 "binary_fp_operator"
			[(match_operand:SF 1 "nonimmediate_operand" "%0,0")
			 (match_operand:SF 2 "nonimmediate_operand" "fm#x,xm#f")]))]
  "TARGET_80387 && TARGET_SSE_MATH && TARGET_MIX_SSE_I387
   && GET_RTX_CLASS (GET_CODE (operands[3])) == 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
	(if_then_else (eq_attr "alternative" "1")
	   (if_then_else (match_operand:SF 3 "mult_operator" "") 
	      (const_string "ssemul")
	      (const_string "sseadd"))
	   (if_then_else (match_operand:SF 3 "mult_operator" "") 
	      (const_string "fmul")
	      (const_string "fop"))))
   (set_attr "mode" "SF")])

(define_insn "*fop_sf_comm_sse"
  [(set (match_operand:SF 0 "register_operand" "=x")
	(match_operator:SF 3 "binary_fp_operator"
			[(match_operand:SF 1 "nonimmediate_operand" "%0")
			 (match_operand:SF 2 "nonimmediate_operand" "xm")]))]
  "TARGET_SSE_MATH && GET_RTX_CLASS (GET_CODE (operands[3])) == 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (if_then_else (match_operand:SF 3 "mult_operator" "") 
	   (const_string "ssemul")
	   (const_string "sseadd")))
   (set_attr "mode" "SF")])

(define_insn "*fop_df_comm_nosse"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(match_operator:DF 3 "binary_fp_operator"
			[(match_operand:DF 1 "nonimmediate_operand" "%0")
			 (match_operand:DF 2 "nonimmediate_operand" "fm")]))]
  "TARGET_80387 && (!TARGET_SSE2 || !TARGET_SSE_MATH)
   && GET_RTX_CLASS (GET_CODE (operands[3])) == 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
	(if_then_else (match_operand:SF 3 "mult_operator" "") 
	   (const_string "fmul")
	   (const_string "fop")))
   (set_attr "mode" "DF")])

(define_insn "*fop_df_comm"
  [(set (match_operand:DF 0 "register_operand" "=f#Y,Y#f")
	(match_operator:DF 3 "binary_fp_operator"
			[(match_operand:DF 1 "nonimmediate_operand" "%0,0")
			 (match_operand:DF 2 "nonimmediate_operand" "fm#Y,Ym#f")]))]
  "TARGET_80387 && TARGET_SSE_MATH && TARGET_SSE2 && TARGET_MIX_SSE_I387
   && GET_RTX_CLASS (GET_CODE (operands[3])) == 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
	(if_then_else (eq_attr "alternative" "1")
	   (if_then_else (match_operand:SF 3 "mult_operator" "") 
	      (const_string "ssemul")
	      (const_string "sseadd"))
	   (if_then_else (match_operand:SF 3 "mult_operator" "") 
	      (const_string "fmul")
	      (const_string "fop"))))
   (set_attr "mode" "DF")])

(define_insn "*fop_df_comm_sse"
  [(set (match_operand:DF 0 "register_operand" "=Y")
	(match_operator:DF 3 "binary_fp_operator"
			[(match_operand:DF 1 "nonimmediate_operand" "%0")
			 (match_operand:DF 2 "nonimmediate_operand" "Ym")]))]
  "TARGET_SSE2 && TARGET_SSE_MATH
   && GET_RTX_CLASS (GET_CODE (operands[3])) == 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (if_then_else (match_operand:SF 3 "mult_operator" "") 
	   (const_string "ssemul")
	   (const_string "sseadd")))
   (set_attr "mode" "DF")])

(define_insn "*fop_xf_comm"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(match_operator:XF 3 "binary_fp_operator"
			[(match_operand:XF 1 "register_operand" "%0")
			 (match_operand:XF 2 "register_operand" "f")]))]
  "TARGET_80387
   && GET_RTX_CLASS (GET_CODE (operands[3])) == 'c'"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (if_then_else (match_operand:XF 3 "mult_operator" "") 
           (const_string "fmul")
           (const_string "fop")))
   (set_attr "mode" "XF")])

(define_insn "*fop_sf_1_nosse"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
	(match_operator:SF 3 "binary_fp_operator"
			[(match_operand:SF 1 "nonimmediate_operand" "0,fm")
			 (match_operand:SF 2 "nonimmediate_operand" "fm,0")]))]
  "TARGET_80387 && !TARGET_SSE_MATH
   && GET_RTX_CLASS (GET_CODE (operands[3])) != 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:SF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:SF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "SF")])

(define_insn "*fop_sf_1"
  [(set (match_operand:SF 0 "register_operand" "=f,f,x")
	(match_operator:SF 3 "binary_fp_operator"
			[(match_operand:SF 1 "nonimmediate_operand" "0,fm,0")
			 (match_operand:SF 2 "nonimmediate_operand" "fm,0,xm#f")]))]
  "TARGET_80387 && TARGET_SSE_MATH && TARGET_MIX_SSE_I387
   && GET_RTX_CLASS (GET_CODE (operands[3])) != 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(and (eq_attr "alternative" "2")
	            (match_operand:SF 3 "mult_operator" ""))
                 (const_string "ssemul")
	       (and (eq_attr "alternative" "2")
	            (match_operand:SF 3 "div_operator" ""))
                 (const_string "ssediv")
	       (eq_attr "alternative" "2")
                 (const_string "sseadd")
	       (match_operand:SF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:SF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "SF")])

(define_insn "*fop_sf_1_sse"
  [(set (match_operand:SF 0 "register_operand" "=x")
	(match_operator:SF 3 "binary_fp_operator"
			[(match_operand:SF 1 "register_operand" "0")
			 (match_operand:SF 2 "nonimmediate_operand" "xm")]))]
  "TARGET_SSE_MATH
   && GET_RTX_CLASS (GET_CODE (operands[3])) != 'c'"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:SF 3 "mult_operator" "")
                 (const_string "ssemul")
	       (match_operand:SF 3 "div_operator" "")
                 (const_string "ssediv")
              ]
              (const_string "sseadd")))
   (set_attr "mode" "SF")])

;; ??? Add SSE splitters for these!
(define_insn "*fop_sf_2"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
	(match_operator:SF 3 "binary_fp_operator"
	  [(float:SF (match_operand:SI 1 "nonimmediate_operand" "m,?r"))
	   (match_operand:SF 2 "register_operand" "0,0")]))]
  "TARGET_80387 && TARGET_USE_FIOP && !TARGET_SSE_MATH"
  "* return which_alternative ? \"#\" : output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:SF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:SF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "fp_int_src" "true")
   (set_attr "ppro_uops" "many")
   (set_attr "mode" "SI")])

(define_insn "*fop_sf_3"
  [(set (match_operand:SF 0 "register_operand" "=f,f")
	(match_operator:SF 3 "binary_fp_operator"
	  [(match_operand:SF 1 "register_operand" "0,0")
	   (float:SF (match_operand:SI 2 "nonimmediate_operand" "m,?r"))]))]
  "TARGET_80387 && TARGET_USE_FIOP && !TARGET_SSE_MATH"
  "* return which_alternative ? \"#\" : output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:SF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:SF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "fp_int_src" "true")
   (set_attr "ppro_uops" "many")
   (set_attr "mode" "SI")])

(define_insn "*fop_df_1_nosse"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(match_operator:DF 3 "binary_fp_operator"
			[(match_operand:DF 1 "nonimmediate_operand" "0,fm")
			 (match_operand:DF 2 "nonimmediate_operand" "fm,0")]))]
  "TARGET_80387 && (!TARGET_SSE2 || !TARGET_SSE_MATH)
   && GET_RTX_CLASS (GET_CODE (operands[3])) != 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:DF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:DF 3 "div_operator" "")
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "DF")])


(define_insn "*fop_df_1"
  [(set (match_operand:DF 0 "register_operand" "=f#Y,f#Y,Y#f")
	(match_operator:DF 3 "binary_fp_operator"
			[(match_operand:DF 1 "nonimmediate_operand" "0,fm,0")
			 (match_operand:DF 2 "nonimmediate_operand" "fm,0,Ym#f")]))]
  "TARGET_80387 && TARGET_SSE2 && TARGET_SSE_MATH && TARGET_MIX_SSE_I387
   && GET_RTX_CLASS (GET_CODE (operands[3])) != 'c'
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(and (eq_attr "alternative" "2")
	            (match_operand:SF 3 "mult_operator" ""))
                 (const_string "ssemul")
	       (and (eq_attr "alternative" "2")
	            (match_operand:SF 3 "div_operator" ""))
                 (const_string "ssediv")
	       (eq_attr "alternative" "2")
                 (const_string "sseadd")
	       (match_operand:DF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:DF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "DF")])

(define_insn "*fop_df_1_sse"
  [(set (match_operand:DF 0 "register_operand" "=Y")
	(match_operator:DF 3 "binary_fp_operator"
			[(match_operand:DF 1 "register_operand" "0")
			 (match_operand:DF 2 "nonimmediate_operand" "Ym")]))]
  "TARGET_SSE2 && TARGET_SSE_MATH
   && GET_RTX_CLASS (GET_CODE (operands[3])) != 'c'"
  "* return output_387_binary_op (insn, operands);"
  [(set_attr "mode" "DF")
   (set (attr "type") 
        (cond [(match_operand:SF 3 "mult_operator" "")
                 (const_string "ssemul")
	       (match_operand:SF 3 "div_operator" "")
                 (const_string "ssediv")
              ]
              (const_string "sseadd")))])

;; ??? Add SSE splitters for these!
(define_insn "*fop_df_2"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(match_operator:DF 3 "binary_fp_operator"
	   [(float:DF (match_operand:SI 1 "nonimmediate_operand" "m,?r"))
	    (match_operand:DF 2 "register_operand" "0,0")]))]
  "TARGET_80387 && TARGET_USE_FIOP && !(TARGET_SSE2 && TARGET_SSE_MATH)"
  "* return which_alternative ? \"#\" : output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:DF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:DF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "fp_int_src" "true")
   (set_attr "ppro_uops" "many")
   (set_attr "mode" "SI")])

(define_insn "*fop_df_3"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(match_operator:DF 3 "binary_fp_operator"
	   [(match_operand:DF 1 "register_operand" "0,0")
	    (float:DF (match_operand:SI 2 "nonimmediate_operand" "m,?r"))]))]
  "TARGET_80387 && TARGET_USE_FIOP && !(TARGET_SSE2 && TARGET_SSE_MATH)"
  "* return which_alternative ? \"#\" : output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:DF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:DF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "fp_int_src" "true")
   (set_attr "ppro_uops" "many")
   (set_attr "mode" "SI")])

(define_insn "*fop_df_4"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(match_operator:DF 3 "binary_fp_operator"
	   [(float_extend:DF (match_operand:SF 1 "nonimmediate_operand" "fm,0"))
	    (match_operand:DF 2 "register_operand" "0,f")]))]
  "TARGET_80387 && (!TARGET_SSE2 || !TARGET_SSE_MATH)
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:DF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:DF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "SF")])

(define_insn "*fop_df_5"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(match_operator:DF 3 "binary_fp_operator"
	  [(match_operand:DF 1 "register_operand" "0,f")
	   (float_extend:DF
	    (match_operand:SF 2 "nonimmediate_operand" "fm,0"))]))]
  "TARGET_80387 && !(TARGET_SSE2 && TARGET_SSE_MATH)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:DF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:DF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "SF")])

(define_insn "*fop_df_6"
  [(set (match_operand:DF 0 "register_operand" "=f,f")
	(match_operator:DF 3 "binary_fp_operator"
	  [(float_extend:DF
	    (match_operand:SF 1 "register_operand" "0,f"))
	   (float_extend:DF
	    (match_operand:SF 2 "nonimmediate_operand" "fm,0"))]))]
  "TARGET_80387 && !(TARGET_SSE2 && TARGET_SSE_MATH)"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:DF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:DF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "SF")])

(define_insn "*fop_xf_1"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(match_operator:XF 3 "binary_fp_operator"
			[(match_operand:XF 1 "register_operand" "0,f")
			 (match_operand:XF 2 "register_operand" "f,0")]))]
  "TARGET_80387
   && GET_RTX_CLASS (GET_CODE (operands[3])) != 'c'"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:XF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:XF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "XF")])

(define_insn "*fop_xf_2"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(match_operator:XF 3 "binary_fp_operator"
	   [(float:XF (match_operand:SI 1 "nonimmediate_operand" "m,?r"))
	    (match_operand:XF 2 "register_operand" "0,0")]))]
  "TARGET_80387 && TARGET_USE_FIOP"
  "* return which_alternative ? \"#\" : output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:XF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:XF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "fp_int_src" "true")
   (set_attr "mode" "SI")
   (set_attr "ppro_uops" "many")])

(define_insn "*fop_xf_3"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(match_operator:XF 3 "binary_fp_operator"
	  [(match_operand:XF 1 "register_operand" "0,0")
	   (float:XF (match_operand:SI 2 "nonimmediate_operand" "m,?r"))]))]
  "TARGET_80387 && TARGET_USE_FIOP"
  "* return which_alternative ? \"#\" : output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:XF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:XF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "fp_int_src" "true")
   (set_attr "mode" "SI")
   (set_attr "ppro_uops" "many")])

(define_insn "*fop_xf_4"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(match_operator:XF 3 "binary_fp_operator"
	   [(float_extend:XF (match_operand 1 "nonimmediate_operand" "fm,0"))
	    (match_operand:XF 2 "register_operand" "0,f")]))]
  "TARGET_80387"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:XF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:XF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "SF")])

(define_insn "*fop_xf_5"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(match_operator:XF 3 "binary_fp_operator"
	  [(match_operand:XF 1 "register_operand" "0,f")
	   (float_extend:XF
	    (match_operand 2 "nonimmediate_operand" "fm,0"))]))]
  "TARGET_80387"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:XF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:XF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "SF")])

(define_insn "*fop_xf_6"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(match_operator:XF 3 "binary_fp_operator"
	  [(float_extend:XF
	    (match_operand 1 "register_operand" "0,f"))
	   (float_extend:XF
	    (match_operand 2 "nonimmediate_operand" "fm,0"))]))]
  "TARGET_80387"
  "* return output_387_binary_op (insn, operands);"
  [(set (attr "type") 
        (cond [(match_operand:XF 3 "mult_operator" "") 
                 (const_string "fmul")
               (match_operand:XF 3 "div_operator" "") 
                 (const_string "fdiv")
              ]
              (const_string "fop")))
   (set_attr "mode" "SF")])

(define_split
  [(set (match_operand 0 "register_operand" "")
	(match_operator 3 "binary_fp_operator"
	   [(float (match_operand:SI 1 "register_operand" ""))
	    (match_operand 2 "register_operand" "")]))]
  "TARGET_80387 && reload_completed
   && FLOAT_MODE_P (GET_MODE (operands[0]))"
  [(const_int 0)]
{ 
  operands[4] = ix86_force_to_memory (GET_MODE (operands[1]), operands[1]);
  operands[4] = gen_rtx_FLOAT (GET_MODE (operands[0]), operands[4]);
  emit_insn (gen_rtx_SET (VOIDmode, operands[0],
			  gen_rtx_fmt_ee (GET_CODE (operands[3]),
					  GET_MODE (operands[3]),
					  operands[4],
					  operands[2])));
  ix86_free_from_memory (GET_MODE (operands[1]));
  DONE;
})

(define_split
  [(set (match_operand 0 "register_operand" "")
	(match_operator 3 "binary_fp_operator"
	   [(match_operand 1 "register_operand" "")
	    (float (match_operand:SI 2 "register_operand" ""))]))]
  "TARGET_80387 && reload_completed
   && FLOAT_MODE_P (GET_MODE (operands[0]))"
  [(const_int 0)]
{
  operands[4] = ix86_force_to_memory (GET_MODE (operands[2]), operands[2]);
  operands[4] = gen_rtx_FLOAT (GET_MODE (operands[0]), operands[4]);
  emit_insn (gen_rtx_SET (VOIDmode, operands[0],
			  gen_rtx_fmt_ee (GET_CODE (operands[3]),
					  GET_MODE (operands[3]),
					  operands[1],
					  operands[4])));
  ix86_free_from_memory (GET_MODE (operands[2]));
  DONE;
})

;; FPU special functions.

(define_expand "sqrtsf2"
  [(set (match_operand:SF 0 "register_operand" "")
	(sqrt:SF (match_operand:SF 1 "nonimmediate_operand" "")))]
  "(! TARGET_NO_FANCY_MATH_387 && TARGET_80387) || TARGET_SSE_MATH"
{
  if (!TARGET_SSE_MATH)
    operands[1] = force_reg (SFmode, operands[1]);
})

(define_insn "sqrtsf2_1"
  [(set (match_operand:SF 0 "register_operand" "=f#x,x#f")
	(sqrt:SF (match_operand:SF 1 "nonimmediate_operand" "0#x,xm#f")))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && (TARGET_SSE_MATH && TARGET_MIX_SSE_I387)"
  "@
   fsqrt
   sqrtss\t{%1, %0|%0, %1}"
  [(set_attr "type" "fpspc,sse")
   (set_attr "mode" "SF,SF")
   (set_attr "athlon_decode" "direct,*")])

(define_insn "sqrtsf2_1_sse_only"
  [(set (match_operand:SF 0 "register_operand" "=x")
	(sqrt:SF (match_operand:SF 1 "nonimmediate_operand" "xm")))]
  "TARGET_SSE_MATH && (!TARGET_80387 || !TARGET_MIX_SSE_I387)"
  "sqrtss\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "*")])

(define_insn "sqrtsf2_i387"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "register_operand" "0")))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && !TARGET_SSE_MATH"
  "fsqrt"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "direct")])

(define_expand "sqrtdf2"
  [(set (match_operand:DF 0 "register_operand" "")
	(sqrt:DF (match_operand:DF 1 "nonimmediate_operand" "")))]
  "(! TARGET_NO_FANCY_MATH_387 && TARGET_80387)
   || (TARGET_SSE2 && TARGET_SSE_MATH)"
{
  if (!TARGET_SSE2 || !TARGET_SSE_MATH)
    operands[1] = force_reg (DFmode, operands[1]);
})

(define_insn "sqrtdf2_1"
  [(set (match_operand:DF 0 "register_operand" "=f#Y,Y#f")
	(sqrt:DF (match_operand:DF 1 "nonimmediate_operand" "0#Y,Ym#f")))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && (TARGET_SSE2 && TARGET_SSE_MATH && TARGET_MIX_SSE_I387)"
  "@
   fsqrt
   sqrtsd\t{%1, %0|%0, %1}"
  [(set_attr "type" "fpspc,sse")
   (set_attr "mode" "DF,DF")
   (set_attr "athlon_decode" "direct,*")])

(define_insn "sqrtdf2_1_sse_only"
  [(set (match_operand:DF 0 "register_operand" "=Y")
	(sqrt:DF (match_operand:DF 1 "nonimmediate_operand" "Ym")))]
  "TARGET_SSE2 && TARGET_SSE_MATH && (!TARGET_80387 || !TARGET_MIX_SSE_I387)"
  "sqrtsd\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "*")])

(define_insn "sqrtdf2_i387"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(sqrt:DF (match_operand:DF 1 "register_operand" "0")))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && (!TARGET_SSE2 || !TARGET_SSE_MATH)"
  "fsqrt"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "direct")])

(define_insn "*sqrtextendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(sqrt:DF (float_extend:DF
		  (match_operand:SF 1 "register_operand" "0"))))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && !(TARGET_SSE2 && TARGET_SSE_MATH)"
  "fsqrt"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "direct")])

(define_insn "sqrtxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(sqrt:XF (match_operand:XF 1 "register_operand" "0")))]
  "TARGET_80387 && !TARGET_NO_FANCY_MATH_387 
   && (TARGET_IEEE_FP || flag_unsafe_math_optimizations) "
  "fsqrt"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")
   (set_attr "athlon_decode" "direct")])

(define_insn "*sqrtextenddfxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(sqrt:XF (float_extend:XF
		  (match_operand:DF 1 "register_operand" "0"))))]
  "TARGET_80387 && !TARGET_NO_FANCY_MATH_387"
  "fsqrt"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")
   (set_attr "athlon_decode" "direct")])

(define_insn "*sqrtextendsfxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(sqrt:XF (float_extend:XF
		  (match_operand:SF 1 "register_operand" "0"))))]
  "TARGET_80387 && !TARGET_NO_FANCY_MATH_387"
  "fsqrt"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")
   (set_attr "athlon_decode" "direct")])

(define_insn "sindf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(unspec:DF [(match_operand:DF 1 "register_operand" "0")] UNSPEC_SIN))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387 
   && flag_unsafe_math_optimizations"
  "fsin"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")])

(define_insn "sinsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(unspec:SF [(match_operand:SF 1 "register_operand" "0")] UNSPEC_SIN))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387 
   && flag_unsafe_math_optimizations"
  "fsin"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "SF")])

(define_insn "*sinextendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(unspec:DF [(float_extend:DF
		     (match_operand:SF 1 "register_operand" "0"))]
		   UNSPEC_SIN))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387 
   && flag_unsafe_math_optimizations"
  "fsin"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")])

(define_insn "sinxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(unspec:XF [(match_operand:XF 1 "register_operand" "0")] UNSPEC_SIN))]
  "TARGET_80387 && !TARGET_NO_FANCY_MATH_387
   && flag_unsafe_math_optimizations"
  "fsin"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")])

(define_insn "cosdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(unspec:DF [(match_operand:DF 1 "register_operand" "0")] UNSPEC_COS))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387 
   && flag_unsafe_math_optimizations"
  "fcos"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")])

(define_insn "cossf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(unspec:SF [(match_operand:SF 1 "register_operand" "0")] UNSPEC_COS))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387 
   && flag_unsafe_math_optimizations"
  "fcos"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "SF")])

(define_insn "*cosextendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(unspec:DF [(float_extend:DF
		     (match_operand:SF 1 "register_operand" "0"))]
		   UNSPEC_COS))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387 
   && flag_unsafe_math_optimizations"
  "fcos"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")])

(define_insn "cosxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(unspec:XF [(match_operand:XF 1 "register_operand" "0")] UNSPEC_COS))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fcos"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")])

(define_insn "atan2df3_1"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(unspec:DF [(match_operand:DF 2 "register_operand" "0")
		    (match_operand:DF 1 "register_operand" "u")]
		   UNSPEC_FPATAN))
   (clobber (match_scratch:DF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fpatan"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")])

(define_expand "atan2df3"
  [(use (match_operand:DF 0 "register_operand" "=f"))
   (use (match_operand:DF 2 "register_operand" "0"))
   (use (match_operand:DF 1 "register_operand" "u"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx copy = gen_reg_rtx (DFmode);
  emit_move_insn (copy, operands[1]);
  emit_insn (gen_atan2df3_1 (operands[0], copy, operands[2]));
  DONE;
})

(define_insn "atan2sf3_1"
  [(set (match_operand:SF 0 "register_operand" "=f")
        (unspec:SF [(match_operand:SF 2 "register_operand" "0")
		    (match_operand:SF 1 "register_operand" "u")]
		   UNSPEC_FPATAN))
   (clobber (match_scratch:SF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fpatan"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "SF")])

(define_expand "atan2sf3"
  [(use (match_operand:SF 0 "register_operand" "=f"))
   (use (match_operand:SF 2 "register_operand" "0"))
   (use (match_operand:SF 1 "register_operand" "u"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx copy = gen_reg_rtx (SFmode);
  emit_move_insn (copy, operands[1]);
  emit_insn (gen_atan2sf3_1 (operands[0], copy, operands[2]));
  DONE;
})

(define_insn "atan2xf3_1"
  [(set (match_operand:XF 0 "register_operand" "=f")
        (unspec:XF [(match_operand:XF 2 "register_operand" "0")
	            (match_operand:XF 1 "register_operand" "u")]
	           UNSPEC_FPATAN))
   (clobber (match_scratch:XF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fpatan"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")])

(define_expand "atan2xf3"
  [(use (match_operand:XF 0 "register_operand" "=f"))
   (use (match_operand:XF 2 "register_operand" "0"))
   (use (match_operand:XF 1 "register_operand" "u"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx copy = gen_reg_rtx (XFmode);
  emit_move_insn (copy, operands[1]);
  emit_insn (gen_atan2xf3_1 (operands[0], copy, operands[2]));
  DONE;
})

(define_insn "*fyl2x_sfxf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
         (unspec:SF [(match_operand:SF 2 "register_operand" "0")
		     (match_operand:XF 1 "register_operand" "u")]
		    UNSPEC_FYL2X))
   (clobber (match_scratch:SF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fyl2x"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "SF")])

(define_insn "*fyl2x_dfxf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
         (unspec:DF [(match_operand:DF 2 "register_operand" "0")
		     (match_operand:XF 1 "register_operand" "u")]
		    UNSPEC_FYL2X))
   (clobber (match_scratch:DF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fyl2x"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")])

(define_insn "*fyl2x_xf3"
  [(set (match_operand:XF 0 "register_operand" "=f")
        (unspec:XF [(match_operand:XF 2 "register_operand" "0")
		    (match_operand:XF 1 "register_operand" "u")]
	           UNSPEC_FYL2X))
   (clobber (match_scratch:XF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fyl2x"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")])

(define_expand "logsf2"
  [(parallel [(set (match_operand:SF 0 "register_operand" "")
		   (unspec:SF [(match_operand:SF 1 "register_operand" "")
			       (match_dup 2)] UNSPEC_FYL2X))
	      (clobber (match_scratch:SF 3 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx temp;

  operands[2] = gen_reg_rtx (XFmode);
  temp = standard_80387_constant_rtx (4); /* fldln2 */
  emit_move_insn (operands[2], temp);
})

(define_expand "logdf2"
  [(parallel [(set (match_operand:DF 0 "register_operand" "")
		   (unspec:DF [(match_operand:DF 1 "register_operand" "")
			       (match_dup 2)] UNSPEC_FYL2X))
	      (clobber (match_scratch:DF 3 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx temp;

  operands[2] = gen_reg_rtx (XFmode);
  temp = standard_80387_constant_rtx (4); /* fldln2 */
  emit_move_insn (operands[2], temp);
})

(define_expand "logxf2"
  [(parallel [(set (match_operand:XF 0 "register_operand" "")
		   (unspec:XF [(match_operand:XF 1 "register_operand" "")
			       (match_dup 2)] UNSPEC_FYL2X))
	      (clobber (match_scratch:XF 3 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx temp;

  operands[2] = gen_reg_rtx (XFmode);
  temp = standard_80387_constant_rtx (4); /* fldln2 */
  emit_move_insn (operands[2], temp);
})

(define_insn "*fscale_sfxf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	 (unspec:SF [(match_operand:XF 2 "register_operand" "0")
		     (match_operand:XF 1 "register_operand" "u")]
		    UNSPEC_FSCALE))
   (clobber (match_scratch:SF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fscale\;fstp\t%y1"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "SF")])

(define_insn "*fscale_dfxf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	 (unspec:DF [(match_operand:XF 2 "register_operand" "0")
		     (match_operand:XF 1 "register_operand" "u")]
		    UNSPEC_FSCALE))
   (clobber (match_scratch:DF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fscale\;fstp\t%y1"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "DF")])

(define_insn "*fscale_xf3"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(unspec:XF [(match_operand:XF 2 "register_operand" "0")
		    (match_operand:XF 1 "register_operand" "u")]
	           UNSPEC_FSCALE))
   (clobber (match_scratch:XF 3 "=1"))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "fscale\;fstp\t%y1"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")])

(define_insn "*frndintxf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(unspec:XF [(match_operand:XF 1 "register_operand" "0")]
	 UNSPEC_FRNDINT))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "frndint"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")])

(define_insn "*f2xm1xf2"
  [(set (match_operand:XF 0 "register_operand" "=f")
	(unspec:XF [(match_operand:XF 1 "register_operand" "0")]
	 UNSPEC_F2XM1))]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
  "f2xm1"
  [(set_attr "type" "fpspc")
   (set_attr "mode" "XF")])

(define_expand "expsf2"
  [(set (match_dup 2)
	(float_extend:XF (match_operand:SF 1 "register_operand" "")))
   (set (match_dup 4) (mult:XF (match_dup 2) (match_dup 3)))
   (set (match_dup 5) (unspec:XF [(match_dup 4)] UNSPEC_FRNDINT))
   (set (match_dup 6) (minus:XF (match_dup 4) (match_dup 5)))
   (set (match_dup 7) (unspec:XF [(match_dup 6)] UNSPEC_F2XM1))
   (set (match_dup 9) (plus:XF (match_dup 7) (match_dup 8)))
   (parallel [(set (match_operand:SF 0 "register_operand" "")
		   (unspec:SF [(match_dup 9) (match_dup 5)] UNSPEC_FSCALE))
	      (clobber (match_scratch:SF 5 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx temp;
  int i;

  for (i=2; i<10; i++)
    operands[i] = gen_reg_rtx (XFmode);
  temp = standard_80387_constant_rtx (5); /* fldl2e */
  emit_move_insn (operands[3], temp);
  emit_move_insn (operands[8], CONST1_RTX (XFmode));  /* fld1 */
})

(define_expand "expdf2"
  [(set (match_dup 2)
	(float_extend:XF (match_operand:DF 1 "register_operand" "")))
   (set (match_dup 4) (mult:XF (match_dup 2) (match_dup 3)))
   (set (match_dup 5) (unspec:XF [(match_dup 4)] UNSPEC_FRNDINT))
   (set (match_dup 6) (minus:XF (match_dup 4) (match_dup 5)))
   (set (match_dup 7) (unspec:XF [(match_dup 6)] UNSPEC_F2XM1))
   (set (match_dup 9) (plus:XF (match_dup 7) (match_dup 8)))
   (parallel [(set (match_operand:DF 0 "register_operand" "")
		   (unspec:DF [(match_dup 9) (match_dup 5)] UNSPEC_FSCALE))
	      (clobber (match_scratch:DF 5 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx temp;
  int i;

  for (i=2; i<10; i++)
    operands[i] = gen_reg_rtx (XFmode);
  temp = standard_80387_constant_rtx (5); /* fldl2e */
  emit_move_insn (operands[3], temp);
  emit_move_insn (operands[8], CONST1_RTX (XFmode));  /* fld1 */
})

(define_expand "expxf2"
  [(set (match_dup 3) (mult:XF (match_operand:XF 1 "register_operand" "")
			       (match_dup 2)))
   (set (match_dup 4) (unspec:XF [(match_dup 3)] UNSPEC_FRNDINT))
   (set (match_dup 5) (minus:XF (match_dup 3) (match_dup 4)))
   (set (match_dup 6) (unspec:XF [(match_dup 5)] UNSPEC_F2XM1))
   (set (match_dup 8) (plus:XF (match_dup 6) (match_dup 7)))
   (parallel [(set (match_operand:XF 0 "register_operand" "")
		   (unspec:XF [(match_dup 8) (match_dup 4)] UNSPEC_FSCALE))
	      (clobber (match_scratch:XF 5 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  rtx temp;
  int i;

  for (i=2; i<9; i++)
    operands[i] = gen_reg_rtx (XFmode);
  temp = standard_80387_constant_rtx (5); /* fldl2e */
  emit_move_insn (operands[2], temp);
  emit_move_insn (operands[7], CONST1_RTX (XFmode));  /* fld1 */
})

(define_expand "atansf2"
  [(parallel [(set (match_operand:SF 0 "register_operand" "")
		   (unspec:SF [(match_dup 2)
			       (match_operand:SF 1 "register_operand" "")]
		    UNSPEC_FPATAN))
	      (clobber (match_scratch:SF 3 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  operands[2] = gen_reg_rtx (SFmode);
  emit_move_insn (operands[2], CONST1_RTX (SFmode));  /* fld1 */
})

(define_expand "atandf2"
  [(parallel [(set (match_operand:DF 0 "register_operand" "")
		   (unspec:DF [(match_dup 2)
			       (match_operand:DF 1 "register_operand" "")]
		    UNSPEC_FPATAN))
	      (clobber (match_scratch:DF 3 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  operands[2] = gen_reg_rtx (DFmode);
  emit_move_insn (operands[2], CONST1_RTX (DFmode));  /* fld1 */
})

(define_expand "atanxf2"
  [(parallel [(set (match_operand:XF 0 "register_operand" "")
		   (unspec:XF [(match_dup 2)
			       (match_operand:XF 1 "register_operand" "")]
		    UNSPEC_FPATAN))
	      (clobber (match_scratch:XF 3 ""))])]
  "! TARGET_NO_FANCY_MATH_387 && TARGET_80387
   && flag_unsafe_math_optimizations"
{
  operands[2] = gen_reg_rtx (XFmode);
  emit_move_insn (operands[2], CONST1_RTX (XFmode));  /* fld1 */
})

;; Block operation instructions

(define_insn "cld"
 [(set (reg:SI 19) (const_int 0))]
 ""
 "cld"
  [(set_attr "type" "cld")])

(define_expand "movstrsi"
  [(use (match_operand:BLK 0 "memory_operand" ""))
   (use (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand:SI 2 "nonmemory_operand" ""))
   (use (match_operand:SI 3 "const_int_operand" ""))]
  "! optimize_size"
{
 if (ix86_expand_movstr (operands[0], operands[1], operands[2], operands[3]))
   DONE;
 else
   FAIL;
})

(define_expand "movstrdi"
  [(use (match_operand:BLK 0 "memory_operand" ""))
   (use (match_operand:BLK 1 "memory_operand" ""))
   (use (match_operand:DI 2 "nonmemory_operand" ""))
   (use (match_operand:DI 3 "const_int_operand" ""))]
  "TARGET_64BIT"
{
 if (ix86_expand_movstr (operands[0], operands[1], operands[2], operands[3]))
   DONE;
 else
   FAIL;
})

;; Most CPUs don't like single string operations
;; Handle this case here to simplify previous expander.

(define_expand "strmov"
  [(set (match_dup 4) (match_operand 3 "memory_operand" ""))
   (set (match_operand 1 "memory_operand" "") (match_dup 4))
   (parallel [(set (match_operand 0 "register_operand" "") (match_dup 5))
	      (clobber (reg:CC 17))])
   (parallel [(set (match_operand 2 "register_operand" "") (match_dup 6))
	      (clobber (reg:CC 17))])]
  ""
{
  rtx adjust = GEN_INT (GET_MODE_SIZE (GET_MODE (operands[1])));

  /* If .md ever supports :P for Pmode, these can be directly
     in the pattern above.  */
  operands[5] = gen_rtx_PLUS (Pmode, operands[0], adjust);
  operands[6] = gen_rtx_PLUS (Pmode, operands[2], adjust);

  if (TARGET_SINGLE_STRINGOP || optimize_size)
    {
      emit_insn (gen_strmov_singleop (operands[0], operands[1],
				      operands[2], operands[3],
				      operands[5], operands[6]));
      DONE;
    }

  operands[4] = gen_reg_rtx (GET_MODE (operands[1]));
})

(define_expand "strmov_singleop"
  [(parallel [(set (match_operand 1 "memory_operand" "")
		   (match_operand 3 "memory_operand" ""))
	      (set (match_operand 0 "register_operand" "")
		   (match_operand 4 "" ""))
	      (set (match_operand 2 "register_operand" "")
		   (match_operand 5 "" ""))
	      (use (reg:SI 19))])]
  "TARGET_SINGLE_STRINGOP || optimize_size"
  "")

(define_insn "*strmovdi_rex_1"
  [(set (mem:DI (match_operand:DI 2 "register_operand" "0"))
	(mem:DI (match_operand:DI 3 "register_operand" "1")))
   (set (match_operand:DI 0 "register_operand" "=D")
	(plus:DI (match_dup 2)
		 (const_int 8)))
   (set (match_operand:DI 1 "register_operand" "=S")
	(plus:DI (match_dup 3)
		 (const_int 8)))
   (use (reg:SI 19))]
  "TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "movsq"
  [(set_attr "type" "str")
   (set_attr "mode" "DI")
   (set_attr "memory" "both")])

(define_insn "*strmovsi_1"
  [(set (mem:SI (match_operand:SI 2 "register_operand" "0"))
	(mem:SI (match_operand:SI 3 "register_operand" "1")))
   (set (match_operand:SI 0 "register_operand" "=D")
	(plus:SI (match_dup 2)
		 (const_int 4)))
   (set (match_operand:SI 1 "register_operand" "=S")
	(plus:SI (match_dup 3)
		 (const_int 4)))
   (use (reg:SI 19))]
  "!TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "{movsl|movsd}"
  [(set_attr "type" "str")
   (set_attr "mode" "SI")
   (set_attr "memory" "both")])

(define_insn "*strmovsi_rex_1"
  [(set (mem:SI (match_operand:DI 2 "register_operand" "0"))
	(mem:SI (match_operand:DI 3 "register_operand" "1")))
   (set (match_operand:DI 0 "register_operand" "=D")
	(plus:DI (match_dup 2)
		 (const_int 4)))
   (set (match_operand:DI 1 "register_operand" "=S")
	(plus:DI (match_dup 3)
		 (const_int 4)))
   (use (reg:SI 19))]
  "TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "{movsl|movsd}"
  [(set_attr "type" "str")
   (set_attr "mode" "SI")
   (set_attr "memory" "both")])

(define_insn "*strmovhi_1"
  [(set (mem:HI (match_operand:SI 2 "register_operand" "0"))
	(mem:HI (match_operand:SI 3 "register_operand" "1")))
   (set (match_operand:SI 0 "register_operand" "=D")
	(plus:SI (match_dup 2)
		 (const_int 2)))
   (set (match_operand:SI 1 "register_operand" "=S")
	(plus:SI (match_dup 3)
		 (const_int 2)))
   (use (reg:SI 19))]
  "!TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "movsw"
  [(set_attr "type" "str")
   (set_attr "memory" "both")
   (set_attr "mode" "HI")])

(define_insn "*strmovhi_rex_1"
  [(set (mem:HI (match_operand:DI 2 "register_operand" "0"))
	(mem:HI (match_operand:DI 3 "register_operand" "1")))
   (set (match_operand:DI 0 "register_operand" "=D")
	(plus:DI (match_dup 2)
		 (const_int 2)))
   (set (match_operand:DI 1 "register_operand" "=S")
	(plus:DI (match_dup 3)
		 (const_int 2)))
   (use (reg:SI 19))]
  "TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "movsw"
  [(set_attr "type" "str")
   (set_attr "memory" "both")
   (set_attr "mode" "HI")])

(define_insn "*strmovqi_1"
  [(set (mem:QI (match_operand:SI 2 "register_operand" "0"))
	(mem:QI (match_operand:SI 3 "register_operand" "1")))
   (set (match_operand:SI 0 "register_operand" "=D")
	(plus:SI (match_dup 2)
		 (const_int 1)))
   (set (match_operand:SI 1 "register_operand" "=S")
	(plus:SI (match_dup 3)
		 (const_int 1)))
   (use (reg:SI 19))]
  "!TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "movsb"
  [(set_attr "type" "str")
   (set_attr "memory" "both")
   (set_attr "mode" "QI")])

(define_insn "*strmovqi_rex_1"
  [(set (mem:QI (match_operand:DI 2 "register_operand" "0"))
	(mem:QI (match_operand:DI 3 "register_operand" "1")))
   (set (match_operand:DI 0 "register_operand" "=D")
	(plus:DI (match_dup 2)
		 (const_int 1)))
   (set (match_operand:DI 1 "register_operand" "=S")
	(plus:DI (match_dup 3)
		 (const_int 1)))
   (use (reg:SI 19))]
  "TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "movsb"
  [(set_attr "type" "str")
   (set_attr "memory" "both")
   (set_attr "mode" "QI")])

(define_expand "rep_mov"
  [(parallel [(set (match_operand 4 "register_operand" "") (const_int 0))
	      (set (match_operand 0 "register_operand" "")
		   (match_operand 5 "" ""))
	      (set (match_operand 2 "register_operand" "")
		   (match_operand 6 "" ""))
	      (set (match_operand 1 "memory_operand" "")
		   (match_operand 3 "memory_operand" ""))
	      (use (match_dup 4))
	      (use (reg:SI 19))])]
  ""
  "")

(define_insn "*rep_movdi_rex64"
  [(set (match_operand:DI 2 "register_operand" "=c") (const_int 0))
   (set (match_operand:DI 0 "register_operand" "=D") 
        (plus:DI (ashift:DI (match_operand:DI 5 "register_operand" "2")
			    (const_int 3))
		 (match_operand:DI 3 "register_operand" "0")))
   (set (match_operand:DI 1 "register_operand" "=S") 
        (plus:DI (ashift:DI (match_dup 5) (const_int 3))
		 (match_operand:DI 4 "register_operand" "1")))
   (set (mem:BLK (match_dup 3))
	(mem:BLK (match_dup 4)))
   (use (match_dup 5))
   (use (reg:SI 19))]
  "TARGET_64BIT"
  "{rep\;movsq|rep movsq}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "both")
   (set_attr "mode" "DI")])

(define_insn "*rep_movsi"
  [(set (match_operand:SI 2 "register_operand" "=c") (const_int 0))
   (set (match_operand:SI 0 "register_operand" "=D") 
        (plus:SI (ashift:SI (match_operand:SI 5 "register_operand" "2")
			    (const_int 2))
		 (match_operand:SI 3 "register_operand" "0")))
   (set (match_operand:SI 1 "register_operand" "=S") 
        (plus:SI (ashift:SI (match_dup 5) (const_int 2))
		 (match_operand:SI 4 "register_operand" "1")))
   (set (mem:BLK (match_dup 3))
	(mem:BLK (match_dup 4)))
   (use (match_dup 5))
   (use (reg:SI 19))]
  "!TARGET_64BIT"
  "{rep\;movsl|rep movsd}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "both")
   (set_attr "mode" "SI")])

(define_insn "*rep_movsi_rex64"
  [(set (match_operand:DI 2 "register_operand" "=c") (const_int 0))
   (set (match_operand:DI 0 "register_operand" "=D") 
        (plus:DI (ashift:DI (match_operand:DI 5 "register_operand" "2")
			    (const_int 2))
		 (match_operand:DI 3 "register_operand" "0")))
   (set (match_operand:DI 1 "register_operand" "=S") 
        (plus:DI (ashift:DI (match_dup 5) (const_int 2))
		 (match_operand:DI 4 "register_operand" "1")))
   (set (mem:BLK (match_dup 3))
	(mem:BLK (match_dup 4)))
   (use (match_dup 5))
   (use (reg:SI 19))]
  "TARGET_64BIT"
  "{rep\;movsl|rep movsd}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "both")
   (set_attr "mode" "SI")])

(define_insn "*rep_movqi"
  [(set (match_operand:SI 2 "register_operand" "=c") (const_int 0))
   (set (match_operand:SI 0 "register_operand" "=D") 
        (plus:SI (match_operand:SI 3 "register_operand" "0")
		 (match_operand:SI 5 "register_operand" "2")))
   (set (match_operand:SI 1 "register_operand" "=S") 
        (plus:SI (match_operand:SI 4 "register_operand" "1") (match_dup 5)))
   (set (mem:BLK (match_dup 3))
	(mem:BLK (match_dup 4)))
   (use (match_dup 5))
   (use (reg:SI 19))]
  "!TARGET_64BIT"
  "{rep\;movsb|rep movsb}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "both")
   (set_attr "mode" "SI")])

(define_insn "*rep_movqi_rex64"
  [(set (match_operand:DI 2 "register_operand" "=c") (const_int 0))
   (set (match_operand:DI 0 "register_operand" "=D") 
        (plus:DI (match_operand:DI 3 "register_operand" "0")
		 (match_operand:DI 5 "register_operand" "2")))
   (set (match_operand:DI 1 "register_operand" "=S") 
        (plus:DI (match_operand:DI 4 "register_operand" "1") (match_dup 5)))
   (set (mem:BLK (match_dup 3))
	(mem:BLK (match_dup 4)))
   (use (match_dup 5))
   (use (reg:SI 19))]
  "TARGET_64BIT"
  "{rep\;movsb|rep movsb}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "both")
   (set_attr "mode" "SI")])

(define_expand "clrstrsi"
   [(use (match_operand:BLK 0 "memory_operand" ""))
    (use (match_operand:SI 1 "nonmemory_operand" ""))
    (use (match_operand 2 "const_int_operand" ""))]
  ""
{
 if (ix86_expand_clrstr (operands[0], operands[1], operands[2]))
   DONE;
 else
   FAIL;
})

(define_expand "clrstrdi"
   [(use (match_operand:BLK 0 "memory_operand" ""))
    (use (match_operand:DI 1 "nonmemory_operand" ""))
    (use (match_operand 2 "const_int_operand" ""))]
  "TARGET_64BIT"
{
 if (ix86_expand_clrstr (operands[0], operands[1], operands[2]))
   DONE;
 else
   FAIL;
})

;; Most CPUs don't like single string operations
;; Handle this case here to simplify previous expander.

(define_expand "strset"
  [(set (match_operand 1 "memory_operand" "")
	(match_operand 2 "register_operand" ""))
   (parallel [(set (match_operand 0 "register_operand" "")
		   (match_dup 3))
	      (clobber (reg:CC 17))])]
  ""
{
  if (GET_MODE (operands[1]) != GET_MODE (operands[2]))
    operands[1] = adjust_address_nv (operands[1], GET_MODE (operands[2]), 0);

  /* If .md ever supports :P for Pmode, this can be directly
     in the pattern above.  */
  operands[3] = gen_rtx_PLUS (Pmode, operands[0],
			      GEN_INT (GET_MODE_SIZE (GET_MODE
						      (operands[2]))));
  if (TARGET_SINGLE_STRINGOP || optimize_size)
    {
      emit_insn (gen_strset_singleop (operands[0], operands[1], operands[2],
				      operands[3]));
      DONE;
    }
})

(define_expand "strset_singleop"
  [(parallel [(set (match_operand 1 "memory_operand" "")
		   (match_operand 2 "register_operand" ""))
	      (set (match_operand 0 "register_operand" "")
		   (match_operand 3 "" ""))
	      (use (reg:SI 19))])]
  "TARGET_SINGLE_STRINGOP || optimize_size"
  "")

(define_insn "*strsetdi_rex_1"
  [(set (mem:SI (match_operand:DI 1 "register_operand" "0"))
	(match_operand:SI 2 "register_operand" "a"))
   (set (match_operand:DI 0 "register_operand" "=D")
	(plus:DI (match_dup 1)
		 (const_int 8)))
   (use (reg:SI 19))]
  "TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "stosq"
  [(set_attr "type" "str")
   (set_attr "memory" "store")
   (set_attr "mode" "DI")])

(define_insn "*strsetsi_1"
  [(set (mem:SI (match_operand:SI 1 "register_operand" "0"))
	(match_operand:SI 2 "register_operand" "a"))
   (set (match_operand:SI 0 "register_operand" "=D")
	(plus:SI (match_dup 1)
		 (const_int 4)))
   (use (reg:SI 19))]
  "!TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "{stosl|stosd}"
  [(set_attr "type" "str")
   (set_attr "memory" "store")
   (set_attr "mode" "SI")])

(define_insn "*strsetsi_rex_1"
  [(set (mem:SI (match_operand:DI 1 "register_operand" "0"))
	(match_operand:SI 2 "register_operand" "a"))
   (set (match_operand:DI 0 "register_operand" "=D")
	(plus:DI (match_dup 1)
		 (const_int 4)))
   (use (reg:SI 19))]
  "TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "{stosl|stosd}"
  [(set_attr "type" "str")
   (set_attr "memory" "store")
   (set_attr "mode" "SI")])

(define_insn "*strsethi_1"
  [(set (mem:HI (match_operand:SI 1 "register_operand" "0"))
	(match_operand:HI 2 "register_operand" "a"))
   (set (match_operand:SI 0 "register_operand" "=D")
	(plus:SI (match_dup 1)
		 (const_int 2)))
   (use (reg:SI 19))]
  "!TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "stosw"
  [(set_attr "type" "str")
   (set_attr "memory" "store")
   (set_attr "mode" "HI")])

(define_insn "*strsethi_rex_1"
  [(set (mem:HI (match_operand:DI 1 "register_operand" "0"))
	(match_operand:HI 2 "register_operand" "a"))
   (set (match_operand:DI 0 "register_operand" "=D")
	(plus:DI (match_dup 1)
		 (const_int 2)))
   (use (reg:SI 19))]
  "TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "stosw"
  [(set_attr "type" "str")
   (set_attr "memory" "store")
   (set_attr "mode" "HI")])

(define_insn "*strsetqi_1"
  [(set (mem:QI (match_operand:SI 1 "register_operand" "0"))
	(match_operand:QI 2 "register_operand" "a"))
   (set (match_operand:SI 0 "register_operand" "=D")
	(plus:SI (match_dup 1)
		 (const_int 1)))
   (use (reg:SI 19))]
  "!TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "stosb"
  [(set_attr "type" "str")
   (set_attr "memory" "store")
   (set_attr "mode" "QI")])

(define_insn "*strsetqi_rex_1"
  [(set (mem:QI (match_operand:DI 1 "register_operand" "0"))
	(match_operand:QI 2 "register_operand" "a"))
   (set (match_operand:DI 0 "register_operand" "=D")
	(plus:DI (match_dup 1)
		 (const_int 1)))
   (use (reg:SI 19))]
  "TARGET_64BIT && (TARGET_SINGLE_STRINGOP || optimize_size)"
  "stosb"
  [(set_attr "type" "str")
   (set_attr "memory" "store")
   (set_attr "mode" "QI")])

(define_expand "rep_stos"
  [(parallel [(set (match_operand 1 "register_operand" "") (const_int 0))
	      (set (match_operand 0 "register_operand" "")
		   (match_operand 4 "" ""))
	      (set (match_operand 2 "memory_operand" "") (const_int 0))
	      (use (match_operand 3 "register_operand" ""))
	      (use (match_dup 1))
	      (use (reg:SI 19))])]
  ""
  "")

(define_insn "*rep_stosdi_rex64"
  [(set (match_operand:DI 1 "register_operand" "=c") (const_int 0))
   (set (match_operand:DI 0 "register_operand" "=D") 
        (plus:DI (ashift:DI (match_operand:DI 4 "register_operand" "1")
			    (const_int 3))
		 (match_operand:DI 3 "register_operand" "0")))
   (set (mem:BLK (match_dup 3))
	(const_int 0))
   (use (match_operand:DI 2 "register_operand" "a"))
   (use (match_dup 4))
   (use (reg:SI 19))]
  "TARGET_64BIT"
  "{rep\;stosq|rep stosq}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "store")
   (set_attr "mode" "DI")])

(define_insn "*rep_stossi"
  [(set (match_operand:SI 1 "register_operand" "=c") (const_int 0))
   (set (match_operand:SI 0 "register_operand" "=D") 
        (plus:SI (ashift:SI (match_operand:SI 4 "register_operand" "1")
			    (const_int 2))
		 (match_operand:SI 3 "register_operand" "0")))
   (set (mem:BLK (match_dup 3))
	(const_int 0))
   (use (match_operand:SI 2 "register_operand" "a"))
   (use (match_dup 4))
   (use (reg:SI 19))]
  "!TARGET_64BIT"
  "{rep\;stosl|rep stosd}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "store")
   (set_attr "mode" "SI")])

(define_insn "*rep_stossi_rex64"
  [(set (match_operand:DI 1 "register_operand" "=c") (const_int 0))
   (set (match_operand:DI 0 "register_operand" "=D") 
        (plus:DI (ashift:DI (match_operand:DI 4 "register_operand" "1")
			    (const_int 2))
		 (match_operand:DI 3 "register_operand" "0")))
   (set (mem:BLK (match_dup 3))
	(const_int 0))
   (use (match_operand:SI 2 "register_operand" "a"))
   (use (match_dup 4))
   (use (reg:SI 19))]
  "TARGET_64BIT"
  "{rep\;stosl|rep stosd}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "store")
   (set_attr "mode" "SI")])

(define_insn "*rep_stosqi"
  [(set (match_operand:SI 1 "register_operand" "=c") (const_int 0))
   (set (match_operand:SI 0 "register_operand" "=D") 
        (plus:SI (match_operand:SI 3 "register_operand" "0")
		 (match_operand:SI 4 "register_operand" "1")))
   (set (mem:BLK (match_dup 3))
	(const_int 0))
   (use (match_operand:QI 2 "register_operand" "a"))
   (use (match_dup 4))
   (use (reg:SI 19))]
  "!TARGET_64BIT"
  "{rep\;stosb|rep stosb}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "store")
   (set_attr "mode" "QI")])

(define_insn "*rep_stosqi_rex64"
  [(set (match_operand:DI 1 "register_operand" "=c") (const_int 0))
   (set (match_operand:DI 0 "register_operand" "=D") 
        (plus:DI (match_operand:DI 3 "register_operand" "0")
		 (match_operand:DI 4 "register_operand" "1")))
   (set (mem:BLK (match_dup 3))
	(const_int 0))
   (use (match_operand:QI 2 "register_operand" "a"))
   (use (match_dup 4))
   (use (reg:SI 19))]
  "TARGET_64BIT"
  "{rep\;stosb|rep stosb}"
  [(set_attr "type" "str")
   (set_attr "prefix_rep" "1")
   (set_attr "memory" "store")
   (set_attr "mode" "QI")])

(define_expand "cmpstrsi"
  [(set (match_operand:SI 0 "register_operand" "")
	(compare:SI (match_operand:BLK 1 "general_operand" "")
		    (match_operand:BLK 2 "general_operand" "")))
   (use (match_operand 3 "general_operand" ""))
   (use (match_operand 4 "immediate_operand" ""))]
  "! optimize_size || TARGET_INLINE_ALL_STRINGOPS"
{
  rtx addr1, addr2, out, outlow, count, countreg, align;

  /* Can't use this if the user has appropriated esi or edi.  */
  if (global_regs[4] || global_regs[5])
    FAIL;

  out = operands[0];
  if (GET_CODE (out) != REG)
    out = gen_reg_rtx (SImode);

  addr1 = copy_to_mode_reg (Pmode, XEXP (operands[1], 0));
  addr2 = copy_to_mode_reg (Pmode, XEXP (operands[2], 0));
  if (addr1 != XEXP (operands[1], 0))
    operands[1] = replace_equiv_address_nv (operands[1], addr1);
  if (addr2 != XEXP (operands[2], 0))
    operands[2] = replace_equiv_address_nv (operands[2], addr2);

  count = operands[3];
  countreg = ix86_zero_extend_to_Pmode (count);

  /* %%% Iff we are testing strict equality, we can use known alignment
     to good advantage.  This may be possible with combine, particularly
     once cc0 is dead.  */
  align = operands[4];

  emit_insn (gen_cld ());
  if (GET_CODE (count) == CONST_INT)
    {
      if (INTVAL (count) == 0)
	{
	  emit_move_insn (operands[0], const0_rtx);
	  DONE;
	}
      emit_insn (gen_cmpstrqi_nz_1 (addr1, addr2, countreg, align,
				    operands[1], operands[2]));
    }
  else
    {
      if (TARGET_64BIT)
	emit_insn (gen_cmpdi_1_rex64 (countreg, countreg));
      else
	emit_insn (gen_cmpsi_1 (countreg, countreg));
      emit_insn (gen_cmpstrqi_1 (addr1, addr2, countreg, align,
				 operands[1], operands[2]));
    }

  outlow = gen_lowpart (QImode, out);
  emit_insn (gen_cmpintqi (outlow));
  emit_move_insn (out, gen_rtx_SIGN_EXTEND (SImode, outlow));

  if (operands[0] != out)
    emit_move_insn (operands[0], out);

  DONE;
})

;; Produce a tri-state integer (-1, 0, 1) from condition codes.

(define_expand "cmpintqi"
  [(set (match_dup 1)
	(gtu:QI (reg:CC 17) (const_int 0)))
   (set (match_dup 2)
	(ltu:QI (reg:CC 17) (const_int 0)))
   (parallel [(set (match_operand:QI 0 "register_operand" "")
		   (minus:QI (match_dup 1)
			     (match_dup 2)))
	      (clobber (reg:CC 17))])]
  ""
  "operands[1] = gen_reg_rtx (QImode);
   operands[2] = gen_reg_rtx (QImode);")

;; memcmp recognizers.  The `cmpsb' opcode does nothing if the count is
;; zero.  Emit extra code to make sure that a zero-length compare is EQ.

(define_expand "cmpstrqi_nz_1"
  [(parallel [(set (reg:CC 17)
		   (compare:CC (match_operand 4 "memory_operand" "")
			       (match_operand 5 "memory_operand" "")))
	      (use (match_operand 2 "register_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (use (reg:SI 19))
	      (clobber (match_operand 0 "register_operand" ""))
	      (clobber (match_operand 1 "register_operand" ""))
	      (clobber (match_dup 2))])]
  ""
  "")

(define_insn "*cmpstrqi_nz_1"
  [(set (reg:CC 17)
	(compare:CC (mem:BLK (match_operand:SI 4 "register_operand" "0"))
		    (mem:BLK (match_operand:SI 5 "register_operand" "1"))))
   (use (match_operand:SI 6 "register_operand" "2"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (use (reg:SI 19))
   (clobber (match_operand:SI 0 "register_operand" "=S"))
   (clobber (match_operand:SI 1 "register_operand" "=D"))
   (clobber (match_operand:SI 2 "register_operand" "=c"))]
  "!TARGET_64BIT"
  "repz{\;| }cmpsb"
  [(set_attr "type" "str")
   (set_attr "mode" "QI")
   (set_attr "prefix_rep" "1")])

(define_insn "*cmpstrqi_nz_rex_1"
  [(set (reg:CC 17)
	(compare:CC (mem:BLK (match_operand:DI 4 "register_operand" "0"))
		    (mem:BLK (match_operand:DI 5 "register_operand" "1"))))
   (use (match_operand:DI 6 "register_operand" "2"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (use (reg:SI 19))
   (clobber (match_operand:DI 0 "register_operand" "=S"))
   (clobber (match_operand:DI 1 "register_operand" "=D"))
   (clobber (match_operand:DI 2 "register_operand" "=c"))]
  "TARGET_64BIT"
  "repz{\;| }cmpsb"
  [(set_attr "type" "str")
   (set_attr "mode" "QI")
   (set_attr "prefix_rep" "1")])

;; The same, but the count is not known to not be zero.

(define_expand "cmpstrqi_1"
  [(parallel [(set (reg:CC 17)
		(if_then_else:CC (ne (match_operand 2 "register_operand" "")
				     (const_int 0))
		  (compare:CC (match_operand 4 "memory_operand" "")
			      (match_operand 5 "memory_operand" ""))
		  (const_int 0)))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (use (reg:CC 17))
	      (use (reg:SI 19))
	      (clobber (match_operand 0 "register_operand" ""))
	      (clobber (match_operand 1 "register_operand" ""))
	      (clobber (match_dup 2))])]
  ""
  "")

(define_insn "*cmpstrqi_1"
  [(set (reg:CC 17)
	(if_then_else:CC (ne (match_operand:SI 6 "register_operand" "2")
			     (const_int 0))
	  (compare:CC (mem:BLK (match_operand:SI 4 "register_operand" "0"))
		      (mem:BLK (match_operand:SI 5 "register_operand" "1")))
	  (const_int 0)))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (use (reg:CC 17))
   (use (reg:SI 19))
   (clobber (match_operand:SI 0 "register_operand" "=S"))
   (clobber (match_operand:SI 1 "register_operand" "=D"))
   (clobber (match_operand:SI 2 "register_operand" "=c"))]
  "!TARGET_64BIT"
  "repz{\;| }cmpsb"
  [(set_attr "type" "str")
   (set_attr "mode" "QI")
   (set_attr "prefix_rep" "1")])

(define_insn "*cmpstrqi_rex_1"
  [(set (reg:CC 17)
	(if_then_else:CC (ne (match_operand:DI 6 "register_operand" "2")
			     (const_int 0))
	  (compare:CC (mem:BLK (match_operand:DI 4 "register_operand" "0"))
		      (mem:BLK (match_operand:DI 5 "register_operand" "1")))
	  (const_int 0)))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (use (reg:CC 17))
   (use (reg:SI 19))
   (clobber (match_operand:DI 0 "register_operand" "=S"))
   (clobber (match_operand:DI 1 "register_operand" "=D"))
   (clobber (match_operand:DI 2 "register_operand" "=c"))]
  "TARGET_64BIT"
  "repz{\;| }cmpsb"
  [(set_attr "type" "str")
   (set_attr "mode" "QI")
   (set_attr "prefix_rep" "1")])

(define_expand "strlensi"
  [(set (match_operand:SI 0 "register_operand" "")
	(unspec:SI [(match_operand:BLK 1 "general_operand" "")
		    (match_operand:QI 2 "immediate_operand" "")
		    (match_operand 3 "immediate_operand" "")] UNSPEC_SCAS))]
  ""
{
 if (ix86_expand_strlen (operands[0], operands[1], operands[2], operands[3]))
   DONE;
 else
   FAIL;
})

(define_expand "strlendi"
  [(set (match_operand:DI 0 "register_operand" "")
	(unspec:DI [(match_operand:BLK 1 "general_operand" "")
		    (match_operand:QI 2 "immediate_operand" "")
		    (match_operand 3 "immediate_operand" "")] UNSPEC_SCAS))]
  ""
{
 if (ix86_expand_strlen (operands[0], operands[1], operands[2], operands[3]))
   DONE;
 else
   FAIL;
})

(define_expand "strlenqi_1"
  [(parallel [(set (match_operand 0 "register_operand" "") (match_operand 2 "" ""))
	      (use (reg:SI 19))
	      (clobber (match_operand 1 "register_operand" ""))
	      (clobber (reg:CC 17))])]
  ""
  "")

(define_insn "*strlenqi_1"
  [(set (match_operand:SI 0 "register_operand" "=&c")
	(unspec:SI [(mem:BLK (match_operand:SI 5 "register_operand" "1"))
		    (match_operand:QI 2 "register_operand" "a")
		    (match_operand:SI 3 "immediate_operand" "i")
		    (match_operand:SI 4 "register_operand" "0")] UNSPEC_SCAS))
   (use (reg:SI 19))
   (clobber (match_operand:SI 1 "register_operand" "=D"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT"
  "repnz{\;| }scasb"
  [(set_attr "type" "str")
   (set_attr "mode" "QI")
   (set_attr "prefix_rep" "1")])

(define_insn "*strlenqi_rex_1"
  [(set (match_operand:DI 0 "register_operand" "=&c")
	(unspec:DI [(mem:BLK (match_operand:DI 5 "register_operand" "1"))
		    (match_operand:QI 2 "register_operand" "a")
		    (match_operand:DI 3 "immediate_operand" "i")
		    (match_operand:DI 4 "register_operand" "0")] UNSPEC_SCAS))
   (use (reg:SI 19))
   (clobber (match_operand:DI 1 "register_operand" "=D"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "repnz{\;| }scasb"
  [(set_attr "type" "str")
   (set_attr "mode" "QI")
   (set_attr "prefix_rep" "1")])

;; Peephole optimizations to clean up after cmpstr*.  This should be
;; handled in combine, but it is not currently up to the task.
;; When used for their truth value, the cmpstr* expanders generate
;; code like this:
;;
;;   repz cmpsb
;;   seta 	%al
;;   setb 	%dl
;;   cmpb 	%al, %dl
;;   jcc	label
;;
;; The intermediate three instructions are unnecessary.

;; This one handles cmpstr*_nz_1...
(define_peephole2
  [(parallel[
     (set (reg:CC 17)
	  (compare:CC (mem:BLK (match_operand 4 "register_operand" ""))
		      (mem:BLK (match_operand 5 "register_operand" ""))))
     (use (match_operand 6 "register_operand" ""))
     (use (match_operand:SI 3 "immediate_operand" ""))
     (use (reg:SI 19))
     (clobber (match_operand 0 "register_operand" ""))
     (clobber (match_operand 1 "register_operand" ""))
     (clobber (match_operand 2 "register_operand" ""))])
   (set (match_operand:QI 7 "register_operand" "")
	(gtu:QI (reg:CC 17) (const_int 0)))
   (set (match_operand:QI 8 "register_operand" "")
	(ltu:QI (reg:CC 17) (const_int 0)))
   (set (reg 17)
	(compare (match_dup 7) (match_dup 8)))
  ]
  "peep2_reg_dead_p (4, operands[7]) && peep2_reg_dead_p (4, operands[8])"
  [(parallel[
     (set (reg:CC 17)
	  (compare:CC (mem:BLK (match_dup 4))
		      (mem:BLK (match_dup 5))))
     (use (match_dup 6))
     (use (match_dup 3))
     (use (reg:SI 19))
     (clobber (match_dup 0))
     (clobber (match_dup 1))
     (clobber (match_dup 2))])]
  "")

;; ...and this one handles cmpstr*_1.
(define_peephole2
  [(parallel[
     (set (reg:CC 17)
	  (if_then_else:CC (ne (match_operand 6 "register_operand" "")
			       (const_int 0))
	    (compare:CC (mem:BLK (match_operand 4 "register_operand" ""))
		        (mem:BLK (match_operand 5 "register_operand" "")))
	    (const_int 0)))
     (use (match_operand:SI 3 "immediate_operand" ""))
     (use (reg:CC 17))
     (use (reg:SI 19))
     (clobber (match_operand 0 "register_operand" ""))
     (clobber (match_operand 1 "register_operand" ""))
     (clobber (match_operand 2 "register_operand" ""))])
   (set (match_operand:QI 7 "register_operand" "")
	(gtu:QI (reg:CC 17) (const_int 0)))
   (set (match_operand:QI 8 "register_operand" "")
	(ltu:QI (reg:CC 17) (const_int 0)))
   (set (reg 17)
	(compare (match_dup 7) (match_dup 8)))
  ]
  "peep2_reg_dead_p (4, operands[7]) && peep2_reg_dead_p (4, operands[8])"
  [(parallel[
     (set (reg:CC 17)
	  (if_then_else:CC (ne (match_dup 6)
			       (const_int 0))
	    (compare:CC (mem:BLK (match_dup 4))
			(mem:BLK (match_dup 5)))
	    (const_int 0)))
     (use (match_dup 3))
     (use (reg:CC 17))
     (use (reg:SI 19))
     (clobber (match_dup 0))
     (clobber (match_dup 1))
     (clobber (match_dup 2))])]
  "")



;; Conditional move instructions.

(define_expand "movdicc"
  [(set (match_operand:DI 0 "register_operand" "")
	(if_then_else:DI (match_operand 1 "comparison_operator" "")
			 (match_operand:DI 2 "general_operand" "")
			 (match_operand:DI 3 "general_operand" "")))]
  "TARGET_64BIT"
  "if (!ix86_expand_int_movcc (operands)) FAIL; DONE;")

(define_insn "x86_movdicc_0_m1_rex64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(if_then_else:DI (match_operand 1 "ix86_carry_flag_operator" "")
	  (const_int -1)
	  (const_int 0)))
   (clobber (reg:CC 17))]
  "TARGET_64BIT"
  "sbb{q}\t%0, %0"
  ; Since we don't have the proper number of operands for an alu insn,
  ; fill in all the blanks.
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "memory" "none")
   (set_attr "imm_disp" "false")
   (set_attr "mode" "DI")
   (set_attr "length_immediate" "0")])

(define_insn "movdicc_c_rex64"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(if_then_else:DI (match_operator 1 "ix86_comparison_operator" 
				[(reg 17) (const_int 0)])
		      (match_operand:DI 2 "nonimmediate_operand" "rm,0")
		      (match_operand:DI 3 "nonimmediate_operand" "0,rm")))]
  "TARGET_64BIT && TARGET_CMOVE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)"
  "@
   cmov%O2%C1\t{%2, %0|%0, %2}
   cmov%O2%c1\t{%3, %0|%0, %3}"
  [(set_attr "type" "icmov")
   (set_attr "mode" "DI")])

(define_expand "movsicc"
  [(set (match_operand:SI 0 "register_operand" "")
	(if_then_else:SI (match_operand 1 "comparison_operator" "")
			 (match_operand:SI 2 "general_operand" "")
			 (match_operand:SI 3 "general_operand" "")))]
  ""
  "if (!ix86_expand_int_movcc (operands)) FAIL; DONE;")

;; Data flow gets confused by our desire for `sbbl reg,reg', and clearing
;; the register first winds up with `sbbl $0,reg', which is also weird.
;; So just document what we're doing explicitly.

(define_insn "x86_movsicc_0_m1"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(if_then_else:SI (match_operand 1 "ix86_carry_flag_operator" "")
	  (const_int -1)
	  (const_int 0)))
   (clobber (reg:CC 17))]
  ""
  "sbb{l}\t%0, %0"
  ; Since we don't have the proper number of operands for an alu insn,
  ; fill in all the blanks.
  [(set_attr "type" "alu")
   (set_attr "pent_pair" "pu")
   (set_attr "memory" "none")
   (set_attr "imm_disp" "false")
   (set_attr "mode" "SI")
   (set_attr "length_immediate" "0")])

(define_insn "*movsicc_noc"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(if_then_else:SI (match_operator 1 "ix86_comparison_operator" 
				[(reg 17) (const_int 0)])
		      (match_operand:SI 2 "nonimmediate_operand" "rm,0")
		      (match_operand:SI 3 "nonimmediate_operand" "0,rm")))]
  "TARGET_CMOVE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)"
  "@
   cmov%O2%C1\t{%2, %0|%0, %2}
   cmov%O2%c1\t{%3, %0|%0, %3}"
  [(set_attr "type" "icmov")
   (set_attr "mode" "SI")])

(define_expand "movhicc"
  [(set (match_operand:HI 0 "register_operand" "")
	(if_then_else:HI (match_operand 1 "comparison_operator" "")
			 (match_operand:HI 2 "general_operand" "")
			 (match_operand:HI 3 "general_operand" "")))]
  "TARGET_HIMODE_MATH"
  "if (!ix86_expand_int_movcc (operands)) FAIL; DONE;")

(define_insn "*movhicc_noc"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(if_then_else:HI (match_operator 1 "ix86_comparison_operator" 
				[(reg 17) (const_int 0)])
		      (match_operand:HI 2 "nonimmediate_operand" "rm,0")
		      (match_operand:HI 3 "nonimmediate_operand" "0,rm")))]
  "TARGET_CMOVE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)"
  "@
   cmov%O2%C1\t{%2, %0|%0, %2}
   cmov%O2%c1\t{%3, %0|%0, %3}"
  [(set_attr "type" "icmov")
   (set_attr "mode" "HI")])

(define_expand "movqicc"
  [(set (match_operand:QI 0 "register_operand" "")
	(if_then_else:QI (match_operand 1 "comparison_operator" "")
			 (match_operand:QI 2 "general_operand" "")
			 (match_operand:QI 3 "general_operand" "")))]
  "TARGET_QIMODE_MATH"
  "if (!ix86_expand_int_movcc (operands)) FAIL; DONE;")

(define_insn_and_split "*movqicc_noc"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	(if_then_else:QI (match_operator 1 "ix86_comparison_operator" 
				[(match_operand 4 "flags_reg_operand" "") (const_int 0)])
		      (match_operand:QI 2 "register_operand" "r,0")
		      (match_operand:QI 3 "register_operand" "0,r")))]
  "TARGET_CMOVE && !TARGET_PARTIAL_REG_STALL"
  "#"
  "&& reload_completed"
  [(set (match_dup 0)
	(if_then_else:SI (match_op_dup 1 [(match_dup 4) (const_int 0)])
		      (match_dup 2)
		      (match_dup 3)))]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[2] = gen_lowpart (SImode, operands[2]);
   operands[3] = gen_lowpart (SImode, operands[3]);"
  [(set_attr "type" "icmov")
   (set_attr "mode" "SI")])

(define_expand "movsfcc"
  [(set (match_operand:SF 0 "register_operand" "")
	(if_then_else:SF (match_operand 1 "comparison_operator" "")
			 (match_operand:SF 2 "register_operand" "")
			 (match_operand:SF 3 "register_operand" "")))]
  "TARGET_CMOVE"
  "if (! ix86_expand_fp_movcc (operands)) FAIL; DONE;")

(define_insn "*movsfcc_1"
  [(set (match_operand:SF 0 "register_operand" "=f#r,f#r,r#f,r#f")
	(if_then_else:SF (match_operator 1 "fcmov_comparison_operator" 
				[(reg 17) (const_int 0)])
		      (match_operand:SF 2 "nonimmediate_operand" "f#r,0,rm#f,0")
		      (match_operand:SF 3 "nonimmediate_operand" "0,f#r,0,rm#f")))]
  "TARGET_CMOVE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)"
  "@
   fcmov%F1\t{%2, %0|%0, %2}
   fcmov%f1\t{%3, %0|%0, %3}
   cmov%O2%C1\t{%2, %0|%0, %2}
   cmov%O2%c1\t{%3, %0|%0, %3}"
  [(set_attr "type" "fcmov,fcmov,icmov,icmov")
   (set_attr "mode" "SF,SF,SI,SI")])

(define_expand "movdfcc"
  [(set (match_operand:DF 0 "register_operand" "")
	(if_then_else:DF (match_operand 1 "comparison_operator" "")
			 (match_operand:DF 2 "register_operand" "")
			 (match_operand:DF 3 "register_operand" "")))]
  "TARGET_CMOVE"
  "if (! ix86_expand_fp_movcc (operands)) FAIL; DONE;")

(define_insn "*movdfcc_1"
  [(set (match_operand:DF 0 "register_operand" "=f#r,f#r,&r#f,&r#f")
	(if_then_else:DF (match_operator 1 "fcmov_comparison_operator" 
				[(reg 17) (const_int 0)])
		      (match_operand:DF 2 "nonimmediate_operand" "f#r,0,rm#f,0")
		      (match_operand:DF 3 "nonimmediate_operand" "0,f#r,0,rm#f")))]
  "!TARGET_64BIT && TARGET_CMOVE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)"
  "@
   fcmov%F1\t{%2, %0|%0, %2}
   fcmov%f1\t{%3, %0|%0, %3}
   #
   #"
  [(set_attr "type" "fcmov,fcmov,multi,multi")
   (set_attr "mode" "DF")])

(define_insn "*movdfcc_1_rex64"
  [(set (match_operand:DF 0 "register_operand" "=f#r,f#r,r#f,r#f")
	(if_then_else:DF (match_operator 1 "fcmov_comparison_operator" 
				[(reg 17) (const_int 0)])
		      (match_operand:DF 2 "nonimmediate_operand" "f#r,0#r,rm#f,0#f")
		      (match_operand:DF 3 "nonimmediate_operand" "0#r,f#r,0#f,rm#f")))]
  "TARGET_64BIT && TARGET_CMOVE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)"
  "@
   fcmov%F1\t{%2, %0|%0, %2}
   fcmov%f1\t{%3, %0|%0, %3}
   cmov%O2%C1\t{%2, %0|%0, %2}
   cmov%O2%c1\t{%3, %0|%0, %3}"
  [(set_attr "type" "fcmov,fcmov,icmov,icmov")
   (set_attr "mode" "DF")])

(define_split
  [(set (match_operand:DF 0 "register_and_not_any_fp_reg_operand" "")
	(if_then_else:DF (match_operator 1 "fcmov_comparison_operator" 
				[(match_operand 4 "flags_reg_operand" "") (const_int 0)])
		      (match_operand:DF 2 "nonimmediate_operand" "")
		      (match_operand:DF 3 "nonimmediate_operand" "")))]
  "!TARGET_64BIT && reload_completed"
  [(set (match_dup 2)
	(if_then_else:SI (match_op_dup 1 [(match_dup 4) (const_int 0)])
		      (match_dup 5)
		      (match_dup 7)))
   (set (match_dup 3)
	(if_then_else:SI (match_op_dup 1 [(match_dup 4) (const_int 0)])
		      (match_dup 6)
		      (match_dup 8)))]
  "split_di (operands+2, 1, operands+5, operands+6);
   split_di (operands+3, 1, operands+7, operands+8);
   split_di (operands, 1, operands+2, operands+3);")

(define_expand "movxfcc"
  [(set (match_operand:XF 0 "register_operand" "")
	(if_then_else:XF (match_operand 1 "comparison_operator" "")
			 (match_operand:XF 2 "register_operand" "")
			 (match_operand:XF 3 "register_operand" "")))]
  "TARGET_CMOVE"
  "if (! ix86_expand_fp_movcc (operands)) FAIL; DONE;")

(define_insn "*movxfcc_1"
  [(set (match_operand:XF 0 "register_operand" "=f,f")
	(if_then_else:XF (match_operator 1 "fcmov_comparison_operator" 
				[(reg 17) (const_int 0)])
		      (match_operand:XF 2 "register_operand" "f,0")
		      (match_operand:XF 3 "register_operand" "0,f")))]
  "TARGET_CMOVE"
  "@
   fcmov%F1\t{%2, %0|%0, %2}
   fcmov%f1\t{%3, %0|%0, %3}"
  [(set_attr "type" "fcmov")
   (set_attr "mode" "XF")])

(define_expand "minsf3"
  [(parallel [
     (set (match_operand:SF 0 "register_operand" "")
	  (if_then_else:SF (lt (match_operand:SF 1 "register_operand" "")
			       (match_operand:SF 2 "nonimmediate_operand" ""))
			   (match_dup 1)
			   (match_dup 2)))
     (clobber (reg:CC 17))])]
  "TARGET_SSE"
  "")

(define_insn "*minsf"
  [(set (match_operand:SF 0 "register_operand" "=x#f,f#x,f#x")
	(if_then_else:SF (lt (match_operand:SF 1 "register_operand" "0,0,f#x")
			     (match_operand:SF 2 "nonimmediate_operand" "xm#f,f#x,0"))
			 (match_dup 1)
			 (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_SSE && TARGET_IEEE_FP"
  "#")

(define_insn "*minsf_nonieee"
  [(set (match_operand:SF 0 "register_operand" "=x#f,f#x")
	(if_then_else:SF (lt (match_operand:SF 1 "nonimmediate_operand" "%0,0")
			     (match_operand:SF 2 "nonimmediate_operand" "xm#f,f#x"))
			 (match_dup 1)
			 (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_SSE && !TARGET_IEEE_FP
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "#")

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(if_then_else:SF (lt (match_operand:SF 1 "register_operand" "")
			     (match_operand:SF 2 "nonimmediate_operand" ""))
			 (match_operand:SF 3 "register_operand" "")
			 (match_operand:SF 4 "nonimmediate_operand" "")))
   (clobber (reg:CC 17))]
  "SSE_REG_P (operands[0]) && reload_completed
   && ((operands_match_p (operands[1], operands[3])
	&& operands_match_p (operands[2], operands[4]))
       || (operands_match_p (operands[1], operands[4])
	   && operands_match_p (operands[2], operands[3])))"
  [(set (match_dup 0)
	(if_then_else:SF (lt (match_dup 1)
			     (match_dup 2))
			 (match_dup 1)
			 (match_dup 2)))])

;; Conditional addition patterns
(define_expand "addqicc"
  [(match_operand:QI 0 "register_operand" "")
   (match_operand 1 "comparison_operator" "")
   (match_operand:QI 2 "register_operand" "")
   (match_operand:QI 3 "const_int_operand" "")]
  ""
  "if (!ix86_expand_int_addcc (operands)) FAIL; DONE;")

(define_expand "addhicc"
  [(match_operand:HI 0 "register_operand" "")
   (match_operand 1 "comparison_operator" "")
   (match_operand:HI 2 "register_operand" "")
   (match_operand:HI 3 "const_int_operand" "")]
  ""
  "if (!ix86_expand_int_addcc (operands)) FAIL; DONE;")

(define_expand "addsicc"
  [(match_operand:SI 0 "register_operand" "")
   (match_operand 1 "comparison_operator" "")
   (match_operand:SI 2 "register_operand" "")
   (match_operand:SI 3 "const_int_operand" "")]
  ""
  "if (!ix86_expand_int_addcc (operands)) FAIL; DONE;")

(define_expand "adddicc"
  [(match_operand:DI 0 "register_operand" "")
   (match_operand 1 "comparison_operator" "")
   (match_operand:DI 2 "register_operand" "")
   (match_operand:DI 3 "const_int_operand" "")]
  "TARGET_64BIT"
  "if (!ix86_expand_int_addcc (operands)) FAIL; DONE;")

;; We can't represent the LT test directly.  Do this by swapping the operands.

(define_split
  [(set (match_operand:SF 0 "fp_register_operand" "")
	(if_then_else:SF (lt (match_operand:SF 1 "register_operand" "")
			     (match_operand:SF 2 "register_operand" ""))
			 (match_operand:SF 3 "register_operand" "")
			 (match_operand:SF 4 "register_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && ((operands_match_p (operands[1], operands[3])
	&& operands_match_p (operands[2], operands[4]))
       || (operands_match_p (operands[1], operands[4])
	   && operands_match_p (operands[2], operands[3])))"
  [(set (reg:CCFP 17)
	(compare:CCFP (match_dup 2)
		      (match_dup 1)))
   (set (match_dup 0)
	(if_then_else:SF (ge (reg:CCFP 17) (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))])

(define_insn "*minsf_sse"
  [(set (match_operand:SF 0 "register_operand" "=x")
	(if_then_else:SF (lt (match_operand:SF 1 "register_operand" "0")
			     (match_operand:SF 2 "nonimmediate_operand" "xm"))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_SSE && reload_completed"
  "minss\t{%2, %0|%0, %2}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")])

(define_expand "mindf3"
  [(parallel [
     (set (match_operand:DF 0 "register_operand" "")
	  (if_then_else:DF (lt (match_operand:DF 1 "register_operand" "")
			       (match_operand:DF 2 "nonimmediate_operand" ""))
			   (match_dup 1)
			   (match_dup 2)))
     (clobber (reg:CC 17))])]
  "TARGET_SSE2 && TARGET_SSE_MATH"
  "#")

(define_insn "*mindf"
  [(set (match_operand:DF 0 "register_operand" "=Y#f,f#Y,f#Y")
	(if_then_else:DF (lt (match_operand:DF 1 "register_operand" "0,0,f#Y")
			     (match_operand:DF 2 "nonimmediate_operand" "Ym#f,f#Y,0"))
			 (match_dup 1)
			 (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_SSE2 && TARGET_IEEE_FP && TARGET_SSE_MATH"
  "#")

(define_insn "*mindf_nonieee"
  [(set (match_operand:DF 0 "register_operand" "=Y#f,f#Y")
	(if_then_else:DF (lt (match_operand:DF 1 "nonimmediate_operand" "%0,0")
			     (match_operand:DF 2 "nonimmediate_operand" "Ym#f,f#Y"))
			 (match_dup 1)
			 (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_SSE2 && TARGET_SSE_MATH && !TARGET_IEEE_FP
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "#")

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(if_then_else:DF (lt (match_operand:DF 1 "register_operand" "")
			     (match_operand:DF 2 "nonimmediate_operand" ""))
			 (match_operand:DF 3 "register_operand" "")
			 (match_operand:DF 4 "nonimmediate_operand" "")))
   (clobber (reg:CC 17))]
  "SSE_REG_P (operands[0]) && reload_completed
   && ((operands_match_p (operands[1], operands[3])
	&& operands_match_p (operands[2], operands[4]))
       || (operands_match_p (operands[1], operands[4])
	   && operands_match_p (operands[2], operands[3])))"
  [(set (match_dup 0)
	(if_then_else:DF (lt (match_dup 1)
			     (match_dup 2))
			 (match_dup 1)
			 (match_dup 2)))])

;; We can't represent the LT test directly.  Do this by swapping the operands.
(define_split
  [(set (match_operand:DF 0 "fp_register_operand" "")
	(if_then_else:DF (lt (match_operand:DF 1 "register_operand" "")
			     (match_operand:DF 2 "register_operand" ""))
			 (match_operand:DF 3 "register_operand" "")
			 (match_operand:DF 4 "register_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && ((operands_match_p (operands[1], operands[3])
	&& operands_match_p (operands[2], operands[4]))
       || (operands_match_p (operands[1], operands[4])
	   && operands_match_p (operands[2], operands[3])))"
  [(set (reg:CCFP 17)
	(compare:CCFP (match_dup 2)
		      (match_dup 1)))
   (set (match_dup 0)
	(if_then_else:DF (ge (reg:CCFP 17) (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))])

(define_insn "*mindf_sse"
  [(set (match_operand:DF 0 "register_operand" "=Y")
	(if_then_else:DF (lt (match_operand:DF 1 "register_operand" "0")
			     (match_operand:DF 2 "nonimmediate_operand" "Ym"))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_SSE2 && TARGET_SSE_MATH && reload_completed"
  "minsd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sse")
   (set_attr "mode" "DF")])

(define_expand "maxsf3"
  [(parallel [
     (set (match_operand:SF 0 "register_operand" "")
	  (if_then_else:SF (gt (match_operand:SF 1 "register_operand" "")
			       (match_operand:SF 2 "nonimmediate_operand" ""))
			   (match_dup 1)
			   (match_dup 2)))
     (clobber (reg:CC 17))])]
  "TARGET_SSE"
  "#")

(define_insn "*maxsf"
  [(set (match_operand:SF 0 "register_operand" "=x#f,f#x,f#x")
	(if_then_else:SF (gt (match_operand:SF 1 "register_operand" "0,0,f#x")
			     (match_operand:SF 2 "nonimmediate_operand" "xm#f,f#x,0"))
			 (match_dup 1)
			 (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_SSE && TARGET_IEEE_FP"
  "#")

(define_insn "*maxsf_nonieee"
  [(set (match_operand:SF 0 "register_operand" "=x#f,f#x")
	(if_then_else:SF (gt (match_operand:SF 1 "nonimmediate_operand" "%0,0")
			     (match_operand:SF 2 "nonimmediate_operand" "xm#f,f#x"))
			 (match_dup 1)
			 (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_SSE && !TARGET_IEEE_FP
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "#")

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(if_then_else:SF (gt (match_operand:SF 1 "register_operand" "")
			     (match_operand:SF 2 "nonimmediate_operand" ""))
			 (match_operand:SF 3 "register_operand" "")
			 (match_operand:SF 4 "nonimmediate_operand" "")))
   (clobber (reg:CC 17))]
  "SSE_REG_P (operands[0]) && reload_completed
   && ((operands_match_p (operands[1], operands[3])
	&& operands_match_p (operands[2], operands[4]))
       || (operands_match_p (operands[1], operands[4])
	   && operands_match_p (operands[2], operands[3])))"
  [(set (match_dup 0)
	(if_then_else:SF (gt (match_dup 1)
			     (match_dup 2))
			 (match_dup 1)
			 (match_dup 2)))])

(define_split
  [(set (match_operand:SF 0 "fp_register_operand" "")
	(if_then_else:SF (gt (match_operand:SF 1 "register_operand" "")
			     (match_operand:SF 2 "register_operand" ""))
			 (match_operand:SF 3 "register_operand" "")
			 (match_operand:SF 4 "register_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && ((operands_match_p (operands[1], operands[3])
	&& operands_match_p (operands[2], operands[4]))
       || (operands_match_p (operands[1], operands[4])
	   && operands_match_p (operands[2], operands[3])))"
  [(set (reg:CCFP 17)
	(compare:CCFP (match_dup 1)
		      (match_dup 2)))
   (set (match_dup 0)
	(if_then_else:SF (gt (reg:CCFP 17) (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))])

(define_insn "*maxsf_sse"
  [(set (match_operand:SF 0 "register_operand" "=x")
	(if_then_else:SF (gt (match_operand:SF 1 "register_operand" "0")
			     (match_operand:SF 2 "nonimmediate_operand" "xm"))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_SSE && reload_completed"
  "maxss\t{%2, %0|%0, %2}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")])

(define_expand "maxdf3"
  [(parallel [
     (set (match_operand:DF 0 "register_operand" "")
	  (if_then_else:DF (gt (match_operand:DF 1 "register_operand" "")
			       (match_operand:DF 2 "nonimmediate_operand" ""))
			   (match_dup 1)
			   (match_dup 2)))
     (clobber (reg:CC 17))])]
  "TARGET_SSE2 && TARGET_SSE_MATH"
  "#")

(define_insn "*maxdf"
  [(set (match_operand:DF 0 "register_operand" "=Y#f,f#Y,f#Y")
	(if_then_else:DF (gt (match_operand:DF 1 "register_operand" "0,0,f#Y")
			     (match_operand:DF 2 "nonimmediate_operand" "Ym#f,f#Y,0"))
			 (match_dup 1)
			 (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_SSE2 && TARGET_SSE_MATH && TARGET_IEEE_FP"
  "#")

(define_insn "*maxdf_nonieee"
  [(set (match_operand:DF 0 "register_operand" "=Y#f,f#Y")
	(if_then_else:DF (gt (match_operand:DF 1 "nonimmediate_operand" "%0,0")
			     (match_operand:DF 2 "nonimmediate_operand" "Ym#f,f#Y"))
			 (match_dup 1)
			 (match_dup 2)))
   (clobber (reg:CC 17))]
  "TARGET_SSE2 && TARGET_SSE_MATH && !TARGET_IEEE_FP
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "#")

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(if_then_else:DF (gt (match_operand:DF 1 "register_operand" "")
			     (match_operand:DF 2 "nonimmediate_operand" ""))
			 (match_operand:DF 3 "register_operand" "")
			 (match_operand:DF 4 "nonimmediate_operand" "")))
   (clobber (reg:CC 17))]
  "SSE_REG_P (operands[0]) && reload_completed
   && ((operands_match_p (operands[1], operands[3])
	&& operands_match_p (operands[2], operands[4]))
       || (operands_match_p (operands[1], operands[4])
	   && operands_match_p (operands[2], operands[3])))"
  [(set (match_dup 0)
	(if_then_else:DF (gt (match_dup 1)
			     (match_dup 2))
			 (match_dup 1)
			 (match_dup 2)))])

(define_split
  [(set (match_operand:DF 0 "fp_register_operand" "")
	(if_then_else:DF (gt (match_operand:DF 1 "register_operand" "")
			     (match_operand:DF 2 "register_operand" ""))
			 (match_operand:DF 3 "register_operand" "")
			 (match_operand:DF 4 "register_operand" "")))
   (clobber (reg:CC 17))]
  "reload_completed
   && ((operands_match_p (operands[1], operands[3])
	&& operands_match_p (operands[2], operands[4]))
       || (operands_match_p (operands[1], operands[4])
	   && operands_match_p (operands[2], operands[3])))"
  [(set (reg:CCFP 17)
	(compare:CCFP (match_dup 1)
		      (match_dup 2)))
   (set (match_dup 0)
	(if_then_else:DF (gt (reg:CCFP 17) (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))])

(define_insn "*maxdf_sse"
  [(set (match_operand:DF 0 "register_operand" "=Y")
	(if_then_else:DF (gt (match_operand:DF 1 "register_operand" "0")
			     (match_operand:DF 2 "nonimmediate_operand" "Ym"))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_SSE2 && TARGET_SSE_MATH && reload_completed"
  "maxsd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sse")
   (set_attr "mode" "DF")])

;; Misc patterns (?)

;; This pattern exists to put a dependency on all ebp-based memory accesses.
;; Otherwise there will be nothing to keep
;; 
;; [(set (reg ebp) (reg esp))]
;; [(set (reg esp) (plus (reg esp) (const_int -160000)))
;;  (clobber (eflags)]
;; [(set (mem (plus (reg ebp) (const_int -160000))) (const_int 0))]
;;
;; in proper program order.
(define_insn "pro_epilogue_adjust_stack_1"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(plus:SI (match_operand:SI 1 "register_operand" "0,r")
	         (match_operand:SI 2 "immediate_operand" "i,i")))
   (clobber (reg:CC 17))
   (clobber (mem:BLK (scratch)))]
  "!TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOV:
      return "mov{l}\t{%1, %0|%0, %1}";

    case TYPE_ALU:
      if (GET_CODE (operands[2]) == CONST_INT
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
	          && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{l}\t{%2, %0|%0, %2}";
	}
      return "add{l}\t{%2, %0|%0, %2}";

    case TYPE_LEA:
      operands[2] = SET_SRC (XVECEXP (PATTERN (insn), 0, 0));
      return "lea{l}\t{%a2, %0|%0, %a2}";

    default:
      abort ();
    }
}
  [(set (attr "type")
	(cond [(eq_attr "alternative" "0")
		 (const_string "alu")
	       (match_operand:SI 2 "const0_operand" "")
		 (const_string "imov")
	      ]
	      (const_string "lea")))
   (set_attr "mode" "SI")])

(define_insn "pro_epilogue_adjust_stack_rex64"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(plus:DI (match_operand:DI 1 "register_operand" "0,r")
		 (match_operand:DI 2 "x86_64_immediate_operand" "e,e")))
   (clobber (reg:CC 17))
   (clobber (mem:BLK (scratch)))]
  "TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_IMOV:
      return "mov{q}\t{%1, %0|%0, %1}";

    case TYPE_ALU:
      if (GET_CODE (operands[2]) == CONST_INT
	  /* Avoid overflows.  */
	  && ((INTVAL (operands[2]) & ((((unsigned int) 1) << 31) - 1)))
          && (INTVAL (operands[2]) == 128
	      || (INTVAL (operands[2]) < 0
	          && INTVAL (operands[2]) != -128)))
	{
	  operands[2] = GEN_INT (-INTVAL (operands[2]));
	  return "sub{q}\t{%2, %0|%0, %2}";
	}
      return "add{q}\t{%2, %0|%0, %2}";

    case TYPE_LEA:
      operands[2] = SET_SRC (XVECEXP (PATTERN (insn), 0, 0));
      return "lea{q}\t{%a2, %0|%0, %a2}";

    default:
      abort ();
    }
}
  [(set (attr "type")
	(cond [(eq_attr "alternative" "0")
		 (const_string "alu")
	       (match_operand:DI 2 "const0_operand" "")
		 (const_string "imov")
	      ]
	      (const_string "lea")))
   (set_attr "mode" "DI")])

(define_insn "pro_epilogue_adjust_stack_rex64_2"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(plus:DI (match_operand:DI 1 "register_operand" "0,r")
		 (match_operand:DI 3 "immediate_operand" "i,i")))
   (use (match_operand:DI 2 "register_operand" "r,r"))
   (clobber (reg:CC 17))
   (clobber (mem:BLK (scratch)))]
  "TARGET_64BIT"
{
  switch (get_attr_type (insn))
    {
    case TYPE_ALU:
      return "add{q}\t{%2, %0|%0, %2}";

    case TYPE_LEA:
      operands[2] = gen_rtx_PLUS (DImode, operands[1], operands[2]);
      return "lea{q}\t{%a2, %0|%0, %a2}";

    default:
      abort ();
    }
}
  [(set_attr "type" "alu,lea")
   (set_attr "mode" "DI")])

;; Placeholder for the conditional moves.  This one is split either to SSE
;; based moves emulation or to usual cmove sequence.  Little bit unfortunate
;; fact is that compares supported by the cmp??ss instructions are exactly
;; swapped of those supported by cmove sequence.
;; The EQ/NE comparisons also needs bit care, since they are not directly
;; supported by i387 comparisons and we do need to emit two conditional moves
;; in tandem.

(define_insn "sse_movsfcc"
  [(set (match_operand:SF 0 "register_operand" "=&x#rf,x#rf,?f#xr,?f#xr,?f#xr,?f#xr,?r#xf,?r#xf,?r#xf,?r#xf")
	(if_then_else:SF (match_operator 1 "sse_comparison_operator"
			[(match_operand:SF 4 "nonimmediate_operand" "0#fx,x#fx,f#x,f#x,xm#f,xm#f,f#x,f#x,xm#f,xm#f")
			 (match_operand:SF 5 "nonimmediate_operand" "xm#f,xm#f,f#x,f#x,x#f,x#f,f#x,f#x,x#f,x#f")])
		      (match_operand:SF 2 "nonimmediate_operand" "x#fr,0#fr,f#fx,0#fx,f#fx,0#fx,rm#rx,0#rx,rm#rx,0#rx")
		      (match_operand:SF 3 "nonimmediate_operand" "x#fr,x#fr,0#fx,f#fx,0#fx,f#fx,0#fx,rm#rx,0#rx,rm#rx")))
   (clobber (match_scratch:SF 6 "=2,&4,X,X,X,X,X,X,X,X"))
   (clobber (reg:CC 17))]
  "TARGET_SSE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)
   /* Avoid combine from being smart and converting min/max
      instruction patterns into conditional moves.  */
   && ((GET_CODE (operands[1]) != LT && GET_CODE (operands[1]) != GT
	&& GET_CODE (operands[1]) != UNLE && GET_CODE (operands[1]) != UNGE)
       || !rtx_equal_p (operands[4], operands[2])
       || !rtx_equal_p (operands[5], operands[3]))
   && (!TARGET_IEEE_FP
       || (GET_CODE (operands[1]) != EQ && GET_CODE (operands[1]) != NE))"
  "#")

(define_insn "sse_movsfcc_eq"
  [(set (match_operand:SF 0 "register_operand" "=&x#rf,x#rf,?f#xr,?f#xr,?r#xf,?r#xf")
	(if_then_else:SF (eq (match_operand:SF 3 "nonimmediate_operand" "%0#fx,x#fx,f#x,xm#f,f#x,xm#f")
			     (match_operand:SF 4 "nonimmediate_operand" "xm#f,xm#f,f#x,x#f,f#x,x#f"))
		      (match_operand:SF 1 "nonimmediate_operand" "x#fr,0#fr,0#fx,0#fx,0#rx,0#rx")
		      (match_operand:SF 2 "nonimmediate_operand" "x#fr,x#fr,f#fx,f#fx,rm#rx,rm#rx")))
   (clobber (match_scratch:SF 5 "=1,&3,X,X,X,X"))
   (clobber (reg:CC 17))]
  "TARGET_SSE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)"
  "#")

(define_insn "sse_movdfcc"
  [(set (match_operand:DF 0 "register_operand" "=&Y#rf,Y#rf,?f#Yr,?f#Yr,?f#Yr,?f#Yr,?r#Yf,?r#Yf,?r#Yf,?r#Yf")
	(if_then_else:DF (match_operator 1 "sse_comparison_operator"
			[(match_operand:DF 4 "nonimmediate_operand" "0#fY,Y#fY,f#Y,f#Y,Ym#f,Ym#f,f#Y,f#Y,Ym#f,Ym#f")
			 (match_operand:DF 5 "nonimmediate_operand" "Ym#f,Ym#f,f#Y,f#Y,Y#f,Y#f,f#Y,f#Y,Y#f,Y#f")])
		      (match_operand:DF 2 "nonimmediate_operand" "Y#fr,0#fr,f#fY,0#fY,f#fY,0#fY,rm#rY,0#rY,rm#rY,0#rY")
		      (match_operand:DF 3 "nonimmediate_operand" "Y#fr,Y#fr,0#fY,f#fY,0#fY,f#fY,0#fY,rm#rY,0#rY,rm#rY")))
   (clobber (match_scratch:DF 6 "=2,&4,X,X,X,X,X,X,X,X"))
   (clobber (reg:CC 17))]
  "TARGET_SSE2
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)
   /* Avoid combine from being smart and converting min/max
      instruction patterns into conditional moves.  */
   && ((GET_CODE (operands[1]) != LT && GET_CODE (operands[1]) != GT
	&& GET_CODE (operands[1]) != UNLE && GET_CODE (operands[1]) != UNGE)
       || !rtx_equal_p (operands[4], operands[2])
       || !rtx_equal_p (operands[5], operands[3]))
   && (!TARGET_IEEE_FP
       || (GET_CODE (operands[1]) != EQ && GET_CODE (operands[1]) != NE))"
  "#")

(define_insn "sse_movdfcc_eq"
  [(set (match_operand:DF 0 "register_operand" "=&Y#rf,Y#rf,?f#Yr,?f#Yr,?r#Yf,?r#Yf")
	(if_then_else:DF (eq (match_operand:DF 3 "nonimmediate_operand" "%0#fY,Y#fY,f#Y,Ym#f,f#Y,Ym#f")
			     (match_operand:DF 4 "nonimmediate_operand" "Ym#f,Ym#f,f#Y,Y#f,f#Y,Y#f"))
		      (match_operand:DF 1 "nonimmediate_operand" "Y#fr,0#fr,0#fY,0#fY,0#rY,0#rY")
		      (match_operand:DF 2 "nonimmediate_operand" "Y#fr,Y#fr,f#fY,f#fY,rm#rY,rm#rY")))
   (clobber (match_scratch:DF 5 "=1,&3,X,X,X,X"))
   (clobber (reg:CC 17))]
  "TARGET_SSE
   && (GET_CODE (operands[2]) != MEM || GET_CODE (operands[3]) != MEM)"
  "#")

;; For non-sse moves just expand the usual cmove sequence.
(define_split
  [(set (match_operand 0 "register_operand" "")
	(if_then_else (match_operator 1 "comparison_operator"
			[(match_operand 4 "nonimmediate_operand" "")
			 (match_operand 5 "register_operand" "")])
		      (match_operand 2 "nonimmediate_operand" "")
		      (match_operand 3 "nonimmediate_operand" "")))
   (clobber (match_operand 6 "" ""))
   (clobber (reg:CC 17))]
  "!SSE_REG_P (operands[0]) && reload_completed
   && VALID_SSE_REG_MODE (GET_MODE (operands[0]))"
  [(const_int 0)]
{
   ix86_compare_op0 = operands[5];
   ix86_compare_op1 = operands[4];
   operands[1] = gen_rtx_fmt_ee (swap_condition (GET_CODE (operands[1])),
				 VOIDmode, operands[5], operands[4]);
   ix86_expand_fp_movcc (operands);
   DONE;
})

;; Split SSE based conditional move into sequence:
;; cmpCC op0, op4   -  set op0 to 0 or ffffffff depending on the comparison
;; and   op2, op0   -  zero op2 if comparison was false
;; nand  op0, op3   -  load op3 to op0 if comparison was false
;; or	 op2, op0   -  get the nonzero one into the result.
(define_split
  [(set (match_operand 0 "register_operand" "")
	(if_then_else (match_operator 1 "sse_comparison_operator"
			[(match_operand 4 "register_operand" "")
			 (match_operand 5 "nonimmediate_operand" "")])
		      (match_operand 2 "register_operand" "")
		      (match_operand 3 "register_operand" "")))
   (clobber (match_operand 6 "" ""))
   (clobber (reg:CC 17))]
  "SSE_REG_P (operands[0]) && reload_completed"
  [(set (match_dup 4) (match_op_dup 1 [(match_dup 4) (match_dup 5)]))
   (set (subreg:TI (match_dup 2) 0) (and:TI (subreg:TI (match_dup 2) 0)
					    (subreg:TI (match_dup 4) 0)))
   (set (subreg:TI (match_dup 4) 0) (and:TI (not:TI (subreg:TI (match_dup 4) 0))
					    (subreg:TI (match_dup 3) 0)))
   (set (subreg:TI (match_dup 0) 0) (ior:TI (subreg:TI (match_dup 6) 0)
					    (subreg:TI (match_dup 7) 0)))]
{
  if (GET_MODE (operands[2]) == DFmode
      && TARGET_SSE_PARTIAL_REGS && !optimize_size)
    {
      rtx op = simplify_gen_subreg (V2DFmode, operands[2], DFmode, 0);
      emit_insn (gen_sse2_unpcklpd (op, op, op));
      op = simplify_gen_subreg (V2DFmode, operands[3], DFmode, 0);
      emit_insn (gen_sse2_unpcklpd (op, op, op));
    }

  /* If op2 == op3, op3 would be clobbered before it is used.  */
  if (operands_match_p (operands[2], operands[3]))
    {
      emit_move_insn (operands[0], operands[2]);
      DONE;
    }

  PUT_MODE (operands[1], GET_MODE (operands[0]));
  if (operands_match_p (operands[0], operands[4]))
    operands[6] = operands[4], operands[7] = operands[2];
  else
    operands[6] = operands[2], operands[7] = operands[4];
})

;; Special case of conditional move we can handle effectively.
;; Do not brother with the integer/floating point case, since these are
;; bot considerably slower, unlike in the generic case.
(define_insn "*sse_movsfcc_const0_1"
  [(set (match_operand:SF 0 "register_operand" "=&x")
	(if_then_else:SF (match_operator 1 "sse_comparison_operator"
			[(match_operand:SF 4 "register_operand" "0")
			 (match_operand:SF 5 "nonimmediate_operand" "xm")])
		      (match_operand:SF 2 "register_operand" "x")
		      (match_operand:SF 3 "const0_operand" "X")))]
  "TARGET_SSE"
  "#")

(define_insn "*sse_movsfcc_const0_2"
  [(set (match_operand:SF 0 "register_operand" "=&x")
	(if_then_else:SF (match_operator 1 "sse_comparison_operator"
			[(match_operand:SF 4 "register_operand" "0")
			 (match_operand:SF 5 "nonimmediate_operand" "xm")])
		      (match_operand:SF 2 "const0_operand" "X")
		      (match_operand:SF 3 "register_operand" "x")))]
  "TARGET_SSE"
  "#")

(define_insn "*sse_movsfcc_const0_3"
  [(set (match_operand:SF 0 "register_operand" "=&x")
	(if_then_else:SF (match_operator 1 "fcmov_comparison_operator"
			[(match_operand:SF 4 "nonimmediate_operand" "xm")
			 (match_operand:SF 5 "register_operand" "0")])
		      (match_operand:SF 2 "register_operand" "x")
		      (match_operand:SF 3 "const0_operand" "X")))]
  "TARGET_SSE"
  "#")

(define_insn "*sse_movsfcc_const0_4"
  [(set (match_operand:SF 0 "register_operand" "=&x")
	(if_then_else:SF (match_operator 1 "fcmov_comparison_operator"
			[(match_operand:SF 4 "nonimmediate_operand" "xm")
			 (match_operand:SF 5 "register_operand" "0")])
		      (match_operand:SF 2 "const0_operand" "X")
		      (match_operand:SF 3 "register_operand" "x")))]
  "TARGET_SSE"
  "#")

(define_insn "*sse_movdfcc_const0_1"
  [(set (match_operand:DF 0 "register_operand" "=&Y")
	(if_then_else:DF (match_operator 1 "sse_comparison_operator"
			[(match_operand:DF 4 "register_operand" "0")
			 (match_operand:DF 5 "nonimmediate_operand" "Ym")])
		      (match_operand:DF 2 "register_operand" "Y")
		      (match_operand:DF 3 "const0_operand" "X")))]
  "TARGET_SSE2"
  "#")

(define_insn "*sse_movdfcc_const0_2"
  [(set (match_operand:DF 0 "register_operand" "=&Y")
	(if_then_else:DF (match_operator 1 "sse_comparison_operator"
			[(match_operand:DF 4 "register_operand" "0")
			 (match_operand:DF 5 "nonimmediate_operand" "Ym")])
		      (match_operand:DF 2 "const0_operand" "X")
		      (match_operand:DF 3 "register_operand" "Y")))]
  "TARGET_SSE2"
  "#")

(define_insn "*sse_movdfcc_const0_3"
  [(set (match_operand:DF 0 "register_operand" "=&Y")
	(if_then_else:DF (match_operator 1 "fcmov_comparison_operator"
			[(match_operand:DF 4 "nonimmediate_operand" "Ym")
			 (match_operand:DF 5 "register_operand" "0")])
		      (match_operand:DF 2 "register_operand" "Y")
		      (match_operand:DF 3 "const0_operand" "X")))]
  "TARGET_SSE2"
  "#")

(define_insn "*sse_movdfcc_const0_4"
  [(set (match_operand:DF 0 "register_operand" "=&Y")
	(if_then_else:DF (match_operator 1 "fcmov_comparison_operator"
			[(match_operand:DF 4 "nonimmediate_operand" "Ym")
			 (match_operand:DF 5 "register_operand" "0")])
		      (match_operand:DF 2 "const0_operand" "X")
		      (match_operand:DF 3 "register_operand" "Y")))]
  "TARGET_SSE2"
  "#")

(define_split
  [(set (match_operand 0 "register_operand" "")
	(if_then_else (match_operator 1 "comparison_operator"
			[(match_operand 4 "nonimmediate_operand" "")
			 (match_operand 5 "nonimmediate_operand" "")])
		      (match_operand 2 "nonmemory_operand" "")
		      (match_operand 3 "nonmemory_operand" "")))]
  "SSE_REG_P (operands[0]) && reload_completed
   && (const0_operand (operands[2], GET_MODE (operands[0]))
       || const0_operand (operands[3], GET_MODE (operands[0])))"
  [(set (match_dup 0) (match_op_dup 1 [(match_dup 0) (match_dup 5)]))
   (set (subreg:TI (match_dup 0) 0) (and:TI (match_dup 6)
					    (match_dup 7)))]
{
  if (TARGET_SSE_PARTIAL_REGS && !optimize_size
      && GET_MODE (operands[2]) == DFmode)
    {
      if (REG_P (operands[2]))
	{
	  rtx op = simplify_gen_subreg (V2DFmode, operands[2], DFmode, 0);
	  emit_insn (gen_sse2_unpcklpd (op, op, op));
	}
      if (REG_P (operands[3]))
	{
	  rtx op = simplify_gen_subreg (V2DFmode, operands[3], DFmode, 0);
	  emit_insn (gen_sse2_unpcklpd (op, op, op));
	}
    }
  PUT_MODE (operands[1], GET_MODE (operands[0]));
  if (!sse_comparison_operator (operands[1], VOIDmode)
      || !rtx_equal_p (operands[0], operands[4]))
    {
      rtx tmp = operands[5];
      operands[5] = operands[4];
      operands[4] = tmp;
      PUT_CODE (operands[1], swap_condition (GET_CODE (operands[1])));
    }
  if (!rtx_equal_p (operands[0], operands[4]))
    abort ();
  if (const0_operand (operands[2], GET_MODE (operands[0])))
    {
      operands[7] = operands[3];
      operands[6] = gen_rtx_NOT (TImode, gen_rtx_SUBREG (TImode, operands[0],
							 0));
    }
  else
    {
      operands[7] = operands[2];
      operands[6] = gen_rtx_SUBREG (TImode, operands[0], 0);
    }
  operands[7] = simplify_gen_subreg (TImode, operands[7],
  				     GET_MODE (operands[7]), 0);
})

(define_expand "allocate_stack_worker"
  [(match_operand:SI 0 "register_operand" "")]
  "TARGET_STACK_PROBE"
{
  if (reload_completed)
    {
      if (TARGET_64BIT)
	emit_insn (gen_allocate_stack_worker_rex64_postreload (operands[0]));
      else
	emit_insn (gen_allocate_stack_worker_postreload (operands[0]));
    }
  else
    {
      if (TARGET_64BIT)
	emit_insn (gen_allocate_stack_worker_rex64 (operands[0]));
      else
	emit_insn (gen_allocate_stack_worker_1 (operands[0]));
    }
  DONE;
})

(define_insn "allocate_stack_worker_1"
  [(unspec_volatile:SI [(match_operand:SI 0 "register_operand" "a")]
    UNSPECV_STACK_PROBE)
   (set (reg:SI 7) (minus:SI (reg:SI 7) (match_dup 0)))
   (clobber (match_scratch:SI 1 "=0"))
   (clobber (reg:CC 17))]
  "!TARGET_64BIT && TARGET_STACK_PROBE"
  "call\t__alloca"
  [(set_attr "type" "multi")
   (set_attr "length" "5")])

(define_expand "allocate_stack_worker_postreload"
  [(parallel [(unspec_volatile:SI [(match_operand:SI 0 "register_operand" "a")]
				    UNSPECV_STACK_PROBE)
	      (set (reg:SI 7) (minus:SI (reg:SI 7) (match_dup 0)))
	      (clobber (match_dup 0))
	      (clobber (reg:CC 17))])]
  ""
  "")

(define_insn "allocate_stack_worker_rex64"
  [(unspec_volatile:DI [(match_operand:DI 0 "register_operand" "a")]
    UNSPECV_STACK_PROBE)
   (set (reg:DI 7) (minus:DI (reg:DI 7) (match_dup 0)))
   (clobber (match_scratch:DI 1 "=0"))
   (clobber (reg:CC 17))]
  "TARGET_64BIT && TARGET_STACK_PROBE"
  "call\t__alloca"
  [(set_attr "type" "multi")
   (set_attr "length" "5")])

(define_expand "allocate_stack_worker_rex64_postreload"
  [(parallel [(unspec_volatile:DI [(match_operand:DI 0 "register_operand" "a")]
				    UNSPECV_STACK_PROBE)
	      (set (reg:DI 7) (minus:DI (reg:DI 7) (match_dup 0)))
	      (clobber (match_dup 0))
	      (clobber (reg:CC 17))])]
  ""
  "")

(define_expand "allocate_stack"
  [(parallel [(set (match_operand:SI 0 "register_operand" "=r")
		   (minus:SI (reg:SI 7)
			     (match_operand:SI 1 "general_operand" "")))
	      (clobber (reg:CC 17))])
   (parallel [(set (reg:SI 7)
		   (minus:SI (reg:SI 7) (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "TARGET_STACK_PROBE"
{
#ifdef CHECK_STACK_LIMIT
  if (GET_CODE (operands[1]) == CONST_INT
      && INTVAL (operands[1]) < CHECK_STACK_LIMIT)
    emit_insn (gen_subsi3 (stack_pointer_rtx, stack_pointer_rtx,
			   operands[1]));
  else 
#endif
    emit_insn (gen_allocate_stack_worker (copy_to_mode_reg (SImode,
							    operands[1])));

  emit_move_insn (operands[0], virtual_stack_dynamic_rtx);
  DONE;
})

(define_expand "builtin_setjmp_receiver"
  [(label_ref (match_operand 0 "" ""))]
  "!TARGET_64BIT && flag_pic"
{
  emit_insn (gen_set_got (pic_offset_table_rtx));
  DONE;
})

;; Avoid redundant prefixes by splitting HImode arithmetic to SImode.

(define_split
  [(set (match_operand 0 "register_operand" "")
	(match_operator 3 "promotable_binary_operator"
	   [(match_operand 1 "register_operand" "")
	    (match_operand 2 "aligned_operand" "")]))
   (clobber (reg:CC 17))]
  "! TARGET_PARTIAL_REG_STALL && reload_completed
   && ((GET_MODE (operands[0]) == HImode 
	&& ((!optimize_size && !TARGET_FAST_PREFIX)
	    || GET_CODE (operands[2]) != CONST_INT
	    || CONST_OK_FOR_LETTER_P (INTVAL (operands[2]), 'K')))
       || (GET_MODE (operands[0]) == QImode 
	   && (TARGET_PROMOTE_QImode || optimize_size)))"
  [(parallel [(set (match_dup 0)
		   (match_op_dup 3 [(match_dup 1) (match_dup 2)]))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);
   if (GET_CODE (operands[3]) != ASHIFT)
     operands[2] = gen_lowpart (SImode, operands[2]);
   PUT_MODE (operands[3], SImode);")

; Promote the QImode tests, as i386 has encoding of the AND
; instruction with 32-bit sign-extended immediate and thus the
; instruction size is unchanged, except in the %eax case for
; which it is increased by one byte, hence the ! optimize_size.
(define_split
  [(set (reg 17)
	(compare (and (match_operand 1 "aligned_operand" "")
		      (match_operand 2 "const_int_operand" ""))
		 (const_int 0)))
   (set (match_operand 0 "register_operand" "")
	(and (match_dup 1) (match_dup 2)))]
  "! TARGET_PARTIAL_REG_STALL && reload_completed
   /* Ensure that the operand will remain sign-extended immediate.  */
   && ix86_match_ccmode (insn, INTVAL (operands[2]) >= 0 ? CCNOmode : CCZmode)
   && ! optimize_size
   && ((GET_MODE (operands[0]) == HImode && ! TARGET_FAST_PREFIX)
       || (GET_MODE (operands[0]) == QImode && TARGET_PROMOTE_QImode))"
  [(parallel [(set (reg:CCNO 17)
		   (compare:CCNO (and:SI (match_dup 1) (match_dup 2))
			         (const_int 0)))
	      (set (match_dup 0)
		   (and:SI (match_dup 1) (match_dup 2)))])]
  "operands[2]
     = gen_int_mode (INTVAL (operands[2])
		     & GET_MODE_MASK (GET_MODE (operands[0])),
		     SImode);
   operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);")

; Don't promote the QImode tests, as i386 doesn't have encoding of
; the TEST instruction with 32-bit sign-extended immediate and thus
; the instruction size would at least double, which is not what we
; want even with ! optimize_size.
(define_split
  [(set (reg 17)
	(compare (and (match_operand:HI 0 "aligned_operand" "")
		      (match_operand:HI 1 "const_int_operand" ""))
		 (const_int 0)))]
  "! TARGET_PARTIAL_REG_STALL && reload_completed
   /* Ensure that the operand will remain sign-extended immediate.  */
   && ix86_match_ccmode (insn, INTVAL (operands[1]) >= 0 ? CCNOmode : CCZmode)
   && ! TARGET_FAST_PREFIX
   && ! optimize_size"
  [(set (reg:CCNO 17)
	(compare:CCNO (and:SI (match_dup 0) (match_dup 1))
		      (const_int 0)))]
  "operands[1]
     = gen_int_mode (INTVAL (operands[1])
		     & GET_MODE_MASK (GET_MODE (operands[0])),
		     SImode);
   operands[0] = gen_lowpart (SImode, operands[0]);")

(define_split
  [(set (match_operand 0 "register_operand" "")
	(neg (match_operand 1 "register_operand" "")))
   (clobber (reg:CC 17))]
  "! TARGET_PARTIAL_REG_STALL && reload_completed
   && (GET_MODE (operands[0]) == HImode
       || (GET_MODE (operands[0]) == QImode 
	   && (TARGET_PROMOTE_QImode || optimize_size)))"
  [(parallel [(set (match_dup 0)
		   (neg:SI (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);")

(define_split
  [(set (match_operand 0 "register_operand" "")
	(not (match_operand 1 "register_operand" "")))]
  "! TARGET_PARTIAL_REG_STALL && reload_completed
   && (GET_MODE (operands[0]) == HImode
       || (GET_MODE (operands[0]) == QImode 
	   && (TARGET_PROMOTE_QImode || optimize_size)))"
  [(set (match_dup 0)
	(not:SI (match_dup 1)))]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[1] = gen_lowpart (SImode, operands[1]);")

(define_split 
  [(set (match_operand 0 "register_operand" "")
	(if_then_else (match_operator 1 "comparison_operator" 
				[(reg 17) (const_int 0)])
		      (match_operand 2 "register_operand" "")
		      (match_operand 3 "register_operand" "")))]
  "! TARGET_PARTIAL_REG_STALL && TARGET_CMOVE
   && (GET_MODE (operands[0]) == HImode
       || (GET_MODE (operands[0]) == QImode 
	   && (TARGET_PROMOTE_QImode || optimize_size)))"
  [(set (match_dup 0)
	(if_then_else:SI (match_dup 1) (match_dup 2) (match_dup 3)))]
  "operands[0] = gen_lowpart (SImode, operands[0]);
   operands[2] = gen_lowpart (SImode, operands[2]);
   operands[3] = gen_lowpart (SImode, operands[3]);")
			

;; RTL Peephole optimizations, run before sched2.  These primarily look to
;; transform a complex memory operation into two memory to register operations.

;; Don't push memory operands
(define_peephole2
  [(set (match_operand:SI 0 "push_operand" "")
	(match_operand:SI 1 "memory_operand" ""))
   (match_scratch:SI 2 "r")]
  "! optimize_size && ! TARGET_PUSH_MEMORY"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

(define_peephole2
  [(set (match_operand:DI 0 "push_operand" "")
	(match_operand:DI 1 "memory_operand" ""))
   (match_scratch:DI 2 "r")]
  "! optimize_size && ! TARGET_PUSH_MEMORY"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

;; We need to handle SFmode only, because DFmode and XFmode is split to
;; SImode pushes.
(define_peephole2
  [(set (match_operand:SF 0 "push_operand" "")
	(match_operand:SF 1 "memory_operand" ""))
   (match_scratch:SF 2 "r")]
  "! optimize_size && ! TARGET_PUSH_MEMORY"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

(define_peephole2
  [(set (match_operand:HI 0 "push_operand" "")
	(match_operand:HI 1 "memory_operand" ""))
   (match_scratch:HI 2 "r")]
  "! optimize_size && ! TARGET_PUSH_MEMORY"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

(define_peephole2
  [(set (match_operand:QI 0 "push_operand" "")
	(match_operand:QI 1 "memory_operand" ""))
   (match_scratch:QI 2 "q")]
  "! optimize_size && ! TARGET_PUSH_MEMORY"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

;; Don't move an immediate directly to memory when the instruction
;; gets too big.
(define_peephole2
  [(match_scratch:SI 1 "r")
   (set (match_operand:SI 0 "memory_operand" "")
        (const_int 0))]
  "! optimize_size
   && ! TARGET_USE_MOV0
   && TARGET_SPLIT_LONG_MOVES
   && get_attr_length (insn) >= ix86_cost->large_insn
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 1) (const_int 0))
	      (clobber (reg:CC 17))])
   (set (match_dup 0) (match_dup 1))]
  "")

(define_peephole2
  [(match_scratch:HI 1 "r")
   (set (match_operand:HI 0 "memory_operand" "")
        (const_int 0))]
  "! optimize_size
   && ! TARGET_USE_MOV0
   && TARGET_SPLIT_LONG_MOVES
   && get_attr_length (insn) >= ix86_cost->large_insn
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 2) (const_int 0))
	      (clobber (reg:CC 17))])
   (set (match_dup 0) (match_dup 1))]
  "operands[2] = gen_lowpart (SImode, operands[1]);")

(define_peephole2
  [(match_scratch:QI 1 "q")
   (set (match_operand:QI 0 "memory_operand" "")
        (const_int 0))]
  "! optimize_size
   && ! TARGET_USE_MOV0
   && TARGET_SPLIT_LONG_MOVES
   && get_attr_length (insn) >= ix86_cost->large_insn
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 2) (const_int 0))
	      (clobber (reg:CC 17))])
   (set (match_dup 0) (match_dup 1))]
  "operands[2] = gen_lowpart (SImode, operands[1]);")

(define_peephole2
  [(match_scratch:SI 2 "r")
   (set (match_operand:SI 0 "memory_operand" "")
        (match_operand:SI 1 "immediate_operand" ""))]
  "! optimize_size
   && get_attr_length (insn) >= ix86_cost->large_insn
   && TARGET_SPLIT_LONG_MOVES"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

(define_peephole2
  [(match_scratch:HI 2 "r")
   (set (match_operand:HI 0 "memory_operand" "")
        (match_operand:HI 1 "immediate_operand" ""))]
  "! optimize_size && get_attr_length (insn) >= ix86_cost->large_insn
  && TARGET_SPLIT_LONG_MOVES"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

(define_peephole2
  [(match_scratch:QI 2 "q")
   (set (match_operand:QI 0 "memory_operand" "")
        (match_operand:QI 1 "immediate_operand" ""))]
  "! optimize_size && get_attr_length (insn) >= ix86_cost->large_insn
  && TARGET_SPLIT_LONG_MOVES"
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

;; Don't compare memory with zero, load and use a test instead.
(define_peephole2
  [(set (reg 17)
	(compare (match_operand:SI 0 "memory_operand" "")
	         (const_int 0)))
   (match_scratch:SI 3 "r")]
  "ix86_match_ccmode (insn, CCNOmode) && ! optimize_size"
  [(set (match_dup 3) (match_dup 0))
   (set (reg:CCNO 17) (compare:CCNO (match_dup 3) (const_int 0)))]
  "")

;; NOT is not pairable on Pentium, while XOR is, but one byte longer. 
;; Don't split NOTs with a displacement operand, because resulting XOR
;; will not be pairable anyway.
;;
;; On AMD K6, NOT is vector decoded with memory operand that can not be
;; represented using a modRM byte.  The XOR replacement is long decoded,
;; so this split helps here as well.
;;
;; Note: Can't do this as a regular split because we can't get proper
;; lifetime information then.

(define_peephole2
  [(set (match_operand:SI 0 "nonimmediate_operand" "")
	(not:SI (match_operand:SI 1 "nonimmediate_operand" "")))]
  "!optimize_size
   && peep2_regno_dead_p (0, FLAGS_REG)
   && ((TARGET_PENTIUM 
        && (GET_CODE (operands[0]) != MEM
            || !memory_displacement_operand (operands[0], SImode)))
       || (TARGET_K6 && long_memory_operand (operands[0], SImode)))"
  [(parallel [(set (match_dup 0)
		   (xor:SI (match_dup 1) (const_int -1)))
	      (clobber (reg:CC 17))])]
  "")

(define_peephole2
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(not:HI (match_operand:HI 1 "nonimmediate_operand" "")))]
  "!optimize_size
   && peep2_regno_dead_p (0, FLAGS_REG)
   && ((TARGET_PENTIUM 
        && (GET_CODE (operands[0]) != MEM
            || !memory_displacement_operand (operands[0], HImode)))
       || (TARGET_K6 && long_memory_operand (operands[0], HImode)))"
  [(parallel [(set (match_dup 0)
		   (xor:HI (match_dup 1) (const_int -1)))
	      (clobber (reg:CC 17))])]
  "")

(define_peephole2
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(not:QI (match_operand:QI 1 "nonimmediate_operand" "")))]
  "!optimize_size
   && peep2_regno_dead_p (0, FLAGS_REG)
   && ((TARGET_PENTIUM 
        && (GET_CODE (operands[0]) != MEM
            || !memory_displacement_operand (operands[0], QImode)))
       || (TARGET_K6 && long_memory_operand (operands[0], QImode)))"
  [(parallel [(set (match_dup 0)
		   (xor:QI (match_dup 1) (const_int -1)))
	      (clobber (reg:CC 17))])]
  "")

;; Non pairable "test imm, reg" instructions can be translated to
;; "and imm, reg" if reg dies.  The "and" form is also shorter (one
;; byte opcode instead of two, have a short form for byte operands),
;; so do it for other CPUs as well.  Given that the value was dead,
;; this should not create any new dependencies.  Pass on the sub-word
;; versions if we're concerned about partial register stalls.

(define_peephole2
  [(set (reg 17)
	(compare (and:SI (match_operand:SI 0 "register_operand" "")
			 (match_operand:SI 1 "immediate_operand" ""))
		 (const_int 0)))]
  "ix86_match_ccmode (insn, CCNOmode)
   && (true_regnum (operands[0]) != 0
       || (GET_CODE (operands[1]) == CONST_INT
	   && CONST_OK_FOR_LETTER_P (INTVAL (operands[1]), 'K')))
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(parallel
     [(set (reg:CCNO 17)
	   (compare:CCNO (and:SI (match_dup 0)
			         (match_dup 1))
		         (const_int 0)))
      (set (match_dup 0)
	   (and:SI (match_dup 0) (match_dup 1)))])]
  "")

;; We don't need to handle HImode case, because it will be promoted to SImode
;; on ! TARGET_PARTIAL_REG_STALL

(define_peephole2
  [(set (reg 17)
	(compare (and:QI (match_operand:QI 0 "register_operand" "")
			 (match_operand:QI 1 "immediate_operand" ""))
		 (const_int 0)))]
  "! TARGET_PARTIAL_REG_STALL
   && ix86_match_ccmode (insn, CCNOmode)
   && true_regnum (operands[0]) != 0
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(parallel
     [(set (reg:CCNO 17)
	   (compare:CCNO (and:QI (match_dup 0)
 			         (match_dup 1))
		         (const_int 0)))
      (set (match_dup 0)
	   (and:QI (match_dup 0) (match_dup 1)))])]
  "")

(define_peephole2
  [(set (reg 17)
	(compare
	  (and:SI
	    (zero_extract:SI
	      (match_operand 0 "ext_register_operand" "")
	      (const_int 8)
	      (const_int 8))
	    (match_operand 1 "const_int_operand" ""))
	  (const_int 0)))]
  "! TARGET_PARTIAL_REG_STALL
   && ix86_match_ccmode (insn, CCNOmode)
   && true_regnum (operands[0]) != 0
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(parallel [(set (reg:CCNO 17)
		   (compare:CCNO
		       (and:SI
			 (zero_extract:SI
			 (match_dup 0)
			 (const_int 8)
			 (const_int 8))
			(match_dup 1))
		   (const_int 0)))
	      (set (zero_extract:SI (match_dup 0)
				    (const_int 8)
				    (const_int 8))
		   (and:SI 
		     (zero_extract:SI
		       (match_dup 0)
		       (const_int 8)
		       (const_int 8))
		     (match_dup 1)))])]
  "")

;; Don't do logical operations with memory inputs.
(define_peephole2
  [(match_scratch:SI 2 "r")
   (parallel [(set (match_operand:SI 0 "register_operand" "")
                   (match_operator:SI 3 "arith_or_logical_operator"
                     [(match_dup 0)
                      (match_operand:SI 1 "memory_operand" "")]))
              (clobber (reg:CC 17))])]
  "! optimize_size && ! TARGET_READ_MODIFY"
  [(set (match_dup 2) (match_dup 1))
   (parallel [(set (match_dup 0)
                   (match_op_dup 3 [(match_dup 0) (match_dup 2)]))
              (clobber (reg:CC 17))])]
  "")

(define_peephole2
  [(match_scratch:SI 2 "r")
   (parallel [(set (match_operand:SI 0 "register_operand" "")
                   (match_operator:SI 3 "arith_or_logical_operator"
                     [(match_operand:SI 1 "memory_operand" "")
                      (match_dup 0)]))
              (clobber (reg:CC 17))])]
  "! optimize_size && ! TARGET_READ_MODIFY"
  [(set (match_dup 2) (match_dup 1))
   (parallel [(set (match_dup 0)
                   (match_op_dup 3 [(match_dup 2) (match_dup 0)]))
              (clobber (reg:CC 17))])]
  "")

; Don't do logical operations with memory outputs
;
; These two don't make sense for PPro/PII -- we're expanding a 4-uop
; instruction into two 1-uop insns plus a 2-uop insn.  That last has
; the same decoder scheduling characteristics as the original.

(define_peephole2
  [(match_scratch:SI 2 "r")
   (parallel [(set (match_operand:SI 0 "memory_operand" "")
                   (match_operator:SI 3 "arith_or_logical_operator"
                     [(match_dup 0)
                      (match_operand:SI 1 "nonmemory_operand" "")]))
              (clobber (reg:CC 17))])]
  "! optimize_size && ! TARGET_READ_MODIFY_WRITE"
  [(set (match_dup 2) (match_dup 0))
   (parallel [(set (match_dup 2)
                   (match_op_dup 3 [(match_dup 2) (match_dup 1)]))
              (clobber (reg:CC 17))])
   (set (match_dup 0) (match_dup 2))]
  "")

(define_peephole2
  [(match_scratch:SI 2 "r")
   (parallel [(set (match_operand:SI 0 "memory_operand" "")
                   (match_operator:SI 3 "arith_or_logical_operator"
                     [(match_operand:SI 1 "nonmemory_operand" "")
                      (match_dup 0)]))
              (clobber (reg:CC 17))])]
  "! optimize_size && ! TARGET_READ_MODIFY_WRITE"
  [(set (match_dup 2) (match_dup 0))
   (parallel [(set (match_dup 2)
                   (match_op_dup 3 [(match_dup 1) (match_dup 2)]))
              (clobber (reg:CC 17))])
   (set (match_dup 0) (match_dup 2))]
  "")

;; Attempt to always use XOR for zeroing registers.
(define_peephole2
  [(set (match_operand 0 "register_operand" "")
	(const_int 0))]
  "(GET_MODE (operands[0]) == QImode
    || GET_MODE (operands[0]) == HImode
    || GET_MODE (operands[0]) == SImode
    || (GET_MODE (operands[0]) == DImode && TARGET_64BIT))
   && (! TARGET_USE_MOV0 || optimize_size)
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 0) (const_int 0))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (GET_MODE (operands[0]) == DImode ? DImode : SImode,
			      operands[0]);")

(define_peephole2
  [(set (strict_low_part (match_operand 0 "register_operand" ""))
	(const_int 0))]
  "(GET_MODE (operands[0]) == QImode
    || GET_MODE (operands[0]) == HImode)
   && (! TARGET_USE_MOV0 || optimize_size)
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (strict_low_part (match_dup 0)) (const_int 0))
	      (clobber (reg:CC 17))])])

;; For HI and SI modes, or $-1,reg is smaller than mov $-1,reg.
(define_peephole2
  [(set (match_operand 0 "register_operand" "")
	(const_int -1))]
  "(GET_MODE (operands[0]) == HImode
    || GET_MODE (operands[0]) == SImode 
    || (GET_MODE (operands[0]) == DImode && TARGET_64BIT))
   && (optimize_size || TARGET_PENTIUM)
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 0) (const_int -1))
	      (clobber (reg:CC 17))])]
  "operands[0] = gen_lowpart (GET_MODE (operands[0]) == DImode ? DImode : SImode,
			      operands[0]);")

;; Attempt to convert simple leas to adds. These can be created by
;; move expanders.
(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
  	(plus:SI (match_dup 0)
		 (match_operand:SI 1 "nonmemory_operand" "")))]
  "peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 0) (plus:SI (match_dup 0) (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
  	(subreg:SI (plus:DI (match_operand:DI 1 "register_operand" "")
			    (match_operand:DI 2 "nonmemory_operand" "")) 0))]
  "peep2_regno_dead_p (0, FLAGS_REG) && REGNO (operands[0]) == REGNO (operands[1])"
  [(parallel [(set (match_dup 0) (plus:SI (match_dup 0) (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[2] = gen_lowpart (SImode, operands[2]);")

(define_peephole2
  [(set (match_operand:DI 0 "register_operand" "")
  	(plus:DI (match_dup 0)
		 (match_operand:DI 1 "x86_64_general_operand" "")))]
  "peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 0) (plus:DI (match_dup 0) (match_dup 1)))
	      (clobber (reg:CC 17))])]
  "")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
  	(mult:SI (match_dup 0)
		 (match_operand:SI 1 "const_int_operand" "")))]
  "exact_log2 (INTVAL (operands[1])) >= 0
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 0) (ashift:SI (match_dup 0) (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[2] = GEN_INT (exact_log2 (INTVAL (operands[1])));")

(define_peephole2
  [(set (match_operand:DI 0 "register_operand" "")
  	(mult:DI (match_dup 0)
		 (match_operand:DI 1 "const_int_operand" "")))]
  "exact_log2 (INTVAL (operands[1])) >= 0
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 0) (ashift:DI (match_dup 0) (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[2] = GEN_INT (exact_log2 (INTVAL (operands[1])));")

(define_peephole2
  [(set (match_operand:SI 0 "register_operand" "")
  	(subreg:SI (mult:DI (match_operand:DI 1 "register_operand" "")
		   (match_operand:DI 2 "const_int_operand" "")) 0))]
  "exact_log2 (INTVAL (operands[2])) >= 0
   && REGNO (operands[0]) == REGNO (operands[1])
   && peep2_regno_dead_p (0, FLAGS_REG)"
  [(parallel [(set (match_dup 0) (ashift:SI (match_dup 0) (match_dup 2)))
	      (clobber (reg:CC 17))])]
  "operands[2] = GEN_INT (exact_log2 (INTVAL (operands[2])));")

;; The ESP adjustments can be done by the push and pop instructions.  Resulting
;; code is shorter, since push is only 1 byte, while add imm, %esp 3 bytes.  On
;; many CPUs it is also faster, since special hardware to avoid esp
;; dependencies is present.

;; While some of these conversions may be done using splitters, we use peepholes
;; in order to allow combine_stack_adjustments pass to see nonobfuscated RTL.

;; Convert prologue esp subtractions to push.
;; We need register to push.  In order to keep verify_flow_info happy we have
;; two choices
;; - use scratch and clobber it in order to avoid dependencies
;; - use already live register
;; We can't use the second way right now, since there is no reliable way how to
;; verify that given register is live.  First choice will also most likely in
;; fewer dependencies.  On the place of esp adjustments it is very likely that
;; call clobbered registers are dead.  We may want to use base pointer as an
;; alternative when no register is available later.

(define_peephole2
  [(match_scratch:SI 0 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int -4)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size || !TARGET_SUB_ESP_4"
  [(clobber (match_dup 0))
   (parallel [(set (mem:SI (pre_dec:SI (reg:SI 7))) (match_dup 0))
	      (clobber (mem:BLK (scratch)))])])

(define_peephole2
  [(match_scratch:SI 0 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int -8)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size || !TARGET_SUB_ESP_8"
  [(clobber (match_dup 0))
   (set (mem:SI (pre_dec:SI (reg:SI 7))) (match_dup 0))
   (parallel [(set (mem:SI (pre_dec:SI (reg:SI 7))) (match_dup 0))
	      (clobber (mem:BLK (scratch)))])])

;; Convert esp subtractions to push.
(define_peephole2
  [(match_scratch:SI 0 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int -4)))
	      (clobber (reg:CC 17))])]
  "optimize_size || !TARGET_SUB_ESP_4"
  [(clobber (match_dup 0))
   (set (mem:SI (pre_dec:SI (reg:SI 7))) (match_dup 0))])

(define_peephole2
  [(match_scratch:SI 0 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int -8)))
	      (clobber (reg:CC 17))])]
  "optimize_size || !TARGET_SUB_ESP_8"
  [(clobber (match_dup 0))
   (set (mem:SI (pre_dec:SI (reg:SI 7))) (match_dup 0))
   (set (mem:SI (pre_dec:SI (reg:SI 7))) (match_dup 0))])

;; Convert epilogue deallocator to pop.
(define_peephole2
  [(match_scratch:SI 0 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size || !TARGET_ADD_ESP_4"
  [(parallel [(set (match_dup 0) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))
	      (clobber (mem:BLK (scratch)))])]
  "")

;; Two pops case is tricky, since pop causes dependency on destination register.
;; We use two registers if available.
(define_peephole2
  [(match_scratch:SI 0 "r")
   (match_scratch:SI 1 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 8)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size || !TARGET_ADD_ESP_8"
  [(parallel [(set (match_dup 0) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))
	      (clobber (mem:BLK (scratch)))])
   (parallel [(set (match_dup 1) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))])]
  "")

(define_peephole2
  [(match_scratch:SI 0 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 8)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size"
  [(parallel [(set (match_dup 0) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))
	      (clobber (mem:BLK (scratch)))])
   (parallel [(set (match_dup 0) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))])]
  "")

;; Convert esp additions to pop.
(define_peephole2
  [(match_scratch:SI 0 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))
	      (clobber (reg:CC 17))])]
  ""
  [(parallel [(set (match_dup 0) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))])]
  "")

;; Two pops case is tricky, since pop causes dependency on destination register.
;; We use two registers if available.
(define_peephole2
  [(match_scratch:SI 0 "r")
   (match_scratch:SI 1 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 8)))
	      (clobber (reg:CC 17))])]
  ""
  [(parallel [(set (match_dup 0) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))])
   (parallel [(set (match_dup 1) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))])]
  "")

(define_peephole2
  [(match_scratch:SI 0 "r")
   (parallel [(set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 8)))
	      (clobber (reg:CC 17))])]
  "optimize_size"
  [(parallel [(set (match_dup 0) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))])
   (parallel [(set (match_dup 0) (mem:SI (reg:SI 7)))
	      (set (reg:SI 7) (plus:SI (reg:SI 7) (const_int 4)))])]
  "")

;; Convert compares with 1 to shorter inc/dec operations when CF is not
;; required and register dies.
(define_peephole2
  [(set (reg 17)
	(compare (match_operand:SI 0 "register_operand" "")
		 (match_operand:SI 1 "incdec_operand" "")))]
  "ix86_match_ccmode (insn, CCGCmode)
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(parallel [(set (reg:CCGC 17)
		   (compare:CCGC (match_dup 0)
				 (match_dup 1)))
	      (clobber (match_dup 0))])]
  "")

(define_peephole2
  [(set (reg 17)
	(compare (match_operand:HI 0 "register_operand" "")
		 (match_operand:HI 1 "incdec_operand" "")))]
  "ix86_match_ccmode (insn, CCGCmode)
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(parallel [(set (reg:CCGC 17)
		   (compare:CCGC (match_dup 0)
				 (match_dup 1)))
	      (clobber (match_dup 0))])]
  "")

(define_peephole2
  [(set (reg 17)
	(compare (match_operand:QI 0 "register_operand" "")
		 (match_operand:QI 1 "incdec_operand" "")))]
  "ix86_match_ccmode (insn, CCGCmode)
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(parallel [(set (reg:CCGC 17)
		   (compare:CCGC (match_dup 0)
				 (match_dup 1)))
	      (clobber (match_dup 0))])]
  "")

;; Convert compares with 128 to shorter add -128
(define_peephole2
  [(set (reg 17)
	(compare (match_operand:SI 0 "register_operand" "")
		 (const_int 128)))]
  "ix86_match_ccmode (insn, CCGCmode)
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(parallel [(set (reg:CCGC 17)
		   (compare:CCGC (match_dup 0)
			         (const_int 128)))
	      (clobber (match_dup 0))])]
  "")

(define_peephole2
  [(set (reg 17)
	(compare (match_operand:HI 0 "register_operand" "")
		 (const_int 128)))]
  "ix86_match_ccmode (insn, CCGCmode)
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(parallel [(set (reg:CCGC 17)
		   (compare:CCGC (match_dup 0)
			         (const_int 128)))
	      (clobber (match_dup 0))])]
  "")

(define_peephole2
  [(match_scratch:DI 0 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int -8)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size || !TARGET_SUB_ESP_4"
  [(clobber (match_dup 0))
   (parallel [(set (mem:DI (pre_dec:DI (reg:DI 7))) (match_dup 0))
	      (clobber (mem:BLK (scratch)))])])

(define_peephole2
  [(match_scratch:DI 0 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int -16)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size || !TARGET_SUB_ESP_8"
  [(clobber (match_dup 0))
   (set (mem:DI (pre_dec:DI (reg:DI 7))) (match_dup 0))
   (parallel [(set (mem:DI (pre_dec:DI (reg:DI 7))) (match_dup 0))
	      (clobber (mem:BLK (scratch)))])])

;; Convert esp subtractions to push.
(define_peephole2
  [(match_scratch:DI 0 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int -8)))
	      (clobber (reg:CC 17))])]
  "optimize_size || !TARGET_SUB_ESP_4"
  [(clobber (match_dup 0))
   (set (mem:DI (pre_dec:DI (reg:DI 7))) (match_dup 0))])

(define_peephole2
  [(match_scratch:DI 0 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int -16)))
	      (clobber (reg:CC 17))])]
  "optimize_size || !TARGET_SUB_ESP_8"
  [(clobber (match_dup 0))
   (set (mem:DI (pre_dec:DI (reg:DI 7))) (match_dup 0))
   (set (mem:DI (pre_dec:DI (reg:DI 7))) (match_dup 0))])

;; Convert epilogue deallocator to pop.
(define_peephole2
  [(match_scratch:DI 0 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size || !TARGET_ADD_ESP_4"
  [(parallel [(set (match_dup 0) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))
	      (clobber (mem:BLK (scratch)))])]
  "")

;; Two pops case is tricky, since pop causes dependency on destination register.
;; We use two registers if available.
(define_peephole2
  [(match_scratch:DI 0 "r")
   (match_scratch:DI 1 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 16)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size || !TARGET_ADD_ESP_8"
  [(parallel [(set (match_dup 0) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))
	      (clobber (mem:BLK (scratch)))])
   (parallel [(set (match_dup 1) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))])]
  "")

(define_peephole2
  [(match_scratch:DI 0 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 16)))
	      (clobber (reg:CC 17))
	      (clobber (mem:BLK (scratch)))])]
  "optimize_size"
  [(parallel [(set (match_dup 0) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))
	      (clobber (mem:BLK (scratch)))])
   (parallel [(set (match_dup 0) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))])]
  "")

;; Convert esp additions to pop.
(define_peephole2
  [(match_scratch:DI 0 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))
	      (clobber (reg:CC 17))])]
  ""
  [(parallel [(set (match_dup 0) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))])]
  "")

;; Two pops case is tricky, since pop causes dependency on destination register.
;; We use two registers if available.
(define_peephole2
  [(match_scratch:DI 0 "r")
   (match_scratch:DI 1 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 16)))
	      (clobber (reg:CC 17))])]
  ""
  [(parallel [(set (match_dup 0) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))])
   (parallel [(set (match_dup 1) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))])]
  "")

(define_peephole2
  [(match_scratch:DI 0 "r")
   (parallel [(set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 16)))
	      (clobber (reg:CC 17))])]
  "optimize_size"
  [(parallel [(set (match_dup 0) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))])
   (parallel [(set (match_dup 0) (mem:DI (reg:DI 7)))
	      (set (reg:DI 7) (plus:DI (reg:DI 7) (const_int 8)))])]
  "")

;; Imul $32bit_imm, mem, reg is vector decoded, while
;; imul $32bit_imm, reg, reg is direct decoded.
(define_peephole2
  [(match_scratch:DI 3 "r")
   (parallel [(set (match_operand:DI 0 "register_operand" "")
		   (mult:DI (match_operand:DI 1 "memory_operand" "")
			    (match_operand:DI 2 "immediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_K8 && !optimize_size
   && (GET_CODE (operands[2]) != CONST_INT
       || !CONST_OK_FOR_LETTER_P (INTVAL (operands[2]), 'K'))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (match_dup 0) (mult:DI (match_dup 3) (match_dup 2)))
	      (clobber (reg:CC 17))])]
"")

(define_peephole2
  [(match_scratch:SI 3 "r")
   (parallel [(set (match_operand:SI 0 "register_operand" "")
		   (mult:SI (match_operand:SI 1 "memory_operand" "")
			    (match_operand:SI 2 "immediate_operand" "")))
	      (clobber (reg:CC 17))])]
  "TARGET_K8 && !optimize_size
   && (GET_CODE (operands[2]) != CONST_INT
       || !CONST_OK_FOR_LETTER_P (INTVAL (operands[2]), 'K'))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (match_dup 0) (mult:SI (match_dup 3) (match_dup 2)))
	      (clobber (reg:CC 17))])]
"")

(define_peephole2
  [(match_scratch:SI 3 "r")
   (parallel [(set (match_operand:DI 0 "register_operand" "")
		   (zero_extend:DI
		     (mult:SI (match_operand:SI 1 "memory_operand" "")
			      (match_operand:SI 2 "immediate_operand" ""))))
	      (clobber (reg:CC 17))])]
  "TARGET_K8 && !optimize_size
   && (GET_CODE (operands[2]) != CONST_INT
       || !CONST_OK_FOR_LETTER_P (INTVAL (operands[2]), 'K'))"
  [(set (match_dup 3) (match_dup 1))
   (parallel [(set (match_dup 0) (zero_extend:DI (mult:SI (match_dup 3) (match_dup 2))))
	      (clobber (reg:CC 17))])]
"")

;; imul $8/16bit_imm, regmem, reg is vector decoded.
;; Convert it into imul reg, reg
;; It would be better to force assembler to encode instruction using long
;; immediate, but there is apparently no way to do so.
(define_peephole2
  [(parallel [(set (match_operand:DI 0 "register_operand" "")
		   (mult:DI (match_operand:DI 1 "nonimmediate_operand" "")
			    (match_operand:DI 2 "const_int_operand" "")))
	      (clobber (reg:CC 17))])
   (match_scratch:DI 3 "r")]
  "TARGET_K8 && !optimize_size
   && CONST_OK_FOR_LETTER_P (INTVAL (operands[2]), 'K')"
  [(set (match_dup 3) (match_dup 2))
   (parallel [(set (match_dup 0) (mult:DI (match_dup 0) (match_dup 3)))
	      (clobber (reg:CC 17))])]
{
  if (!rtx_equal_p (operands[0], operands[1]))
    emit_move_insn (operands[0], operands[1]);
})

(define_peephole2
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (mult:SI (match_operand:SI 1 "nonimmediate_operand" "")
			    (match_operand:SI 2 "const_int_operand" "")))
	      (clobber (reg:CC 17))])
   (match_scratch:SI 3 "r")]
  "TARGET_K8 && !optimize_size
   && CONST_OK_FOR_LETTER_P (INTVAL (operands[2]), 'K')"
  [(set (match_dup 3) (match_dup 2))
   (parallel [(set (match_dup 0) (mult:SI (match_dup 0) (match_dup 3)))
	      (clobber (reg:CC 17))])]
{
  if (!rtx_equal_p (operands[0], operands[1]))
    emit_move_insn (operands[0], operands[1]);
})

(define_peephole2
  [(parallel [(set (match_operand:HI 0 "register_operand" "")
		   (mult:HI (match_operand:HI 1 "nonimmediate_operand" "")
			    (match_operand:HI 2 "immediate_operand" "")))
	      (clobber (reg:CC 17))])
   (match_scratch:HI 3 "r")]
  "TARGET_K8 && !optimize_size"
  [(set (match_dup 3) (match_dup 2))
   (parallel [(set (match_dup 0) (mult:HI (match_dup 0) (match_dup 3)))
	      (clobber (reg:CC 17))])]
{
  if (!rtx_equal_p (operands[0], operands[1]))
    emit_move_insn (operands[0], operands[1]);
})

;; Call-value patterns last so that the wildcard operand does not
;; disrupt insn-recog's switch tables.

(define_insn "*call_value_pop_0"
  [(set (match_operand 0 "" "")
	(call (mem:QI (match_operand:SI 1 "constant_call_address_operand" ""))
	      (match_operand:SI 2 "" "")))
   (set (reg:SI 7) (plus:SI (reg:SI 7)
			    (match_operand:SI 3 "immediate_operand" "")))]
  "!TARGET_64BIT"
{
  if (SIBLING_CALL_P (insn))
    return "jmp\t%P1";
  else
    return "call\t%P1";
}
  [(set_attr "type" "callv")])

(define_insn "*call_value_pop_1"
  [(set (match_operand 0 "" "")
	(call (mem:QI (match_operand:SI 1 "call_insn_operand" "rsm"))
	      (match_operand:SI 2 "" "")))
   (set (reg:SI 7) (plus:SI (reg:SI 7)
			    (match_operand:SI 3 "immediate_operand" "i")))]
  "!TARGET_64BIT"
{
  if (constant_call_address_operand (operands[1], QImode))
    {
      if (SIBLING_CALL_P (insn))
	return "jmp\t%P1";
      else
	return "call\t%P1";
    }
  if (SIBLING_CALL_P (insn))
    return "jmp\t%A1";
  else
    return "call\t%A1";
}
  [(set_attr "type" "callv")])

(define_insn "*call_value_0"
  [(set (match_operand 0 "" "")
	(call (mem:QI (match_operand:SI 1 "constant_call_address_operand" ""))
	      (match_operand:SI 2 "" "")))]
  "!TARGET_64BIT"
{
  if (SIBLING_CALL_P (insn))
    return "jmp\t%P1";
  else
    return "call\t%P1";
}
  [(set_attr "type" "callv")])

(define_insn "*call_value_0_rex64"
  [(set (match_operand 0 "" "")
	(call (mem:QI (match_operand:DI 1 "constant_call_address_operand" ""))
	      (match_operand:DI 2 "const_int_operand" "")))]
  "TARGET_64BIT"
{
  if (SIBLING_CALL_P (insn))
    return "jmp\t%P1";
  else
    return "call\t%P1";
}
  [(set_attr "type" "callv")])

(define_insn "*call_value_1"
  [(set (match_operand 0 "" "")
	(call (mem:QI (match_operand:SI 1 "call_insn_operand" "rsm"))
	      (match_operand:SI 2 "" "")))]
  "!SIBLING_CALL_P (insn) && !TARGET_64BIT"
{
  if (constant_call_address_operand (operands[1], QImode))
    return "call\t%P1";
  return "call\t%*%1";
}
  [(set_attr "type" "callv")])

(define_insn "*sibcall_value_1"
  [(set (match_operand 0 "" "")
	(call (mem:QI (match_operand:SI 1 "sibcall_insn_operand" "s,c,d,a"))
	      (match_operand:SI 2 "" "")))]
  "SIBLING_CALL_P (insn) && !TARGET_64BIT"
{
  if (constant_call_address_operand (operands[1], QImode))
    return "jmp\t%P1";
  return "jmp\t%*%1";
}
  [(set_attr "type" "callv")])

(define_insn "*call_value_1_rex64"
  [(set (match_operand 0 "" "")
	(call (mem:QI (match_operand:DI 1 "call_insn_operand" "rsm"))
	      (match_operand:DI 2 "" "")))]
  "!SIBLING_CALL_P (insn) && TARGET_64BIT"
{
  if (constant_call_address_operand (operands[1], QImode))
    return "call\t%P1";
  return "call\t%A1";
}
  [(set_attr "type" "callv")])

(define_insn "*sibcall_value_1_rex64"
  [(set (match_operand 0 "" "")
	(call (mem:QI (match_operand:DI 1 "constant_call_address_operand" ""))
	      (match_operand:DI 2 "" "")))]
  "SIBLING_CALL_P (insn) && TARGET_64BIT"
  "jmp\t%P1"
  [(set_attr "type" "callv")])

(define_insn "*sibcall_value_1_rex64_v"
  [(set (match_operand 0 "" "")
	(call (mem:QI (reg:DI 40))
	      (match_operand:DI 1 "" "")))]
  "SIBLING_CALL_P (insn) && TARGET_64BIT"
  "jmp\t*%%r11"
  [(set_attr "type" "callv")])

(define_insn "trap"
  [(trap_if (const_int 1) (const_int 5))]
  ""
  "int\t$5")

;;; ix86 doesn't have conditional trap instructions, but we fake them
;;; for the sake of bounds checking.  By emitting bounds checks as
;;; conditional traps rather than as conditional jumps around
;;; unconditional traps we avoid introducing spurious basic-block
;;; boundaries and facilitate elimination of redundant checks.  In
;;; honor of the too-inflexible-for-BPs `bound' instruction, we use
;;; interrupt 5.
;;; 
;;; FIXME: Static branch prediction rules for ix86 are such that
;;; forward conditional branches predict as untaken.  As implemented
;;; below, pseudo conditional traps violate that rule.  We should use
;;; .pushsection/.popsection to place all of the `int 5's in a special
;;; section loaded at the end of the text segment and branch forward
;;; there on bounds-failure, and then jump back immediately (in case
;;; the system chooses to ignore bounds violations, or to report
;;; violations and continue execution).

(define_expand "conditional_trap"
  [(trap_if (match_operator 0 "comparison_operator"
	     [(match_dup 2) (const_int 0)])
	    (match_operand 1 "const_int_operand" ""))]
  ""
{
  emit_insn (gen_rtx_TRAP_IF (VOIDmode,
			      ix86_expand_compare (GET_CODE (operands[0]),
						   NULL, NULL),
			      operands[1]));
  DONE;
})

(define_insn "*conditional_trap_1"
  [(trap_if (match_operator 0 "comparison_operator"
	     [(reg 17) (const_int 0)])
	    (match_operand 1 "const_int_operand" ""))]
  ""
{
  operands[2] = gen_label_rtx ();
  output_asm_insn ("j%c0\t%l2\; int\t%1", operands);
  (*targetm.asm_out.internal_label) (asm_out_file, "L",
			     CODE_LABEL_NUMBER (operands[2]));
  RET;
})

	;; Pentium III SIMD instructions.

;; Moves for SSE/MMX regs.

(define_insn "movv4sf_internal"
  [(set (match_operand:V4SF 0 "nonimmediate_operand" "=x,x,m")
	(match_operand:V4SF 1 "vector_move_operand" "C,xm,x"))]
  "TARGET_SSE"
  "@
    xorps\t%0, %0
    movaps\t{%1, %0|%0, %1}
    movaps\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "V4SF")])

(define_split
  [(set (match_operand:V4SF 0 "register_operand" "")
	(match_operand:V4SF 1 "zero_extended_scalar_load_operand" ""))]
  "TARGET_SSE"
  [(set (match_dup 0)
	(vec_merge:V4SF
	 (vec_duplicate:V4SF (match_dup 1))
	 (match_dup 2)
	 (const_int 1)))]
{
  operands[1] = simplify_gen_subreg (SFmode, operands[1], V4SFmode, 0);
  operands[2] = CONST0_RTX (V4SFmode);
})

(define_insn "movv4si_internal"
  [(set (match_operand:V4SI 0 "nonimmediate_operand" "=x,x,m")
	(match_operand:V4SI 1 "vector_move_operand" "C,xm,x"))]
  "TARGET_SSE"
{
  switch (which_alternative)
    {
    case 0:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "xorps\t%0, %0";
      else
	return "pxor\t%0, %0";
    case 1:
    case 2:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movdqa\t{%1, %0|%0, %1}";
    default:
      abort ();
    }
}
  [(set_attr "type" "ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "0,1")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "TI"))
	       (eq_attr "alternative" "2")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_TYPELESS_STORES")
			    (const_int 0))
			(ne (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "TI"))]
	       (const_string "TI")))])

(define_insn "movv2di_internal"
  [(set (match_operand:V2DI 0 "nonimmediate_operand" "=x,x,m")
	(match_operand:V2DI 1 "vector_move_operand" "C,xm,x"))]
  "TARGET_SSE"
{
  switch (which_alternative)
    {
    case 0:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "xorps\t%0, %0";
      else
	return "pxor\t%0, %0";
    case 1:
    case 2:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movdqa\t{%1, %0|%0, %1}";
    default:
      abort ();
    }
}
  [(set_attr "type" "ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "0,1")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "TI"))
	       (eq_attr "alternative" "2")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_TYPELESS_STORES")
			    (const_int 0))
			(ne (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "TI"))]
	       (const_string "TI")))])

(define_split
  [(set (match_operand:V2DF 0 "register_operand" "")
	(match_operand:V2DF 1 "zero_extended_scalar_load_operand" ""))]
  "TARGET_SSE2"
  [(set (match_dup 0)
	(vec_merge:V2DF
	 (vec_duplicate:V2DF (match_dup 1))
	 (match_dup 2)
	 (const_int 1)))]
{
  operands[1] = simplify_gen_subreg (DFmode, operands[1], V2DFmode, 0);
  operands[2] = CONST0_RTX (V2DFmode);
})

(define_insn "movv8qi_internal"
  [(set (match_operand:V8QI 0 "nonimmediate_operand" "=y,y,m")
	(match_operand:V8QI 1 "vector_move_operand" "C,ym,y"))]
  "TARGET_MMX
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
    pxor\t%0, %0
    movq\t{%1, %0|%0, %1}
    movq\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxmov")
   (set_attr "mode" "DI")])

(define_insn "movv4hi_internal"
  [(set (match_operand:V4HI 0 "nonimmediate_operand" "=y,y,m")
	(match_operand:V4HI 1 "vector_move_operand" "C,ym,y"))]
  "TARGET_MMX
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
    pxor\t%0, %0
    movq\t{%1, %0|%0, %1}
    movq\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxmov")
   (set_attr "mode" "DI")])

(define_insn "movv2si_internal"
  [(set (match_operand:V2SI 0 "nonimmediate_operand" "=y,y,m")
	(match_operand:V2SI 1 "vector_move_operand" "C,ym,y"))]
  "TARGET_MMX
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
    pxor\t%0, %0
    movq\t{%1, %0|%0, %1}
    movq\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "movv2sf_internal"
  [(set (match_operand:V2SF 0 "nonimmediate_operand" "=y,y,m")
        (match_operand:V2SF 1 "vector_move_operand" "C,ym,y"))]
  "TARGET_3DNOW
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
    pxor\t%0, %0
    movq\t{%1, %0|%0, %1}
    movq\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_expand "movti"
  [(set (match_operand:TI 0 "nonimmediate_operand" "")
	(match_operand:TI 1 "nonimmediate_operand" ""))]
  "TARGET_SSE || TARGET_64BIT"
{
  if (TARGET_64BIT)
    ix86_expand_move (TImode, operands);
  else
    ix86_expand_vector_move (TImode, operands);
  DONE;
})

(define_expand "movtf"
  [(set (match_operand:TF 0 "nonimmediate_operand" "")
	(match_operand:TF 1 "nonimmediate_operand" ""))]
  "TARGET_64BIT"
{
  if (TARGET_64BIT)
    ix86_expand_move (TFmode, operands);
  else
    ix86_expand_vector_move (TFmode, operands);
  DONE;
})

(define_insn "movv2df_internal"
  [(set (match_operand:V2DF 0 "nonimmediate_operand" "=x,x,m")
	(match_operand:V2DF 1 "vector_move_operand" "C,xm,x"))]
  "TARGET_SSE2
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "xorps\t%0, %0";
      else
	return "xorpd\t%0, %0";
    case 1:
    case 2:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movapd\t{%1, %0|%0, %1}";
    default:
      abort ();
    }
}
  [(set_attr "type" "ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "0,1")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "V2DF"))
	       (eq_attr "alternative" "2")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_TYPELESS_STORES")
			    (const_int 0))
			(ne (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "V2DF"))]
	       (const_string "V2DF")))])

(define_insn "movv8hi_internal"
  [(set (match_operand:V8HI 0 "nonimmediate_operand" "=x,x,m")
	(match_operand:V8HI 1 "vector_move_operand" "C,xm,x"))]
  "TARGET_SSE2
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "xorps\t%0, %0";
      else
	return "pxor\t%0, %0";
    case 1:
    case 2:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movdqa\t{%1, %0|%0, %1}";
    default:
      abort ();
    }
}
  [(set_attr "type" "ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "0,1")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "TI"))
	       (eq_attr "alternative" "2")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_TYPELESS_STORES")
			    (const_int 0))
			(ne (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "TI"))]
	       (const_string "TI")))])

(define_insn "movv16qi_internal"
  [(set (match_operand:V16QI 0 "nonimmediate_operand" "=x,x,m")
	(match_operand:V16QI 1 "vector_move_operand" "C,xm,x"))]
  "TARGET_SSE2
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "xorps\t%0, %0";
      else
	return "pxor\t%0, %0";
    case 1:
    case 2:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movdqa\t{%1, %0|%0, %1}";
    default:
      abort ();
    }
}
  [(set_attr "type" "ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "0,1")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "TI"))
	       (eq_attr "alternative" "2")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_TYPELESS_STORES")
			    (const_int 0))
			(ne (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "TI"))]
	       (const_string "TI")))])

(define_expand "movv2df"
  [(set (match_operand:V2DF 0 "nonimmediate_operand" "")
	(match_operand:V2DF 1 "nonimmediate_operand" ""))]
  "TARGET_SSE2"
{
  ix86_expand_vector_move (V2DFmode, operands);
  DONE;
})

(define_expand "movv8hi"
  [(set (match_operand:V8HI 0 "nonimmediate_operand" "")
	(match_operand:V8HI 1 "nonimmediate_operand" ""))]
  "TARGET_SSE2"
{
  ix86_expand_vector_move (V8HImode, operands);
  DONE;
})

(define_expand "movv16qi"
  [(set (match_operand:V16QI 0 "nonimmediate_operand" "")
	(match_operand:V16QI 1 "nonimmediate_operand" ""))]
  "TARGET_SSE2"
{
  ix86_expand_vector_move (V16QImode, operands);
  DONE;
})

(define_expand "movv4sf"
  [(set (match_operand:V4SF 0 "nonimmediate_operand" "")
	(match_operand:V4SF 1 "nonimmediate_operand" ""))]
  "TARGET_SSE"
{
  ix86_expand_vector_move (V4SFmode, operands);
  DONE;
})

(define_expand "movv4si"
  [(set (match_operand:V4SI 0 "nonimmediate_operand" "")
	(match_operand:V4SI 1 "nonimmediate_operand" ""))]
  "TARGET_SSE"
{
  ix86_expand_vector_move (V4SImode, operands);
  DONE;
})

(define_expand "movv2di"
  [(set (match_operand:V2DI 0 "nonimmediate_operand" "")
	(match_operand:V2DI 1 "nonimmediate_operand" ""))]
  "TARGET_SSE"
{
  ix86_expand_vector_move (V2DImode, operands);
  DONE;
})

(define_expand "movv2si"
  [(set (match_operand:V2SI 0 "nonimmediate_operand" "")
	(match_operand:V2SI 1 "nonimmediate_operand" ""))]
  "TARGET_MMX"
{
  ix86_expand_vector_move (V2SImode, operands);
  DONE;
})

(define_expand "movv4hi"
  [(set (match_operand:V4HI 0 "nonimmediate_operand" "")
	(match_operand:V4HI 1 "nonimmediate_operand" ""))]
  "TARGET_MMX"
{
  ix86_expand_vector_move (V4HImode, operands);
  DONE;
})

(define_expand "movv8qi"
  [(set (match_operand:V8QI 0 "nonimmediate_operand" "")
	(match_operand:V8QI 1 "nonimmediate_operand" ""))]
  "TARGET_MMX"
{
  ix86_expand_vector_move (V8QImode, operands);
  DONE;
})

(define_expand "movv2sf"
  [(set (match_operand:V2SF 0 "nonimmediate_operand" "")
	(match_operand:V2SF 1 "nonimmediate_operand" ""))]
   "TARGET_3DNOW"
{
  ix86_expand_vector_move (V2SFmode, operands);
  DONE;
})

(define_insn "*pushti"
  [(set (match_operand:TI 0 "push_operand" "=<")
	(match_operand:TI 1 "register_operand" "x"))]
  "TARGET_SSE"
  "#")

(define_insn "*pushv2df"
  [(set (match_operand:V2DF 0 "push_operand" "=<")
	(match_operand:V2DF 1 "register_operand" "x"))]
  "TARGET_SSE"
  "#")

(define_insn "*pushv2di"
  [(set (match_operand:V2DI 0 "push_operand" "=<")
	(match_operand:V2DI 1 "register_operand" "x"))]
  "TARGET_SSE2"
  "#")

(define_insn "*pushv8hi"
  [(set (match_operand:V8HI 0 "push_operand" "=<")
	(match_operand:V8HI 1 "register_operand" "x"))]
  "TARGET_SSE2"
  "#")

(define_insn "*pushv16qi"
  [(set (match_operand:V16QI 0 "push_operand" "=<")
	(match_operand:V16QI 1 "register_operand" "x"))]
  "TARGET_SSE2"
  "#")

(define_insn "*pushv4sf"
  [(set (match_operand:V4SF 0 "push_operand" "=<")
	(match_operand:V4SF 1 "register_operand" "x"))]
  "TARGET_SSE"
  "#")

(define_insn "*pushv4si"
  [(set (match_operand:V4SI 0 "push_operand" "=<")
	(match_operand:V4SI 1 "register_operand" "x"))]
  "TARGET_SSE2"
  "#")

(define_insn "*pushv2si"
  [(set (match_operand:V2SI 0 "push_operand" "=<")
	(match_operand:V2SI 1 "register_operand" "y"))]
  "TARGET_MMX"
  "#")

(define_insn "*pushv4hi"
  [(set (match_operand:V4HI 0 "push_operand" "=<")
	(match_operand:V4HI 1 "register_operand" "y"))]
  "TARGET_MMX"
  "#")

(define_insn "*pushv8qi"
  [(set (match_operand:V8QI 0 "push_operand" "=<")
	(match_operand:V8QI 1 "register_operand" "y"))]
  "TARGET_MMX"
  "#")

(define_insn "*pushv2sf"
  [(set (match_operand:V2SF 0 "push_operand" "=<")
	(match_operand:V2SF 1 "register_operand" "y"))]
  "TARGET_3DNOW"
  "#")

(define_split
  [(set (match_operand 0 "push_operand" "")
	(match_operand 1 "register_operand" ""))]
  "!TARGET_64BIT && reload_completed
   && (SSE_REG_P (operands[1]) || MMX_REG_P (operands[1]))"
  [(set (reg:SI 7) (plus:SI (reg:SI 7) (match_dup 3)))
   (set (match_dup 2) (match_dup 1))]
  "operands[2] = change_address (operands[0], GET_MODE (operands[0]),
				 stack_pointer_rtx);
   operands[3] = GEN_INT (-GET_MODE_SIZE (GET_MODE (operands[0])));")

(define_split
  [(set (match_operand 0 "push_operand" "")
	(match_operand 1 "register_operand" ""))]
  "TARGET_64BIT && reload_completed
   && (SSE_REG_P (operands[1]) || MMX_REG_P (operands[1]))"
  [(set (reg:DI 7) (plus:DI (reg:DI 7) (match_dup 3)))
   (set (match_dup 2) (match_dup 1))]
  "operands[2] = change_address (operands[0], GET_MODE (operands[0]),
				 stack_pointer_rtx);
   operands[3] = GEN_INT (-GET_MODE_SIZE (GET_MODE (operands[0])));")


(define_insn "movti_internal"
  [(set (match_operand:TI 0 "nonimmediate_operand" "=x,x,m")
	(match_operand:TI 1 "vector_move_operand" "C,xm,x"))]
  "TARGET_SSE && !TARGET_64BIT
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "xorps\t%0, %0";
      else
	return "pxor\t%0, %0";
    case 1:
    case 2:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movdqa\t{%1, %0|%0, %1}";
    default:
      abort ();
    }
}
  [(set_attr "type" "ssemov,ssemov,ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "0,1")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "TI"))
	       (eq_attr "alternative" "2")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "TI"))]
	       (const_string "TI")))])

(define_insn "*movti_rex64"
  [(set (match_operand:TI 0 "nonimmediate_operand" "=r,o,x,x,xm")
	(match_operand:TI 1 "general_operand" "riFo,riF,C,xm,x"))]
  "TARGET_64BIT
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
    case 1:
      return "#";
    case 2:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "xorps\t%0, %0";
      else
	return "pxor\t%0, %0";
    case 3:
    case 4:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movdqa\t{%1, %0|%0, %1}";
    default:
      abort ();
    }
}
  [(set_attr "type" "*,*,ssemov,ssemov,ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "2,3")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "TI"))
	       (eq_attr "alternative" "4")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_TYPELESS_STORES")
			    (const_int 0))
			(ne (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "TI"))]
	       (const_string "DI")))])

(define_insn "*movtf_rex64"
  [(set (match_operand:TF 0 "nonimmediate_operand" "=r,o,x,x,xm")
	(match_operand:TF 1 "general_operand" "riFo,riF,C,xm,x"))]
  "TARGET_64BIT
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
{
  switch (which_alternative)
    {
    case 0:
    case 1:
      return "#";
    case 2:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "xorps\t%0, %0";
      else
	return "pxor\t%0, %0";
    case 3:
    case 4:
      if (get_attr_mode (insn) == MODE_V4SF)
	return "movaps\t{%1, %0|%0, %1}";
      else
	return "movdqa\t{%1, %0|%0, %1}";
    default:
      abort ();
    }
}
  [(set_attr "type" "*,*,ssemov,ssemov,ssemov")
   (set (attr "mode")
        (cond [(eq_attr "alternative" "2,3")
		 (if_then_else
		   (ne (symbol_ref "optimize_size")
		       (const_int 0))
		   (const_string "V4SF")
		   (const_string "TI"))
	       (eq_attr "alternative" "4")
		 (if_then_else
		   (ior (ne (symbol_ref "TARGET_SSE_TYPELESS_STORES")
			    (const_int 0))
			(ne (symbol_ref "optimize_size")
			    (const_int 0)))
		   (const_string "V4SF")
		   (const_string "TI"))]
	       (const_string "DI")))])

(define_split
  [(set (match_operand:TI 0 "nonimmediate_operand" "")
        (match_operand:TI 1 "general_operand" ""))]
  "reload_completed && !SSE_REG_P (operands[0])
   && !SSE_REG_P (operands[1])"
  [(const_int 0)]
  "ix86_split_long_move (operands); DONE;")

(define_split
  [(set (match_operand:TF 0 "nonimmediate_operand" "")
        (match_operand:TF 1 "general_operand" ""))]
  "reload_completed && !SSE_REG_P (operands[0])
   && !SSE_REG_P (operands[1])"
  [(const_int 0)]
  "ix86_split_long_move (operands); DONE;")

;; These two patterns are useful for specifying exactly whether to use
;; movaps or movups
(define_expand "sse_movaps"
  [(set (match_operand:V4SF 0 "nonimmediate_operand" "")
	(unspec:V4SF [(match_operand:V4SF 1 "nonimmediate_operand" "")]
		     UNSPEC_MOVA))]
  "TARGET_SSE"
{
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    {
      rtx tmp = gen_reg_rtx (V4SFmode);
      emit_insn (gen_sse_movaps (tmp, operands[1]));
      emit_move_insn (operands[0], tmp);
      DONE;
    }
})

(define_insn "*sse_movaps_1"
  [(set (match_operand:V4SF 0 "nonimmediate_operand" "=x,m")
	(unspec:V4SF [(match_operand:V4SF 1 "nonimmediate_operand" "xm,x")]
		     UNSPEC_MOVA))]
  "TARGET_SSE
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "movaps\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov,ssemov")
   (set_attr "mode" "V4SF")])

(define_expand "sse_movups"
  [(set (match_operand:V4SF 0 "nonimmediate_operand" "")
	(unspec:V4SF [(match_operand:V4SF 1 "nonimmediate_operand" "")]
		     UNSPEC_MOVU))]
  "TARGET_SSE"
{
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    {
      rtx tmp = gen_reg_rtx (V4SFmode);
      emit_insn (gen_sse_movups (tmp, operands[1]));
      emit_move_insn (operands[0], tmp);
      DONE;
    }
})

(define_insn "*sse_movups_1"
  [(set (match_operand:V4SF 0 "nonimmediate_operand" "=x,m")
	(unspec:V4SF [(match_operand:V4SF 1 "nonimmediate_operand" "xm,x")]
		     UNSPEC_MOVU))]
  "TARGET_SSE
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "movups\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt,ssecvt")
   (set_attr "mode" "V4SF")])

;; SSE Strange Moves.

(define_insn "sse_movmskps"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:V4SF 1 "register_operand" "x")]
		   UNSPEC_MOVMSK))]
  "TARGET_SSE"
  "movmskps\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_insn "mmx_pmovmskb"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:V8QI 1 "register_operand" "y")]
		   UNSPEC_MOVMSK))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pmovmskb\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])


(define_insn "mmx_maskmovq"
  [(set (mem:V8QI (match_operand:SI 0 "register_operand" "D"))
	(unspec:V8QI [(match_operand:V8QI 1 "register_operand" "y")
		      (match_operand:V8QI 2 "register_operand" "y")]
		     UNSPEC_MASKMOV))]
  "(TARGET_SSE || TARGET_3DNOW_A) && !TARGET_64BIT"
  ;; @@@ check ordering of operands in intel/nonintel syntax
  "maskmovq\t{%2, %1|%1, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "mmx_maskmovq_rex"
  [(set (mem:V8QI (match_operand:DI 0 "register_operand" "D"))
	(unspec:V8QI [(match_operand:V8QI 1 "register_operand" "y")
		      (match_operand:V8QI 2 "register_operand" "y")]
		     UNSPEC_MASKMOV))]
  "(TARGET_SSE || TARGET_3DNOW_A) && TARGET_64BIT"
  ;; @@@ check ordering of operands in intel/nonintel syntax
  "maskmovq\t{%2, %1|%1, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "sse_movntv4sf"
  [(set (match_operand:V4SF 0 "memory_operand" "=m")
	(unspec:V4SF [(match_operand:V4SF 1 "register_operand" "x")]
		     UNSPEC_MOVNT))]
  "TARGET_SSE"
  "movntps\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "V4SF")])

(define_insn "sse_movntdi"
  [(set (match_operand:DI 0 "memory_operand" "=m")
	(unspec:DI [(match_operand:DI 1 "register_operand" "y")]
		   UNSPEC_MOVNT))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "movntq\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxmov")
   (set_attr "mode" "DI")])

(define_insn "sse_movhlps"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (match_operand:V4SF 1 "register_operand" "0")
	 (vec_select:V4SF (match_operand:V4SF 2 "register_operand" "x")
			  (parallel [(const_int 2)
				     (const_int 3)
				     (const_int 0)
				     (const_int 1)]))
	 (const_int 3)))]
  "TARGET_SSE"
  "movhlps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_insn "sse_movlhps"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (match_operand:V4SF 1 "register_operand" "0")
	 (vec_select:V4SF (match_operand:V4SF 2 "register_operand" "x")
			  (parallel [(const_int 2)
				     (const_int 3)
				     (const_int 0)
				     (const_int 1)]))
	 (const_int 12)))]
  "TARGET_SSE"
  "movlhps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_insn "sse_movhps"
  [(set (match_operand:V4SF 0 "nonimmediate_operand" "=x,m")
	(vec_merge:V4SF
	 (match_operand:V4SF 1 "nonimmediate_operand" "0,0")
	 (match_operand:V4SF 2 "nonimmediate_operand" "m,x")
	 (const_int 12)))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) == MEM || GET_CODE (operands[2]) == MEM)"
  "movhps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_insn "sse_movlps"
  [(set (match_operand:V4SF 0 "nonimmediate_operand" "=x,m")
	(vec_merge:V4SF
	 (match_operand:V4SF 1 "nonimmediate_operand" "0,0")
	 (match_operand:V4SF 2 "nonimmediate_operand" "m,x")
	 (const_int 3)))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) == MEM || GET_CODE (operands[2]) == MEM)"
  "movlps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_expand "sse_loadss"
  [(match_operand:V4SF 0 "register_operand" "")
   (match_operand:SF 1 "memory_operand" "")]
  "TARGET_SSE"
{
  emit_insn (gen_sse_loadss_1 (operands[0], operands[1],
			       CONST0_RTX (V4SFmode)));
  DONE;
})

(define_insn "sse_loadss_1"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (vec_duplicate:V4SF (match_operand:SF 1 "memory_operand" "m"))
	 (match_operand:V4SF 2 "const0_operand" "X")
	 (const_int 1)))]
  "TARGET_SSE"
  "movss\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "SF")])

(define_insn "sse_movss"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (match_operand:V4SF 1 "register_operand" "0")
	 (match_operand:V4SF 2 "register_operand" "x")
	 (const_int 1)))]
  "TARGET_SSE"
  "movss\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "SF")])

(define_insn "sse_storess"
  [(set (match_operand:SF 0 "memory_operand" "=m")
	(vec_select:SF
	 (match_operand:V4SF 1 "register_operand" "x")
	 (parallel [(const_int 0)])))]
  "TARGET_SSE"
  "movss\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "SF")])

(define_insn "sse_shufps"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (unspec:V4SF [(match_operand:V4SF 1 "register_operand" "0")
		      (match_operand:V4SF 2 "nonimmediate_operand" "xm")
		      (match_operand:SI 3 "immediate_operand" "i")]
		     UNSPEC_SHUFFLE))]
  "TARGET_SSE"
  ;; @@@ check operand order for intel/nonintel syntax
  "shufps\t{%3, %2, %0|%0, %2, %3}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])


;; SSE arithmetic

(define_insn "addv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (plus:V4SF (match_operand:V4SF 1 "register_operand" "0")
	           (match_operand:V4SF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "addps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V4SF")])

(define_insn "vmaddv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (plus:V4SF (match_operand:V4SF 1 "register_operand" "0")
		    (match_operand:V4SF 2 "nonimmediate_operand" "xm"))
	 (match_dup 1)
	 (const_int 1)))]
  "TARGET_SSE"
  "addss\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "SF")])

(define_insn "subv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (minus:V4SF (match_operand:V4SF 1 "register_operand" "0")
		    (match_operand:V4SF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "subps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V4SF")])

(define_insn "vmsubv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (minus:V4SF (match_operand:V4SF 1 "register_operand" "0")
		     (match_operand:V4SF 2 "nonimmediate_operand" "xm"))
	 (match_dup 1)
	 (const_int 1)))]
  "TARGET_SSE"
  "subss\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "SF")])

(define_insn "mulv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (mult:V4SF (match_operand:V4SF 1 "register_operand" "0")
	           (match_operand:V4SF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "mulps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssemul")
   (set_attr "mode" "V4SF")])

(define_insn "vmmulv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (mult:V4SF (match_operand:V4SF 1 "register_operand" "0")
		    (match_operand:V4SF 2 "nonimmediate_operand" "xm"))
	 (match_dup 1)
	 (const_int 1)))]
  "TARGET_SSE"
  "mulss\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssemul")
   (set_attr "mode" "SF")])

(define_insn "divv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (div:V4SF (match_operand:V4SF 1 "register_operand" "0")
	          (match_operand:V4SF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "divps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssediv")
   (set_attr "mode" "V4SF")])

(define_insn "vmdivv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (div:V4SF (match_operand:V4SF 1 "register_operand" "0")
		   (match_operand:V4SF 2 "nonimmediate_operand" "xm"))
	 (match_dup 1)
	 (const_int 1)))]
  "TARGET_SSE"
  "divss\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssediv")
   (set_attr "mode" "SF")])


;; SSE square root/reciprocal

(define_insn "rcpv4sf2"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (unspec:V4SF
	 [(match_operand:V4SF 1 "nonimmediate_operand" "xm")] UNSPEC_RCP))]
  "TARGET_SSE"
  "rcpps\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "V4SF")])

(define_insn "vmrcpv4sf2"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (unspec:V4SF [(match_operand:V4SF 1 "nonimmediate_operand" "xm")]
		      UNSPEC_RCP)
	 (match_operand:V4SF 2 "register_operand" "0")
	 (const_int 1)))]
  "TARGET_SSE"
  "rcpss\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")])

(define_insn "rsqrtv4sf2"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (unspec:V4SF
	 [(match_operand:V4SF 1 "nonimmediate_operand" "xm")] UNSPEC_RSQRT))]
  "TARGET_SSE"
  "rsqrtps\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "V4SF")])

(define_insn "vmrsqrtv4sf2"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (unspec:V4SF [(match_operand:V4SF 1 "nonimmediate_operand" "xm")]
		      UNSPEC_RSQRT)
	 (match_operand:V4SF 2 "register_operand" "0")
	 (const_int 1)))]
  "TARGET_SSE"
  "rsqrtss\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")])

(define_insn "sqrtv4sf2"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (sqrt:V4SF (match_operand:V4SF 1 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "sqrtps\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "V4SF")])

(define_insn "vmsqrtv4sf2"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (sqrt:V4SF (match_operand:V4SF 1 "nonimmediate_operand" "xm"))
	 (match_operand:V4SF 2 "register_operand" "0")
	 (const_int 1)))]
  "TARGET_SSE"
  "sqrtss\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")])

;; SSE logical operations.

;; SSE defines logical operations on floating point values.  This brings
;; interesting challenge to RTL representation where logicals are only valid
;; on integral types.  We deal with this by representing the floating point
;; logical as logical on arguments casted to TImode as this is what hardware
;; really does.  Unfortunately hardware requires the type information to be
;; present and thus we must avoid subregs from being simplified and eliminated
;; in later compilation phases.
;;
;; We have following variants from each instruction:
;; sse_andsf3 - the operation taking V4SF vector operands
;;              and doing TImode cast on them
;; *sse_andsf3_memory - the operation taking one memory operand casted to
;;                      TImode, since backend insist on eliminating casts
;;                      on memory operands
;; sse_andti3_sf_1 - the operation taking SF scalar operands.
;;                   We can not accept memory operand here as instruction reads
;;		     whole scalar.  This is generated only post reload by GCC
;;		     scalar float operations that expands to logicals (fabs)
;; sse_andti3_sf_2 - the operation taking SF scalar input and TImode
;;		     memory operand.  Eventually combine can be able
;;		     to synthesize these using splitter.
;; sse2_anddf3, *sse2_anddf3_memory
;;              
;; 
;; These are not called andti3 etc. because we really really don't want
;; the compiler to widen DImode ands to TImode ands and then try to move
;; into DImode subregs of SSE registers, and them together, and move out
;; of DImode subregs again!
;; SSE1 single precision floating point logical operation
(define_expand "sse_andv4sf3"
  [(set (subreg:TI (match_operand:V4SF 0 "register_operand" "") 0)
        (and:TI (subreg:TI (match_operand:V4SF 1 "register_operand" "") 0)
		(subreg:TI (match_operand:V4SF 2 "nonimmediate_operand" "") 0)))]
  "TARGET_SSE"
  "")

(define_insn "*sse_andv4sf3"
  [(set (subreg:TI (match_operand:V4SF 0 "register_operand" "=x") 0)
        (and:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "andps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V4SF")])

(define_insn "*sse_andsf3"
  [(set (subreg:TI (match_operand:SF 0 "register_operand" "=x") 0)
        (and:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "andps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V4SF")])

(define_expand "sse_nandv4sf3"
  [(set (subreg:TI (match_operand:V4SF 0 "register_operand" "") 0)
        (and:TI (not:TI (subreg:TI (match_operand:V4SF 1 "register_operand" "") 0))
	        (subreg:TI (match_operand:V4SF 2 "nonimmediate_operand" "") 0)))]
  "TARGET_SSE"
  "")

(define_insn "*sse_nandv4sf3"
  [(set (subreg:TI (match_operand:V4SF 0 "register_operand" "=x") 0)
        (and:TI (not:TI (match_operand:TI 1 "register_operand" "0"))
	        (match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "andnps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V4SF")])

(define_insn "*sse_nandsf3"
  [(set (subreg:TI (match_operand:SF 0 "register_operand" "=x") 0)
        (and:TI (not:TI (match_operand:TI 1 "register_operand" "0"))
	        (match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "andnps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V4SF")])

(define_expand "sse_iorv4sf3"
  [(set (subreg:TI (match_operand:V4SF 0 "register_operand" "") 0)
        (ior:TI (subreg:TI (match_operand:V4SF 1 "register_operand" "") 0)
		(subreg:TI (match_operand:V4SF 2 "nonimmediate_operand" "") 0)))]
  "TARGET_SSE"
  "")

(define_insn "*sse_iorv4sf3"
  [(set (subreg:TI (match_operand:V4SF 0 "register_operand" "=x") 0)
        (ior:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "orps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V4SF")])

(define_insn "*sse_iorsf3"
  [(set (subreg:TI (match_operand:SF 0 "register_operand" "=x") 0)
        (ior:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "orps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V4SF")])

(define_expand "sse_xorv4sf3"
  [(set (subreg:TI (match_operand:V4SF 0 "register_operand" "") 0)
        (xor:TI (subreg:TI (match_operand:V4SF 1 "register_operand" "") 0)
		(subreg:TI (match_operand:V4SF 2 "nonimmediate_operand" "") 0)))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "")

(define_insn "*sse_xorv4sf3"
  [(set (subreg:TI (match_operand:V4SF 0 "register_operand" "=x") 0)
        (xor:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "xorps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V4SF")])

(define_insn "*sse_xorsf3"
  [(set (subreg:TI (match_operand:SF 0 "register_operand" "=x") 0)
        (xor:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "xorps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V4SF")])

;; SSE2 double precision floating point logical operation

(define_expand "sse2_andv2df3"
  [(set (subreg:TI (match_operand:V2DF 0 "register_operand" "") 0)
        (and:TI (subreg:TI (match_operand:V2DF 1 "register_operand" "") 0)
	        (subreg:TI (match_operand:V2DF 2 "nonimmediate_operand" "") 0)))]
  "TARGET_SSE2"
  "")

(define_insn "*sse2_andv2df3"
  [(set (subreg:TI (match_operand:V2DF 0 "register_operand" "=x") 0)
        (and:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "andpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V2DF")])

(define_insn "*sse2_andv2df3"
  [(set (subreg:TI (match_operand:DF 0 "register_operand" "=x") 0)
        (and:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "andpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V2DF")])

(define_expand "sse2_nandv2df3"
  [(set (subreg:TI (match_operand:V2DF 0 "register_operand" "") 0)
        (and:TI (not:TI (subreg:TI (match_operand:V2DF 1 "register_operand" "") 0))
	        (subreg:TI (match_operand:V2DF 2 "nonimmediate_operand" "") 0)))]
  "TARGET_SSE2"
  "")

(define_insn "*sse2_nandv2df3"
  [(set (subreg:TI (match_operand:V2DF 0 "register_operand" "=x") 0)
        (and:TI (not:TI (match_operand:TI 1 "register_operand" "0"))
	        (match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "andnpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V2DF")])

(define_insn "*sse_nandti3_df"
  [(set (subreg:TI (match_operand:DF 0 "register_operand" "=Y") 0)
        (and:TI (not:TI (match_operand:TI 1 "register_operand" "0"))
		(match_operand:TI 2 "nonimmediate_operand" "Ym")))]
  "TARGET_SSE2"
  "andnpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V2DF")])

(define_expand "sse2_iorv2df3"
  [(set (subreg:TI (match_operand:V2DF 0 "register_operand" "") 0)
        (ior:TI (subreg:TI (match_operand:V2DF 1 "register_operand" "") 0)
		(subreg:TI (match_operand:V2DF 2 "nonimmediate_operand" "") 0)))]
  "TARGET_SSE2"
  "")

(define_insn "*sse2_iorv2df3"
  [(set (subreg:TI (match_operand:V2DF 0 "register_operand" "=x") 0)
        (ior:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "orpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V2DF")])

(define_insn "*sse2_iordf3"
  [(set (subreg:TI (match_operand:DF 0 "register_operand" "=x") 0)
        (ior:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "orpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V2DF")])

(define_expand "sse2_xorv2df3"
  [(set (subreg:TI (match_operand:V2DF 0 "register_operand" "") 0)
        (xor:TI (subreg:TI (match_operand:V2DF 1 "nonimmediate_operand" "") 0)
		(subreg:TI (match_operand:V2DF 2 "nonimmediate_operand" "") 0)))]
  "TARGET_SSE2"
  "")

(define_insn "*sse2_xorv2df3"
  [(set (subreg:TI (match_operand:V2DF 0 "register_operand" "=x") 0)
        (xor:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "xorpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V2DF")])

(define_insn "*sse2_xordf3"
  [(set (subreg:TI (match_operand:DF 0 "register_operand" "=x") 0)
        (xor:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "xorpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "V2DF")])

;; SSE2 integral logicals.  These patterns must always come after floating
;; point ones since we don't want compiler to use integer opcodes on floating
;; point SSE values to avoid matching of subregs in the match_operand.
(define_insn "*sse2_andti3"
  [(set (match_operand:TI 0 "register_operand" "=x")
        (and:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "pand\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "TI")])

(define_insn "sse2_andv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (and:V2DI (match_operand:V2DI 1 "nonimmediate_operand" "%0")
		  (match_operand:V2DI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "pand\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "TI")])

(define_insn "*sse2_nandti3"
  [(set (match_operand:TI 0 "register_operand" "=x")
        (and:TI (not:TI (match_operand:TI 1 "register_operand" "0"))
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pandn\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "TI")])

(define_insn "sse2_nandv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (and:V2DI (not:V2DI (match_operand:V2DI 1 "register_operand" "0"))
		  (match_operand:V2DI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "pandn\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "TI")])

(define_insn "*sse2_iorti3"
  [(set (match_operand:TI 0 "register_operand" "=x")
        (ior:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "por\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "TI")])

(define_insn "sse2_iorv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (ior:V2DI (match_operand:V2DI 1 "nonimmediate_operand" "%0")
		  (match_operand:V2DI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "por\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "TI")])

(define_insn "*sse2_xorti3"
  [(set (match_operand:TI 0 "register_operand" "=x")
        (xor:TI (match_operand:TI 1 "nonimmediate_operand" "%0")
		(match_operand:TI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "pxor\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "TI")])

(define_insn "sse2_xorv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (xor:V2DI (match_operand:V2DI 1 "nonimmediate_operand" "%0")
		  (match_operand:V2DI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2
   && (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != MEM)"
  "pxor\t{%2, %0|%0, %2}"
  [(set_attr "type" "sselog")
   (set_attr "mode" "TI")])

;; Use xor, but don't show input operands so they aren't live before
;; this insn.
(define_insn "sse_clrv4sf"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(match_operand:V4SF 1 "const0_operand" "X"))]
  "TARGET_SSE"
{
  if (get_attr_mode (insn) == MODE_TI)
    return "pxor\t{%0, %0|%0, %0}";
  else
    return "xorps\t{%0, %0|%0, %0}";
}
  [(set_attr "type" "sselog")
   (set_attr "memory" "none")
   (set (attr "mode")
	(if_then_else
	   (and (and (ne (symbol_ref "TARGET_SSE_LOAD0_BY_PXOR")
			 (const_int 0))
		     (ne (symbol_ref "TARGET_SSE2")
			 (const_int 0)))
		(eq (symbol_ref "optimize_size")
		    (const_int 0)))
	 (const_string "TI")
	 (const_string "V4SF")))])

;; Use xor, but don't show input operands so they aren't live before
;; this insn.
(define_insn "sse_clrv2df"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (unspec:V2DF [(const_int 0)] UNSPEC_NOP))]
  "TARGET_SSE2"
  "xorpd\t{%0, %0|%0, %0}"
  [(set_attr "type" "sselog")
   (set_attr "memory" "none")
   (set_attr "mode" "V4SF")])

;; SSE mask-generating compares

(define_insn "maskcmpv4sf3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (match_operator:V4SI 3 "sse_comparison_operator"
		[(match_operand:V4SF 1 "register_operand" "0")
		 (match_operand:V4SF 2 "register_operand" "x")]))]
  "TARGET_SSE"
  "cmp%D3ps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "V4SF")])

(define_insn "maskncmpv4sf3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (not:V4SI
	 (match_operator:V4SI 3 "sse_comparison_operator"
		[(match_operand:V4SF 1 "register_operand" "0")
		 (match_operand:V4SF 2 "register_operand" "x")])))]
  "TARGET_SSE"
{
  if (GET_CODE (operands[3]) == UNORDERED)
    return "cmpordps\t{%2, %0|%0, %2}";
  else
    return "cmpn%D3ps\t{%2, %0|%0, %2}";
}
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "V4SF")])

(define_insn "vmmaskcmpv4sf3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(vec_merge:V4SI
	 (match_operator:V4SI 3 "sse_comparison_operator"
		[(match_operand:V4SF 1 "register_operand" "0")
		 (match_operand:V4SF 2 "register_operand" "x")])
	 (subreg:V4SI (match_dup 1) 0)
	 (const_int 1)))]
  "TARGET_SSE"
  "cmp%D3ss\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "SF")])

(define_insn "vmmaskncmpv4sf3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(vec_merge:V4SI
	 (not:V4SI
	  (match_operator:V4SI 3 "sse_comparison_operator"
		[(match_operand:V4SF 1 "register_operand" "0")
		 (match_operand:V4SF 2 "register_operand" "x")]))
	 (subreg:V4SI (match_dup 1) 0)
	 (const_int 1)))]
  "TARGET_SSE"
{
  if (GET_CODE (operands[3]) == UNORDERED)
    return "cmpordss\t{%2, %0|%0, %2}";
  else
    return "cmpn%D3ss\t{%2, %0|%0, %2}";
}
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "SF")])

(define_insn "sse_comi"
  [(set (reg:CCFP 17)
        (compare:CCFP (vec_select:SF
		       (match_operand:V4SF 0 "register_operand" "x")
		       (parallel [(const_int 0)]))
		      (vec_select:SF
		       (match_operand:V4SF 1 "register_operand" "x")
		       (parallel [(const_int 0)]))))]
  "TARGET_SSE"
  "comiss\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecomi")
   (set_attr "mode" "SF")])

(define_insn "sse_ucomi"
  [(set (reg:CCFPU 17)
	(compare:CCFPU (vec_select:SF
			(match_operand:V4SF 0 "register_operand" "x")
			(parallel [(const_int 0)]))
		       (vec_select:SF
			(match_operand:V4SF 1 "register_operand" "x")
			(parallel [(const_int 0)]))))]
  "TARGET_SSE"
  "ucomiss\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecomi")
   (set_attr "mode" "SF")])


;; SSE unpack

(define_insn "sse_unpckhps"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (vec_select:V4SF (match_operand:V4SF 1 "register_operand" "0")
			  (parallel [(const_int 2)
				     (const_int 0)
				     (const_int 3)
				     (const_int 1)]))
	 (vec_select:V4SF (match_operand:V4SF 2 "register_operand" "x")
			  (parallel [(const_int 0)
				     (const_int 2)
				     (const_int 1)
				     (const_int 3)]))
	 (const_int 5)))]
  "TARGET_SSE"
  "unpckhps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_insn "sse_unpcklps"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (vec_select:V4SF (match_operand:V4SF 1 "register_operand" "0")
			  (parallel [(const_int 0)
				     (const_int 2)
				     (const_int 1)
				     (const_int 3)]))
	 (vec_select:V4SF (match_operand:V4SF 2 "register_operand" "x")
			  (parallel [(const_int 2)
				     (const_int 0)
				     (const_int 3)
				     (const_int 1)]))
	 (const_int 5)))]
  "TARGET_SSE"
  "unpcklps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])


;; SSE min/max

(define_insn "smaxv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (smax:V4SF (match_operand:V4SF 1 "register_operand" "0")
		   (match_operand:V4SF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "maxps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sse")
   (set_attr "mode" "V4SF")])

(define_insn "vmsmaxv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (smax:V4SF (match_operand:V4SF 1 "register_operand" "0")
		    (match_operand:V4SF 2 "nonimmediate_operand" "xm"))
	 (match_dup 1)
	 (const_int 1)))]
  "TARGET_SSE"
  "maxss\t{%2, %0|%0, %2}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")])

(define_insn "sminv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (smin:V4SF (match_operand:V4SF 1 "register_operand" "0")
		   (match_operand:V4SF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE"
  "minps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sse")
   (set_attr "mode" "V4SF")])

(define_insn "vmsminv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (smin:V4SF (match_operand:V4SF 1 "register_operand" "0")
		    (match_operand:V4SF 2 "nonimmediate_operand" "xm"))
	 (match_dup 1)
	 (const_int 1)))]
  "TARGET_SSE"
  "minss\t{%2, %0|%0, %2}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")])

;; SSE <-> integer/MMX conversions

(define_insn "cvtpi2ps"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(vec_merge:V4SF
	 (match_operand:V4SF 1 "register_operand" "0")
	 (vec_duplicate:V4SF
	  (float:V2SF (match_operand:V2SI 2 "nonimmediate_operand" "ym")))
	 (const_int 12)))]
  "TARGET_SSE"
  "cvtpi2ps\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_insn "cvtps2pi"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(vec_select:V2SI
	 (fix:V4SI (match_operand:V4SF 1 "nonimmediate_operand" "xm"))
	 (parallel [(const_int 0) (const_int 1)])))]
  "TARGET_SSE"
  "cvtps2pi\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_insn "cvttps2pi"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(vec_select:V2SI
	 (unspec:V4SI [(match_operand:V4SF 1 "nonimmediate_operand" "xm")]
		      UNSPEC_FIX)
	 (parallel [(const_int 0) (const_int 1)])))]
  "TARGET_SSE"
  "cvttps2pi\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "SF")])

(define_insn "cvtsi2ss"
  [(set (match_operand:V4SF 0 "register_operand" "=x,x")
	(vec_merge:V4SF
	 (match_operand:V4SF 1 "register_operand" "0,0")
	 (vec_duplicate:V4SF
	  (float:SF (match_operand:SI 2 "nonimmediate_operand" "r,rm")))
	 (const_int 14)))]
  "TARGET_SSE"
  "cvtsi2ss\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseicvt")
   (set_attr "athlon_decode" "vector,double")
   (set_attr "mode" "SF")])

(define_insn "cvtsi2ssq"
  [(set (match_operand:V4SF 0 "register_operand" "=x,x")
	(vec_merge:V4SF
	 (match_operand:V4SF 1 "register_operand" "0,0")
	 (vec_duplicate:V4SF
	  (float:SF (match_operand:DI 2 "nonimmediate_operand" "r,rm")))
	 (const_int 14)))]
  "TARGET_SSE && TARGET_64BIT"
  "cvtsi2ssq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseicvt")
   (set_attr "athlon_decode" "vector,double")
   (set_attr "mode" "SF")])

(define_insn "cvtss2si"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(vec_select:SI
	 (fix:V4SI (match_operand:V4SF 1 "nonimmediate_operand" "x,m"))
	 (parallel [(const_int 0)])))]
  "TARGET_SSE"
  "cvtss2si\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "athlon_decode" "double,vector")
   (set_attr "mode" "SI")])

(define_insn "cvtss2siq"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(vec_select:DI
	 (fix:V4DI (match_operand:V4SF 1 "nonimmediate_operand" "x,m"))
	 (parallel [(const_int 0)])))]
  "TARGET_SSE"
  "cvtss2siq\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "athlon_decode" "double,vector")
   (set_attr "mode" "DI")])

(define_insn "cvttss2si"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(vec_select:SI
	 (unspec:V4SI [(match_operand:V4SF 1 "nonimmediate_operand" "x,xm")]
		      UNSPEC_FIX)
	 (parallel [(const_int 0)])))]
  "TARGET_SSE"
  "cvttss2si\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "double,vector")])

(define_insn "cvttss2siq"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(vec_select:DI
	 (unspec:V4DI [(match_operand:V4SF 1 "nonimmediate_operand" "x,xm")]
		      UNSPEC_FIX)
	 (parallel [(const_int 0)])))]
  "TARGET_SSE && TARGET_64BIT"
  "cvttss2siq\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "SF")
   (set_attr "athlon_decode" "double,vector")])


;; MMX insns

;; MMX arithmetic

(define_insn "addv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (plus:V8QI (match_operand:V8QI 1 "register_operand" "%0")
	           (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "paddb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "addv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (plus:V4HI (match_operand:V4HI 1 "register_operand" "%0")
	           (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "paddw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "addv2si3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
        (plus:V2SI (match_operand:V2SI 1 "register_operand" "%0")
	           (match_operand:V2SI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "paddd\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "mmx_adddi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI
	 [(plus:DI (match_operand:DI 1 "register_operand" "%0")
		   (match_operand:DI 2 "nonimmediate_operand" "ym"))]
	 UNSPEC_NOP))]
  "TARGET_MMX"
  "paddq\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "ssaddv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (ss_plus:V8QI (match_operand:V8QI 1 "register_operand" "%0")
		      (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "paddsb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "ssaddv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (ss_plus:V4HI (match_operand:V4HI 1 "register_operand" "%0")
		      (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "paddsw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "usaddv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (us_plus:V8QI (match_operand:V8QI 1 "register_operand" "%0")
		      (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "paddusb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "usaddv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (us_plus:V4HI (match_operand:V4HI 1 "register_operand" "%0")
		      (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "paddusw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "subv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (minus:V8QI (match_operand:V8QI 1 "register_operand" "0")
		    (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "psubb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "subv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (minus:V4HI (match_operand:V4HI 1 "register_operand" "0")
		    (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "psubw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "subv2si3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
        (minus:V2SI (match_operand:V2SI 1 "register_operand" "0")
		    (match_operand:V2SI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "psubd\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "mmx_subdi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI
	 [(minus:DI (match_operand:DI 1 "register_operand" "0")
		    (match_operand:DI 2 "nonimmediate_operand" "ym"))]
	 UNSPEC_NOP))]
  "TARGET_MMX"
  "psubq\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "sssubv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (ss_minus:V8QI (match_operand:V8QI 1 "register_operand" "0")
		       (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "psubsb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "sssubv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (ss_minus:V4HI (match_operand:V4HI 1 "register_operand" "0")
		       (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "psubsw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "ussubv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (us_minus:V8QI (match_operand:V8QI 1 "register_operand" "0")
		       (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "psubusb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "ussubv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (us_minus:V4HI (match_operand:V4HI 1 "register_operand" "0")
		       (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "psubusw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "mulv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (mult:V4HI (match_operand:V4HI 1 "register_operand" "0")
		   (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "pmullw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxmul")
   (set_attr "mode" "DI")])

(define_insn "smulv4hi3_highpart"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
	(truncate:V4HI
	 (lshiftrt:V4SI
	  (mult:V4SI (sign_extend:V4SI
		      (match_operand:V4HI 1 "register_operand" "0"))
		     (sign_extend:V4SI
		      (match_operand:V4HI 2 "nonimmediate_operand" "ym")))
	  (const_int 16))))]
  "TARGET_MMX"
  "pmulhw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxmul")
   (set_attr "mode" "DI")])

(define_insn "umulv4hi3_highpart"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
	(truncate:V4HI
	 (lshiftrt:V4SI
	  (mult:V4SI (zero_extend:V4SI
		      (match_operand:V4HI 1 "register_operand" "0"))
		     (zero_extend:V4SI
		      (match_operand:V4HI 2 "nonimmediate_operand" "ym")))
	  (const_int 16))))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pmulhuw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxmul")
   (set_attr "mode" "DI")])

(define_insn "mmx_pmaddwd"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
        (plus:V2SI
	 (mult:V2SI
	  (sign_extend:V2SI
	   (vec_select:V2HI (match_operand:V4HI 1 "register_operand" "0")
			    (parallel [(const_int 0) (const_int 2)])))
	  (sign_extend:V2SI
	   (vec_select:V2HI (match_operand:V4HI 2 "nonimmediate_operand" "ym")
			    (parallel [(const_int 0) (const_int 2)]))))
	 (mult:V2SI
	  (sign_extend:V2SI (vec_select:V2HI (match_dup 1)
					     (parallel [(const_int 1)
							(const_int 3)])))
	  (sign_extend:V2SI (vec_select:V2HI (match_dup 2)
					     (parallel [(const_int 1)
							(const_int 3)]))))))]
  "TARGET_MMX"
  "pmaddwd\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxmul")
   (set_attr "mode" "DI")])


;; MMX logical operations
;; Note we don't want to declare these as regular iordi3 insns to prevent
;; normal code that also wants to use the FPU from getting broken.
;; The UNSPECs are there to prevent the combiner from getting overly clever.
(define_insn "mmx_iordi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI
	 [(ior:DI (match_operand:DI 1 "register_operand" "%0")
		  (match_operand:DI 2 "nonimmediate_operand" "ym"))]
	 UNSPEC_NOP))]
  "TARGET_MMX"
  "por\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "mmx_xordi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI
	 [(xor:DI (match_operand:DI 1 "register_operand" "%0")
		  (match_operand:DI 2 "nonimmediate_operand" "ym"))]
	 UNSPEC_NOP))]
  "TARGET_MMX"
  "pxor\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")
   (set_attr "memory" "none")])

;; Same as pxor, but don't show input operands so that we don't think
;; they are live.
(define_insn "mmx_clrdi"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI [(const_int 0)] UNSPEC_NOP))]
  "TARGET_MMX"
  "pxor\t{%0, %0|%0, %0}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")
   (set_attr "memory" "none")])

(define_insn "mmx_anddi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI
	 [(and:DI (match_operand:DI 1 "register_operand" "%0")
		  (match_operand:DI 2 "nonimmediate_operand" "ym"))]
	 UNSPEC_NOP))]
  "TARGET_MMX"
  "pand\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "mmx_nanddi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI
	 [(and:DI (not:DI (match_operand:DI 1 "register_operand" "0"))
			  (match_operand:DI 2 "nonimmediate_operand" "ym"))]
	 UNSPEC_NOP))]
  "TARGET_MMX"
  "pandn\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])


;; MMX unsigned averages/sum of absolute differences

(define_insn "mmx_uavgv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (ashiftrt:V8QI
	 (plus:V8QI (plus:V8QI
		     (match_operand:V8QI 1 "register_operand" "0")
		     (match_operand:V8QI 2 "nonimmediate_operand" "ym"))
		    (const_vector:V8QI [(const_int 1)
					(const_int 1)
					(const_int 1)
					(const_int 1)
					(const_int 1)
					(const_int 1)
					(const_int 1)
					(const_int 1)]))
	 (const_int 1)))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pavgb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "mmx_uavgv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (ashiftrt:V4HI
	 (plus:V4HI (plus:V4HI
		     (match_operand:V4HI 1 "register_operand" "0")
		     (match_operand:V4HI 2 "nonimmediate_operand" "ym"))
		    (const_vector:V4HI [(const_int 1)
					(const_int 1)
					(const_int 1)
					(const_int 1)]))
	 (const_int 1)))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pavgw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "mmx_psadbw"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI [(match_operand:V8QI 1 "register_operand" "0")
		    (match_operand:V8QI 2 "nonimmediate_operand" "ym")]
		   UNSPEC_PSADBW))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "psadbw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])


;; MMX insert/extract/shuffle

(define_insn "mmx_pinsrw"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (vec_merge:V4HI (match_operand:V4HI 1 "register_operand" "0")
			(vec_duplicate:V4HI
			 (truncate:HI (match_operand:SI 2 "nonimmediate_operand" "rm")))
			(match_operand:SI 3 "const_0_to_15_operand" "N")))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pinsrw\t{%3, %2, %0|%0, %2, %3}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "mmx_pextrw"
  [(set (match_operand:SI 0 "register_operand" "=r")
        (zero_extend:SI (vec_select:HI (match_operand:V4HI 1 "register_operand" "y")
				       (parallel
					[(match_operand:SI 2 "const_0_to_3_operand" "N")]))))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pextrw\t{%2, %1, %0|%0, %1, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "mmx_pshufw"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (unspec:V4HI [(match_operand:V4HI 1 "register_operand" "0")
		      (match_operand:SI 2 "immediate_operand" "i")]
		     UNSPEC_SHUFFLE))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pshufw\t{%2, %1, %0|%0, %1, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])


;; MMX mask-generating comparisons

(define_insn "eqv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (eq:V8QI (match_operand:V8QI 1 "register_operand" "0")
		 (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "pcmpeqb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "DI")])

(define_insn "eqv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (eq:V4HI (match_operand:V4HI 1 "register_operand" "0")
		 (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "pcmpeqw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "DI")])

(define_insn "eqv2si3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
        (eq:V2SI (match_operand:V2SI 1 "register_operand" "0")
		 (match_operand:V2SI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "pcmpeqd\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "DI")])

(define_insn "gtv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (gt:V8QI (match_operand:V8QI 1 "register_operand" "0")
		 (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "pcmpgtb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "DI")])

(define_insn "gtv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (gt:V4HI (match_operand:V4HI 1 "register_operand" "0")
		 (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "pcmpgtw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "DI")])

(define_insn "gtv2si3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
        (gt:V2SI (match_operand:V2SI 1 "register_operand" "0")
		 (match_operand:V2SI 2 "nonimmediate_operand" "ym")))]
  "TARGET_MMX"
  "pcmpgtd\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "DI")])


;; MMX max/min insns

(define_insn "umaxv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (umax:V8QI (match_operand:V8QI 1 "register_operand" "0")
		   (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pmaxub\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "smaxv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (smax:V4HI (match_operand:V4HI 1 "register_operand" "0")
		   (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pmaxsw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "uminv8qi3"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
        (umin:V8QI (match_operand:V8QI 1 "register_operand" "0")
		   (match_operand:V8QI 2 "nonimmediate_operand" "ym")))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pminub\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])

(define_insn "sminv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (smin:V4HI (match_operand:V4HI 1 "register_operand" "0")
		   (match_operand:V4HI 2 "nonimmediate_operand" "ym")))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "pminsw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "DI")])


;; MMX shifts

(define_insn "ashrv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (ashiftrt:V4HI (match_operand:V4HI 1 "register_operand" "0")
		       (match_operand:DI 2 "nonmemory_operand" "yi")))]
  "TARGET_MMX"
  "psraw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "ashrv2si3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
        (ashiftrt:V2SI (match_operand:V2SI 1 "register_operand" "0")
		       (match_operand:DI 2 "nonmemory_operand" "yi")))]
  "TARGET_MMX"
  "psrad\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "lshrv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (lshiftrt:V4HI (match_operand:V4HI 1 "register_operand" "0")
		       (match_operand:DI 2 "nonmemory_operand" "yi")))]
  "TARGET_MMX"
  "psrlw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "lshrv2si3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
        (lshiftrt:V2SI (match_operand:V2SI 1 "register_operand" "0")
		       (match_operand:DI 2 "nonmemory_operand" "yi")))]
  "TARGET_MMX"
  "psrld\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

;; See logical MMX insns.
(define_insn "mmx_lshrdi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI
	  [(lshiftrt:DI (match_operand:DI 1 "register_operand" "0")
		       (match_operand:DI 2 "nonmemory_operand" "yi"))]
	  UNSPEC_NOP))]
  "TARGET_MMX"
  "psrlq\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "ashlv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
        (ashift:V4HI (match_operand:V4HI 1 "register_operand" "0")
		       (match_operand:DI 2 "nonmemory_operand" "yi")))]
  "TARGET_MMX"
  "psllw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "ashlv2si3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
        (ashift:V2SI (match_operand:V2SI 1 "register_operand" "0")
		       (match_operand:DI 2 "nonmemory_operand" "yi")))]
  "TARGET_MMX"
  "pslld\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

;; See logical MMX insns.
(define_insn "mmx_ashldi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (unspec:DI
	 [(ashift:DI (match_operand:DI 1 "register_operand" "0")
		     (match_operand:DI 2 "nonmemory_operand" "yi"))]
	 UNSPEC_NOP))]
  "TARGET_MMX"
  "psllq\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])


;; MMX pack/unpack insns.

(define_insn "mmx_packsswb"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
	(vec_concat:V8QI
	 (ss_truncate:V4QI (match_operand:V4HI 1 "register_operand" "0"))
	 (ss_truncate:V4QI (match_operand:V4HI 2 "register_operand" "y"))))]
  "TARGET_MMX"
  "packsswb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "mmx_packssdw"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
	(vec_concat:V4HI
	 (ss_truncate:V2HI (match_operand:V2SI 1 "register_operand" "0"))
	 (ss_truncate:V2HI (match_operand:V2SI 2 "register_operand" "y"))))]
  "TARGET_MMX"
  "packssdw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "mmx_packuswb"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
	(vec_concat:V8QI
	 (us_truncate:V4QI (match_operand:V4HI 1 "register_operand" "0"))
	 (us_truncate:V4QI (match_operand:V4HI 2 "register_operand" "y"))))]
  "TARGET_MMX"
  "packuswb\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "DI")])

(define_insn "mmx_punpckhbw"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
	(vec_merge:V8QI
	 (vec_select:V8QI (match_operand:V8QI 1 "register_operand" "0")
			  (parallel [(const_int 4)
				     (const_int 0)
				     (const_int 5)
				     (const_int 1)
				     (const_int 6)
				     (const_int 2)
				     (const_int 7)
				     (const_int 3)]))
	 (vec_select:V8QI (match_operand:V8QI 2 "register_operand" "y")
			  (parallel [(const_int 0)
				     (const_int 4)
				     (const_int 1)
				     (const_int 5)
				     (const_int 2)
				     (const_int 6)
				     (const_int 3)
				     (const_int 7)]))
	 (const_int 85)))]
  "TARGET_MMX"
  "punpckhbw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "mmx_punpckhwd"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
	(vec_merge:V4HI
	 (vec_select:V4HI (match_operand:V4HI 1 "register_operand" "0")
			  (parallel [(const_int 0)
				     (const_int 2)
				     (const_int 1)
				     (const_int 3)]))
	 (vec_select:V4HI (match_operand:V4HI 2 "register_operand" "y")
			  (parallel [(const_int 2)
				     (const_int 0)
				     (const_int 3)
				     (const_int 1)]))
	 (const_int 5)))]
  "TARGET_MMX"
  "punpckhwd\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "mmx_punpckhdq"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(vec_merge:V2SI
	 (match_operand:V2SI 1 "register_operand" "0")
	 (vec_select:V2SI (match_operand:V2SI 2 "register_operand" "y")
			  (parallel [(const_int 1)
				     (const_int 0)]))
	 (const_int 1)))]
  "TARGET_MMX"
  "punpckhdq\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "mmx_punpcklbw"
  [(set (match_operand:V8QI 0 "register_operand" "=y")
	(vec_merge:V8QI
	 (vec_select:V8QI (match_operand:V8QI 1 "register_operand" "0")
			  (parallel [(const_int 0)
				     (const_int 4)
				     (const_int 1)
				     (const_int 5)
				     (const_int 2)
				     (const_int 6)
				     (const_int 3)
				     (const_int 7)]))
	 (vec_select:V8QI (match_operand:V8QI 2 "register_operand" "y")
			  (parallel [(const_int 4)
				     (const_int 0)
				     (const_int 5)
				     (const_int 1)
				     (const_int 6)
				     (const_int 2)
				     (const_int 7)
				     (const_int 3)]))
	 (const_int 85)))]
  "TARGET_MMX"
  "punpcklbw\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "mmx_punpcklwd"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
	(vec_merge:V4HI
	 (vec_select:V4HI (match_operand:V4HI 1 "register_operand" "0")
			  (parallel [(const_int 2)
				     (const_int 0)
				     (const_int 3)
				     (const_int 1)]))
	 (vec_select:V4HI (match_operand:V4HI 2 "register_operand" "y")
			  (parallel [(const_int 0)
				     (const_int 2)
				     (const_int 1)
				     (const_int 3)]))
	 (const_int 5)))]
  "TARGET_MMX"
  "punpcklwd\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])

(define_insn "mmx_punpckldq"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(vec_merge:V2SI
	 (vec_select:V2SI (match_operand:V2SI 1 "register_operand" "0")
			   (parallel [(const_int 1)
				      (const_int 0)]))
	 (match_operand:V2SI 2 "register_operand" "y")
	 (const_int 1)))]
  "TARGET_MMX"
  "punpckldq\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "DI")])


;; Miscellaneous stuff

(define_insn "emms"
  [(unspec_volatile [(const_int 0)] UNSPECV_EMMS)
   (clobber (reg:XF 8))
   (clobber (reg:XF 9))
   (clobber (reg:XF 10))
   (clobber (reg:XF 11))
   (clobber (reg:XF 12))
   (clobber (reg:XF 13))
   (clobber (reg:XF 14))
   (clobber (reg:XF 15))
   (clobber (reg:DI 29))
   (clobber (reg:DI 30))
   (clobber (reg:DI 31))
   (clobber (reg:DI 32))
   (clobber (reg:DI 33))
   (clobber (reg:DI 34))
   (clobber (reg:DI 35))
   (clobber (reg:DI 36))]
  "TARGET_MMX"
  "emms"
  [(set_attr "type" "mmx")
   (set_attr "memory" "unknown")])

(define_insn "ldmxcsr"
  [(unspec_volatile [(match_operand:SI 0 "memory_operand" "m")]
		    UNSPECV_LDMXCSR)]
  "TARGET_SSE"
  "ldmxcsr\t%0"
  [(set_attr "type" "sse")
   (set_attr "memory" "load")])

(define_insn "stmxcsr"
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(unspec_volatile:SI [(const_int 0)] UNSPECV_STMXCSR))]
  "TARGET_SSE"
  "stmxcsr\t%0"
  [(set_attr "type" "sse")
   (set_attr "memory" "store")])

(define_expand "sfence"
  [(set (match_dup 0)
	(unspec:BLK [(match_dup 0)] UNSPEC_SFENCE))]
  "TARGET_SSE || TARGET_3DNOW_A"
{
  operands[0] = gen_rtx_MEM (BLKmode, gen_rtx_SCRATCH (Pmode));
  MEM_VOLATILE_P (operands[0]) = 1;
})

(define_insn "*sfence_insn"
  [(set (match_operand:BLK 0 "" "")
	(unspec:BLK [(match_dup 0)] UNSPEC_SFENCE))]
  "TARGET_SSE || TARGET_3DNOW_A"
  "sfence"
  [(set_attr "type" "sse")
   (set_attr "memory" "unknown")])

(define_expand "sse_prologue_save"
  [(parallel [(set (match_operand:BLK 0 "" "")
		   (unspec:BLK [(reg:DI 21)
				(reg:DI 22)
				(reg:DI 23)
				(reg:DI 24)
				(reg:DI 25)
				(reg:DI 26)
				(reg:DI 27)
				(reg:DI 28)] UNSPEC_SSE_PROLOGUE_SAVE))
	      (use (match_operand:DI 1 "register_operand" ""))
	      (use (match_operand:DI 2 "immediate_operand" ""))
	      (use (label_ref:DI (match_operand 3 "" "")))])]
  "TARGET_64BIT"
  "")

(define_insn "*sse_prologue_save_insn"
  [(set (mem:BLK (plus:DI (match_operand:DI 0 "register_operand" "R")
			  (match_operand:DI 4 "const_int_operand" "n")))
	(unspec:BLK [(reg:DI 21)
		     (reg:DI 22)
		     (reg:DI 23)
		     (reg:DI 24)
		     (reg:DI 25)
		     (reg:DI 26)
		     (reg:DI 27)
		     (reg:DI 28)] UNSPEC_SSE_PROLOGUE_SAVE))
   (use (match_operand:DI 1 "register_operand" "r"))
   (use (match_operand:DI 2 "const_int_operand" "i"))
   (use (label_ref:DI (match_operand 3 "" "X")))]
  "TARGET_64BIT
   && INTVAL (operands[4]) + SSE_REGPARM_MAX * 16 - 16 < 128
   && INTVAL (operands[4]) + INTVAL (operands[2]) * 16 >= -128"
  "*
{
  int i;
  operands[0] = gen_rtx_MEM (Pmode,
			     gen_rtx_PLUS (Pmode, operands[0], operands[4]));
  output_asm_insn (\"jmp\\t%A1\", operands);
  for (i = SSE_REGPARM_MAX - 1; i >= INTVAL (operands[2]); i--)
    {
      operands[4] = adjust_address (operands[0], DImode, i*16);
      operands[5] = gen_rtx_REG (TImode, SSE_REGNO (i));
      PUT_MODE (operands[4], TImode);
      if (GET_CODE (XEXP (operands[0], 0)) != PLUS)
        output_asm_insn (\"rex\", operands);
      output_asm_insn (\"movaps\\t{%5, %4|%4, %5}\", operands);
    }
  (*targetm.asm_out.internal_label) (asm_out_file, \"L\",
			     CODE_LABEL_NUMBER (operands[3]));
  RET;
}
  "
  [(set_attr "type" "other")
   (set_attr "length_immediate" "0")
   (set_attr "length_address" "0")
   (set_attr "length" "135")
   (set_attr "memory" "store")
   (set_attr "modrm" "0")
   (set_attr "mode" "DI")])

;; 3Dnow! instructions

(define_insn "addv2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(plus:V2SF (match_operand:V2SF 1 "register_operand" "0")
		   (match_operand:V2SF 2 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pfadd\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "V2SF")])

(define_insn "subv2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
        (minus:V2SF (match_operand:V2SF 1 "register_operand" "0")
		    (match_operand:V2SF 2 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pfsub\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "V2SF")])

(define_insn "subrv2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
        (minus:V2SF (match_operand:V2SF 2 "nonimmediate_operand" "ym")
                    (match_operand:V2SF 1 "register_operand" "0")))]
  "TARGET_3DNOW"
  "pfsubr\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "V2SF")])

(define_insn "gtv2sf3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(gt:V2SI (match_operand:V2SF 1 "register_operand" "0")
		 (match_operand:V2SF 2 "nonimmediate_operand" "ym")))]
 "TARGET_3DNOW"
  "pfcmpgt\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "V2SF")])

(define_insn "gev2sf3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(ge:V2SI (match_operand:V2SF 1 "register_operand" "0")
		 (match_operand:V2SF 2 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pfcmpge\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "V2SF")])

(define_insn "eqv2sf3"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(eq:V2SI (match_operand:V2SF 1 "register_operand" "0")
		 (match_operand:V2SF 2 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pfcmpeq\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxcmp")
   (set_attr "mode" "V2SF")])

(define_insn "pfmaxv2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
        (smax:V2SF (match_operand:V2SF 1 "register_operand" "0")
                   (match_operand:V2SF 2 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pfmax\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "V2SF")])

(define_insn "pfminv2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
        (smin:V2SF (match_operand:V2SF 1 "register_operand" "0")
                   (match_operand:V2SF 2 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pfmin\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "V2SF")])

(define_insn "mulv2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(mult:V2SF (match_operand:V2SF 1 "register_operand" "0")
		   (match_operand:V2SF 2 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pfmul\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxmul")
   (set_attr "mode" "V2SF")])

(define_insn "femms"
  [(unspec_volatile [(const_int 0)] UNSPECV_FEMMS)
   (clobber (reg:XF 8))
   (clobber (reg:XF 9))
   (clobber (reg:XF 10))
   (clobber (reg:XF 11))
   (clobber (reg:XF 12))
   (clobber (reg:XF 13))
   (clobber (reg:XF 14))
   (clobber (reg:XF 15))
   (clobber (reg:DI 29))
   (clobber (reg:DI 30))
   (clobber (reg:DI 31))
   (clobber (reg:DI 32))
   (clobber (reg:DI 33))
   (clobber (reg:DI 34))
   (clobber (reg:DI 35))
   (clobber (reg:DI 36))]
  "TARGET_3DNOW"
  "femms"
  [(set_attr "type" "mmx")
   (set_attr "memory" "none")]) 

(define_insn "pf2id"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(fix:V2SI (match_operand:V2SF 1 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pf2id\\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "V2SF")])

(define_insn "pf2iw"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(sign_extend:V2SI
	   (ss_truncate:V2HI
	      (fix:V2SI (match_operand:V2SF 1 "nonimmediate_operand" "ym")))))]
  "TARGET_3DNOW_A"
  "pf2iw\\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "V2SF")])

(define_insn "pfacc"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(vec_concat:V2SF
	   (plus:SF
	      (vec_select:SF (match_operand:V2SF 1 "register_operand" "0")
			     (parallel [(const_int  0)]))
	      (vec_select:SF (match_dup 1)
			     (parallel [(const_int 1)])))
           (plus:SF
              (vec_select:SF (match_operand:V2SF 2 "nonimmediate_operand" "y")
			     (parallel [(const_int  0)]))
              (vec_select:SF (match_dup 2)
			     (parallel [(const_int 1)])))))]
  "TARGET_3DNOW"
  "pfacc\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "V2SF")])

(define_insn "pfnacc"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
  	(vec_concat:V2SF
           (minus:SF
              (vec_select:SF (match_operand:V2SF 1 "register_operand" "0")
			     (parallel [(const_int 0)]))
              (vec_select:SF (match_dup 1)
			     (parallel [(const_int 1)])))
           (minus:SF
              (vec_select:SF (match_operand:V2SF 2 "nonimmediate_operand" "y")
			     (parallel [(const_int  0)]))
              (vec_select:SF (match_dup 2)
			     (parallel [(const_int 1)])))))]
  "TARGET_3DNOW_A"
  "pfnacc\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "V2SF")])

(define_insn "pfpnacc"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
        (vec_concat:V2SF
           (minus:SF
              (vec_select:SF (match_operand:V2SF 1 "register_operand" "0")
			     (parallel [(const_int 0)]))
              (vec_select:SF (match_dup 1)
			     (parallel [(const_int 1)])))
           (plus:SF
              (vec_select:SF (match_operand:V2SF 2 "nonimmediate_operand" "y")
			     (parallel [(const_int 0)]))
              (vec_select:SF (match_dup 2)
			     (parallel [(const_int 1)])))))]
  "TARGET_3DNOW_A"
  "pfpnacc\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxadd")
   (set_attr "mode" "V2SF")])

(define_insn "pi2fw"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(float:V2SF
	   (vec_concat:V2SI
	      (sign_extend:SI
		 (truncate:HI
		    (vec_select:SI (match_operand:V2SI 1 "nonimmediate_operand" "ym")
				   (parallel [(const_int 0)]))))
              (sign_extend:SI
		 (truncate:HI
                    (vec_select:SI (match_dup 1)
				   (parallel [(const_int  1)])))))))]
  "TARGET_3DNOW_A"
  "pi2fw\\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "V2SF")])

(define_insn "floatv2si2"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(float:V2SF (match_operand:V2SI 1 "nonimmediate_operand" "ym")))]
  "TARGET_3DNOW"
  "pi2fd\\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "V2SF")])

;; This insn is identical to pavgb in operation, but the opcode is
;; different.  To avoid accidentally matching pavgb, use an unspec.

(define_insn "pavgusb"
 [(set (match_operand:V8QI 0 "register_operand" "=y")
       (unspec:V8QI
          [(match_operand:V8QI 1 "register_operand" "0")
           (match_operand:V8QI 2 "nonimmediate_operand" "ym")]
	  UNSPEC_PAVGUSB))]
  "TARGET_3DNOW"
  "pavgusb\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxshft")
   (set_attr "mode" "TI")])

;; 3DNow reciprocal and sqrt
 
(define_insn "pfrcpv2sf2"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
        (unspec:V2SF [(match_operand:V2SF 1 "nonimmediate_operand" "ym")]
	UNSPEC_PFRCP))]
  "TARGET_3DNOW"
  "pfrcp\\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmx")
   (set_attr "mode" "TI")])

(define_insn "pfrcpit1v2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(unspec:V2SF [(match_operand:V2SF 1 "register_operand" "0")
		      (match_operand:V2SF 2 "nonimmediate_operand" "ym")]
		     UNSPEC_PFRCPIT1))]
  "TARGET_3DNOW"
  "pfrcpit1\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmx")
   (set_attr "mode" "TI")])

(define_insn "pfrcpit2v2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(unspec:V2SF [(match_operand:V2SF 1 "register_operand" "0")
		      (match_operand:V2SF 2 "nonimmediate_operand" "ym")]
		     UNSPEC_PFRCPIT2))]
  "TARGET_3DNOW"
  "pfrcpit2\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmx")
   (set_attr "mode" "TI")])

(define_insn "pfrsqrtv2sf2"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(unspec:V2SF [(match_operand:V2SF 1 "nonimmediate_operand" "ym")]
		     UNSPEC_PFRSQRT))]
  "TARGET_3DNOW"
  "pfrsqrt\\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmx")
   (set_attr "mode" "TI")])
		
(define_insn "pfrsqit1v2sf3"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(unspec:V2SF [(match_operand:V2SF 1 "register_operand" "0")
		      (match_operand:V2SF 2 "nonimmediate_operand" "ym")]
		     UNSPEC_PFRSQIT1))]
  "TARGET_3DNOW"
  "pfrsqit1\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmx")
   (set_attr "mode" "TI")])

(define_insn "pmulhrwv4hi3"
  [(set (match_operand:V4HI 0 "register_operand" "=y")
	(truncate:V4HI
	   (lshiftrt:V4SI
	      (plus:V4SI
	         (mult:V4SI
	            (sign_extend:V4SI
		       (match_operand:V4HI 1 "register_operand" "0"))
	            (sign_extend:V4SI
		       (match_operand:V4HI 2 "nonimmediate_operand" "ym")))
		 (const_vector:V4SI [(const_int 32768)
				     (const_int 32768)
				     (const_int 32768)
				     (const_int 32768)]))
	      (const_int 16))))]
  "TARGET_3DNOW"
  "pmulhrw\\t{%2, %0|%0, %2}"
  [(set_attr "type" "mmxmul")
   (set_attr "mode" "TI")])

(define_insn "pswapdv2si2"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(vec_select:V2SI (match_operand:V2SI 1 "nonimmediate_operand" "ym")
			 (parallel [(const_int 1) (const_int 0)])))]
  "TARGET_3DNOW_A"
  "pswapd\\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "TI")])

(define_insn "pswapdv2sf2"
  [(set (match_operand:V2SF 0 "register_operand" "=y")
	(vec_select:V2SF (match_operand:V2SF 1 "nonimmediate_operand" "ym")
			 (parallel [(const_int 1) (const_int 0)])))]
  "TARGET_3DNOW_A"
  "pswapd\\t{%1, %0|%0, %1}"
  [(set_attr "type" "mmxcvt")
   (set_attr "mode" "TI")])

(define_expand "prefetch"
  [(prefetch (match_operand 0 "address_operand" "")
	     (match_operand:SI 1 "const_int_operand" "")
	     (match_operand:SI 2 "const_int_operand" ""))]
  "TARGET_PREFETCH_SSE || TARGET_3DNOW"
{
  int rw = INTVAL (operands[1]);
  int locality = INTVAL (operands[2]);

  if (rw != 0 && rw != 1)
    abort ();
  if (locality < 0 || locality > 3)
    abort ();
  if (GET_MODE (operands[0]) != Pmode && GET_MODE (operands[0]) != VOIDmode)
    abort ();

  /* Use 3dNOW prefetch in case we are asking for write prefetch not
     suported by SSE counterpart or the SSE prefetch is not available
     (K6 machines).  Otherwise use SSE prefetch as it allows specifying
     of locality.  */
  if (TARGET_3DNOW && (!TARGET_PREFETCH_SSE || rw))
    operands[2] = GEN_INT (3);
  else
    operands[1] = const0_rtx;
})

(define_insn "*prefetch_sse"
  [(prefetch (match_operand:SI 0 "address_operand" "p")
	     (const_int 0)
	     (match_operand:SI 1 "const_int_operand" ""))]
  "TARGET_PREFETCH_SSE && !TARGET_64BIT"
{
  static const char * const patterns[4] = {
   "prefetchnta\t%a0", "prefetcht2\t%a0", "prefetcht1\t%a0", "prefetcht0\t%a0"
  };

  int locality = INTVAL (operands[1]);
  if (locality < 0 || locality > 3)
    abort ();

  return patterns[locality];  
}
  [(set_attr "type" "sse")
   (set_attr "memory" "none")])

(define_insn "*prefetch_sse_rex"
  [(prefetch (match_operand:DI 0 "address_operand" "p")
	     (const_int 0)
	     (match_operand:SI 1 "const_int_operand" ""))]
  "TARGET_PREFETCH_SSE && TARGET_64BIT"
{
  static const char * const patterns[4] = {
   "prefetchnta\t%a0", "prefetcht2\t%a0", "prefetcht1\t%a0", "prefetcht0\t%a0"
  };

  int locality = INTVAL (operands[1]);
  if (locality < 0 || locality > 3)
    abort ();

  return patterns[locality];  
}
  [(set_attr "type" "sse")
   (set_attr "memory" "none")])

(define_insn "*prefetch_3dnow"
  [(prefetch (match_operand:SI 0 "address_operand" "p")
	     (match_operand:SI 1 "const_int_operand" "n")
	     (const_int 3))]
  "TARGET_3DNOW && !TARGET_64BIT"
{
  if (INTVAL (operands[1]) == 0)
    return "prefetch\t%a0";
  else
    return "prefetchw\t%a0";
}
  [(set_attr "type" "mmx")
   (set_attr "memory" "none")])

(define_insn "*prefetch_3dnow_rex"
  [(prefetch (match_operand:DI 0 "address_operand" "p")
	     (match_operand:SI 1 "const_int_operand" "n")
	     (const_int 3))]
  "TARGET_3DNOW && TARGET_64BIT"
{
  if (INTVAL (operands[1]) == 0)
    return "prefetch\t%a0";
  else
    return "prefetchw\t%a0";
}
  [(set_attr "type" "mmx")
   (set_attr "memory" "none")])

;; SSE2 support

(define_insn "addv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (plus:V2DF (match_operand:V2DF 1 "register_operand" "0")
	           (match_operand:V2DF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "addpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V2DF")])

(define_insn "vmaddv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF (plus:V2DF (match_operand:V2DF 1 "register_operand" "0")
	                           (match_operand:V2DF 2 "nonimmediate_operand" "xm"))
                        (match_dup 1)
			(const_int 1)))]
  "TARGET_SSE2"
  "addsd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "DF")])

(define_insn "subv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (minus:V2DF (match_operand:V2DF 1 "register_operand" "0")
	           (match_operand:V2DF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "subpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V2DF")])

(define_insn "vmsubv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF (minus:V2DF (match_operand:V2DF 1 "register_operand" "0")
	                           (match_operand:V2DF 2 "nonimmediate_operand" "xm"))
                        (match_dup 1)
			(const_int 1)))]
  "TARGET_SSE2"
  "subsd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "DF")])

(define_insn "mulv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (mult:V2DF (match_operand:V2DF 1 "register_operand" "0")
	           (match_operand:V2DF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "mulpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssemul")
   (set_attr "mode" "V2DF")])

(define_insn "vmmulv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF (mult:V2DF (match_operand:V2DF 1 "register_operand" "0")
	                           (match_operand:V2DF 2 "nonimmediate_operand" "xm"))
                        (match_dup 1)
			(const_int 1)))]
  "TARGET_SSE2"
  "mulsd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssemul")
   (set_attr "mode" "DF")])

(define_insn "divv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (div:V2DF (match_operand:V2DF 1 "register_operand" "0")
	          (match_operand:V2DF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "divpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssediv")
   (set_attr "mode" "V2DF")])

(define_insn "vmdivv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF (div:V2DF (match_operand:V2DF 1 "register_operand" "0")
				  (match_operand:V2DF 2 "nonimmediate_operand" "xm"))
                        (match_dup 1)
			(const_int 1)))]
  "TARGET_SSE2"
  "divsd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssediv")
   (set_attr "mode" "DF")])

;; SSE min/max

(define_insn "smaxv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (smax:V2DF (match_operand:V2DF 1 "register_operand" "0")
		   (match_operand:V2DF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "maxpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V2DF")])

(define_insn "vmsmaxv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF (smax:V2DF (match_operand:V2DF 1 "register_operand" "0")
	                           (match_operand:V2DF 2 "nonimmediate_operand" "xm"))
                        (match_dup 1)
			(const_int 1)))]
  "TARGET_SSE2"
  "maxsd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "DF")])

(define_insn "sminv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (smin:V2DF (match_operand:V2DF 1 "register_operand" "0")
		   (match_operand:V2DF 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "minpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V2DF")])

(define_insn "vmsminv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF (smin:V2DF (match_operand:V2DF 1 "register_operand" "0")
	                           (match_operand:V2DF 2 "nonimmediate_operand" "xm"))
                        (match_dup 1)
			(const_int 1)))]
  "TARGET_SSE2"
  "minsd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "DF")])
;; SSE2 square root.  There doesn't appear to be an extension for the
;; reciprocal/rsqrt instructions if the Intel manual is to be believed.

(define_insn "sqrtv2df2"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (sqrt:V2DF (match_operand:V2DF 1 "register_operand" "xm")))]
  "TARGET_SSE2"
  "sqrtpd\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "V2DF")])

(define_insn "vmsqrtv2df2"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF (sqrt:V2DF (match_operand:V2DF 1 "register_operand" "xm"))
                        (match_operand:V2DF 2 "register_operand" "0")
			(const_int 1)))]
  "TARGET_SSE2"
  "sqrtsd\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "SF")])

;; SSE mask-generating compares

(define_insn "maskcmpv2df3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (match_operator:V2DI 3 "sse_comparison_operator"
			     [(match_operand:V2DF 1 "register_operand" "0")
			      (match_operand:V2DF 2 "nonimmediate_operand" "x")]))]
  "TARGET_SSE2"
  "cmp%D3pd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "V2DF")])

(define_insn "maskncmpv2df3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (not:V2DI
	 (match_operator:V2DI 3 "sse_comparison_operator"
			      [(match_operand:V2DF 1 "register_operand" "0")
			       (match_operand:V2DF 2 "nonimmediate_operand" "x")])))]
  "TARGET_SSE2"
{
  if (GET_CODE (operands[3]) == UNORDERED)
    return "cmpordps\t{%2, %0|%0, %2}";
  else
    return "cmpn%D3pd\t{%2, %0|%0, %2}";
}
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "V2DF")])

(define_insn "vmmaskcmpv2df3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
	(vec_merge:V2DI
	 (match_operator:V2DI 3 "sse_comparison_operator"
			      [(match_operand:V2DF 1 "register_operand" "0")
			       (match_operand:V2DF 2 "nonimmediate_operand" "x")])
	 (subreg:V2DI (match_dup 1) 0)
	 (const_int 1)))]
  "TARGET_SSE2"
  "cmp%D3sd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "DF")])

(define_insn "vmmaskncmpv2df3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
	(vec_merge:V2DI
	 (not:V2DI
	  (match_operator:V2DI 3 "sse_comparison_operator"
			       [(match_operand:V2DF 1 "register_operand" "0")
				(match_operand:V2DF 2 "nonimmediate_operand" "x")]))
	 (subreg:V2DI (match_dup 1) 0)
	 (const_int 1)))]
  "TARGET_SSE2"
{
  if (GET_CODE (operands[3]) == UNORDERED)
    return "cmpordsd\t{%2, %0|%0, %2}";
  else
    return "cmpn%D3sd\t{%2, %0|%0, %2}";
}
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "DF")])

(define_insn "sse2_comi"
  [(set (reg:CCFP 17)
        (compare:CCFP (vec_select:DF
		       (match_operand:V2DF 0 "register_operand" "x")
		       (parallel [(const_int 0)]))
		      (vec_select:DF
		       (match_operand:V2DF 1 "register_operand" "x")
		       (parallel [(const_int 0)]))))]
  "TARGET_SSE2"
  "comisd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecomi")
   (set_attr "mode" "DF")])

(define_insn "sse2_ucomi"
  [(set (reg:CCFPU 17)
	(compare:CCFPU (vec_select:DF
			 (match_operand:V2DF 0 "register_operand" "x")
			 (parallel [(const_int 0)]))
			(vec_select:DF
			 (match_operand:V2DF 1 "register_operand" "x")
			 (parallel [(const_int 0)]))))]
  "TARGET_SSE2"
  "ucomisd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecomi")
   (set_attr "mode" "DF")])

;; SSE Strange Moves.

(define_insn "sse2_movmskpd"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:V2DF 1 "register_operand" "x")]
		   UNSPEC_MOVMSK))]
  "TARGET_SSE2"
  "movmskpd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_insn "sse2_pmovmskb"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:V16QI 1 "register_operand" "x")]
		   UNSPEC_MOVMSK))]
  "TARGET_SSE2"
  "pmovmskb\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_insn "sse2_maskmovdqu"
  [(set (mem:V16QI (match_operand:SI 0 "register_operand" "D"))
	(unspec:V16QI [(match_operand:V16QI 1 "register_operand" "x")
		       (match_operand:V16QI 2 "register_operand" "x")]
		      UNSPEC_MASKMOV))]
  "TARGET_SSE2"
  ;; @@@ check ordering of operands in intel/nonintel syntax
  "maskmovdqu\t{%2, %1|%1, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_maskmovdqu_rex64"
  [(set (mem:V16QI (match_operand:DI 0 "register_operand" "D"))
	(unspec:V16QI [(match_operand:V16QI 1 "register_operand" "x")
		       (match_operand:V16QI 2 "register_operand" "x")]
		      UNSPEC_MASKMOV))]
  "TARGET_SSE2"
  ;; @@@ check ordering of operands in intel/nonintel syntax
  "maskmovdqu\t{%2, %1|%1, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_movntv2df"
  [(set (match_operand:V2DF 0 "memory_operand" "=m")
	(unspec:V2DF [(match_operand:V2DF 1 "register_operand" "x")]
		     UNSPEC_MOVNT))]
  "TARGET_SSE2"
  "movntpd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_insn "sse2_movntv2di"
  [(set (match_operand:V2DI 0 "memory_operand" "=m")
	(unspec:V2DI [(match_operand:V2DI 1 "register_operand" "x")]
		     UNSPEC_MOVNT))]
  "TARGET_SSE2"
  "movntdq\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_movntsi"
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(unspec:SI [(match_operand:SI 1 "register_operand" "r")]
		   UNSPEC_MOVNT))]
  "TARGET_SSE2"
  "movnti\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

;; SSE <-> integer/MMX conversions

;; Conversions between SI and SF

(define_insn "cvtdq2ps"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(float:V4SF (match_operand:V4SI 1 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "cvtdq2ps\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_insn "cvtps2dq"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(fix:V4SI (match_operand:V4SF 1 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "cvtps2dq\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "cvttps2dq"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(unspec:V4SI [(match_operand:V4SF 1 "nonimmediate_operand" "xm")]
		     UNSPEC_FIX))]
  "TARGET_SSE2"
  "cvttps2dq\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

;; Conversions between SI and DF

(define_insn "cvtdq2pd"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(float:V2DF (vec_select:V2SI
		     (match_operand:V4SI 1 "nonimmediate_operand" "xm")
		     (parallel
		      [(const_int 0)
		       (const_int 1)]))))]
  "TARGET_SSE2"
  "cvtdq2pd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_insn "cvtpd2dq"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(vec_concat:V4SI
	 (fix:V2SI (match_operand:V2DF 1 "nonimmediate_operand" "xm"))
	 (const_vector:V2SI [(const_int 0) (const_int 0)])))]
  "TARGET_SSE2"
  "cvtpd2dq\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "cvttpd2dq"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(vec_concat:V4SI
	 (unspec:V2SI [(match_operand:V2DF 1 "nonimmediate_operand" "xm")]
		      UNSPEC_FIX)
	 (const_vector:V2SI [(const_int 0) (const_int 0)])))]
  "TARGET_SSE2"
  "cvttpd2dq\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "cvtpd2pi"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(fix:V2SI (match_operand:V2DF 1 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "cvtpd2pi\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "cvttpd2pi"
  [(set (match_operand:V2SI 0 "register_operand" "=y")
	(unspec:V2SI [(match_operand:V2DF 1 "nonimmediate_operand" "xm")]
		     UNSPEC_FIX))]
  "TARGET_SSE2"
  "cvttpd2pi\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "cvtpi2pd"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(float:V2DF (match_operand:V2SI 1 "nonimmediate_operand" "ym")))]
  "TARGET_SSE2"
  "cvtpi2pd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

;; Conversions between SI and DF

(define_insn "cvtsd2si"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(fix:SI (vec_select:DF (match_operand:V2DF 1 "register_operand" "x,m")
			       (parallel [(const_int 0)]))))]
  "TARGET_SSE2"
  "cvtsd2si\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "athlon_decode" "double,vector")
   (set_attr "mode" "SI")])

(define_insn "cvtsd2siq"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(fix:DI (vec_select:DF (match_operand:V2DF 1 "register_operand" "x,m")
			       (parallel [(const_int 0)]))))]
  "TARGET_SSE2 && TARGET_64BIT"
  "cvtsd2siq\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "athlon_decode" "double,vector")
   (set_attr "mode" "DI")])

(define_insn "cvttsd2si"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(unspec:SI [(vec_select:DF (match_operand:V2DF 1 "register_operand" "x,xm")
				   (parallel [(const_int 0)]))] UNSPEC_FIX))]
  "TARGET_SSE2"
  "cvttsd2si\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "SI")
   (set_attr "athlon_decode" "double,vector")])

(define_insn "cvttsd2siq"
  [(set (match_operand:DI 0 "register_operand" "=r,r")
	(unspec:DI [(vec_select:DF (match_operand:V2DF 1 "register_operand" "x,xm")
				   (parallel [(const_int 0)]))] UNSPEC_FIX))]
  "TARGET_SSE2 && TARGET_64BIT"
  "cvttsd2siq\t{%1, %0|%0, %1}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "DI")
   (set_attr "athlon_decode" "double,vector")])

(define_insn "cvtsi2sd"
  [(set (match_operand:V2DF 0 "register_operand" "=x,x")
	(vec_merge:V2DF (match_operand:V2DF 1 "register_operand" "0,0")
	 		(vec_duplicate:V2DF
			  (float:DF
			    (match_operand:SI 2 "nonimmediate_operand" "r,rm")))
			(const_int 2)))]
  "TARGET_SSE2"
  "cvtsi2sd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "double,direct")])

(define_insn "cvtsi2sdq"
  [(set (match_operand:V2DF 0 "register_operand" "=x,x")
	(vec_merge:V2DF (match_operand:V2DF 1 "register_operand" "0,0")
	 		(vec_duplicate:V2DF
			  (float:DF
			    (match_operand:DI 2 "nonimmediate_operand" "r,rm")))
			(const_int 2)))]
  "TARGET_SSE2 && TARGET_64BIT"
  "cvtsi2sdq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseicvt")
   (set_attr "mode" "DF")
   (set_attr "athlon_decode" "double,direct")])

;; Conversions between SF and DF

(define_insn "cvtsd2ss"
  [(set (match_operand:V4SF 0 "register_operand" "=x,x")
	(vec_merge:V4SF (match_operand:V4SF 1 "register_operand" "0,0")
	 		(vec_duplicate:V4SF
			  (float_truncate:V2SF
			    (match_operand:V2DF 2 "nonimmediate_operand" "x,xm")))
			(const_int 14)))]
  "TARGET_SSE2"
  "cvtsd2ss\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "athlon_decode" "vector,double")
   (set_attr "mode" "SF")])

(define_insn "cvtss2sd"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF (match_operand:V2DF 1 "register_operand" "0")
	 		(float_extend:V2DF
			  (vec_select:V2SF
			    (match_operand:V4SF 2 "nonimmediate_operand" "xm")
			    (parallel [(const_int 0)
				       (const_int 1)])))
			(const_int 2)))]
  "TARGET_SSE2"
  "cvtss2sd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "DF")])

(define_insn "cvtpd2ps"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
	(subreg:V4SF
	  (vec_concat:V4SI
	    (subreg:V2SI (float_truncate:V2SF
			   (match_operand:V2DF 1 "nonimmediate_operand" "xm")) 0)
	    (const_vector:V2SI [(const_int 0) (const_int 0)])) 0))]
  "TARGET_SSE2"
  "cvtpd2ps\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V4SF")])

(define_insn "cvtps2pd"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(float_extend:V2DF
	  (vec_select:V2SF (match_operand:V4SF 1 "nonimmediate_operand" "xm")
			   (parallel [(const_int 0)
				      (const_int 1)]))))]
  "TARGET_SSE2"
  "cvtps2pd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

;; SSE2 variants of MMX insns

;; MMX arithmetic

(define_insn "addv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (plus:V16QI (match_operand:V16QI 1 "register_operand" "%0")
		    (match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "paddb\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "addv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (plus:V8HI (match_operand:V8HI 1 "register_operand" "%0")
	           (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "paddw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "addv4si3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (plus:V4SI (match_operand:V4SI 1 "register_operand" "%0")
	           (match_operand:V4SI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "paddd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "addv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (plus:V2DI (match_operand:V2DI 1 "register_operand" "%0")
	           (match_operand:V2DI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "paddq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "ssaddv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (ss_plus:V16QI (match_operand:V16QI 1 "register_operand" "%0")
		       (match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "paddsb\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "ssaddv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (ss_plus:V8HI (match_operand:V8HI 1 "register_operand" "%0")
		      (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "paddsw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "usaddv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (us_plus:V16QI (match_operand:V16QI 1 "register_operand" "%0")
		       (match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "paddusb\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "usaddv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (us_plus:V8HI (match_operand:V8HI 1 "register_operand" "%0")
		      (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "paddusw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "subv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (minus:V16QI (match_operand:V16QI 1 "register_operand" "0")
		     (match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "psubb\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "subv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (minus:V8HI (match_operand:V8HI 1 "register_operand" "0")
		    (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "psubw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "subv4si3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (minus:V4SI (match_operand:V4SI 1 "register_operand" "0")
		    (match_operand:V4SI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "psubd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "subv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (minus:V2DI (match_operand:V2DI 1 "register_operand" "0")
		    (match_operand:V2DI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "psubq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "sssubv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (ss_minus:V16QI (match_operand:V16QI 1 "register_operand" "0")
			(match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "psubsb\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "sssubv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (ss_minus:V8HI (match_operand:V8HI 1 "register_operand" "0")
		       (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "psubsw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "ussubv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (us_minus:V16QI (match_operand:V16QI 1 "register_operand" "0")
			(match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "psubusb\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "ussubv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (us_minus:V8HI (match_operand:V8HI 1 "register_operand" "0")
		       (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "psubusw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "mulv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (mult:V8HI (match_operand:V8HI 1 "register_operand" "0")
		   (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pmullw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseimul")
   (set_attr "mode" "TI")])

(define_insn "smulv8hi3_highpart"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
	(truncate:V8HI
	 (lshiftrt:V8SI
	  (mult:V8SI (sign_extend:V8SI (match_operand:V8HI 1 "register_operand" "0"))
		     (sign_extend:V8SI (match_operand:V8HI 2 "nonimmediate_operand" "xm")))
	  (const_int 16))))]
  "TARGET_SSE2"
  "pmulhw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseimul")
   (set_attr "mode" "TI")])

(define_insn "umulv8hi3_highpart"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
	(truncate:V8HI
	 (lshiftrt:V8SI
	  (mult:V8SI (zero_extend:V8SI (match_operand:V8HI 1 "register_operand" "0"))
		     (zero_extend:V8SI (match_operand:V8HI 2 "nonimmediate_operand" "xm")))
	  (const_int 16))))]
  "TARGET_SSE2"
  "pmulhuw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseimul")
   (set_attr "mode" "TI")])

(define_insn "sse2_umulsidi3"
  [(set (match_operand:DI 0 "register_operand" "=y")
        (mult:DI (zero_extend:DI (vec_select:SI
				  (match_operand:V2SI 1 "register_operand" "0")
				  (parallel [(const_int 0)])))
		 (zero_extend:DI (vec_select:SI
				  (match_operand:V2SI 2 "nonimmediate_operand" "ym")
				  (parallel [(const_int 0)])))))]
  "TARGET_SSE2"
  "pmuludq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseimul")
   (set_attr "mode" "TI")])

(define_insn "sse2_umulv2siv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (mult:V2DI (zero_extend:V2DI
		     (vec_select:V2SI
		       (match_operand:V4SI 1 "register_operand" "0")
		       (parallel [(const_int 0) (const_int 2)])))
		   (zero_extend:V2DI
		     (vec_select:V2SI
		       (match_operand:V4SI 2 "nonimmediate_operand" "xm")
		       (parallel [(const_int 0) (const_int 2)])))))]
  "TARGET_SSE2"
  "pmuludq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseimul")
   (set_attr "mode" "TI")])

(define_insn "sse2_pmaddwd"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (plus:V4SI
	 (mult:V4SI
	  (sign_extend:V4SI (vec_select:V4HI (match_operand:V8HI 1 "register_operand" "0")
					     (parallel [(const_int 0)
							(const_int 2)
							(const_int 4)
							(const_int 6)])))
	  (sign_extend:V4SI (vec_select:V4HI (match_operand:V8HI 2 "nonimmediate_operand" "xm")
					     (parallel [(const_int 0)
							(const_int 2)
							(const_int 4)
							(const_int 6)]))))
	 (mult:V4SI
	  (sign_extend:V4SI (vec_select:V4HI (match_dup 1)
					     (parallel [(const_int 1)
							(const_int 3)
							(const_int 5)
							(const_int 7)])))
	  (sign_extend:V4SI (vec_select:V4HI (match_dup 2)
					     (parallel [(const_int 1)
							(const_int 3)
							(const_int 5)
							(const_int 7)]))))))]
  "TARGET_SSE2"
  "pmaddwd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

;; Same as pxor, but don't show input operands so that we don't think
;; they are live.
(define_insn "sse2_clrti"
  [(set (match_operand:TI 0 "register_operand" "=x") (const_int 0))]
  "TARGET_SSE2"
{
  if (get_attr_mode (insn) == MODE_TI)
    return "pxor\t%0, %0";
  else
    return "xorps\t%0, %0";
}
  [(set_attr "type" "ssemov")
   (set_attr "memory" "none")
   (set (attr "mode")
	      (if_then_else
		(ne (symbol_ref "optimize_size")
		    (const_int 0))
		(const_string "V4SF")
		(const_string "TI")))])

;; MMX unsigned averages/sum of absolute differences

(define_insn "sse2_uavgv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (ashiftrt:V16QI
	 (plus:V16QI (plus:V16QI
		     (match_operand:V16QI 1 "register_operand" "0")
		     (match_operand:V16QI 2 "nonimmediate_operand" "xm"))
		     (const_vector:V16QI [(const_int 1) (const_int 1)
					  (const_int 1) (const_int 1)
					  (const_int 1) (const_int 1)
					  (const_int 1) (const_int 1)
					  (const_int 1) (const_int 1)
					  (const_int 1) (const_int 1)
					  (const_int 1) (const_int 1)
					  (const_int 1) (const_int 1)]))
	 (const_int 1)))]
  "TARGET_SSE2"
  "pavgb\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "sse2_uavgv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (ashiftrt:V8HI
	 (plus:V8HI (plus:V8HI
		     (match_operand:V8HI 1 "register_operand" "0")
		     (match_operand:V8HI 2 "nonimmediate_operand" "xm"))
		    (const_vector:V8HI [(const_int 1) (const_int 1)
				        (const_int 1) (const_int 1)
				        (const_int 1) (const_int 1)
				        (const_int 1) (const_int 1)]))
	 (const_int 1)))]
  "TARGET_SSE2"
  "pavgw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

;; @@@ this isn't the right representation.
(define_insn "sse2_psadbw"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (unspec:V2DI [(match_operand:V16QI 1 "register_operand" "0")
		      (match_operand:V16QI 2 "nonimmediate_operand" "xm")]
		     UNSPEC_PSADBW))]
  "TARGET_SSE2"
  "psadbw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])


;; MMX insert/extract/shuffle

(define_insn "sse2_pinsrw"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (vec_merge:V8HI (match_operand:V8HI 1 "register_operand" "0")
			(vec_duplicate:V8HI
			 (truncate:HI
			   (match_operand:SI 2 "nonimmediate_operand" "rm")))
			(match_operand:SI 3 "const_0_to_255_operand" "N")))]
  "TARGET_SSE2"
  "pinsrw\t{%3, %2, %0|%0, %2, %3}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_pextrw"
  [(set (match_operand:SI 0 "register_operand" "=r")
        (zero_extend:SI
	  (vec_select:HI (match_operand:V8HI 1 "register_operand" "x")
			 (parallel
			  [(match_operand:SI 2 "const_0_to_7_operand" "N")]))))]
  "TARGET_SSE2"
  "pextrw\t{%2, %1, %0|%0, %1, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_pshufd"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (unspec:V4SI [(match_operand:V4SI 1 "register_operand" "0")
		      (match_operand:SI 2 "immediate_operand" "i")]
		     UNSPEC_SHUFFLE))]
  "TARGET_SSE2"
  "pshufd\t{%2, %1, %0|%0, %1, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_pshuflw"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (unspec:V8HI [(match_operand:V8HI 1 "register_operand" "0")
		      (match_operand:SI 2 "immediate_operand" "i")]
		     UNSPEC_PSHUFLW))]
  "TARGET_SSE2"
  "pshuflw\t{%2, %1, %0|%0, %1, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_pshufhw"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (unspec:V8HI [(match_operand:V8HI 1 "register_operand" "0")
		      (match_operand:SI 2 "immediate_operand" "i")]
		     UNSPEC_PSHUFHW))]
  "TARGET_SSE2"
  "pshufhw\t{%2, %1, %0|%0, %1, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

;; MMX mask-generating comparisons

(define_insn "eqv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (eq:V16QI (match_operand:V16QI 1 "register_operand" "0")
		 (match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pcmpeqb\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "TI")])

(define_insn "eqv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (eq:V8HI (match_operand:V8HI 1 "register_operand" "0")
		 (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pcmpeqw\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "TI")])

(define_insn "eqv4si3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (eq:V4SI (match_operand:V4SI 1 "register_operand" "0")
		 (match_operand:V4SI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pcmpeqd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "TI")])

(define_insn "gtv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (gt:V16QI (match_operand:V16QI 1 "register_operand" "0")
		 (match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pcmpgtb\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "TI")])

(define_insn "gtv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (gt:V8HI (match_operand:V8HI 1 "register_operand" "0")
		 (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pcmpgtw\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "TI")])

(define_insn "gtv4si3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (gt:V4SI (match_operand:V4SI 1 "register_operand" "0")
		 (match_operand:V4SI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pcmpgtd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecmp")
   (set_attr "mode" "TI")])


;; MMX max/min insns

(define_insn "umaxv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (umax:V16QI (match_operand:V16QI 1 "register_operand" "0")
		   (match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pmaxub\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "smaxv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (smax:V8HI (match_operand:V8HI 1 "register_operand" "0")
		   (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pmaxsw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "uminv16qi3"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
        (umin:V16QI (match_operand:V16QI 1 "register_operand" "0")
		   (match_operand:V16QI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pminub\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])

(define_insn "sminv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (smin:V8HI (match_operand:V8HI 1 "register_operand" "0")
		   (match_operand:V8HI 2 "nonimmediate_operand" "xm")))]
  "TARGET_SSE2"
  "pminsw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseiadd")
   (set_attr "mode" "TI")])


;; MMX shifts

(define_insn "ashrv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (ashiftrt:V8HI (match_operand:V8HI 1 "register_operand" "0")
		       (match_operand:SI 2 "nonmemory_operand" "xi")))]
  "TARGET_SSE2"
  "psraw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashrv4si3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (ashiftrt:V4SI (match_operand:V4SI 1 "register_operand" "0")
		       (match_operand:SI 2 "nonmemory_operand" "xi")))]
  "TARGET_SSE2"
  "psrad\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "lshrv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (lshiftrt:V8HI (match_operand:V8HI 1 "register_operand" "0")
		       (match_operand:SI 2 "nonmemory_operand" "xi")))]
  "TARGET_SSE2"
  "psrlw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "lshrv4si3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (lshiftrt:V4SI (match_operand:V4SI 1 "register_operand" "0")
		       (match_operand:SI 2 "nonmemory_operand" "xi")))]
  "TARGET_SSE2"
  "psrld\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "lshrv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (lshiftrt:V2DI (match_operand:V2DI 1 "register_operand" "0")
		       (match_operand:SI 2 "nonmemory_operand" "xi")))]
  "TARGET_SSE2"
  "psrlq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashlv8hi3"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (ashift:V8HI (match_operand:V8HI 1 "register_operand" "0")
		     (match_operand:SI 2 "nonmemory_operand" "xi")))]
  "TARGET_SSE2"
  "psllw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashlv4si3"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (ashift:V4SI (match_operand:V4SI 1 "register_operand" "0")
		     (match_operand:SI 2 "nonmemory_operand" "xi")))]
  "TARGET_SSE2"
  "pslld\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashlv2di3"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (ashift:V2DI (match_operand:V2DI 1 "register_operand" "0")
		     (match_operand:SI 2 "nonmemory_operand" "xi")))]
  "TARGET_SSE2"
  "psllq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashrv8hi3_ti"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (ashiftrt:V8HI (match_operand:V8HI 1 "register_operand" "0")
		       (subreg:SI (match_operand:V2DI 2 "nonmemory_operand" "xi") 0)))]
  "TARGET_SSE2"
  "psraw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashrv4si3_ti"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (ashiftrt:V4SI (match_operand:V4SI 1 "register_operand" "0")
		       (subreg:SI (match_operand:V2DI 2 "nonmemory_operand" "xi") 0)))]
  "TARGET_SSE2"
  "psrad\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "lshrv8hi3_ti"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (lshiftrt:V8HI (match_operand:V8HI 1 "register_operand" "0")
		       (subreg:SI (match_operand:V2DI 2 "nonmemory_operand" "xi") 0)))]
  "TARGET_SSE2"
  "psrlw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "lshrv4si3_ti"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (lshiftrt:V4SI (match_operand:V4SI 1 "register_operand" "0")
		       (subreg:SI (match_operand:V2DI 2 "nonmemory_operand" "xi") 0)))]
  "TARGET_SSE2"
  "psrld\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "lshrv2di3_ti"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (lshiftrt:V2DI (match_operand:V2DI 1 "register_operand" "0")
		       (subreg:SI (match_operand:V2DI 2 "nonmemory_operand" "xi") 0)))]
  "TARGET_SSE2"
  "psrlq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashlv8hi3_ti"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
        (ashift:V8HI (match_operand:V8HI 1 "register_operand" "0")
		     (subreg:SI (match_operand:V2DI 2 "nonmemory_operand" "xi") 0)))]
  "TARGET_SSE2"
  "psllw\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashlv4si3_ti"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
        (ashift:V4SI (match_operand:V4SI 1 "register_operand" "0")
		     (subreg:SI (match_operand:V2DI 2 "nonmemory_operand" "xi") 0)))]
  "TARGET_SSE2"
  "pslld\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "ashlv2di3_ti"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
        (ashift:V2DI (match_operand:V2DI 1 "register_operand" "0")
		     (subreg:SI (match_operand:V2DI 2 "nonmemory_operand" "xi") 0)))]
  "TARGET_SSE2"
  "psllq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

;; See logical MMX insns for the reason for the unspec.  Strictly speaking
;; we wouldn't need here it since we never generate TImode arithmetic.

;; There has to be some kind of prize for the weirdest new instruction...
(define_insn "sse2_ashlti3"
  [(set (match_operand:TI 0 "register_operand" "=x")
        (unspec:TI
	 [(ashift:TI (match_operand:TI 1 "register_operand" "0")
		     (mult:SI (match_operand:SI 2 "immediate_operand" "i")
			       (const_int 8)))] UNSPEC_NOP))]
  "TARGET_SSE2"
  "pslldq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

(define_insn "sse2_lshrti3"
  [(set (match_operand:TI 0 "register_operand" "=x")
        (unspec:TI
	 [(lshiftrt:TI (match_operand:TI 1 "register_operand" "0")
		       (mult:SI (match_operand:SI 2 "immediate_operand" "i")
				(const_int 8)))] UNSPEC_NOP))]
  "TARGET_SSE2"
  "psrldq\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseishft")
   (set_attr "mode" "TI")])

;; SSE unpack

(define_insn "sse2_unpckhpd"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_concat:V2DF
	 (vec_select:DF (match_operand:V2DF 1 "register_operand" "0")
			(parallel [(const_int 1)]))
	 (vec_select:DF (match_operand:V2DF 2 "register_operand" "x")
			(parallel [(const_int 1)]))))]
  "TARGET_SSE2"
  "unpckhpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_insn "sse2_unpcklpd"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_concat:V2DF
	 (vec_select:DF (match_operand:V2DF 1 "register_operand" "0")
			(parallel [(const_int 0)]))
	 (vec_select:DF (match_operand:V2DF 2 "register_operand" "x")
			(parallel [(const_int 0)]))))]
  "TARGET_SSE2"
  "unpcklpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

;; MMX pack/unpack insns.

(define_insn "sse2_packsswb"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
	(vec_concat:V16QI
	 (ss_truncate:V8QI (match_operand:V8HI 1 "register_operand" "0"))
	 (ss_truncate:V8QI (match_operand:V8HI 2 "register_operand" "x"))))]
  "TARGET_SSE2"
  "packsswb\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_packssdw"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
	(vec_concat:V8HI
	 (ss_truncate:V4HI (match_operand:V4SI 1 "register_operand" "0"))
	 (ss_truncate:V4HI (match_operand:V4SI 2 "register_operand" "x"))))]
  "TARGET_SSE2"
  "packssdw\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_packuswb"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
	(vec_concat:V16QI
	 (us_truncate:V8QI (match_operand:V8HI 1 "register_operand" "0"))
	 (us_truncate:V8QI (match_operand:V8HI 2 "register_operand" "x"))))]
  "TARGET_SSE2"
  "packuswb\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_punpckhbw"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
	(vec_merge:V16QI
	 (vec_select:V16QI (match_operand:V16QI 1 "register_operand" "0")
			   (parallel [(const_int 8) (const_int 0)
				      (const_int 9) (const_int 1)
				      (const_int 10) (const_int 2)
				      (const_int 11) (const_int 3)
				      (const_int 12) (const_int 4)
				      (const_int 13) (const_int 5)
				      (const_int 14) (const_int 6)
				      (const_int 15) (const_int 7)]))
	 (vec_select:V16QI (match_operand:V16QI 2 "register_operand" "x")
			   (parallel [(const_int 0) (const_int 8)
				      (const_int 1) (const_int 9)
				      (const_int 2) (const_int 10)
				      (const_int 3) (const_int 11)
				      (const_int 4) (const_int 12)
				      (const_int 5) (const_int 13)
				      (const_int 6) (const_int 14)
				      (const_int 7) (const_int 15)]))
	 (const_int 21845)))]
  "TARGET_SSE2"
  "punpckhbw\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_punpckhwd"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
	(vec_merge:V8HI
	 (vec_select:V8HI (match_operand:V8HI 1 "register_operand" "0")
			  (parallel [(const_int 4) (const_int 0)
				     (const_int 5) (const_int 1)
				     (const_int 6) (const_int 2)
				     (const_int 7) (const_int 3)]))
	 (vec_select:V8HI (match_operand:V8HI 2 "register_operand" "x")
			  (parallel [(const_int 0) (const_int 4)
				     (const_int 1) (const_int 5)
				     (const_int 2) (const_int 6)
				     (const_int 3) (const_int 7)]))
	 (const_int 85)))]
  "TARGET_SSE2"
  "punpckhwd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_punpckhdq"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(vec_merge:V4SI
	 (vec_select:V4SI (match_operand:V4SI 1 "register_operand" "0")
			  (parallel [(const_int 2) (const_int 0)
				     (const_int 3) (const_int 1)]))
	 (vec_select:V4SI (match_operand:V4SI 2 "register_operand" "x")
			  (parallel [(const_int 0) (const_int 2)
				     (const_int 1) (const_int 3)]))
	 (const_int 5)))]
  "TARGET_SSE2"
  "punpckhdq\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_punpcklbw"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
	(vec_merge:V16QI
	 (vec_select:V16QI (match_operand:V16QI 1 "register_operand" "0")
			   (parallel [(const_int 0) (const_int 8)
				      (const_int 1) (const_int 9)
				      (const_int 2) (const_int 10)
				      (const_int 3) (const_int 11)
				      (const_int 4) (const_int 12)
				      (const_int 5) (const_int 13)
				      (const_int 6) (const_int 14)
				      (const_int 7) (const_int 15)]))
	 (vec_select:V16QI (match_operand:V16QI 2 "register_operand" "x")
			   (parallel [(const_int 8) (const_int 0)
				      (const_int 9) (const_int 1)
				      (const_int 10) (const_int 2)
				      (const_int 11) (const_int 3)
				      (const_int 12) (const_int 4)
				      (const_int 13) (const_int 5)
				      (const_int 14) (const_int 6)
				      (const_int 15) (const_int 7)]))
	 (const_int 21845)))]
  "TARGET_SSE2"
  "punpcklbw\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_punpcklwd"
  [(set (match_operand:V8HI 0 "register_operand" "=x")
	(vec_merge:V8HI
	 (vec_select:V8HI (match_operand:V8HI 1 "register_operand" "0")
			  (parallel [(const_int 0) (const_int 4)
				     (const_int 1) (const_int 5)
				     (const_int 2) (const_int 6)
				     (const_int 3) (const_int 7)]))
	 (vec_select:V8HI (match_operand:V8HI 2 "register_operand" "x")
			  (parallel [(const_int 4) (const_int 0)
				     (const_int 5) (const_int 1)
				     (const_int 6) (const_int 2)
				     (const_int 7) (const_int 3)]))
	 (const_int 85)))]
  "TARGET_SSE2"
  "punpcklwd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_punpckldq"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(vec_merge:V4SI
	 (vec_select:V4SI (match_operand:V4SI 1 "register_operand" "0")
			  (parallel [(const_int 0) (const_int 2)
				     (const_int 1) (const_int 3)]))
	 (vec_select:V4SI (match_operand:V4SI 2 "register_operand" "x")
			  (parallel [(const_int 2) (const_int 0)
				     (const_int 3) (const_int 1)]))
	 (const_int 5)))]
  "TARGET_SSE2"
  "punpckldq\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_punpcklqdq"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
	(vec_merge:V2DI
	 (vec_select:V2DI (match_operand:V2DI 2 "register_operand" "x")
			  (parallel [(const_int 1)
				     (const_int 0)]))
	 (match_operand:V2DI 1 "register_operand" "0")
	 (const_int 1)))]
  "TARGET_SSE2"
  "punpcklqdq\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_punpckhqdq"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
	(vec_merge:V2DI
	 (match_operand:V2DI 1 "register_operand" "0")
	 (vec_select:V2DI (match_operand:V2DI 2 "register_operand" "x")
			  (parallel [(const_int 1)
				     (const_int 0)]))
	 (const_int 1)))]
  "TARGET_SSE2"
  "punpckhqdq\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

;; SSE2 moves

(define_insn "sse2_movapd"
  [(set (match_operand:V2DF 0 "nonimmediate_operand" "=x,m")
	(unspec:V2DF [(match_operand:V2DF 1 "nonimmediate_operand" "xm,x")]
		     UNSPEC_MOVA))]
  "TARGET_SSE2
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "movapd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "V2DF")])

(define_insn "sse2_movupd"
  [(set (match_operand:V2DF 0 "nonimmediate_operand" "=x,m")
	(unspec:V2DF [(match_operand:V2DF 1 "nonimmediate_operand" "xm,x")]
		     UNSPEC_MOVU))]
  "TARGET_SSE2
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "movupd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_insn "sse2_movdqa"
  [(set (match_operand:V16QI 0 "nonimmediate_operand" "=x,m")
	(unspec:V16QI [(match_operand:V16QI 1 "nonimmediate_operand" "xm,x")]
		       UNSPEC_MOVA))]
  "TARGET_SSE2
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "movdqa\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "TI")])

(define_insn "sse2_movdqu"
  [(set (match_operand:V16QI 0 "nonimmediate_operand" "=x,m")
	(unspec:V16QI [(match_operand:V16QI 1 "nonimmediate_operand" "xm,x")]
		       UNSPEC_MOVU))]
  "TARGET_SSE2
   && (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != MEM)"
  "movdqu\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_movdq2q"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=m,y")
	(vec_select:DI (match_operand:V2DI 1 "register_operand" "x,x")
		       (parallel [(const_int 0)])))]
  "TARGET_SSE2 && !TARGET_64BIT"
  "@
   movq\t{%1, %0|%0, %1}
   movdq2q\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_movdq2q_rex64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=m,y,r")
	(vec_select:DI (match_operand:V2DI 1 "register_operand" "x,x,x")
		       (parallel [(const_int 0)])))]
  "TARGET_SSE2 && TARGET_64BIT"
  "@
   movq\t{%1, %0|%0, %1}
   movdq2q\t{%1, %0|%0, %1}
   movd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_movq2dq"
  [(set (match_operand:V2DI 0 "register_operand" "=x,?x")
	(vec_concat:V2DI (match_operand:DI 1 "nonimmediate_operand" "m,y")
			 (const_int 0)))]
  "TARGET_SSE2 && !TARGET_64BIT"
  "@
   movq\t{%1, %0|%0, %1}
   movq2dq\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt,ssemov")
   (set_attr "mode" "TI")])

(define_insn "sse2_movq2dq_rex64"
  [(set (match_operand:V2DI 0 "register_operand" "=x,?x,?x")
	(vec_concat:V2DI (match_operand:DI 1 "nonimmediate_operand" "m,y,r")
			 (const_int 0)))]
  "TARGET_SSE2 && TARGET_64BIT"
  "@
   movq\t{%1, %0|%0, %1}
   movq2dq\t{%1, %0|%0, %1}
   movd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt,ssemov,ssecvt")
   (set_attr "mode" "TI")])

(define_insn "sse2_movq"
  [(set (match_operand:V2DI 0 "register_operand" "=x")
	(vec_concat:V2DI (vec_select:DI
			  (match_operand:V2DI 1 "nonimmediate_operand" "xm")
			  (parallel [(const_int 0)]))
			 (const_int 0)))]
  "TARGET_SSE2"
  "movq\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "TI")])

(define_insn "sse2_loadd"
  [(set (match_operand:V4SI 0 "register_operand" "=x")
	(vec_merge:V4SI
	 (vec_duplicate:V4SI (match_operand:SI 1 "nonimmediate_operand" "mr"))
	 (const_vector:V4SI [(const_int 0)
			     (const_int 0)
			     (const_int 0)
			     (const_int 0)])
	 (const_int 1)))]
  "TARGET_SSE2"
  "movd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "TI")])

(define_insn "sse2_stored"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=mr")
	(vec_select:SI
	 (match_operand:V4SI 1 "register_operand" "x")
	 (parallel [(const_int 0)])))]
  "TARGET_SSE2"
  "movd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssemov")
   (set_attr "mode" "TI")])

(define_insn "sse2_movhpd"
  [(set (match_operand:V2DF 0 "nonimmediate_operand" "=x,m")
	(vec_merge:V2DF
	 (match_operand:V2DF 1 "nonimmediate_operand" "0,0")
	 (match_operand:V2DF 2 "nonimmediate_operand" "m,x")
	 (const_int 2)))]
  "TARGET_SSE2 && (GET_CODE (operands[1]) == MEM || GET_CODE (operands[2]) == MEM)"
  "movhpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_expand "sse2_loadsd"
  [(match_operand:V2DF 0 "register_operand" "")
   (match_operand:DF 1 "memory_operand" "")]
  "TARGET_SSE2"
{
  emit_insn (gen_sse2_loadsd_1 (operands[0], operands[1],
			        CONST0_RTX (V2DFmode)));
  DONE;
})

(define_insn "sse2_loadsd_1"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_merge:V2DF
	 (vec_duplicate:V2DF (match_operand:DF 1 "memory_operand" "m"))
	 (match_operand:V2DF 2 "const0_operand" "X")
	 (const_int 1)))]
  "TARGET_SSE2"
  "movsd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "DF")])

(define_insn "sse2_movsd"
  [(set (match_operand:V2DF 0 "nonimmediate_operand" "=x,x,m")
	(vec_merge:V2DF
	 (match_operand:V2DF 1 "nonimmediate_operand" "0,0,0")
	 (match_operand:V2DF 2 "nonimmediate_operand" "x,m,x")
	 (const_int 1)))]
  "TARGET_SSE2 && ix86_binary_operator_ok (UNKNOWN, V2DFmode, operands)"
  "@movsd\t{%2, %0|%0, %2}
    movlpd\t{%2, %0|%0, %2}
    movlpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "DF,V2DF,V2DF")])

(define_insn "sse2_storesd"
  [(set (match_operand:DF 0 "memory_operand" "=m")
	(vec_select:DF
	 (match_operand:V2DF 1 "register_operand" "x")
	 (parallel [(const_int 0)])))]
  "TARGET_SSE2"
  "movsd\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "DF")])

(define_insn "sse2_shufpd"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (unspec:V2DF [(match_operand:V2DF 1 "register_operand" "0")
		      (match_operand:V2DF 2 "nonimmediate_operand" "xm")
		      (match_operand:SI 3 "immediate_operand" "i")]
		     UNSPEC_SHUFFLE))]
  "TARGET_SSE2"
  ;; @@@ check operand order for intel/nonintel syntax
  "shufpd\t{%3, %2, %0|%0, %2, %3}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "V2DF")])

(define_insn "sse2_clflush"
  [(unspec_volatile [(match_operand 0 "address_operand" "p")]
		    UNSPECV_CLFLUSH)]
  "TARGET_SSE2"
  "clflush %0"
  [(set_attr "type" "sse")
   (set_attr "memory" "unknown")])

(define_expand "sse2_mfence"
  [(set (match_dup 0)
	(unspec:BLK [(match_dup 0)] UNSPEC_MFENCE))]
  "TARGET_SSE2"
{
  operands[0] = gen_rtx_MEM (BLKmode, gen_rtx_SCRATCH (Pmode));
  MEM_VOLATILE_P (operands[0]) = 1;
})

(define_insn "*mfence_insn"
  [(set (match_operand:BLK 0 "" "")
	(unspec:BLK [(match_dup 0)] UNSPEC_MFENCE))]
  "TARGET_SSE2"
  "mfence"
  [(set_attr "type" "sse")
   (set_attr "memory" "unknown")])

(define_expand "sse2_lfence"
  [(set (match_dup 0)
	(unspec:BLK [(match_dup 0)] UNSPEC_LFENCE))]
  "TARGET_SSE2"
{
  operands[0] = gen_rtx_MEM (BLKmode, gen_rtx_SCRATCH (Pmode));
  MEM_VOLATILE_P (operands[0]) = 1;
})

(define_insn "*lfence_insn"
  [(set (match_operand:BLK 0 "" "")
	(unspec:BLK [(match_dup 0)] UNSPEC_LFENCE))]
  "TARGET_SSE2"
  "lfence"
  [(set_attr "type" "sse")
   (set_attr "memory" "unknown")])

;; SSE3

(define_insn "mwait"
  [(unspec_volatile [(match_operand:SI 0 "register_operand" "a")
		     (match_operand:SI 1 "register_operand" "c")]
		    UNSPECV_MWAIT)]
  "TARGET_SSE3"
  "mwait\t%0, %1"
  [(set_attr "length" "3")])

(define_insn "monitor"
  [(unspec_volatile [(match_operand:SI 0 "register_operand" "a")
		     (match_operand:SI 1 "register_operand" "c")
		     (match_operand:SI 2 "register_operand" "d")]
		    UNSPECV_MONITOR)]
  "TARGET_SSE3"
  "monitor\t%0, %1, %2"
  [(set_attr "length" "3")])

;; SSE3 arithmetic

(define_insn "addsubv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (unspec:V4SF [(match_operand:V4SF 1 "register_operand" "0")
		      (match_operand:V4SF 2 "nonimmediate_operand" "xm")]
		     UNSPEC_ADDSUB))]
  "TARGET_SSE3"
  "addsubps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V4SF")])

(define_insn "addsubv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (unspec:V2DF [(match_operand:V2DF 1 "register_operand" "0")
		      (match_operand:V2DF 2 "nonimmediate_operand" "xm")]
		     UNSPEC_ADDSUB))]
  "TARGET_SSE3"
  "addsubpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V2DF")])

(define_insn "haddv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (unspec:V4SF [(match_operand:V4SF 1 "register_operand" "0")
		      (match_operand:V4SF 2 "nonimmediate_operand" "xm")]
		     UNSPEC_HADD))]
  "TARGET_SSE3"
  "haddps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V4SF")])

(define_insn "haddv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (unspec:V2DF [(match_operand:V2DF 1 "register_operand" "0")
		      (match_operand:V2DF 2 "nonimmediate_operand" "xm")]
		     UNSPEC_HADD))]
  "TARGET_SSE3"
  "haddpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V2DF")])

(define_insn "hsubv4sf3"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (unspec:V4SF [(match_operand:V4SF 1 "register_operand" "0")
		      (match_operand:V4SF 2 "nonimmediate_operand" "xm")]
		     UNSPEC_HSUB))]
  "TARGET_SSE3"
  "hsubps\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V4SF")])

(define_insn "hsubv2df3"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
        (unspec:V2DF [(match_operand:V2DF 1 "register_operand" "0")
		      (match_operand:V2DF 2 "nonimmediate_operand" "xm")]
		     UNSPEC_HSUB))]
  "TARGET_SSE3"
  "hsubpd\t{%2, %0|%0, %2}"
  [(set_attr "type" "sseadd")
   (set_attr "mode" "V2DF")])

(define_insn "movshdup"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (unspec:V4SF
	 [(match_operand:V4SF 1 "nonimmediate_operand" "xm")] UNSPEC_MOVSHDUP))]
  "TARGET_SSE3"
  "movshdup\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "V4SF")])

(define_insn "movsldup"
  [(set (match_operand:V4SF 0 "register_operand" "=x")
        (unspec:V4SF
	 [(match_operand:V4SF 1 "nonimmediate_operand" "xm")] UNSPEC_MOVSLDUP))]
  "TARGET_SSE3"
  "movsldup\t{%1, %0|%0, %1}"
  [(set_attr "type" "sse")
   (set_attr "mode" "V4SF")])

(define_insn "lddqu"
  [(set (match_operand:V16QI 0 "register_operand" "=x")
	(unspec:V16QI [(match_operand:V16QI 1 "memory_operand" "m")]
		       UNSPEC_LDQQU))]
  "TARGET_SSE3"
  "lddqu\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "TI")])

(define_insn "loadddup"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_duplicate:V2DF (match_operand:DF 1 "memory_operand" "m")))]
  "TARGET_SSE3"
  "movddup\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "DF")])

(define_insn "movddup"
  [(set (match_operand:V2DF 0 "register_operand" "=x")
	(vec_duplicate:V2DF
	 (vec_select:DF (match_operand:V2DF 1 "register_operand" "x")
			(parallel [(const_int 0)]))))]
  "TARGET_SSE3"
  "movddup\t{%1, %0|%0, %1}"
  [(set_attr "type" "ssecvt")
   (set_attr "mode" "DF")])
