/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "setupscreenshot.h"
#include "ui_setupscreenshot.h"

#include <QDebug>
#include <QFileDialog>
#include <QStandardPaths>
#include <QFileSystemWatcher>

#include "global/global.h"

using namespace Global;

SetupScreenshot::SetupScreenshot(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::SetupScreenshot)
{
    ui->setupUi(this);

    m_format_index = 0;

    QFont f("Noto Sans CJK SC Regular");
    f.setPixelSize(14);
    ui->rb_Save2Clip->setFont(f);
    ui->rb_Save2File->setFont(f);
    ui->label->setFont(f);
    ui->label_2->setFont(f);
    ui->lineEdit->setFont(f);
    ui->comboBox->setFont(f);
    ui->btn_Browse->setFont(f);
    ui->checkBox->setFont(f);

    ui->lineEdit->setReadOnly(true);

    initConnect();

    // 保存到剪切板功能和当前尺寸截图功能未实现
    ui->rb_Save2Clip->hide();
    ui->checkBox->hide();
}

SetupScreenshot::~SetupScreenshot()
{
    delete ui;
}

void SetupScreenshot::initData()
{
    if(gsetup->screenShotSaveToClip.first)
        ui->rb_Save2Clip->setChecked(true);
    else
        ui->rb_Save2File->setChecked(true);

    if(gsetup->screenShotPath.first.length() == 0)
    {
        gsetup->screenShotPath.second = QDir::homePath().append("/").append(tr("Pictures"));
        ui->lineEdit->setText(gsetup->screenShotPath.second);
        gsetup->flushChange();
    }
    else
        ui->lineEdit->setText(gsetup->screenShotPath.first);

    // 设置支持的截图格式
    QStringList format;
    format << "jpg" << "png" << "webp";
    for(int i=0; i<format.size(); i++)
        if(format.at(i) == gsetup->screenShotFormat.first)
            m_format_index = i;

    ui->comboBox->clear();
    ui->comboBox->addItems(format);
    ui->comboBox->setCurrentIndex(m_format_index);

    ui->checkBox->setChecked(gsetup->screenShotCurrentSize.first);
}

void SetupScreenshot::setBlackTheme()
{
    ui->rb_Save2Clip->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->rb_Save2File->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->label->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->label_2->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->lineEdit->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->comboBox->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->btn_Browse->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->checkBox->setStyleSheet(QString("color:rgb(249,249,249);"));
}

void SetupScreenshot::setLightTheme()
{
    ui->rb_Save2Clip->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->rb_Save2File->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_2->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->lineEdit->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->comboBox->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->btn_Browse->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->checkBox->setStyleSheet(QString("color:rgb(38,38,38);"));
}

void SetupScreenshot::setWidgetFont(QString family, int size)
{
    QFont f(family);
    f.setPointSize(size);

    ui->rb_Save2Clip->setFont(f);
    ui->rb_Save2File->setFont(f);
    ui->label->setFont(f);
    ui->label_2->setFont(f);
    ui->lineEdit->setFont(f);
    ui->comboBox->setFont(f);
    ui->btn_Browse->setFont(f);
    ui->checkBox->setFont(f);
}

void SetupScreenshot::initConnect()
{
    connect(ui->rb_Save2Clip, &QRadioButton::toggled, [&](bool checked){gsetup->screenShotSaveToClip.second = checked;});
    connect(ui->lineEdit, &QLineEdit::textChanged, [&](QString path){gsetup->screenShotPath.second = path;});
    connect(ui->btn_Browse, &QPushButton::clicked, [&](bool checked){
        // 打开文件夹
        QString url;

        {
            QFileDialog fd(parentWidget());
            fd.setModal(true);
            QList<QUrl> list = fd.sidebarUrls();
            int sidebarNum = 8;
            QString home = QDir::homePath().section("/", -1, -1);
            QString mnt = "/media/" + home + "/";
            QDir mntDir(mnt);
            mntDir.setFilter(QDir::Dirs | QDir::NoDotAndDotDot);
            QFileInfoList filist = mntDir.entryInfoList();
            QList<QUrl> mntUrlList;
            for(int i=0; i < sidebarNum && i < filist.size(); i++) {
                QFileInfo fi = filist.at(i);
                //华为990、9a0需要屏蔽最小系统挂载的目录
                if (fi.fileName() == "2691-6AB8")
                     continue;
                mntUrlList << QUrl("file://" + fi.filePath());
            }
            QFileSystemWatcher fsw(&fd);
            fsw.addPath("/media/" + home + "/");
            connect(&fsw, &QFileSystemWatcher::directoryChanged, &fd, [=, &sidebarNum, &mntUrlList, &list, &fd](const QString path){
                QDir wmnDir(path);
                wmnDir.setFilter(QDir::Dirs | QDir::NoDotAndDotDot);
                QFileInfoList wfilist = wmnDir.entryInfoList();
                mntUrlList.clear();
                for(int i=0; i < sidebarNum && i < wfilist.size(); ++i) {
                    QFileInfo fi = wfilist.at(i);
                    //华为990、9a0需要屏蔽最小系统挂载的目录
                    if (fi.fileName() == "2691-6AB8")
                         continue;
                    mntUrlList << QUrl("file://" + fi.filePath());
                }
                fd.setSidebarUrls(list + mntUrlList);
                fd.update();
            });
            connect(&fd, &QFileDialog::finished, &fd, [=, &list, &fd](){
                fd.setSidebarUrls(list);
            });
            fd.setSidebarUrls(list + mntUrlList);
            fd.setDirectory(QDir(ui->lineEdit->text()));
            fd.setWindowTitle(tr("Video Player Choose a directory"));
            fd.setFileMode(QFileDialog::DirectoryOnly);

            gshortCut->makeAllInvalid();
            if(fd.exec() == QFileDialog::Accepted)
            {
                url = fd.selectedUrls().at(0).toString();
                if(url.startsWith("file"))
                    url.remove(0, 7);
            }
            gshortCut->makeAllValid();
        }

        if(url.length() > 0)
            ui->lineEdit->setText(url);
    });
    connect(ui->comboBox, &QComboBox::currentTextChanged, [&](QString format){gsetup->screenShotFormat.second = format;});
    connect(ui->checkBox, &QCheckBox::toggled, [&](bool checked){gsetup->screenShotCurrentSize.second = checked;});
}
