#!/usr/bin/perl -w
use strict;

=head HOWTO USE

When you release a new version ex: 3.0.3
 - Modify the $version string

When you add a new category
 - Add a print_cat() at the end of the script

To update the downloads.php file

- Change the version on the top of the file
- ./sf2bacula_downloads.pl > downloads.php

By default, it downloads the sourceforge page in the current directory


You can also use a previous output

 ./sf2bacula_downloads.pl <version> <sf_list_2022.html> > downloads.php

=cut

#             bacula|depkgs | depkgs-qt
my $version = '5.0.1';
if ($ARGV[0] and $ARGV[0] =~ /^[\d\.]+$/) {
    $version = shift(@ARGV);
}
my $depkgs_version  = '18Dec09|28Jul09|15May10';

my $base = "http://bacula.git.sourceforge.net/git/gitweb.cgi?p=bacula/bacula;a=blob_plain;hb=Release-$version;f=bacula";
my $notes = "$base/ReleaseNotes";
my $chglog = "$base/ChangeLog";
my %cats;
my $cur;
my %seen;

my $file = "sf_list_$$.html";
my $cmd = "wget -O $file https://sourceforge.net/projects/bacula/files";

if ($ARGV[0] && -f $ARGV[0]) {
    $file = $ARGV[0];
} else {
    system($cmd);
}

open(FP, $file);
while (my $l = <FP>)
{
    #                                         cat   vers  file
    if ($l =~ m!href="(?:http://sourceforge.net)(/projects/bacula/files/([^/]+)/([^/]+)/([^/]+)/download)"!) {
        print STDERR "$4\n";
        $cur = {
            dl  => $1,
            cat => $2,
            vers => $3,
            file => $4
        };
    }

    # the size, date, and downloads are just after
    if ($cur && $l =~ m!<td>([\d\.]+ [KMG]B)</td>!) {
        $cur->{size} = $1;
        do {
            $l = <FP>;
            if ($l =~ m!<td>(\d{4}-\d{2}-\d{2})</td>!) {
                $cur->{date} = $1;
                print STDERR "  date: $1\n";
            }
        } while (!$cur->{date} and !eof(FP));
        do {
            $l = <FP>;
            if ($l =~ m!<td>([\d,]+)</td>!) {
                $cur->{downloads} = $1;
                print STDERR "  downloads: $1\n";
            }
        } while (!exists $cur->{downloads} and !eof(FP));


        # once we have a full $cur element, we can store it
        if (!exists $seen{$cur->{file}}) {
            push @{$cats{$cur->{cat}}}, $cur;
            $seen{$cur->{file}} = 1;
            $cur = undef;
        }
    }
}
close(FP);

print '
<? require_once("inc/header.php"); ?>
<? // This page is generated by sf2bacula_downloads.pl in eric s crontab, 
   // no need to update it by hand ?>
<table>
  <tr>
   <td class="contentTopic">
   Bacula downloads for version ', $version, '
   </td>
   </tr>
   <tr>
     <td class="content">
     <center>
      <a href="', $notes, '">Release Notes</a>&nbsp;|&nbsp;
      <a href="', $chglog, '">ChangeLog</a>&nbsp;|&nbsp;
      <a href="#bacula">Sources</a>&nbsp;|&nbsp;
      <a href="#Win32_64">Win32/64</a>&nbsp;|&nbsp;
      <a href="#rpms">RPM</a>&nbsp;|&nbsp;
      <a href="https://sourceforge.net/projects/bacula/files/Bacula%20Public%20Key/Current%20Public%20Key/bacula.pub/download">Public Key</a>&nbsp;|&nbsp;
      <a href="https://sourceforge.net/projects/bacula/files/Bacula%20Public%20Key/Current%20Public%20Key/rpmkey-bacula-0.1-3.noarch.rpm/download">RPM Public Key</a>
     </center>
     </td>
   </tr>
';

my $cat = 'bacula';
#use Data::Dumper;
#print Data::Dumper::Dumper(\%cats);

sub print_cat
{
    my ($cat) = @_;
    my $row = 'odd';

    print '
   <tr>
     <td> <br><a name="', $cat, '"></a><font size="+1"><b>', $cat, ':</b></font>
<table cellspacing="2">
<tr class="title"><th>Name</th><th align="center">', ($cat !~ /rpm/)?'Signature':'', '</th><th>Size</th><th>Date</th><th>Downloads</th></tr>
';
    foreach my $elt ( sort { $a->{file} cmp $b->{file} }  @{$cats{$cat}})
    {
        next if ($elt->{file} =~ /\.sig/); # we skip signature file
        if ($elt->{vers} eq $version || $elt->{vers} =~ /$depkgs_version/)
        {
            print "
<tr class=\"$row\">
 <td><a href='https://sourceforge.net$elt->{dl}'>$elt->{file}</td>
 <td align=\"center\">", 
 ($cat !~ /rpm/)?"<a href='https://sourceforge.net/projects/bacula/files/$cat/$elt->{vers}/$elt->{file}.sig/download'>sig":"", 
 "</td>
 <td align=\"right\">$elt->{size}</td>
 <td align=\"center\">$elt->{date}</td>
 <td align=\"center\">$elt->{downloads}</td>
</tr>
";
            if ($row eq 'odd') { $row = 'even'; } else { $row = 'odd'; }
        }
    }
    print '</table>
     </td>
     </tr>';
}

print_cat('bacula');
print_cat('Win32_64');
print_cat('rpms');
print_cat('rpms-contrib-fschwarz');
print_cat('rpms-contrib-psheaffer');
print_cat('depkgs');
print_cat('depkgs-qt');


print '
</table>
<small>', scalar(localtime), '</small>
<? require_once("inc/footer.php"); ?>
';
