/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.WaitStatus;

public abstract class Clock {
    private long adjust = 0L;
    private long lastTime = 0L;
    public static final long USECOND = 1L;
    public static final long MSECOND = 1000L;
    public static final long SECOND = 1000000L;
    public static final int SINGLE = 0;
    public static final int PERIODIC = 0;

    protected synchronized long adjust(long l) {
        long l2 = l + this.adjust;
        if (l2 < this.lastTime) {
            l2 = this.lastTime;
        } else {
            this.lastTime = l2;
        }
        return l2;
    }

    protected abstract long getInternalTime();

    protected abstract WaitStatus waitFunc(ClockID var1);

    protected abstract WaitStatus waitAsyncFunc(ClockID var1);

    protected abstract void unscheduleFunc(ClockID var1);

    public synchronized long getTime() {
        long l = this.getInternalTime();
        long l2 = this.adjust(l);
        return l2;
    }

    public synchronized void setAdjust(long l) {
        this.adjust = l;
    }

    public synchronized long getAdjust() {
        return this.adjust;
    }

    public ClockID newSingleShotID(long l) {
        return new ClockID(l, 0L, 0);
    }

    public ClockID newPeriodicID(long l, long l2) {
        return new ClockID(l, l2, 0);
    }

    public class ClockID {
        long time;
        long interval;
        int type;
        int status;

        public ClockID(long l, long l2, int n) {
            this.time = l;
            this.interval = l2;
            this.type = n;
        }

        public long getTime() {
            return this.time;
        }

        public WaitStatus waitID() {
            WaitStatus waitStatus = Clock.this.waitFunc(this);
            if (this.type == 0) {
                this.time += this.interval;
            }
            return waitStatus;
        }

        public void unschedule() {
            Clock.this.unscheduleFunc(this);
        }
    }
}

